/* alpm_utils.c generated by valac 0.56.16, the Vala compiler
 * generated from alpm_utils.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2018-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <alpm.h>
#include <alpm_list.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <libsoup/soup.h>
#include "pamac.h"
#include <errno.h>
#include <glib/gi18n-lib.h>
#include <stdarg.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_DOWNLOAD (download_get_type ())
#define DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOWNLOAD, Download))
#define DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOWNLOAD, DownloadClass))
#define IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOWNLOAD))
#define IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOWNLOAD))
#define DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOWNLOAD, DownloadClass))

typedef struct _Download Download;
typedef struct _DownloadClass DownloadClass;
typedef struct _DownloadPrivate DownloadPrivate;

#define PAMAC_TYPE_ALPM_UTILS (pamac_alpm_utils_get_type ())
#define PAMAC_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils))
#define PAMAC_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))
#define PAMAC_IS_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_IS_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_ALPM_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))

typedef struct _PamacAlpmUtils PamacAlpmUtils;
typedef struct _PamacAlpmUtilsClass PamacAlpmUtilsClass;
enum  {
	DOWNLOAD_0_PROPERTY,
	DOWNLOAD_NUM_PROPERTIES
};
static GParamSpec* download_properties[DOWNLOAD_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PamacAlpmUtilsPrivate PamacAlpmUtilsPrivate;

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
enum  {
	PAMAC_ALPM_UTILS_0_PROPERTY,
	PAMAC_ALPM_UTILS_NUM_PROPERTIES
};
static GParamSpec* pamac_alpm_utils_properties[PAMAC_ALPM_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alpm_config_unref0(var) ((var == NULL) ? NULL : (var = (alpm_config_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PAMAC_TYPE_ALPM_PACKAGE_LINKED (pamac_alpm_package_linked_get_type ())
#define PAMAC_ALPM_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinked))
#define PAMAC_ALPM_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinkedClass))
#define PAMAC_IS_ALPM_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED))
#define PAMAC_IS_ALPM_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_PACKAGE_LINKED))
#define PAMAC_ALPM_PACKAGE_LINKED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinkedClass))

typedef struct _PamacAlpmPackageLinked PamacAlpmPackageLinked;
typedef struct _PamacAlpmPackageLinkedClass PamacAlpmPackageLinkedClass;

#define PAMAC_TYPE_ALPM_PACKAGE_STATIC (pamac_alpm_package_static_get_type ())
#define PAMAC_ALPM_PACKAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStatic))
#define PAMAC_ALPM_PACKAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStaticClass))
#define PAMAC_IS_ALPM_PACKAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC))
#define PAMAC_IS_ALPM_PACKAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_PACKAGE_STATIC))
#define PAMAC_ALPM_PACKAGE_STATIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStaticClass))

typedef struct _PamacAlpmPackageStatic PamacAlpmPackageStatic;
typedef struct _PamacAlpmPackageStaticClass PamacAlpmPackageStaticClass;
#define _alpm_list_free0(var) ((var == NULL) ? NULL : (var = (alpm_list_free (var), NULL)))
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _alpm_pkg_free0(var) ((var == NULL) ? NULL : (var = (alpm_pkg_free (var), NULL)))
#define _alpm_depmissing_free0(var) ((var == NULL) ? NULL : (var = (alpm_depmissing_free (var), NULL)))
#define _alpm_conflict_free0(var) ((var == NULL) ? NULL : (var = (alpm_conflict_free (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _Block58Data Block58Data;
#define _alpm_fileconflict_free0(var) ((var == NULL) ? NULL : (var = (alpm_fileconflict_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL,
	PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL,
	PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL,
	PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL,
	PAMAC_ALPM_UTILS_NUM_SIGNALS
};
static guint pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_NUM_SIGNALS] = {0};
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Download {
	GObject parent_instance;
	DownloadPrivate * priv;
};

struct _DownloadClass {
	GObjectClass parent_class;
};

struct _DownloadPrivate {
	PamacAlpmUtils* alpm_utils;
	const gchar* cachedir;
	alpm_pkg_t* alpm_pkg;
	gboolean emit_signals;
};

struct _PamacAlpmUtils {
	GObject parent_instance;
	PamacAlpmUtilsPrivate * priv;
	AlpmConfig* alpm_config;
	GFile* lockfile;
	GCancellable* cancellable;
	gboolean downloading_updates;
	gchar* current_filename;
	gchar* current_action;
	gdouble current_progress;
	GPtrArray* unresolvables;
	guint64 total_download;
	guint64 already_downloaded;
	GMutex multi_progress_mutex;
	GHashTable* multi_progress;
	SoupSession* soup_session;
	GTimer* rate_timer;
};

struct _PamacAlpmUtilsClass {
	GObjectClass parent_class;
};

struct _PamacAlpmUtilsPrivate {
	gchar* sender;
	PamacConfig* config;
	gchar* tmp_path;
	guint8 commit_retries;
	gchar* current_status;
	gboolean sysupgrade;
	gboolean enable_downgrade;
	gboolean simple_install;
	gboolean no_confirm_commit;
	gboolean keep_built_pkgs;
	gint trans_flags;
	GHashTable* to_install;
	GHashTable* deps_to_install;
	GHashTable* to_remove;
	GHashTable* required_to_remove;
	GHashTable* orphans_to_remove;
	GHashTable* conflicts_to_remove;
	GHashTable* local_paths;
	GHashTable* remote_paths;
	GHashTable* to_build;
	GHashTable* checked_deps;
	GHashTable* to_install_as_dep;
	GHashTable* ignorepkgs;
	GHashTable* overwrite_files;
	GHashTable* to_syncfirst;
	GQueue* download_rates;
	gdouble download_rate;
};

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gchar* dbpath;
	gboolean checkspace;
	GHashTable* ignorepkgs;
	GHashTable* holdpkgs;
	GHashTable* syncfirsts;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

struct _Block58Data {
	int _ref_count_;
	PamacAlpmUtils* self;
	alpm_handle_t* alpm_handle;
};

static gint Download_private_offset;
static gpointer download_parent_class = NULL;
static gint PamacAlpmUtils_private_offset;
static gpointer pamac_alpm_utils_parent_class = NULL;

VALA_EXTERN GType download_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_alpm_utils_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Download* download_new (PamacAlpmUtils* alpm_utils,
                        const gchar* cachedir,
                        alpm_pkg_t* alpm_pkg,
                        gboolean emit_signals);
VALA_EXTERN Download* download_construct (GType object_type,
                              PamacAlpmUtils* alpm_utils,
                              const gchar* cachedir,
                              alpm_pkg_t* alpm_pkg,
                              gboolean emit_signals);
VALA_EXTERN void download_run (Download* self);
VALA_EXTERN gint dload (PamacAlpmUtils* alpm_utils,
            const gchar* mirror,
            const gchar* filename,
            const gchar* localpath,
            gint force,
            gboolean parallel,
            gboolean emit_signals);
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
static void download_finalize (GObject * obj);
static GType download_get_type_once (void);
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_new (PamacConfig* config,
                                      SoupSession* soup_session);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_construct (GType object_type,
                                            PamacConfig* config,
                                            SoupSession* soup_session);
VALA_EXTERN AlpmConfig* pamac_config_get_alpm_config (PamacConfig* self);
static void pamac_alpm_utils_check_old_lock (PamacAlpmUtils* self);
VALA_EXTERN gint pamac_alpm_utils_do_choose_provider (PamacAlpmUtils* self,
                                          const gchar* depend,
                                          GPtrArray* providers);
static void pamac_alpm_utils_do_start_downloading (PamacAlpmUtils* self);
static void pamac_alpm_utils_do_stop_downloading (PamacAlpmUtils* self);
static void pamac_alpm_utils_do_emit_action (PamacAlpmUtils* self,
                                      const gchar* action);
static void pamac_alpm_utils_do_emit_action_progress (PamacAlpmUtils* self,
                                               const gchar* action,
                                               const gchar* status,
                                               gdouble progress);
static void pamac_alpm_utils_do_emit_download_progress (PamacAlpmUtils* self,
                                                 const gchar* action,
                                                 const gchar* status,
                                                 gdouble progress);
static void pamac_alpm_utils_do_emit_hook_progress (PamacAlpmUtils* self,
                                             const gchar* action,
                                             const gchar* details,
                                             const gchar* status,
                                             gdouble progress);
VALA_EXTERN void pamac_alpm_utils_do_emit_script_output (PamacAlpmUtils* self,
                                             const gchar* message);
static void pamac_alpm_utils_do_emit_warning (PamacAlpmUtils* self,
                                       const gchar* message);
static void pamac_alpm_utils_do_emit_error (PamacAlpmUtils* self,
                                     const gchar* message,
                                     GPtrArray* details);
static void pamac_alpm_utils_do_important_details_outpout (PamacAlpmUtils* self,
                                                    gboolean must_show);
VALA_EXTERN alpm_handle_t* pamac_alpm_utils_get_handle (PamacAlpmUtils* self,
                                            gboolean files_db,
                                            gboolean tmp_db,
                                            gboolean callbacks);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self,
                                       gboolean files_db,
                                       gboolean tmp_db,
                                       gboolean copy_dbs);
VALA_EXTERN void cb_event (void* ctx,
               alpm_event_t* data);
static void _cb_event_alpm_cb_event (void* ctx,
                              alpm_event_t* data);
VALA_EXTERN void cb_progress (void* ctx,
                  alpm_progress_t progress,
                  const gchar* pkgname,
                  gint percent,
                  guint n_targets,
                  guint current_target);
static void _cb_progress_alpm_cb_progress (void* ctx,
                                    alpm_progress_t progress,
                                    const gchar* pkgname,
                                    gint percent,
                                    guint n_targets,
                                    guint current_target);
VALA_EXTERN void cb_question (void* ctx,
                  alpm_question_t* data);
static void _cb_question_alpm_cb_question (void* ctx,
                                    alpm_question_t* data);
VALA_EXTERN gint cb_fetch (void* ctx,
               const gchar* fileurl,
               const gchar* localpath,
               gint force);
static gint _cb_fetch_alpm_cb_fetch (void* ctx,
                              const gchar* url,
                              const gchar* localpath,
                              gint force);
VALA_EXTERN void cb_log (void* ctx,
             alpm_loglevel_t level,
             const gchar* fmt,
             va_list args);
static void _cb_log_alpm_cb_log (void* ctx,
                          alpm_loglevel_t level,
                          const gchar* fmt,
                          va_list args);
VALA_EXTERN void alpm_config_register_syncdbs (AlpmConfig* self,
                                   alpm_handle_t* handle);
VALA_EXTERN gboolean pamac_alpm_utils_set_pkgreason (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         const gchar* pkgname,
                                         guint reason);
VALA_EXTERN gboolean pamac_alpm_utils_clean_cache (PamacAlpmUtils* self,
                                       gchar** filenames,
                                       gint filenames_length1);
VALA_EXTERN gboolean pamac_alpm_utils_clean_build_files (PamacAlpmUtils* self,
                                             const gchar* aur_build_dir);
static alpm_pkg_t* pamac_alpm_utils_get_syncpkg (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          const gchar* name);
static gboolean pamac_alpm_utils_update_dbs (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle,
                                      gint force);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         gboolean force_refresh);
VALA_EXTERN void write_log_file (const gchar* event);
static void pamac_alpm_utils_add_ignorepkgs (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_ignorepkgs (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_add_overwrite_files (PamacAlpmUtils* self,
                                           alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_overwrite_files (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle);
static PamacAlpmPackage* pamac_alpm_utils_initialise_pkg (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle,
                                                   alpm_pkg_t* alpm_pkg);
VALA_EXTERN PamacAlpmPackageStatic* pamac_alpm_package_static_new_transaction (alpm_pkg_t* alpm_pkg,
                                                                   alpm_pkg_t* local_pkg,
                                                                   alpm_pkg_t* sync_pkg);
VALA_EXTERN PamacAlpmPackageStatic* pamac_alpm_package_static_construct_transaction (GType object_type,
                                                                         alpm_pkg_t* alpm_pkg,
                                                                         alpm_pkg_t* local_pkg,
                                                                         alpm_pkg_t* sync_pkg);
VALA_EXTERN GType pamac_alpm_package_linked_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_alpm_package_static_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean pamac_alpm_utils_download_updates (PamacAlpmUtils* self,
                                            const gchar* sender);
static void pamac_alpm_utils_download_files (PamacAlpmUtils* self,
                                      alpm_handle_t* handle,
                                      guint64 max_parallel_downloads,
                                      gboolean emit_signals);
static gboolean pamac_alpm_utils_trans_init (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle,
                                      gint flags,
                                      gboolean emit_error);
static gboolean pamac_alpm_utils_trans_sysupgrade (PamacAlpmUtils* self,
                                            alpm_handle_t* alpm_handle,
                                            gboolean emit_error);
static gboolean pamac_alpm_utils_trans_add_pkg_real (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle,
                                              alpm_pkg_t* pkg,
                                              gboolean emit_error);
static gboolean pamac_alpm_utils_trans_add_pkg (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle,
                                         const gchar* pkgname,
                                         gboolean emit_error);
VALA_EXTERN GPtrArray* pamac_alpm_utils_download_pkgs (PamacAlpmUtils* self,
                                           const gchar* sender,
                                           gchar** urls,
                                           gint urls_length1);
static gboolean pamac_alpm_utils_trans_load_pkg (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          const gchar* path,
                                          gint siglevel,
                                          gboolean emit_error);
static gboolean pamac_alpm_utils_trans_remove_pkg (PamacAlpmUtils* self,
                                            alpm_handle_t* alpm_handle,
                                            const gchar* pkgname,
                                            gboolean emit_error);
static gboolean pamac_alpm_utils_trans_prepare_real (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle,
                                              gboolean emit_error);
static void pamac_alpm_utils_trans_release (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_prepare_aur_db (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_aur_db (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle);
VALA_EXTERN gboolean pamac_alpm_utils_trans_check_prepare (PamacAlpmUtils* self,
                                               gboolean sysupgrade,
                                               gboolean enable_downgrade,
                                               gboolean simple_install,
                                               gint trans_flags,
                                               GHashTable* to_install,
                                               GHashTable* to_remove,
                                               GHashTable* local_paths,
                                               GHashTable* remote_paths,
                                               GHashTable* to_build,
                                               GHashTable* ignorepkgs,
                                               GHashTable* overwrite_files,
                                               PamacTransactionSummary** summary);
static void pamac_alpm_utils_intern_compute_pkgs_to_remove (PamacAlpmUtils* self,
                                                     alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_intern_compute_pkgs_to_install (PamacAlpmUtils* self,
                                                      alpm_handle_t* alpm_handle,
                                                      alpm_db_t* aur_db);
static void pamac_alpm_utils_intern_compute_orphans_to_remove (PamacAlpmUtils* self,
                                                        alpm_handle_t* alpm_handle);
static gboolean pamac_alpm_utils_trans_prepare (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle,
                                         alpm_db_t* aur_db);
static void pamac_alpm_utils_get_transaction_summary (PamacAlpmUtils* self,
                                               alpm_handle_t* alpm_handle,
                                               PamacTransactionSummary** summary);
static void pamac_alpm_utils_trans_reset (PamacAlpmUtils* self);
VALA_EXTERN gboolean pamac_alpm_utils_trans_run (PamacAlpmUtils* self,
                                     const gchar* sender,
                                     gboolean sysupgrade,
                                     gboolean enable_downgrade,
                                     gboolean simple_install,
                                     gboolean keep_built_pkgs,
                                     gint trans_flags,
                                     gchar** to_install,
                                     gint to_install_length1,
                                     gchar** to_remove,
                                     gint to_remove_length1,
                                     gchar** to_load_local,
                                     gint to_load_local_length1,
                                     gchar** to_load_remote,
                                     gint to_load_remote_length1,
                                     gchar** to_install_as_dep,
                                     gint to_install_as_dep_length1,
                                     gchar** ignorepkgs,
                                     gint ignorepkgs_length1,
                                     gchar** overwrite_files,
                                     gint overwrite_files_length1);
static gboolean pamac_alpm_utils_trans_run_real (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle);
static gboolean pamac_alpm_utils_trans_commit (PamacAlpmUtils* self,
                                        alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_install_deps_in_to_remove (PamacAlpmUtils* self,
                                                        alpm_handle_t* alpm_handle,
                                                        alpm_list_t* deps_to_check);
static void pamac_alpm_utils_check_orphans_to_remove (PamacAlpmUtils* self,
                                               alpm_handle_t* alpm_handle,
                                               alpm_list_t* deps_to_check);
static void _g_free_alpm_list_fn_free (gconstpointer a);
VALA_EXTERN GPtrArray* pamac_transaction_summary_get_aur_pkgbases_to_build (PamacTransactionSummary* self);
VALA_EXTERN GPtrArray* pamac_transaction_summary_get_to_load (PamacTransactionSummary* self);
VALA_EXTERN void pamac_alpm_utils_emit_totaldownload (PamacAlpmUtils* self,
                                          guint64 total);
VALA_EXTERN void pamac_alpm_utils_emit_event (PamacAlpmUtils* self,
                                  guint primary_event,
                                  guint secondary_event,
                                  GPtrArray* details);
static void ___lambda5_ (PamacAlpmUtils* self,
                  Download* download);
static void ____lambda5__gfunc (gpointer data,
                         gpointer self);
static gboolean pamac_alpm_utils_need_reboot (PamacAlpmUtils* self,
                                       alpm_handle_t* alpm_handle);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static gboolean pamac_alpm_utils_trans_commit_real (PamacAlpmUtils* self,
                                             alpm_handle_t* alpm_handle,
                                             gboolean* need_retry);
static gboolean ___lambda6_ (Block58Data* _data58_,
                      const gchar* pkgname,
                      const gchar* val);
static gboolean ____lambda6__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gchar* pamac_alpm_utils_backup_conflict_file (PamacAlpmUtils* self,
                                              const gchar* file_path);
VALA_EXTERN void pamac_alpm_utils_trans_cancel (PamacAlpmUtils* self,
                                    const gchar* sender);
static gchar* pamac_alpm_utils_remove_bash_colors (PamacAlpmUtils* self,
                                            const gchar* msg);
VALA_EXTERN void pamac_alpm_utils_emit_progress (PamacAlpmUtils* self,
                                     guint progress,
                                     const gchar* pkgname,
                                     guint percent,
                                     guint n_targets,
                                     guint current_target);
VALA_EXTERN void pamac_alpm_utils_emit_download (PamacAlpmUtils* self,
                                     guint64 xfered,
                                     guint64 total);
static gdouble* _double_dup (gdouble* self);
VALA_EXTERN void pamac_alpm_utils_emit_log (PamacAlpmUtils* self,
                                guint level,
                                const gchar* msg);
static void g_cclosure_user_marshal_INT__STRING_BOXED (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                       GValue * return_value,
                                                                       guint n_param_values,
                                                                       const GValue * param_values,
                                                                       gpointer invocation_hint,
                                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOXED (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void pamac_alpm_utils_finalize (GObject * obj);
static GType pamac_alpm_utils_get_type_once (void);
VALA_EXTERN void compute_multi_download_progress (PamacAlpmUtils* alpm_utils);
static guint64* _uint64_dup (guint64* self);
VALA_EXTERN void cb_download (PamacAlpmUtils* alpm_utils,
                  const gchar* filename,
                  guint64 xfered,
                  guint64 total);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
download_get_instance_private (Download* self)
{
	return G_STRUCT_MEMBER_P (self, Download_private_offset);
}

Download*
download_construct (GType object_type,
                    PamacAlpmUtils* alpm_utils,
                    const gchar* cachedir,
                    alpm_pkg_t* alpm_pkg,
                    gboolean emit_signals)
{
	Download * self = NULL;
	g_return_val_if_fail (alpm_utils != NULL, NULL);
	g_return_val_if_fail (cachedir != NULL, NULL);
	g_return_val_if_fail (alpm_pkg != NULL, NULL);
	self = (Download*) g_object_new (object_type, NULL);
	self->priv->alpm_utils = alpm_utils;
	self->priv->cachedir = cachedir;
	self->priv->alpm_pkg = alpm_pkg;
	self->priv->emit_signals = emit_signals;
	return self;
}

Download*
download_new (PamacAlpmUtils* alpm_utils,
              const gchar* cachedir,
              alpm_pkg_t* alpm_pkg,
              gboolean emit_signals)
{
	return download_construct (TYPE_DOWNLOAD, alpm_utils, cachedir, alpm_pkg, emit_signals);
}

void
download_run (Download* self)
{
	alpm_db_t* db = NULL;
	alpm_pkg_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_db_t* _tmp3_;
	gchar* filename = NULL;
	alpm_pkg_t* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	alpm_list_t* servers = NULL;
	alpm_db_t* _tmp8_;
	alpm_list_t* _tmp9_;
	alpm_list_t* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->alpm_pkg;
	_tmp1_ = alpm_pkg_get_db (_tmp0_);
	_tmp2_ = _tmp1_;
	db = _tmp2_;
	_tmp3_ = db;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->alpm_pkg;
	_tmp5_ = alpm_pkg_get_filename (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	filename = _tmp7_;
	_tmp8_ = db;
	_tmp9_ = alpm_db_get_servers (_tmp8_);
	_tmp10_ = _tmp9_;
	servers = _tmp10_;
	while (TRUE) {
		alpm_list_t* _tmp11_;
		gint ret = 0;
		const gchar* mirror = NULL;
		alpm_list_t* _tmp12_;
		gconstpointer _tmp13_;
		PamacAlpmUtils* _tmp28_;
		GCancellable* _tmp29_;
		_tmp11_ = servers;
		if (!(_tmp11_ != NULL)) {
			break;
		}
		_tmp12_ = servers;
		_tmp13_ = _tmp12_->data;
		mirror = (const gchar*) _tmp13_;
		if (self->priv->emit_signals) {
			PamacAlpmUtils* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->priv->alpm_utils;
			_tmp15_ = mirror;
			_tmp16_ = filename;
			_tmp17_ = self->priv->cachedir;
			ret = dload (_tmp14_, _tmp15_, _tmp16_, _tmp17_, 0, TRUE, TRUE);
		} else {
			PamacAlpmUtils* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp18_ = self->priv->alpm_utils;
			_tmp19_ = mirror;
			_tmp20_ = filename;
			_tmp21_ = self->priv->cachedir;
			ret = dload (_tmp18_, _tmp19_, _tmp20_, _tmp21_, 0, TRUE, FALSE);
		}
		if (ret == 0) {
			PamacAlpmUtils* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp22_ = self->priv->alpm_utils;
			_tmp23_ = mirror;
			_tmp24_ = filename;
			_tmp25_ = g_strconcat (_tmp24_, ".sig", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->cachedir;
			ret = dload (_tmp22_, _tmp23_, _tmp26_, _tmp27_, 0, TRUE, FALSE);
			_g_free0 (_tmp26_);
		}
		if (ret == 0) {
			_g_free0 (filename);
			return;
		}
		_tmp28_ = self->priv->alpm_utils;
		_tmp29_ = _tmp28_->cancellable;
		if (g_cancellable_is_cancelled (_tmp29_)) {
			_g_free0 (filename);
			return;
		}
		servers = alpm_list_next (servers);
	}
	_g_free0 (filename);
}

static void
download_class_init (DownloadClass * klass,
                     gpointer klass_data)
{
	download_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Download_private_offset);
	G_OBJECT_CLASS (klass)->finalize = download_finalize;
}

static void
download_instance_init (Download * self,
                        gpointer klass)
{
	self->priv = download_get_instance_private (self);
}

static void
download_finalize (GObject * obj)
{
	Download * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOWNLOAD, Download);
	G_OBJECT_CLASS (download_parent_class)->finalize (obj);
}

static GType
download_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DownloadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) download_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Download), 0, (GInstanceInitFunc) download_instance_init, NULL };
	GType download_type_id;
	download_type_id = g_type_register_static (G_TYPE_OBJECT, "Download", &g_define_type_info, 0);
	Download_private_offset = g_type_add_instance_private (download_type_id, sizeof (DownloadPrivate));
	return download_type_id;
}

GType
download_get_type (void)
{
	static volatile gsize download_type_id__once = 0;
	if (g_once_init_enter (&download_type_id__once)) {
		GType download_type_id;
		download_type_id = download_get_type_once ();
		g_once_init_leave (&download_type_id__once, download_type_id);
	}
	return download_type_id__once;
}

static inline gpointer
pamac_alpm_utils_get_instance_private (PamacAlpmUtils* self)
{
	return G_STRUCT_MEMBER_P (self, PamacAlpmUtils_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_alpm_config_ref0 (gpointer self)
{
	return self ? alpm_config_ref (self) : NULL;
}

PamacAlpmUtils*
pamac_alpm_utils_construct (GType object_type,
                            PamacConfig* config,
                            SoupSession* soup_session)
{
	PamacAlpmUtils * self = NULL;
	gchar* _tmp0_;
	PamacConfig* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	AlpmConfig* _tmp5_;
	AlpmConfig* _tmp6_;
	AlpmConfig* _tmp7_;
	gchar* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GHashTable* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GHashFunc _tmp21_;
	GEqualFunc _tmp22_;
	GHashTable* _tmp23_;
	GHashFunc _tmp24_;
	GEqualFunc _tmp25_;
	GHashTable* _tmp26_;
	GHashFunc _tmp27_;
	GEqualFunc _tmp28_;
	GHashTable* _tmp29_;
	GHashFunc _tmp30_;
	GEqualFunc _tmp31_;
	GHashTable* _tmp32_;
	GHashFunc _tmp33_;
	GEqualFunc _tmp34_;
	GHashTable* _tmp35_;
	GHashFunc _tmp36_;
	GEqualFunc _tmp37_;
	GHashTable* _tmp38_;
	GHashFunc _tmp39_;
	GEqualFunc _tmp40_;
	GHashTable* _tmp41_;
	GHashFunc _tmp42_;
	GEqualFunc _tmp43_;
	GHashTable* _tmp44_;
	GHashFunc _tmp45_;
	GEqualFunc _tmp46_;
	GHashTable* _tmp47_;
	GHashFunc _tmp48_;
	GEqualFunc _tmp49_;
	GHashTable* _tmp50_;
	GPtrArray* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GTimer* _tmp55_;
	GQueue* _tmp56_;
	GCancellable* _tmp57_;
	SoupSession* _tmp58_;
	g_return_val_if_fail (config != NULL, NULL);
	g_return_val_if_fail (soup_session != NULL, NULL);
	self = (PamacAlpmUtils*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_vala_clear_GMutex (&self->multi_progress_mutex);
	g_mutex_init (&self->multi_progress_mutex);
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->multi_progress);
	self->multi_progress = _tmp4_;
	_tmp5_ = pamac_config_get_alpm_config (config);
	_tmp6_ = _tmp5_;
	_tmp7_ = _alpm_config_ref0 (_tmp6_);
	_alpm_config_unref0 (self->alpm_config);
	self->alpm_config = _tmp7_;
	_tmp8_ = g_strdup ("/var/tmp/pamac");
	_g_free0 (self->priv->tmp_path);
	self->priv->tmp_path = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_syncfirst);
	self->priv->to_syncfirst = _tmp11_;
	_tmp12_ = g_str_hash;
	_tmp13_ = g_str_equal;
	_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_install);
	self->priv->to_install = _tmp14_;
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->deps_to_install);
	self->priv->deps_to_install = _tmp17_;
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_remove);
	self->priv->to_remove = _tmp20_;
	_tmp21_ = g_str_hash;
	_tmp22_ = g_str_equal;
	_tmp23_ = g_hash_table_new_full (_tmp21_, _tmp22_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->required_to_remove);
	self->priv->required_to_remove = _tmp23_;
	_tmp24_ = g_str_hash;
	_tmp25_ = g_str_equal;
	_tmp26_ = g_hash_table_new_full (_tmp24_, _tmp25_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->orphans_to_remove);
	self->priv->orphans_to_remove = _tmp26_;
	_tmp27_ = g_str_hash;
	_tmp28_ = g_str_equal;
	_tmp29_ = g_hash_table_new_full (_tmp27_, _tmp28_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->conflicts_to_remove);
	self->priv->conflicts_to_remove = _tmp29_;
	_tmp30_ = g_str_hash;
	_tmp31_ = g_str_equal;
	_tmp32_ = g_hash_table_new_full (_tmp30_, _tmp31_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->local_paths);
	self->priv->local_paths = _tmp32_;
	_tmp33_ = g_str_hash;
	_tmp34_ = g_str_equal;
	_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->remote_paths);
	self->priv->remote_paths = _tmp35_;
	_tmp36_ = g_str_hash;
	_tmp37_ = g_str_equal;
	_tmp38_ = g_hash_table_new_full (_tmp36_, _tmp37_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_build);
	self->priv->to_build = _tmp38_;
	_tmp39_ = g_str_hash;
	_tmp40_ = g_str_equal;
	_tmp41_ = g_hash_table_new_full (_tmp39_, _tmp40_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->checked_deps);
	self->priv->checked_deps = _tmp41_;
	_tmp42_ = g_str_hash;
	_tmp43_ = g_str_equal;
	_tmp44_ = g_hash_table_new_full (_tmp42_, _tmp43_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_install_as_dep);
	self->priv->to_install_as_dep = _tmp44_;
	_tmp45_ = g_str_hash;
	_tmp46_ = g_str_equal;
	_tmp47_ = g_hash_table_new_full (_tmp45_, _tmp46_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->ignorepkgs);
	self->priv->ignorepkgs = _tmp47_;
	_tmp48_ = g_str_hash;
	_tmp49_ = g_str_equal;
	_tmp50_ = g_hash_table_new_full (_tmp48_, _tmp49_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->overwrite_files);
	self->priv->overwrite_files = _tmp50_;
	_tmp51_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->unresolvables);
	self->unresolvables = _tmp51_;
	_tmp52_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp52_;
	_tmp53_ = g_strdup ("");
	_g_free0 (self->current_action);
	self->current_action = _tmp53_;
	_tmp54_ = g_strdup ("");
	_g_free0 (self->priv->current_status);
	self->priv->current_status = _tmp54_;
	_tmp55_ = g_timer_new ();
	_g_timer_destroy0 (self->rate_timer);
	self->rate_timer = _tmp55_;
	_tmp56_ = g_queue_new ();
	(self->priv->download_rates == NULL) ? NULL : (self->priv->download_rates = (_g_queue_free__g_free0_ (self->priv->download_rates), NULL));
	self->priv->download_rates = _tmp56_;
	_tmp57_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp57_;
	_tmp58_ = _g_object_ref0 (soup_session);
	_g_object_unref0 (self->soup_session);
	self->soup_session = _tmp58_;
	self->downloading_updates = FALSE;
	pamac_alpm_utils_check_old_lock (self);
	return self;
}

PamacAlpmUtils*
pamac_alpm_utils_new (PamacConfig* config,
                      SoupSession* soup_session)
{
	return pamac_alpm_utils_construct (PAMAC_TYPE_ALPM_UTILS, config, soup_session);
}

gint
pamac_alpm_utils_do_choose_provider (PamacAlpmUtils* self,
                                     const gchar* depend,
                                     GPtrArray* providers)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (depend != NULL, 0);
	g_return_val_if_fail (providers != NULL, 0);
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL], 0, depend, providers, &_tmp0_);
	result = _tmp0_;
	return result;
}

static void
pamac_alpm_utils_do_start_downloading (PamacAlpmUtils* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL], 0, _tmp0_);
}

static void
pamac_alpm_utils_do_stop_downloading (PamacAlpmUtils* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL], 0, _tmp0_);
}

static void
pamac_alpm_utils_do_emit_action (PamacAlpmUtils* self,
                                 const gchar* action)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL], 0, _tmp0_, action);
}

static void
pamac_alpm_utils_do_emit_action_progress (PamacAlpmUtils* self,
                                          const gchar* action,
                                          const gchar* status,
                                          gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL], 0, _tmp0_, action, status, progress);
}

static void
pamac_alpm_utils_do_emit_download_progress (PamacAlpmUtils* self,
                                            const gchar* action,
                                            const gchar* status,
                                            gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL], 0, _tmp0_, action, status, progress);
}

static void
pamac_alpm_utils_do_emit_hook_progress (PamacAlpmUtils* self,
                                        const gchar* action,
                                        const gchar* details,
                                        const gchar* status,
                                        gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL], 0, _tmp0_, action, details, status, progress);
}

void
pamac_alpm_utils_do_emit_script_output (PamacAlpmUtils* self,
                                        const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL], 0, _tmp0_, message);
}

static void
pamac_alpm_utils_do_emit_warning (PamacAlpmUtils* self,
                                  const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL], 0, _tmp0_, message);
}

static void
pamac_alpm_utils_do_emit_error (PamacAlpmUtils* self,
                                const gchar* message,
                                GPtrArray* details)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL], 0, _tmp0_, message, details);
}

static void
pamac_alpm_utils_do_important_details_outpout (PamacAlpmUtils* self,
                                               gboolean must_show)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL], 0, _tmp0_, must_show);
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
pamac_alpm_utils_check_old_lock (PamacAlpmUtils* self)
{
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp0_;
	_tmp1_ = alpm_handle;
	if (_tmp1_ == NULL) {
		_alpm_release0 (alpm_handle);
		return;
	}
	_tmp2_ = alpm_handle;
	_tmp3_ = alpm_option_get_lockfile (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_g_object_unref0 (self->lockfile);
	self->lockfile = _tmp5_;
	_tmp6_ = self->lockfile;
	if (g_file_query_exists (_tmp6_, NULL)) {
		gint exit_status = 0;
		gchar* output = NULL;
		guint64 lockfile_time = 0ULL;
		{
			alpm_handle_t* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			_tmp7_ = alpm_handle;
			_tmp8_ = alpm_option_get_lockfile (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("stat -c %Y %s", _tmp9_);
			_tmp11_ = _tmp10_;
			g_spawn_command_line_sync (_tmp11_, &_tmp12_, NULL, &_tmp13_, &_inner_error0_);
			_g_free0 (output);
			output = _tmp12_;
			exit_status = _tmp13_;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (output);
				_alpm_release0 (alpm_handle);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (exit_status == 0) {
				gchar** splitted = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp14_ = output;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "\n", 0);
				splitted = _tmp16_;
				splitted_length1 = _vala_array_length (_tmp15_);
				_splitted_size_ = splitted_length1;
				_tmp17_ = splitted;
				_tmp17__length1 = splitted_length1;
				if (_tmp17__length1 == 2) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					guint64 _tmp20_ = 0ULL;
					gboolean _tmp21_;
					_tmp18_ = splitted;
					_tmp18__length1 = splitted_length1;
					_tmp19_ = _tmp18_[0];
					_tmp21_ = uint64_try_parse (_tmp19_, &_tmp20_, NULL, (guint) 0);
					lockfile_time = _tmp20_;
					if (_tmp21_) {
						guint64 boot_time = 0ULL;
						gchar* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						g_spawn_command_line_sync ("cat /proc/stat", &_tmp22_, NULL, &_tmp23_, &_inner_error0_);
						_g_free0 (output);
						output = _tmp22_;
						exit_status = _tmp23_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error0_->domain == G_SPAWN_ERROR) {
								goto __catch0_g_spawn_error;
							}
							_g_free0 (output);
							_alpm_release0 (alpm_handle);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						if (exit_status == 0) {
							const gchar* _tmp24_;
							gchar** _tmp25_;
							gchar** _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							_tmp24_ = output;
							_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "\n", 0);
							splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
							splitted = _tmp26_;
							splitted_length1 = _vala_array_length (_tmp25_);
							_splitted_size_ = splitted_length1;
							_tmp27_ = splitted;
							_tmp27__length1 = splitted_length1;
							{
								gchar** line_collection = NULL;
								gint line_collection_length1 = 0;
								gint _line_collection_size_ = 0;
								gint line_it = 0;
								line_collection = _tmp27_;
								line_collection_length1 = _tmp27__length1;
								for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
									const gchar* line = NULL;
									line = line_collection[line_it];
									{
										const gchar* _tmp28_;
										_tmp28_ = line;
										if (string_contains (_tmp28_, "btime")) {
											gchar** space_splitted = NULL;
											const gchar* _tmp29_;
											gchar** _tmp30_;
											gchar** _tmp31_;
											gint space_splitted_length1;
											gint _space_splitted_size_;
											gchar** _tmp32_;
											gint _tmp32__length1;
											_tmp29_ = line;
											_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, " ", 0);
											space_splitted = _tmp31_;
											space_splitted_length1 = _vala_array_length (_tmp30_);
											_space_splitted_size_ = space_splitted_length1;
											_tmp32_ = space_splitted;
											_tmp32__length1 = space_splitted_length1;
											if (_tmp32__length1 == 2) {
												gchar** _tmp33_;
												gint _tmp33__length1;
												const gchar* _tmp34_;
												guint64 _tmp35_ = 0ULL;
												gboolean _tmp36_;
												_tmp33_ = space_splitted;
												_tmp33__length1 = space_splitted_length1;
												_tmp34_ = _tmp33_[1];
												_tmp36_ = uint64_try_parse (_tmp34_, &_tmp35_, NULL, (guint) 0);
												boot_time = _tmp35_;
												if (_tmp36_) {
													if (lockfile_time < boot_time) {
														{
															GFile* _tmp37_;
															_tmp37_ = self->lockfile;
															g_file_delete (_tmp37_, NULL, &_inner_error0_);
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
																goto __catch1_g_error;
															}
														}
														goto __finally1;
														__catch1_g_error:
														{
															GError* e = NULL;
															GError* _tmp38_;
															const gchar* _tmp39_;
															e = _inner_error0_;
															_inner_error0_ = NULL;
															_tmp38_ = e;
															_tmp39_ = _tmp38_->message;
															g_warning ("alpm_utils.vala:240: %s", _tmp39_);
															_g_error_free0 (e);
														}
														__finally1:
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
															space_splitted = (_vala_array_free (space_splitted, space_splitted_length1, (GDestroyNotify) g_free), NULL);
															splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
															if (_inner_error0_->domain == G_SPAWN_ERROR) {
																goto __catch0_g_spawn_error;
															}
															_g_free0 (output);
															_alpm_release0 (alpm_handle);
															g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
															g_clear_error (&_inner_error0_);
															return;
														}
													}
												}
											}
											space_splitted = (_vala_array_free (space_splitted, space_splitted_length1, (GDestroyNotify) g_free), NULL);
										}
									}
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			g_warning ("alpm_utils.vala:252: %s", _tmp41_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (output);
			_alpm_release0 (alpm_handle);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (output);
	}
	_alpm_release0 (alpm_handle);
}

static void
_cb_event_alpm_cb_event (void* ctx,
                         alpm_event_t* data)
{
	cb_event (ctx, data);
}

static void
_cb_progress_alpm_cb_progress (void* ctx,
                               alpm_progress_t progress,
                               const gchar* pkgname,
                               gint percent,
                               guint n_targets,
                               guint current_target)
{
	cb_progress (ctx, progress, pkgname, percent, n_targets, current_target);
}

static void
_cb_question_alpm_cb_question (void* ctx,
                               alpm_question_t* data)
{
	cb_question (ctx, data);
}

static gint
_cb_fetch_alpm_cb_fetch (void* ctx,
                         const gchar* url,
                         const gchar* localpath,
                         gint force)
{
	gint result;
	result = cb_fetch (ctx, url, localpath, force);
	return result;
}

static void
_cb_log_alpm_cb_log (void* ctx,
                     alpm_loglevel_t level,
                     const gchar* fmt,
                     va_list args)
{
	cb_log (ctx, level, fmt, args);
}

alpm_handle_t*
pamac_alpm_utils_get_handle (PamacAlpmUtils* self,
                             gboolean files_db,
                             gboolean tmp_db,
                             gboolean callbacks)
{
	AlpmConfig* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	AlpmConfig* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	AlpmConfig* _tmp13_;
	alpm_handle_t* _tmp14_;
	alpm_handle_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->alpm_config;
	alpm_config_reload (_tmp0_);
	_tmp1_ = self->alpm_config;
	_tmp2_ = alpm_config_get_handle (_tmp1_, files_db, tmp_db, TRUE);
	alpm_handle = _tmp2_;
	_tmp3_ = alpm_handle;
	if (_tmp3_ == NULL) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp4_;
		GPtrArray* _tmp5_;
		gchar* _tmp6_;
		GPtrArray* _tmp7_;
		_tmp4_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
		details = _tmp4_;
		_tmp5_ = details;
		_tmp6_ = g_strdup (_ ("Failed to initialize alpm library"));
		g_ptr_array_add (_tmp5_, _tmp6_);
		_tmp7_ = details;
		pamac_alpm_utils_do_emit_error (self, "Alpm Error", _tmp7_);
		_g_ptr_array_unref0 (details);
	} else {
		if (callbacks) {
			alpm_handle_t* _tmp8_;
			alpm_handle_t* _tmp9_;
			alpm_handle_t* _tmp10_;
			alpm_handle_t* _tmp11_;
			alpm_handle_t* _tmp12_;
			_tmp8_ = alpm_handle;
			alpm_option_set_eventcb (_tmp8_, _cb_event_alpm_cb_event, self);
			_tmp9_ = alpm_handle;
			alpm_option_set_progresscb (_tmp9_, _cb_progress_alpm_cb_progress, self);
			_tmp10_ = alpm_handle;
			alpm_option_set_questioncb (_tmp10_, _cb_question_alpm_cb_question, self);
			_tmp11_ = alpm_handle;
			alpm_option_set_fetchcb (_tmp11_, _cb_fetch_alpm_cb_fetch, self);
			_tmp12_ = alpm_handle;
			alpm_option_set_logcb (_tmp12_, _cb_log_alpm_cb_log, self);
		}
	}
	_tmp13_ = self->alpm_config;
	_tmp14_ = alpm_handle;
	alpm_config_register_syncdbs (_tmp13_, _tmp14_);
	result = alpm_handle;
	return result;
}

gboolean
pamac_alpm_utils_set_pkgreason (PamacAlpmUtils* self,
                                const gchar* sender,
                                const gchar* pkgname,
                                guint reason)
{
	gchar* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_pkg_t* pkg = NULL;
	alpm_handle_t* _tmp3_;
	alpm_db_t* _tmp4_;
	alpm_db_t* _tmp5_;
	alpm_pkg_t* _tmp6_;
	alpm_pkg_t* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp1_;
	_tmp2_ = alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp3_ = alpm_handle;
	_tmp4_ = alpm_get_localdb (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = alpm_db_get_pkg (_tmp5_, pkgname);
	pkg = _tmp6_;
	_tmp7_ = pkg;
	if (_tmp7_ != NULL) {
		alpm_handle_t* _tmp8_;
		_tmp8_ = alpm_handle;
		if (alpm_trans_init (_tmp8_, 0) == 0) {
			alpm_pkg_t* _tmp9_;
			alpm_handle_t* _tmp10_;
			_tmp9_ = pkg;
			alpm_pkg_set_reason (_tmp9_, (alpm_pkgreason_t) reason);
			_tmp10_ = alpm_handle;
			alpm_trans_release (_tmp10_);
			result = TRUE;
			_alpm_release0 (alpm_handle);
			return result;
		}
	}
	result = FALSE;
	_alpm_release0 (alpm_handle);
	return result;
}

gboolean
pamac_alpm_utils_clean_cache (PamacAlpmUtils* self,
                              gchar** filenames,
                              gint filenames_length1)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
			filename_collection = filenames;
			filename_collection_length1 = filenames_length1;
			for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
				const gchar* filename = NULL;
				filename = filename_collection[filename_it];
				{
					GFile* file = NULL;
					const gchar* _tmp0_;
					GFile* _tmp1_;
					GFile* _tmp2_;
					_tmp0_ = filename;
					_tmp1_ = g_file_new_for_path (_tmp0_);
					file = _tmp1_;
					_tmp2_ = file;
					g_file_delete (_tmp2_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						goto __catch0_g_error;
					}
					_g_object_unref0 (file);
				}
			}
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("alpm_utils.vala:301: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	return result;
}

gboolean
pamac_alpm_utils_clean_build_files (PamacAlpmUtils* self,
                                    const gchar* aur_build_dir)
{
	GFile* build_directory = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (aur_build_dir != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (aur_build_dir);
	build_directory = _tmp0_;
	_tmp1_ = build_directory;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = TRUE;
		_g_object_unref0 (build_directory);
		return result;
	}
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* info = NULL;
		_tmp2_ = build_directory;
		_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* absolute_filename = NULL;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			if (g_strcmp0 (_tmp10_, "packages-meta-ext-v1.json.gz") == 0) {
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp11_ = build_directory;
			_tmp12_ = g_file_get_path (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_name (_tmp14_);
			_tmp16_ = g_build_filename (_tmp13_, _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp13_);
			absolute_filename = _tmp17_;
			_tmp18_ = absolute_filename;
			_tmp19_ = g_strdup_printf ("rm -rf %s", _tmp18_);
			_tmp20_ = _tmp19_;
			g_spawn_command_line_sync (_tmp20_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp20_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (absolute_filename);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_g_free0 (absolute_filename);
			_g_object_unref0 (_tmp4_);
		}
		result = TRUE;
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (build_directory);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("alpm_utils.vala:323: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		_g_object_unref0 (build_directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp23_;
	}
	result = FALSE;
	_g_object_unref0 (build_directory);
	return result;
}

static alpm_pkg_t*
pamac_alpm_utils_get_syncpkg (PamacAlpmUtils* self,
                              alpm_handle_t* alpm_handle,
                              const gchar* name)
{
	alpm_pkg_t* pkg = NULL;
	alpm_list_t* syncdbs = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_pkg_t* _tmp8_;
	alpm_pkg_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	pkg = NULL;
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	syncdbs = _tmp1_;
	while (TRUE) {
		alpm_list_t* _tmp2_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp3_;
		gconstpointer _tmp4_;
		alpm_db_t* _tmp5_;
		alpm_pkg_t* _tmp6_;
		alpm_pkg_t* _tmp7_;
		_tmp2_ = syncdbs;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = syncdbs;
		_tmp4_ = _tmp3_->data;
		db = (alpm_db_t*) _tmp4_;
		_tmp5_ = db;
		_tmp6_ = alpm_db_get_pkg (_tmp5_, name);
		pkg = _tmp6_;
		_tmp7_ = pkg;
		if (_tmp7_ != NULL) {
			break;
		}
		syncdbs = alpm_list_next (syncdbs);
	}
	_tmp8_ = pkg;
	result = _tmp8_;
	return result;
}

static gboolean
pamac_alpm_utils_update_dbs (PamacAlpmUtils* self,
                             alpm_handle_t* alpm_handle,
                             gint force)
{
	gboolean success = FALSE;
	alpm_list_t* syncdbs = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_list_t* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	syncdbs = _tmp1_;
	_tmp2_ = syncdbs;
	if (alpm_db_update (alpm_handle, _tmp2_, force) < 0) {
		alpm_errno_t err_no = 0;
		success = FALSE;
		err_no = alpm_errno (alpm_handle);
		if (err_no != 0) {
			if (err_no == ALPM_ERR_HANDLE_LOCK) {
				{
					const gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = self->priv->tmp_path;
					_tmp4_ = g_strdup_printf ("rm -f %s/dbs/db.lck", _tmp3_);
					_tmp5_ = _tmp4_;
					g_spawn_command_line_sync (_tmp5_, NULL, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp5_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp6_ = FALSE;
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch0_g_spawn_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp6_;
					}
				}
				goto __finally0;
				__catch0_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp7_;
					const gchar* _tmp8_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp7_ = e;
					_tmp8_ = _tmp7_->message;
					g_warning ("alpm_utils.vala:354: %s", _tmp8_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp9_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			if (err_no != ALPM_ERR_EXTERNAL_DOWNLOAD) {
				const gchar* _tmp10_;
				_tmp10_ = alpm_strerror (err_no);
				pamac_alpm_utils_do_emit_warning (self, _tmp10_);
			}
		}
	}
	result = success;
	return result;
}

gboolean
pamac_alpm_utils_trans_refresh (PamacAlpmUtils* self,
                                const gchar* sender,
                                gboolean force_refresh)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	gint _tmp4_ = 0;
	gint force = 0;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp12_;
	alpm_handle_t* _tmp13_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp14_;
	GCancellable* _tmp15_;
	GCancellable* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = g_strconcat (_ ("Synchronizing package databases"), "...", NULL);
	_tmp2_ = _tmp1_;
	pamac_alpm_utils_do_emit_action (self, _tmp2_);
	_g_free0 (_tmp2_);
	write_log_file ("synchronizing package lists");
	_tmp3_ = self->cancellable;
	g_cancellable_reset (_tmp3_);
	if (force_refresh) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	force = _tmp4_;
	if (force_refresh) {
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->tmp_path;
			_tmp6_ = g_strdup_printf ("bash -c 'rm -rf %s/dbs'", _tmp5_);
			_tmp7_ = _tmp6_;
			g_spawn_command_line_sync (_tmp7_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp7_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp8_;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("alpm_utils.vala:377: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	_tmp12_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, TRUE);
	alpm_handle = _tmp12_;
	_tmp13_ = alpm_handle;
	if (_tmp13_ == NULL) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp14_ = alpm_handle;
	success = pamac_alpm_utils_update_dbs (self, _tmp14_, force);
	_tmp15_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp15_)) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	if (force_refresh) {
		alpm_handle_t* files_handle = NULL;
		alpm_handle_t* _tmp16_;
		alpm_handle_t* _tmp17_;
		_tmp16_ = pamac_alpm_utils_get_handle (self, TRUE, FALSE, TRUE);
		files_handle = _tmp16_;
		_tmp17_ = files_handle;
		if (_tmp17_ != NULL) {
			alpm_handle_t* _tmp18_;
			_tmp18_ = files_handle;
			pamac_alpm_utils_update_dbs (self, _tmp18_, force);
		}
		_alpm_release0 (files_handle);
	}
	_tmp19_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp19_)) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	} else {
		if (!success) {
			pamac_alpm_utils_do_emit_warning (self, _ ("Failed to synchronize databases"));
		}
	}
	_tmp20_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp20_;
	result = TRUE;
	_alpm_release0 (alpm_handle);
	return result;
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pamac_alpm_utils_add_ignorepkgs (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _pkgname_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* pkgname = NULL;
		_tmp0_ = self->priv->ignorepkgs;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_pkgname_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_pkgname_it);
			pkgname = (const gchar*) _tmp2_;
			_tmp3_ = pkgname;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = pkgname;
			alpm_option_add_ignorepkg (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_remove_ignorepkgs (PamacAlpmUtils* self,
                                    alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _pkgname_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* pkgname = NULL;
		_tmp0_ = self->priv->ignorepkgs;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_pkgname_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_pkgname_it);
			pkgname = (const gchar*) _tmp2_;
			_tmp3_ = pkgname;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = pkgname;
			alpm_option_remove_ignorepkg (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_add_overwrite_files (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* name = NULL;
		_tmp0_ = self->priv->overwrite_files;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_name_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			alpm_option_add_overwrite_file (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_remove_overwrite_files (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* name = NULL;
		_tmp0_ = self->priv->overwrite_files;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_name_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			alpm_option_remove_overwrite_file (alpm_handle, _tmp4_);
		}
	}
}

static PamacAlpmPackage*
pamac_alpm_utils_initialise_pkg (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle,
                                 alpm_pkg_t* alpm_pkg)
{
	alpm_pkg_t* local_pkg = NULL;
	alpm_pkg_t* sync_pkg = NULL;
	alpm_pkgfrom_t _tmp0_;
	alpm_pkgfrom_t _tmp1_;
	alpm_pkg_t* _tmp17_;
	alpm_pkg_t* _tmp18_;
	PamacAlpmPackageStatic* _tmp19_;
	PamacAlpmPackage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = alpm_pkg_get_origin (alpm_pkg);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ALPM_PKG_FROM_LOCALDB) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		alpm_pkg_t* _tmp4_;
		local_pkg = alpm_pkg;
		_tmp2_ = alpm_pkg_get_name (alpm_pkg);
		_tmp3_ = _tmp2_;
		_tmp4_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp3_);
		sync_pkg = _tmp4_;
	} else {
		alpm_pkgfrom_t _tmp5_;
		alpm_pkgfrom_t _tmp6_;
		_tmp5_ = alpm_pkg_get_origin (alpm_pkg);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == ALPM_PKG_FROM_SYNCDB) {
			alpm_db_t* _tmp7_;
			alpm_db_t* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			alpm_pkg_t* _tmp11_;
			_tmp7_ = alpm_get_localdb (alpm_handle);
			_tmp8_ = _tmp7_;
			_tmp9_ = alpm_pkg_get_name (alpm_pkg);
			_tmp10_ = _tmp9_;
			_tmp11_ = alpm_db_get_pkg (_tmp8_, _tmp10_);
			local_pkg = _tmp11_;
			sync_pkg = alpm_pkg;
		} else {
			alpm_db_t* _tmp12_;
			alpm_db_t* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			_tmp12_ = alpm_get_localdb (alpm_handle);
			_tmp13_ = _tmp12_;
			_tmp14_ = alpm_pkg_get_name (alpm_pkg);
			_tmp15_ = _tmp14_;
			_tmp16_ = alpm_db_get_pkg (_tmp13_, _tmp15_);
			local_pkg = _tmp16_;
			sync_pkg = NULL;
		}
	}
	_tmp17_ = local_pkg;
	_tmp18_ = sync_pkg;
	_tmp19_ = pamac_alpm_package_static_new_transaction (alpm_pkg, _tmp17_, _tmp18_);
	result = (PamacAlpmPackage*) _tmp19_;
	return result;
}

gboolean
pamac_alpm_utils_download_updates (PamacAlpmUtils* self,
                                   const gchar* sender)
{
	gchar* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	AlpmConfig* _tmp3_;
	alpm_handle_t* _tmp4_;
	alpm_handle_t* _tmp5_;
	GCancellable* _tmp6_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp7_;
	gboolean _tmp21_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	self->downloading_updates = TRUE;
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp1_;
	_tmp2_ = alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp3_ = self->alpm_config;
	_tmp4_ = alpm_handle;
	alpm_config_register_syncdbs (_tmp3_, _tmp4_);
	_tmp5_ = alpm_handle;
	alpm_option_set_questioncb (_tmp5_, _cb_question_alpm_cb_question, self);
	_tmp6_ = self->cancellable;
	g_cancellable_reset (_tmp6_);
	_tmp7_ = alpm_handle;
	success = pamac_alpm_utils_update_dbs (self, _tmp7_, 0);
	if (success) {
		alpm_handle_t* _tmp8_;
		_tmp8_ = alpm_handle;
		if (alpm_trans_init (_tmp8_, (gint) ALPM_TRANS_FLAG_DOWNLOADONLY) == 0) {
			alpm_handle_t* _tmp9_;
			alpm_handle_t* _tmp20_;
			_tmp9_ = alpm_handle;
			if (alpm_sync_sysupgrade (_tmp9_, 0) == 0) {
				alpm_list_t* err_data = NULL;
				alpm_handle_t* _tmp10_;
				alpm_list_t* _tmp11_ = NULL;
				gint _tmp12_;
				_tmp10_ = alpm_handle;
				_tmp12_ = alpm_trans_prepare (_tmp10_, &_tmp11_);
				_alpm_list_free0 (err_data);
				err_data = _tmp11_;
				if (_tmp12_ == 0) {
					alpm_handle_t* _tmp13_;
					PamacConfig* _tmp14_;
					guint64 _tmp15_;
					guint64 _tmp16_;
					alpm_handle_t* _tmp17_;
					alpm_list_t* _tmp18_ = NULL;
					gint _tmp19_;
					_tmp13_ = alpm_handle;
					_tmp14_ = self->priv->config;
					_tmp15_ = pamac_config_get_max_parallel_downloads (_tmp14_);
					_tmp16_ = _tmp15_;
					pamac_alpm_utils_download_files (self, _tmp13_, _tmp16_, FALSE);
					_tmp17_ = alpm_handle;
					_tmp19_ = alpm_trans_commit (_tmp17_, &_tmp18_);
					_alpm_list_free0 (err_data);
					err_data = _tmp18_;
					if (_tmp19_ == 0) {
						success = TRUE;
					}
				}
				_alpm_list_free0 (err_data);
			}
			_tmp20_ = alpm_handle;
			alpm_trans_release (_tmp20_);
		}
	}
	self->downloading_updates = FALSE;
	if (success) {
		PamacConfig* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp22_ = self->priv->config;
		_tmp23_ = pamac_config_get_offline_upgrade (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp21_ = _tmp24_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		{
			g_spawn_command_line_sync ("touch /system-update", NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp25_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_alpm_release0 (alpm_handle);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp25_;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("alpm_utils.vala:483: %s", _tmp27_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp28_ = FALSE;
			_alpm_release0 (alpm_handle);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp28_;
		}
	}
	result = success;
	_alpm_release0 (alpm_handle);
	return result;
}

static gboolean
pamac_alpm_utils_trans_init (PamacAlpmUtils* self,
                             alpm_handle_t* alpm_handle,
                             gint flags,
                             gboolean emit_error)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->cancellable;
	g_cancellable_reset (_tmp0_);
	if (alpm_trans_init (alpm_handle, (gint) ((alpm_transflag_t) flags)) == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp1_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp5_;
			_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp1_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp2_ = details;
				_tmp3_ = alpm_strerror (err_no);
				_tmp4_ = g_strdup (_tmp3_);
				g_ptr_array_add (_tmp2_, _tmp4_);
			}
			_tmp5_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to init transaction"), _tmp5_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_sysupgrade (PamacAlpmUtils* self,
                                   alpm_handle_t* alpm_handle,
                                   gboolean emit_error)
{
	gint _tmp0_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	pamac_alpm_utils_add_ignorepkgs (self, alpm_handle);
	if (self->priv->enable_downgrade) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	if (alpm_sync_sysupgrade (alpm_handle, _tmp0_) == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp1_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp5_;
			_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp1_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp2_ = details;
				_tmp3_ = alpm_strerror (err_no);
				_tmp4_ = g_strdup (_tmp3_);
				g_ptr_array_add (_tmp2_, _tmp4_);
			}
			_tmp5_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp5_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	}
	{
		GHashTableIter _name_it = {0};
		AlpmConfig* _tmp6_;
		GHashTable* _tmp7_;
		GHashTableIter _tmp8_ = {0};
		const gchar* name = NULL;
		_tmp6_ = self->alpm_config;
		_tmp7_ = _tmp6_->syncfirsts;
		g_hash_table_iter_init (&_tmp8_, _tmp7_);
		_name_it = _tmp8_;
		while (TRUE) {
			gconstpointer _tmp9_;
			const gchar* _tmp10_;
			alpm_pkg_t* pkg = NULL;
			alpm_db_t* _tmp11_;
			alpm_db_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			alpm_pkg_t* _tmp17_;
			_tmp9_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = alpm_get_localdb (alpm_handle);
			_tmp12_ = _tmp11_;
			_tmp13_ = alpm_db_get_pkgcache (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			_tmp16_ = alpm_find_satisfier (_tmp14_, _tmp15_);
			pkg = _tmp16_;
			_tmp17_ = pkg;
			if (_tmp17_ != NULL) {
				alpm_pkg_t* candidate = NULL;
				alpm_pkg_t* _tmp18_;
				alpm_list_t* _tmp19_;
				alpm_list_t* _tmp20_;
				alpm_pkg_t* _tmp21_;
				alpm_pkg_t* _tmp22_;
				_tmp18_ = pkg;
				_tmp19_ = alpm_get_syncdbs (alpm_handle);
				_tmp20_ = _tmp19_;
				_tmp21_ = alpm_sync_get_new_version (_tmp18_, _tmp20_);
				candidate = _tmp21_;
				_tmp22_ = candidate;
				if (_tmp22_ != NULL) {
					GHashTable* _tmp23_;
					alpm_pkg_t* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp23_ = self->priv->to_syncfirst;
					_tmp24_ = candidate;
					_tmp25_ = alpm_pkg_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup (_tmp26_);
					g_hash_table_add (_tmp23_, _tmp27_);
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_add_pkg_real (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle,
                                     alpm_pkg_t* pkg,
                                     gboolean emit_error)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (alpm_add_pkg (alpm_handle, pkg) == -1) {
		alpm_errno_t err_no = 0;
		err_no = alpm_errno (alpm_handle);
		if (err_no == ALPM_ERR_TRANS_DUP_TARGET) {
			result = TRUE;
			return result;
		} else {
			if (emit_error) {
				GPtrArray* details = NULL;
				GPtrArray* _tmp0_;
				GPtrArray* _tmp4_;
				_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				details = _tmp0_;
				if (err_no != 0) {
					GPtrArray* _tmp1_;
					const gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = details;
					_tmp2_ = alpm_strerror (err_no);
					_tmp3_ = g_strdup (_tmp2_);
					g_ptr_array_add (_tmp1_, _tmp3_);
				}
				_tmp4_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp4_);
				_g_ptr_array_unref0 (details);
			}
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_add_pkg (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle,
                                const gchar* pkgname,
                                gboolean emit_error)
{
	alpm_pkg_t* pkg = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_find_dbs_satisfier (alpm_handle, _tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ == NULL) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp4_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp10_;
			_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp4_;
			err_no = alpm_errno (alpm_handle);
			if (err_no == ALPM_ERR_PKG_IGNORED) {
				GPtrArray* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp5_ = details;
				_tmp6_ = alpm_strerror (err_no);
				_tmp7_ = g_strdup (_tmp6_);
				g_ptr_array_add (_tmp5_, _tmp7_);
			} else {
				GPtrArray* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = details;
				_tmp9_ = g_strdup_printf (_ ("target not found: %s"), pkgname);
				g_ptr_array_add (_tmp8_, _tmp9_);
			}
			_tmp10_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp10_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	} else {
		gboolean success = FALSE;
		alpm_pkg_t* _tmp11_;
		_tmp11_ = pkg;
		success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp11_, emit_error);
		if (success) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			alpm_pkg_t* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = pkg;
			_tmp15_ = alpm_pkg_get_name (_tmp14_);
			_tmp16_ = _tmp15_;
			if (string_contains (_tmp16_, "linux4")) {
				_tmp13_ = TRUE;
			} else {
				alpm_pkg_t* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp17_ = pkg;
				_tmp18_ = alpm_pkg_get_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp13_ = string_contains (_tmp19_, "linux5");
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				alpm_pkg_t* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp20_ = pkg;
				_tmp21_ = alpm_pkg_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp12_ = string_contains (_tmp22_, "linux6");
			}
			if (_tmp12_) {
				GPtrArray* installed_kernels = NULL;
				GPtrArray* _tmp23_;
				GPtrArray* installed_modules = NULL;
				GPtrArray* _tmp24_;
				alpm_list_t* pkgcache = NULL;
				alpm_db_t* _tmp25_;
				alpm_db_t* _tmp26_;
				alpm_list_t* _tmp27_;
				alpm_list_t* _tmp28_;
				gchar** splitted = NULL;
				alpm_pkg_t* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				gchar** _tmp68_;
				gchar** _tmp69_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp70_;
				gint _tmp70__length1;
				_tmp23_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				installed_kernels = _tmp23_;
				_tmp24_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				installed_modules = _tmp24_;
				_tmp25_ = alpm_get_localdb (alpm_handle);
				_tmp26_ = _tmp25_;
				_tmp27_ = alpm_db_get_pkgcache (_tmp26_);
				_tmp28_ = _tmp27_;
				pkgcache = _tmp28_;
				while (TRUE) {
					alpm_list_t* _tmp29_;
					alpm_pkg_t* local_pkg = NULL;
					alpm_list_t* _tmp30_;
					gconstpointer _tmp31_;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					alpm_pkg_t* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					_tmp29_ = pkgcache;
					if (!(_tmp29_ != NULL)) {
						break;
					}
					_tmp30_ = pkgcache;
					_tmp31_ = _tmp30_->data;
					local_pkg = (alpm_pkg_t*) _tmp31_;
					_tmp34_ = local_pkg;
					_tmp35_ = alpm_pkg_get_name (_tmp34_);
					_tmp36_ = _tmp35_;
					if (string_contains (_tmp36_, "linux4")) {
						_tmp33_ = TRUE;
					} else {
						alpm_pkg_t* _tmp37_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						_tmp37_ = local_pkg;
						_tmp38_ = alpm_pkg_get_name (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp33_ = string_contains (_tmp39_, "linux5");
					}
					if (_tmp33_) {
						_tmp32_ = TRUE;
					} else {
						alpm_pkg_t* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = local_pkg;
						_tmp41_ = alpm_pkg_get_name (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp32_ = string_contains (_tmp42_, "linux6");
					}
					if (_tmp32_) {
						gchar** local_pkg_splitted = NULL;
						alpm_pkg_t* _tmp43_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						gchar** _tmp46_;
						gchar** _tmp47_;
						gint local_pkg_splitted_length1;
						gint _local_pkg_splitted_size_;
						GPtrArray* _tmp48_;
						gchar** _tmp49_;
						gint _tmp49__length1;
						const gchar* _tmp50_;
						GEqualFunc _tmp51_;
						gchar** _tmp56_;
						gint _tmp56__length1;
						_tmp43_ = local_pkg;
						_tmp44_ = alpm_pkg_get_name (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, "-", 2);
						local_pkg_splitted = _tmp47_;
						local_pkg_splitted_length1 = _vala_array_length (_tmp46_);
						_local_pkg_splitted_size_ = local_pkg_splitted_length1;
						_tmp48_ = installed_kernels;
						_tmp49_ = local_pkg_splitted;
						_tmp49__length1 = local_pkg_splitted_length1;
						_tmp50_ = _tmp49_[0];
						_tmp51_ = g_str_equal;
						if (!g_ptr_array_find_with_equal_func (_tmp48_, _tmp50_, _tmp51_, NULL)) {
							GPtrArray* _tmp52_;
							gchar** _tmp53_;
							gint _tmp53__length1;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp52_ = installed_kernels;
							_tmp53_ = local_pkg_splitted;
							_tmp53__length1 = local_pkg_splitted_length1;
							_tmp54_ = _tmp53_[0];
							_tmp55_ = g_strdup (_tmp54_);
							g_ptr_array_add (_tmp52_, _tmp55_);
						}
						_tmp56_ = local_pkg_splitted;
						_tmp56__length1 = local_pkg_splitted_length1;
						if (_tmp56__length1 == 2) {
							GPtrArray* _tmp57_;
							gchar** _tmp58_;
							gint _tmp58__length1;
							const gchar* _tmp59_;
							GEqualFunc _tmp60_;
							_tmp57_ = installed_modules;
							_tmp58_ = local_pkg_splitted;
							_tmp58__length1 = local_pkg_splitted_length1;
							_tmp59_ = _tmp58_[1];
							_tmp60_ = g_str_equal;
							if (!g_ptr_array_find_with_equal_func (_tmp57_, _tmp59_, _tmp60_, NULL)) {
								GPtrArray* _tmp61_;
								gchar** _tmp62_;
								gint _tmp62__length1;
								const gchar* _tmp63_;
								gchar* _tmp64_;
								_tmp61_ = installed_modules;
								_tmp62_ = local_pkg_splitted;
								_tmp62__length1 = local_pkg_splitted_length1;
								_tmp63_ = _tmp62_[1];
								_tmp64_ = g_strdup (_tmp63_);
								g_ptr_array_add (_tmp61_, _tmp64_);
							}
						}
						local_pkg_splitted = (_vala_array_free (local_pkg_splitted, local_pkg_splitted_length1, (GDestroyNotify) g_free), NULL);
					}
					pkgcache = alpm_list_next (pkgcache);
				}
				_tmp65_ = pkg;
				_tmp66_ = alpm_pkg_get_name (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, "-", 2);
				splitted = _tmp69_;
				splitted_length1 = _vala_array_length (_tmp68_);
				_splitted_size_ = splitted_length1;
				_tmp70_ = splitted;
				_tmp70__length1 = splitted_length1;
				if (_tmp70__length1 == 2) {
					GPtrArray* _tmp71_;
					_tmp71_ = installed_kernels;
					{
						GPtrArray* installed_kernel_collection = NULL;
						guint installed_kernel_index = 0U;
						installed_kernel_collection = _tmp71_;
						for (installed_kernel_index = 0; installed_kernel_index < installed_kernel_collection->len; installed_kernel_index = installed_kernel_index + 1) {
							const gchar* installed_kernel = NULL;
							installed_kernel = (const gchar*) g_ptr_array_index (installed_kernel_collection, installed_kernel_index);
							{
								GString* module = NULL;
								GString* _tmp72_;
								GString* _tmp73_;
								const gchar* _tmp74_;
								GString* _tmp75_;
								GString* _tmp76_;
								gchar** _tmp77_;
								gint _tmp77__length1;
								const gchar* _tmp78_;
								alpm_pkg_t* installed_module_pkg = NULL;
								alpm_db_t* _tmp79_;
								alpm_db_t* _tmp80_;
								GString* _tmp81_;
								const gchar* _tmp82_;
								alpm_pkg_t* _tmp83_;
								alpm_pkg_t* _tmp84_;
								_tmp72_ = g_string_new ("");
								module = _tmp72_;
								_tmp73_ = module;
								_tmp74_ = installed_kernel;
								g_string_append (_tmp73_, _tmp74_);
								_tmp75_ = module;
								g_string_append (_tmp75_, "-");
								_tmp76_ = module;
								_tmp77_ = splitted;
								_tmp77__length1 = splitted_length1;
								_tmp78_ = _tmp77_[1];
								g_string_append (_tmp76_, _tmp78_);
								_tmp79_ = alpm_get_localdb (alpm_handle);
								_tmp80_ = _tmp79_;
								_tmp81_ = module;
								_tmp82_ = _tmp81_->str;
								_tmp83_ = alpm_db_get_pkg (_tmp80_, _tmp82_);
								installed_module_pkg = _tmp83_;
								_tmp84_ = installed_module_pkg;
								if (_tmp84_ == NULL) {
									alpm_pkg_t* module_pkg = NULL;
									GString* _tmp85_;
									const gchar* _tmp86_;
									alpm_pkg_t* _tmp87_;
									alpm_pkg_t* _tmp88_;
									_tmp85_ = module;
									_tmp86_ = _tmp85_->str;
									_tmp87_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp86_);
									module_pkg = _tmp87_;
									_tmp88_ = module_pkg;
									if (_tmp88_ != NULL) {
										alpm_pkg_t* _tmp89_;
										_tmp89_ = module_pkg;
										pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp89_, emit_error);
									}
								}
								_g_string_free0 (module);
							}
						}
					}
				} else {
					gchar** _tmp90_;
					gint _tmp90__length1;
					_tmp90_ = splitted;
					_tmp90__length1 = splitted_length1;
					if (_tmp90__length1 == 1) {
						GPtrArray* _tmp91_;
						_tmp91_ = installed_modules;
						{
							GPtrArray* installed_module_collection = NULL;
							guint installed_module_index = 0U;
							installed_module_collection = _tmp91_;
							for (installed_module_index = 0; installed_module_index < installed_module_collection->len; installed_module_index = installed_module_index + 1) {
								const gchar* installed_module = NULL;
								installed_module = (const gchar*) g_ptr_array_index (installed_module_collection, installed_module_index);
								{
									GString* module = NULL;
									GString* _tmp92_;
									GString* _tmp93_;
									gchar** _tmp94_;
									gint _tmp94__length1;
									const gchar* _tmp95_;
									GString* _tmp96_;
									GString* _tmp97_;
									const gchar* _tmp98_;
									alpm_pkg_t* module_pkg = NULL;
									GString* _tmp99_;
									const gchar* _tmp100_;
									alpm_pkg_t* _tmp101_;
									alpm_pkg_t* _tmp102_;
									_tmp92_ = g_string_new ("");
									module = _tmp92_;
									_tmp93_ = module;
									_tmp94_ = splitted;
									_tmp94__length1 = splitted_length1;
									_tmp95_ = _tmp94_[0];
									g_string_append (_tmp93_, _tmp95_);
									_tmp96_ = module;
									g_string_append (_tmp96_, "-");
									_tmp97_ = module;
									_tmp98_ = installed_module;
									g_string_append (_tmp97_, _tmp98_);
									_tmp99_ = module;
									_tmp100_ = _tmp99_->str;
									_tmp101_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp100_);
									module_pkg = _tmp101_;
									_tmp102_ = module_pkg;
									if (_tmp102_ != NULL) {
										alpm_pkg_t* _tmp103_;
										_tmp103_ = module_pkg;
										pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp103_, emit_error);
									}
									_g_string_free0 (module);
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_ptr_array_unref0 (installed_modules);
				_g_ptr_array_unref0 (installed_kernels);
			}
		}
		result = success;
		return result;
	}
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

GPtrArray*
pamac_alpm_utils_download_pkgs (PamacAlpmUtils* self,
                                const gchar* sender,
                                gchar** urls,
                                gint urls_length1)
{
	gchar* _tmp0_;
	GPtrArray* dload_paths = NULL;
	GPtrArray* _tmp1_;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	alpm_handle_t* _tmp4_;
	gboolean _tmp36_ = FALSE;
	GPtrArray* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	dload_paths = _tmp1_;
	_tmp2_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp2_;
	_tmp3_ = alpm_handle;
	if (_tmp3_ == NULL) {
		result = dload_paths;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp4_ = alpm_handle;
	alpm_option_set_logcb (_tmp4_, _cb_log_alpm_cb_log, self);
	{
		gchar** url_collection = NULL;
		gint url_collection_length1 = 0;
		gint _url_collection_size_ = 0;
		gint url_it = 0;
		url_collection = urls;
		url_collection_length1 = urls_length1;
		for (url_it = 0; url_it < url_collection_length1; url_it = url_it + 1) {
			const gchar* url = NULL;
			url = url_collection[url_it];
			{
				gchar* mirror = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* cachedir = NULL;
				alpm_handle_t* _tmp9_;
				alpm_list_t* _tmp10_;
				alpm_list_t* _tmp11_;
				alpm_list_t* _tmp12_;
				gconstpointer _tmp13_;
				gchar* dload_path = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				GFile* destfile = NULL;
				const gchar* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				GCancellable* _tmp34_;
				_tmp5_ = url;
				_tmp6_ = g_path_get_dirname (_tmp5_);
				mirror = _tmp6_;
				_tmp7_ = url;
				_tmp8_ = g_path_get_basename (_tmp7_);
				_g_free0 (self->current_filename);
				self->current_filename = _tmp8_;
				_tmp9_ = alpm_handle;
				_tmp10_ = alpm_option_get_cachedirs (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = alpm_list_nth (_tmp11_, (gsize) 0);
				_tmp13_ = _tmp12_->data;
				cachedir = (const gchar*) _tmp13_;
				_tmp14_ = cachedir;
				_tmp15_ = self->current_filename;
				_tmp16_ = g_build_filename (_tmp14_, _tmp15_, NULL);
				dload_path = _tmp16_;
				_tmp17_ = dload_path;
				_tmp18_ = g_file_new_for_path (_tmp17_);
				destfile = _tmp18_;
				_tmp19_ = destfile;
				if (g_file_query_exists (_tmp19_, NULL)) {
					GPtrArray* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = dload_paths;
					_tmp21_ = dload_path;
					_tmp22_ = g_strdup (_tmp21_);
					g_ptr_array_add (_tmp20_, _tmp22_);
				} else {
					gint ret = 0;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp23_ = mirror;
					_tmp24_ = self->current_filename;
					_tmp25_ = cachedir;
					ret = dload (self, _tmp23_, _tmp24_, _tmp25_, 0, FALSE, TRUE);
					if (ret == 0) {
						gchar* sig_filename = NULL;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						const gchar* _tmp30_;
						GPtrArray* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp26_ = self->current_filename;
						_tmp27_ = g_strconcat (_tmp26_, ".sig", NULL);
						sig_filename = _tmp27_;
						_tmp28_ = mirror;
						_tmp29_ = sig_filename;
						_tmp30_ = cachedir;
						dload (self, _tmp28_, _tmp29_, _tmp30_, 0, FALSE, FALSE);
						_tmp31_ = dload_paths;
						_tmp32_ = dload_path;
						_tmp33_ = g_strdup (_tmp32_);
						g_ptr_array_add (_tmp31_, _tmp33_);
						_g_free0 (sig_filename);
					}
				}
				_tmp34_ = self->cancellable;
				if (g_cancellable_is_cancelled (_tmp34_)) {
					GPtrArray* _tmp35_;
					_tmp35_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
					_g_ptr_array_unref0 (dload_paths);
					dload_paths = _tmp35_;
					_g_object_unref0 (destfile);
					_g_free0 (dload_path);
					_g_free0 (mirror);
					break;
				}
				_g_object_unref0 (destfile);
				_g_free0 (dload_path);
				_g_free0 (mirror);
			}
		}
	}
	_tmp37_ = dload_paths;
	_tmp38_ = vala_g_ptr_array_get_length (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == 0) {
		GCancellable* _tmp40_;
		_tmp40_ = self->cancellable;
		_tmp36_ = !g_cancellable_is_cancelled (_tmp40_);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp41_;
		GPtrArray* _tmp42_;
		gchar* _tmp43_;
		GPtrArray* _tmp44_;
		_tmp41_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp41_;
		_tmp42_ = details;
		_tmp43_ = g_strdup (_ ("failed to retrieve some files"));
		g_ptr_array_add (_tmp42_, _tmp43_);
		_tmp44_ = details;
		pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp44_);
		_g_ptr_array_unref0 (details);
	}
	result = dload_paths;
	_alpm_release0 (alpm_handle);
	return result;
}

static gboolean
pamac_alpm_utils_trans_load_pkg (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle,
                                 const gchar* path,
                                 gint siglevel,
                                 gboolean emit_error)
{
	alpm_pkg_t* pkg = NULL;
	alpm_pkg_t* _tmp0_ = NULL;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = alpm_pkg_load (alpm_handle, path, 1, siglevel, &_tmp0_);
	pkg = _tmp0_;
	if (_tmp1_ == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp2_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp6_;
			_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp2_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = details;
				_tmp4_ = alpm_strerror (err_no);
				_tmp5_ = g_strdup (_tmp4_);
				g_ptr_array_add (_tmp3_, _tmp5_);
			}
			_tmp6_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp6_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	} else {
		alpm_pkg_t* _tmp7_;
		_tmp7_ = pkg;
		if (alpm_add_pkg (alpm_handle, _tmp7_) == -1) {
			alpm_errno_t err_no = 0;
			err_no = alpm_errno (alpm_handle);
			if (err_no == ALPM_ERR_TRANS_DUP_TARGET) {
				result = TRUE;
				return result;
			} else {
				alpm_pkg_t* _tmp16_;
				if (emit_error) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp8_;
					GPtrArray* _tmp15_;
					_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
					details = _tmp8_;
					if (err_no != 0) {
						GPtrArray* _tmp9_;
						alpm_pkg_t* _tmp10_;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp9_ = details;
						_tmp10_ = pkg;
						_tmp11_ = alpm_pkg_get_name (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = alpm_strerror (err_no);
						_tmp14_ = g_strdup_printf ("%s: %s", _tmp12_, _tmp13_);
						g_ptr_array_add (_tmp9_, _tmp14_);
					}
					_tmp15_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp15_);
					_g_ptr_array_unref0 (details);
				}
				_tmp16_ = pkg;
				_alpm_pkg_free0 (_tmp16_);
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_remove_pkg (PamacAlpmUtils* self,
                                   alpm_handle_t* alpm_handle,
                                   const gchar* pkgname,
                                   gboolean emit_error)
{
	gboolean success = FALSE;
	alpm_pkg_t* pkg = NULL;
	alpm_db_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	success = TRUE;
	_tmp0_ = alpm_get_localdb (alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_db_get_pkg (_tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ == NULL) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			gchar* _tmp6_;
			GPtrArray* _tmp7_;
			_tmp4_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
			details = _tmp4_;
			_tmp5_ = details;
			_tmp6_ = g_strdup_printf (_ ("target not found: %s"), pkgname);
			g_ptr_array_add (_tmp5_, _tmp6_);
			_tmp7_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp7_);
			_g_ptr_array_unref0 (details);
		}
		success = FALSE;
	} else {
		alpm_pkg_t* _tmp8_;
		_tmp8_ = pkg;
		if (alpm_remove_pkg (alpm_handle, _tmp8_) == -1) {
			alpm_errno_t err_no = 0;
			err_no = alpm_errno (alpm_handle);
			if (err_no != ALPM_ERR_TRANS_DUP_TARGET) {
				if (emit_error) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp9_;
					GPtrArray* _tmp16_;
					_tmp9_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
					details = _tmp9_;
					if (err_no != 0) {
						GPtrArray* _tmp10_;
						alpm_pkg_t* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp10_ = details;
						_tmp11_ = pkg;
						_tmp12_ = alpm_pkg_get_name (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = alpm_strerror (err_no);
						_tmp15_ = g_strdup_printf ("%s: %s", _tmp13_, _tmp14_);
						g_ptr_array_add (_tmp10_, _tmp15_);
					}
					_tmp16_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp16_);
					_g_ptr_array_unref0 (details);
				}
				success = FALSE;
			}
		}
	}
	result = success;
	return result;
}

static gboolean
pamac_alpm_utils_trans_prepare_real (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle,
                                     gboolean emit_error)
{
	gboolean success = FALSE;
	gboolean need_retry = FALSE;
	alpm_list_t* err_data = NULL;
	alpm_list_t* _tmp0_ = NULL;
	gint _tmp1_;
	GCancellable* _tmp153_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	need_retry = FALSE;
	_tmp1_ = alpm_trans_prepare (alpm_handle, &_tmp0_);
	_alpm_list_free0 (err_data);
	err_data = _tmp0_;
	if (_tmp1_ == -1) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp2_;
		alpm_errno_t err_no = 0;
		gboolean _tmp132_ = FALSE;
		_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp2_;
		err_no = alpm_errno (alpm_handle);
		switch (err_no) {
			case 0:
			{
				break;
			}
			case ALPM_ERR_PKG_INVALID_ARCH:
			{
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp6_;
				_tmp3_ = details;
				_tmp4_ = alpm_strerror (err_no);
				_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
				g_ptr_array_add (_tmp3_, _tmp5_);
				_tmp6_ = err_data;
				list = _tmp6_;
				while (TRUE) {
					alpm_list_t* _tmp7_;
					const gchar* pkgname = NULL;
					alpm_list_t* _tmp8_;
					gconstpointer _tmp9_;
					GPtrArray* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp7_ = list;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = list;
					_tmp9_ = _tmp8_->data;
					pkgname = _tmp9_;
					_tmp10_ = details;
					_tmp11_ = pkgname;
					_tmp12_ = g_strdup_printf (_ ("package %s does not have a valid architecture"), _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat ("- ", _tmp13_, NULL);
					g_ptr_array_add (_tmp10_, _tmp14_);
					_g_free0 (_tmp13_);
					_tmp15_ = pkgname;
					_g_free0 (_tmp15_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_UNSATISFIED_DEPS:
			{
				GPtrArray* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp19_;
				GHashTable* depstrings = NULL;
				GHashFunc _tmp20_;
				GEqualFunc _tmp21_;
				GHashTable* _tmp22_;
				_tmp16_ = details;
				_tmp17_ = alpm_strerror (err_no);
				_tmp18_ = g_strconcat (_tmp17_, ":", NULL);
				g_ptr_array_add (_tmp16_, _tmp18_);
				_tmp19_ = err_data;
				list = _tmp19_;
				_tmp20_ = g_str_hash;
				_tmp21_ = g_str_equal;
				_tmp22_ = g_hash_table_new_full (_tmp20_, _tmp21_, NULL, _g_free0_);
				depstrings = _tmp22_;
				while (TRUE) {
					alpm_list_t* _tmp23_;
					alpm_depmissing_t* miss = NULL;
					alpm_list_t* _tmp24_;
					gconstpointer _tmp25_;
					gchar* depstring = NULL;
					alpm_depmissing_t* _tmp26_;
					alpm_depend_t* _tmp27_;
					gchar* _tmp28_;
					GHashTable* _tmp29_;
					const gchar* _tmp30_;
					alpm_list_t* trans_add = NULL;
					alpm_list_t* _tmp32_;
					alpm_pkg_t* pkg = NULL;
					alpm_depmissing_t* _tmp33_;
					const gchar* _tmp34_;
					GHashTable* _tmp98_;
					gchar* _tmp99_;
					alpm_depmissing_t* _tmp100_;
					_tmp23_ = list;
					if (!(_tmp23_ != NULL)) {
						break;
					}
					_tmp24_ = list;
					_tmp25_ = _tmp24_->data;
					miss = _tmp25_;
					_tmp26_ = miss;
					_tmp27_ = _tmp26_->depend;
					_tmp28_ = alpm_dep_compute_string (_tmp27_);
					depstring = _tmp28_;
					_tmp29_ = depstrings;
					_tmp30_ = depstring;
					if (g_hash_table_contains (_tmp29_, _tmp30_)) {
						alpm_depmissing_t* _tmp31_;
						_tmp31_ = miss;
						_alpm_depmissing_free0 (_tmp31_);
						list = alpm_list_next (list);
						_g_free0 (depstring);
						continue;
					}
					_tmp32_ = alpm_trans_get_add (alpm_handle);
					trans_add = _tmp32_;
					_tmp33_ = miss;
					_tmp34_ = _tmp33_->causingpkg;
					if (_tmp34_ == NULL) {
						GPtrArray* _tmp35_;
						const gchar* _tmp36_;
						alpm_depmissing_t* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp35_ = details;
						_tmp36_ = depstring;
						_tmp37_ = miss;
						_tmp38_ = _tmp37_->target;
						_tmp39_ = g_strdup_printf (_ ("unable to satisfy dependency '%1$s' required by %2$s"), _tmp36_, _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strconcat ("- ", _tmp40_, NULL);
						g_ptr_array_add (_tmp35_, _tmp41_);
						_g_free0 (_tmp40_);
					} else {
						alpm_list_t* _tmp42_;
						alpm_depmissing_t* _tmp43_;
						const gchar* _tmp44_;
						alpm_pkg_t* _tmp45_;
						alpm_pkg_t* _tmp46_;
						_tmp42_ = trans_add;
						_tmp43_ = miss;
						_tmp44_ = _tmp43_->causingpkg;
						_tmp45_ = alpm_pkg_find (_tmp42_, _tmp44_);
						pkg = _tmp45_;
						_tmp46_ = pkg;
						if (_tmp46_ != NULL) {
							if (((gint) self->priv->commit_retries) < 1) {
								gchar* _tmp47_;
								gchar* _tmp48_;
								alpm_depmissing_t* _tmp49_;
								const gchar* _tmp50_;
								alpm_pkg_t* _tmp51_;
								const gchar* _tmp52_;
								const gchar* _tmp53_;
								const gchar* _tmp54_;
								alpm_depmissing_t* _tmp55_;
								const gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								alpm_depmissing_t* _tmp61_;
								const gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								GHashTable* _tmp65_;
								alpm_depmissing_t* _tmp66_;
								const gchar* _tmp67_;
								gchar* _tmp68_;
								alpm_depmissing_t* _tmp69_;
								const gchar* _tmp70_;
								_tmp47_ = g_strconcat (_ ("Warning"), ": ", NULL);
								_tmp48_ = _tmp47_;
								_tmp49_ = miss;
								_tmp50_ = _tmp49_->causingpkg;
								_tmp51_ = pkg;
								_tmp52_ = alpm_pkg_get_version (_tmp51_);
								_tmp53_ = _tmp52_;
								_tmp54_ = depstring;
								_tmp55_ = miss;
								_tmp56_ = _tmp55_->target;
								_tmp57_ = g_strdup_printf (_ ("installing %1$s (%2$s) breaks dependency '%3$s' required by %4$s"), _tmp50_, _tmp53_, _tmp54_, _tmp56_);
								_tmp58_ = _tmp57_;
								_tmp59_ = g_strconcat (_tmp48_, _tmp58_, NULL);
								_tmp60_ = _tmp59_;
								pamac_alpm_utils_do_emit_warning (self, _tmp60_);
								_g_free0 (_tmp60_);
								_g_free0 (_tmp58_);
								_g_free0 (_tmp48_);
								_tmp61_ = miss;
								_tmp62_ = _tmp61_->target;
								_tmp63_ = g_strdup_printf (_ ("Add %s to remove"), _tmp62_);
								_tmp64_ = _tmp63_;
								pamac_alpm_utils_do_emit_warning (self, _tmp64_);
								_g_free0 (_tmp64_);
								_tmp65_ = self->priv->required_to_remove;
								_tmp66_ = miss;
								_tmp67_ = _tmp66_->target;
								_tmp68_ = g_strdup (_tmp67_);
								g_hash_table_add (_tmp65_, _tmp68_);
								_tmp69_ = miss;
								_tmp70_ = _tmp69_->target;
								if (pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp70_, TRUE)) {
									need_retry = TRUE;
								}
							} else {
								GPtrArray* _tmp71_;
								alpm_depmissing_t* _tmp72_;
								const gchar* _tmp73_;
								alpm_pkg_t* _tmp74_;
								const gchar* _tmp75_;
								const gchar* _tmp76_;
								const gchar* _tmp77_;
								alpm_depmissing_t* _tmp78_;
								const gchar* _tmp79_;
								gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp82_;
								GPtrArray* _tmp83_;
								alpm_depmissing_t* _tmp84_;
								const gchar* _tmp85_;
								gchar* _tmp86_;
								gchar* _tmp87_;
								gchar* _tmp88_;
								_tmp71_ = details;
								_tmp72_ = miss;
								_tmp73_ = _tmp72_->causingpkg;
								_tmp74_ = pkg;
								_tmp75_ = alpm_pkg_get_version (_tmp74_);
								_tmp76_ = _tmp75_;
								_tmp77_ = depstring;
								_tmp78_ = miss;
								_tmp79_ = _tmp78_->target;
								_tmp80_ = g_strdup_printf (_ ("installing %1$s (%2$s) breaks dependency '%3$s' required by %4$s"), _tmp73_, _tmp76_, _tmp77_, _tmp79_);
								_tmp81_ = _tmp80_;
								_tmp82_ = g_strconcat ("- ", _tmp81_, NULL);
								g_ptr_array_add (_tmp71_, _tmp82_);
								_g_free0 (_tmp81_);
								_tmp83_ = details;
								_tmp84_ = miss;
								_tmp85_ = _tmp84_->target;
								_tmp86_ = g_strdup_printf (_ ("if possible, remove %s and retry"), _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = g_strconcat ("- ", _tmp87_, NULL);
								g_ptr_array_add (_tmp83_, _tmp88_);
								_g_free0 (_tmp87_);
							}
						} else {
							GPtrArray* _tmp89_;
							alpm_depmissing_t* _tmp90_;
							const gchar* _tmp91_;
							const gchar* _tmp92_;
							alpm_depmissing_t* _tmp93_;
							const gchar* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							_tmp89_ = details;
							_tmp90_ = miss;
							_tmp91_ = _tmp90_->causingpkg;
							_tmp92_ = depstring;
							_tmp93_ = miss;
							_tmp94_ = _tmp93_->target;
							_tmp95_ = g_strdup_printf (_ ("removing %1$s breaks dependency '%2$s' required by %3$s"), _tmp91_, _tmp92_, _tmp94_);
							_tmp96_ = _tmp95_;
							_tmp97_ = g_strconcat ("- ", _tmp96_, NULL);
							g_ptr_array_add (_tmp89_, _tmp97_);
							_g_free0 (_tmp96_);
						}
					}
					_tmp98_ = depstrings;
					_tmp99_ = depstring;
					depstring = NULL;
					g_hash_table_add (_tmp98_, _tmp99_);
					_tmp100_ = miss;
					_alpm_depmissing_free0 (_tmp100_);
					list = alpm_list_next (list);
					_g_free0 (depstring);
				}
				_g_hash_table_unref0 (depstrings);
				break;
			}
			case ALPM_ERR_CONFLICTING_DEPS:
			{
				GPtrArray* _tmp101_;
				const gchar* _tmp102_;
				gchar* _tmp103_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp104_;
				_tmp101_ = details;
				_tmp102_ = alpm_strerror (err_no);
				_tmp103_ = g_strconcat (_tmp102_, ":", NULL);
				g_ptr_array_add (_tmp101_, _tmp103_);
				_tmp104_ = err_data;
				list = _tmp104_;
				while (TRUE) {
					alpm_list_t* _tmp105_;
					alpm_conflict_t* conflict = NULL;
					alpm_list_t* _tmp106_;
					gconstpointer _tmp107_;
					gchar* conflict_detail = NULL;
					alpm_conflict_t* _tmp108_;
					alpm_pkg_t* _tmp109_;
					alpm_conflict_t* _tmp110_;
					alpm_pkg_t* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					alpm_conflict_t* _tmp116_;
					alpm_depend_t* _tmp117_;
					GPtrArray* _tmp126_;
					gchar* _tmp127_;
					alpm_conflict_t* _tmp128_;
					_tmp105_ = list;
					if (!(_tmp105_ != NULL)) {
						break;
					}
					_tmp106_ = list;
					_tmp107_ = _tmp106_->data;
					conflict = _tmp107_;
					_tmp108_ = conflict;
					_tmp109_ = _tmp108_->package1;
					_tmp110_ = conflict;
					_tmp111_ = _tmp110_->package2;
					_tmp112_ = g_strdup_printf (_ ("%1$s and %2$s are in conflict"), _tmp109_, _tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = g_strconcat ("- ", _tmp113_, NULL);
					_tmp115_ = _tmp114_;
					_g_free0 (_tmp113_);
					conflict_detail = _tmp115_;
					_tmp116_ = conflict;
					_tmp117_ = _tmp116_->reason;
					if (_tmp117_->mod != ALPM_DEP_MOD_ANY) {
						const gchar* _tmp118_;
						alpm_conflict_t* _tmp119_;
						alpm_depend_t* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						_tmp118_ = conflict_detail;
						_tmp119_ = conflict;
						_tmp120_ = _tmp119_->reason;
						_tmp121_ = alpm_dep_compute_string (_tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = g_strdup_printf (" (%s)", _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = g_strconcat (_tmp118_, _tmp124_, NULL);
						_g_free0 (conflict_detail);
						conflict_detail = _tmp125_;
						_g_free0 (_tmp124_);
						_g_free0 (_tmp122_);
					}
					_tmp126_ = details;
					_tmp127_ = conflict_detail;
					conflict_detail = NULL;
					g_ptr_array_add (_tmp126_, _tmp127_);
					_tmp128_ = conflict;
					_alpm_conflict_free0 (_tmp128_);
					list = alpm_list_next (list);
					_g_free0 (conflict_detail);
				}
				break;
			}
			default:
			{
				GPtrArray* _tmp129_;
				const gchar* _tmp130_;
				gchar* _tmp131_;
				_tmp129_ = details;
				_tmp130_ = alpm_strerror (err_no);
				_tmp131_ = g_strdup (_tmp130_);
				g_ptr_array_add (_tmp129_, _tmp131_);
				break;
			}
		}
		if (need_retry) {
			_tmp132_ = ((gint) self->priv->commit_retries) < 1;
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			guint8 _tmp133_;
			_tmp133_ = self->priv->commit_retries;
			self->priv->commit_retries = _tmp133_ + 1;
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, TRUE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
			if (emit_error) {
				GPtrArray* _tmp134_;
				_tmp134_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp134_);
			}
			success = FALSE;
		}
		_g_ptr_array_unref0 (details);
	} else {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp135_;
			gboolean found_locked_pkg = FALSE;
			alpm_list_t* to_remove = NULL;
			alpm_list_t* _tmp136_;
			_tmp135_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp135_;
			found_locked_pkg = FALSE;
			_tmp136_ = alpm_trans_get_remove (alpm_handle);
			to_remove = _tmp136_;
			while (TRUE) {
				alpm_list_t* _tmp137_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp138_;
				gconstpointer _tmp139_;
				AlpmConfig* _tmp140_;
				GHashTable* _tmp141_;
				alpm_pkg_t* _tmp142_;
				const gchar* _tmp143_;
				const gchar* _tmp144_;
				_tmp137_ = to_remove;
				if (!(_tmp137_ != NULL)) {
					break;
				}
				_tmp138_ = to_remove;
				_tmp139_ = _tmp138_->data;
				pkg = (alpm_pkg_t*) _tmp139_;
				_tmp140_ = self->alpm_config;
				_tmp141_ = _tmp140_->holdpkgs;
				_tmp142_ = pkg;
				_tmp143_ = alpm_pkg_get_name (_tmp142_);
				_tmp144_ = _tmp143_;
				if (g_hash_table_contains (_tmp141_, _tmp144_)) {
					GPtrArray* _tmp145_;
					alpm_pkg_t* _tmp146_;
					const gchar* _tmp147_;
					const gchar* _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					_tmp145_ = details;
					_tmp146_ = pkg;
					_tmp147_ = alpm_pkg_get_name (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = g_strdup_printf (_ ("%s needs to be removed but it is a locked package"), _tmp148_);
					_tmp150_ = _tmp149_;
					_tmp151_ = g_strconcat ("- ", _tmp150_, NULL);
					g_ptr_array_add (_tmp145_, _tmp151_);
					_g_free0 (_tmp150_);
					found_locked_pkg = TRUE;
				}
				to_remove = alpm_list_next (to_remove);
			}
			if (found_locked_pkg) {
				GPtrArray* _tmp152_;
				_tmp152_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp152_);
				pamac_alpm_utils_trans_release (self, alpm_handle);
				success = FALSE;
			}
			_g_ptr_array_unref0 (details);
		}
	}
	_tmp153_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp153_)) {
		pamac_alpm_utils_trans_release (self, alpm_handle);
		result = FALSE;
		_alpm_list_free0 (err_data);
		return result;
	}
	result = success;
	_alpm_list_free0 (err_data);
	return result;
}

static void
pamac_alpm_utils_prepare_aur_db (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	gchar* devel_pkgname = NULL;
	gchar* _tmp20_;
	alpm_db_t* _tmp21_;
	alpm_db_t* _tmp22_;
	alpm_list_t* _tmp23_;
	alpm_list_t* _tmp24_;
	const gchar* _tmp25_;
	alpm_pkg_t* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->tmp_path;
		_tmp1_ = alpm_option_get_dbpath (alpm_handle);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("cp %s/pamac_aur.db %ssync", _tmp0_, _tmp2_);
		_tmp4_ = _tmp3_;
		g_spawn_command_line_sync (_tmp4_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		pamac_alpm_utils_do_emit_warning (self, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp7_;
		GHashTableIter _tmp8_ = {0};
		const gchar* name = NULL;
		_tmp7_ = self->priv->to_build;
		g_hash_table_iter_init (&_tmp8_, _tmp7_);
		_name_it = _tmp8_;
		while (TRUE) {
			gconstpointer _tmp9_;
			const gchar* _tmp10_;
			gchar* debug_pkg_name = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			alpm_db_t* _tmp13_;
			alpm_db_t* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			_tmp9_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = name;
			_tmp12_ = g_strdup_printf ("%s-debug", _tmp11_);
			debug_pkg_name = _tmp12_;
			_tmp13_ = alpm_get_localdb (alpm_handle);
			_tmp14_ = _tmp13_;
			_tmp15_ = debug_pkg_name;
			_tmp16_ = alpm_db_get_pkg (_tmp14_, _tmp15_);
			if (_tmp16_ != NULL) {
				GHashTable* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = self->priv->to_remove;
				_tmp18_ = debug_pkg_name;
				_tmp19_ = g_strdup (_tmp18_);
				g_hash_table_add (_tmp17_, _tmp19_);
			}
			_g_free0 (debug_pkg_name);
		}
	}
	_tmp20_ = g_strdup ("base-devel");
	devel_pkgname = _tmp20_;
	_tmp21_ = alpm_get_localdb (alpm_handle);
	_tmp22_ = _tmp21_;
	_tmp23_ = alpm_db_get_pkgcache (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = devel_pkgname;
	_tmp26_ = alpm_find_satisfier (_tmp24_, _tmp25_);
	if (_tmp26_ == NULL) {
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp27_;
		alpm_list_t* _tmp28_;
		const gchar* _tmp29_;
		alpm_pkg_t* _tmp30_;
		alpm_pkg_t* _tmp31_;
		_tmp27_ = alpm_get_syncdbs (alpm_handle);
		_tmp28_ = _tmp27_;
		_tmp29_ = devel_pkgname;
		_tmp30_ = alpm_find_dbs_satisfier (alpm_handle, _tmp28_, _tmp29_);
		pkg = _tmp30_;
		_tmp31_ = pkg;
		if (_tmp31_ != NULL) {
			GHashTable* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp32_ = self->priv->to_install;
			_tmp33_ = devel_pkgname;
			_tmp34_ = g_strdup (_tmp33_);
			g_hash_table_add (_tmp32_, _tmp34_);
		}
	} else {
		GHashTable* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = self->priv->to_remove;
		_tmp36_ = devel_pkgname;
		g_hash_table_remove (_tmp35_, _tmp36_);
	}
	_g_free0 (devel_pkgname);
}

static void
pamac_alpm_utils_remove_aur_db (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = alpm_option_get_dbpath (alpm_handle);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("rm -f %ssync/pamac_aur.db", _tmp1_);
		_tmp3_ = _tmp2_;
		g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("alpm_utils.vala:885: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
pamac_alpm_utils_trans_check_prepare (PamacAlpmUtils* self,
                                      gboolean sysupgrade,
                                      gboolean enable_downgrade,
                                      gboolean simple_install,
                                      gint trans_flags,
                                      GHashTable* to_install,
                                      GHashTable* to_remove,
                                      GHashTable* local_paths,
                                      GHashTable* remote_paths,
                                      GHashTable* to_build,
                                      GHashTable* ignorepkgs,
                                      GHashTable* overwrite_files,
                                      PamacTransactionSummary** summary)
{
	alpm_handle_t* tmp_handle = NULL;
	alpm_handle_t* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	gchar* _tmp3_;
	alpm_db_t* aur_db = NULL;
	guint _tmp46_;
	guint _tmp47_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	guint _tmp53_;
	guint _tmp54_;
	alpm_handle_t* _tmp77_;
	alpm_handle_t* _tmp78_;
	alpm_handle_t* _tmp79_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp80_;
	alpm_db_t* _tmp81_;
	alpm_db_t* _tmp84_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (to_install != NULL, FALSE);
	g_return_val_if_fail (to_remove != NULL, FALSE);
	g_return_val_if_fail (local_paths != NULL, FALSE);
	g_return_val_if_fail (remote_paths != NULL, FALSE);
	g_return_val_if_fail (to_build != NULL, FALSE);
	g_return_val_if_fail (ignorepkgs != NULL, FALSE);
	g_return_val_if_fail (overwrite_files != NULL, FALSE);
	g_return_val_if_fail (*summary != NULL, FALSE);
	_tmp0_ = pamac_alpm_utils_get_handle (self, FALSE, TRUE, FALSE);
	tmp_handle = _tmp0_;
	_tmp1_ = tmp_handle;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_alpm_release0 (tmp_handle);
		return result;
	}
	_tmp2_ = tmp_handle;
	alpm_option_set_questioncb (_tmp2_, _cb_question_alpm_cb_question, self);
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp3_;
	self->priv->sysupgrade = sysupgrade;
	self->priv->enable_downgrade = enable_downgrade;
	self->priv->simple_install = simple_install;
	self->priv->trans_flags = trans_flags | ALPM_TRANS_FLAG_NOLOCK;
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp4_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp4_, to_install);
		_name_it = _tmp4_;
		while (TRUE) {
			gconstpointer _tmp5_;
			const gchar* _tmp6_;
			GHashTable* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp5_;
			_tmp6_ = name;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = self->priv->to_install;
			_tmp8_ = name;
			_tmp9_ = g_strdup (_tmp8_);
			g_hash_table_add (_tmp7_, _tmp9_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp10_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp10_, to_remove);
		_name_it = _tmp10_;
		while (TRUE) {
			gconstpointer _tmp11_;
			const gchar* _tmp12_;
			GHashTable* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp11_;
			_tmp12_ = name;
			if (!(_tmp12_ != NULL)) {
				break;
			}
			_tmp13_ = self->priv->to_remove;
			_tmp14_ = name;
			_tmp15_ = g_strdup (_tmp14_);
			g_hash_table_add (_tmp13_, _tmp15_);
		}
	}
	{
		GHashTableIter _path_it = {0};
		GHashTableIter _tmp16_ = {0};
		const gchar* path = NULL;
		g_hash_table_iter_init (&_tmp16_, local_paths);
		_path_it = _tmp16_;
		while (TRUE) {
			gconstpointer _tmp17_;
			const gchar* _tmp18_;
			GHashTable* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = _vala_hash_set_next_value (&_path_it);
			path = (const gchar*) _tmp17_;
			_tmp18_ = path;
			if (!(_tmp18_ != NULL)) {
				break;
			}
			_tmp19_ = self->priv->local_paths;
			_tmp20_ = path;
			_tmp21_ = g_strdup (_tmp20_);
			g_hash_table_add (_tmp19_, _tmp21_);
		}
	}
	{
		GHashTableIter _path_it = {0};
		GHashTableIter _tmp22_ = {0};
		const gchar* path = NULL;
		g_hash_table_iter_init (&_tmp22_, remote_paths);
		_path_it = _tmp22_;
		while (TRUE) {
			gconstpointer _tmp23_;
			const gchar* _tmp24_;
			GHashTable* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp23_ = _vala_hash_set_next_value (&_path_it);
			path = (const gchar*) _tmp23_;
			_tmp24_ = path;
			if (!(_tmp24_ != NULL)) {
				break;
			}
			_tmp25_ = self->priv->remote_paths;
			_tmp26_ = path;
			_tmp27_ = g_strdup (_tmp26_);
			g_hash_table_add (_tmp25_, _tmp27_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp28_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp28_, to_build);
		_name_it = _tmp28_;
		while (TRUE) {
			gconstpointer _tmp29_;
			const gchar* _tmp30_;
			GHashTable* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp29_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp29_;
			_tmp30_ = name;
			if (!(_tmp30_ != NULL)) {
				break;
			}
			_tmp31_ = self->priv->to_build;
			_tmp32_ = name;
			_tmp33_ = g_strdup (_tmp32_);
			g_hash_table_add (_tmp31_, _tmp33_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp34_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp34_, ignorepkgs);
		_name_it = _tmp34_;
		while (TRUE) {
			gconstpointer _tmp35_;
			const gchar* _tmp36_;
			GHashTable* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp35_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp35_;
			_tmp36_ = name;
			if (!(_tmp36_ != NULL)) {
				break;
			}
			_tmp37_ = self->priv->ignorepkgs;
			_tmp38_ = name;
			_tmp39_ = g_strdup (_tmp38_);
			g_hash_table_add (_tmp37_, _tmp39_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp40_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp40_, overwrite_files);
		_name_it = _tmp40_;
		while (TRUE) {
			gconstpointer _tmp41_;
			const gchar* _tmp42_;
			GHashTable* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp41_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp41_;
			_tmp42_ = name;
			if (!(_tmp42_ != NULL)) {
				break;
			}
			_tmp43_ = self->priv->overwrite_files;
			_tmp44_ = name;
			_tmp45_ = g_strdup (_tmp44_);
			g_hash_table_add (_tmp43_, _tmp45_);
		}
	}
	aur_db = NULL;
	_tmp46_ = g_hash_table_size (to_remove);
	_tmp47_ = _tmp46_;
	if (_tmp47_ > ((guint) 0)) {
		alpm_handle_t* _tmp48_;
		_tmp48_ = tmp_handle;
		pamac_alpm_utils_intern_compute_pkgs_to_remove (self, _tmp48_);
	}
	_tmp53_ = g_hash_table_size (to_install);
	_tmp54_ = _tmp53_;
	if (_tmp54_ > ((guint) 0)) {
		_tmp52_ = TRUE;
	} else {
		_tmp52_ = sysupgrade;
	}
	if (_tmp52_) {
		_tmp51_ = TRUE;
	} else {
		guint _tmp55_;
		guint _tmp56_;
		_tmp55_ = g_hash_table_size (to_build);
		_tmp56_ = _tmp55_;
		_tmp51_ = _tmp56_ > ((guint) 0);
	}
	if (_tmp51_) {
		_tmp50_ = TRUE;
	} else {
		guint _tmp57_;
		guint _tmp58_;
		_tmp57_ = g_hash_table_size (local_paths);
		_tmp58_ = _tmp57_;
		_tmp50_ = _tmp58_ > ((guint) 0);
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		guint _tmp59_;
		guint _tmp60_;
		_tmp59_ = g_hash_table_size (remote_paths);
		_tmp60_ = _tmp59_;
		_tmp49_ = _tmp60_ > ((guint) 0);
	}
	if (_tmp49_) {
		guint _tmp61_;
		guint _tmp62_;
		alpm_handle_t* _tmp74_;
		alpm_db_t* _tmp75_;
		_tmp61_ = g_hash_table_size (to_build);
		_tmp62_ = _tmp61_;
		if (_tmp62_ > ((guint) 0)) {
			alpm_handle_t* _tmp63_;
			alpm_handle_t* _tmp64_;
			alpm_db_t* _tmp65_;
			alpm_db_t* _tmp66_;
			_tmp63_ = tmp_handle;
			pamac_alpm_utils_prepare_aur_db (self, _tmp63_);
			_tmp64_ = tmp_handle;
			_tmp65_ = alpm_register_syncdb (_tmp64_, "pamac_aur", 0);
			aur_db = _tmp65_;
			_tmp66_ = aur_db;
			if (_tmp66_ == NULL) {
				alpm_handle_t* _tmp67_;
				alpm_errno_t err_no = 0;
				alpm_handle_t* _tmp68_;
				GPtrArray* details = NULL;
				GPtrArray* _tmp69_;
				GPtrArray* _tmp70_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				GPtrArray* _tmp73_;
				_tmp67_ = tmp_handle;
				pamac_alpm_utils_remove_aur_db (self, _tmp67_);
				_tmp68_ = tmp_handle;
				err_no = alpm_errno (_tmp68_);
				_tmp69_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
				details = _tmp69_;
				_tmp70_ = details;
				_tmp71_ = alpm_strerror (err_no);
				_tmp72_ = g_strdup (_tmp71_);
				g_ptr_array_add (_tmp70_, _tmp72_);
				_tmp73_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to initialize AUR database"), _tmp73_);
				result = FALSE;
				_g_ptr_array_unref0 (details);
				_alpm_release0 (tmp_handle);
				return result;
			}
		}
		_tmp74_ = tmp_handle;
		_tmp75_ = aur_db;
		pamac_alpm_utils_intern_compute_pkgs_to_install (self, _tmp74_, _tmp75_);
	}
	if ((trans_flags & ALPM_TRANS_FLAG_RECURSE) != 0) {
		alpm_handle_t* _tmp76_;
		_tmp76_ = tmp_handle;
		pamac_alpm_utils_intern_compute_orphans_to_remove (self, _tmp76_);
	}
	_tmp77_ = tmp_handle;
	alpm_option_set_eventcb (_tmp77_, _cb_event_alpm_cb_event, self);
	_tmp78_ = tmp_handle;
	alpm_option_set_progresscb (_tmp78_, _cb_progress_alpm_cb_progress, self);
	_tmp79_ = tmp_handle;
	alpm_option_set_logcb (_tmp79_, _cb_log_alpm_cb_log, self);
	_tmp80_ = tmp_handle;
	_tmp81_ = aur_db;
	success = pamac_alpm_utils_trans_prepare (self, _tmp80_, _tmp81_);
	if (success) {
		alpm_handle_t* _tmp82_;
		alpm_handle_t* _tmp83_;
		_tmp82_ = tmp_handle;
		pamac_alpm_utils_get_transaction_summary (self, _tmp82_, summary);
		_tmp83_ = tmp_handle;
		pamac_alpm_utils_trans_release (self, _tmp83_);
	}
	_tmp84_ = aur_db;
	if (_tmp84_ != NULL) {
		alpm_handle_t* _tmp85_;
		_tmp85_ = tmp_handle;
		pamac_alpm_utils_remove_aur_db (self, _tmp85_);
	}
	pamac_alpm_utils_trans_reset (self);
	result = success;
	_alpm_release0 (tmp_handle);
	return result;
}

gboolean
pamac_alpm_utils_trans_run (PamacAlpmUtils* self,
                            const gchar* sender,
                            gboolean sysupgrade,
                            gboolean enable_downgrade,
                            gboolean simple_install,
                            gboolean keep_built_pkgs,
                            gint trans_flags,
                            gchar** to_install,
                            gint to_install_length1,
                            gchar** to_remove,
                            gint to_remove_length1,
                            gchar** to_load_local,
                            gint to_load_local_length1,
                            gchar** to_load_remote,
                            gint to_load_remote_length1,
                            gchar** to_install_as_dep,
                            gint to_install_as_dep_length1,
                            gchar** ignorepkgs,
                            gint ignorepkgs_length1,
                            gchar** overwrite_files,
                            gint overwrite_files_length1)
{
	gchar* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	alpm_handle_t* _tmp27_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	self->priv->sysupgrade = sysupgrade;
	self->priv->enable_downgrade = enable_downgrade;
	self->priv->simple_install = simple_install;
	self->priv->no_confirm_commit = TRUE;
	self->priv->keep_built_pkgs = keep_built_pkgs;
	self->priv->trans_flags = trans_flags;
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_CASCADE);
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_RECURSE);
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp1_;
	_tmp2_ = alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp3_ = alpm_handle;
	alpm_option_set_questioncb (_tmp3_, _cb_question_alpm_cb_question, self);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_install;
		name_collection_length1 = to_install_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = self->priv->to_install;
				_tmp5_ = name;
				_tmp6_ = g_strdup (_tmp5_);
				g_hash_table_add (_tmp4_, _tmp6_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_remove;
		name_collection_length1 = to_remove_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp7_ = self->priv->to_remove;
				_tmp8_ = name;
				_tmp9_ = g_strdup (_tmp8_);
				g_hash_table_add (_tmp7_, _tmp9_);
			}
		}
	}
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = to_load_local;
		path_collection_length1 = to_load_local_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				GHashTable* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp10_ = self->priv->local_paths;
				_tmp11_ = path;
				_tmp12_ = g_strdup (_tmp11_);
				g_hash_table_add (_tmp10_, _tmp12_);
			}
		}
	}
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = to_load_remote;
		path_collection_length1 = to_load_remote_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				GHashTable* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = self->priv->remote_paths;
				_tmp14_ = path;
				_tmp15_ = g_strdup (_tmp14_);
				g_hash_table_add (_tmp13_, _tmp15_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_install_as_dep;
		name_collection_length1 = to_install_as_dep_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp16_ = self->priv->to_install_as_dep;
				_tmp17_ = name;
				_tmp18_ = g_strdup (_tmp17_);
				_tmp19_ = name;
				_tmp20_ = g_strdup (_tmp19_);
				g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = ignorepkgs;
		name_collection_length1 = ignorepkgs_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = self->priv->ignorepkgs;
				_tmp22_ = name;
				_tmp23_ = g_strdup (_tmp22_);
				g_hash_table_add (_tmp21_, _tmp23_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = overwrite_files;
		name_collection_length1 = overwrite_files_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp24_ = self->priv->overwrite_files;
				_tmp25_ = name;
				_tmp26_ = g_strdup (_tmp25_);
				g_hash_table_add (_tmp24_, _tmp26_);
			}
		}
	}
	_tmp27_ = alpm_handle;
	result = pamac_alpm_utils_trans_run_real (self, _tmp27_);
	_alpm_release0 (alpm_handle);
	return result;
}

static gboolean
pamac_alpm_utils_trans_run_real (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	alpm_db_t* aur_db = NULL;
	gboolean success = FALSE;
	alpm_db_t* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	aur_db = NULL;
	_tmp0_ = aur_db;
	success = pamac_alpm_utils_trans_prepare (self, alpm_handle, _tmp0_);
	if (success) {
		gboolean _tmp1_ = FALSE;
		alpm_list_t* _tmp2_;
		_tmp2_ = alpm_trans_get_add (alpm_handle);
		if (_tmp2_ != NULL) {
			_tmp1_ = TRUE;
		} else {
			alpm_list_t* _tmp3_;
			_tmp3_ = alpm_trans_get_remove (alpm_handle);
			_tmp1_ = _tmp3_ != NULL;
		}
		if (_tmp1_) {
			alpm_option_set_eventcb (alpm_handle, _cb_event_alpm_cb_event, self);
			alpm_option_set_progresscb (alpm_handle, _cb_progress_alpm_cb_progress, self);
			alpm_option_set_fetchcb (alpm_handle, _cb_fetch_alpm_cb_fetch, self);
			alpm_option_set_logcb (alpm_handle, _cb_log_alpm_cb_log, self);
			success = pamac_alpm_utils_trans_commit (self, alpm_handle);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
			pamac_alpm_utils_trans_reset (self);
			success = TRUE;
		}
	}
	result = success;
	return result;
}

static void
pamac_alpm_utils_trans_reset (PamacAlpmUtils* self)
{
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	g_return_if_fail (self != NULL);
	self->priv->commit_retries = (guint8) 0;
	self->total_download = (guint64) 0;
	self->already_downloaded = (guint64) 0;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp0_;
	_tmp1_ = self->priv->to_syncfirst;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = self->priv->to_install;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = self->priv->deps_to_install;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->to_remove;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = self->priv->required_to_remove;
	g_hash_table_remove_all (_tmp5_);
	_tmp6_ = self->priv->orphans_to_remove;
	g_hash_table_remove_all (_tmp6_);
	_tmp7_ = self->priv->conflicts_to_remove;
	g_hash_table_remove_all (_tmp7_);
	_tmp8_ = self->priv->local_paths;
	g_hash_table_remove_all (_tmp8_);
	_tmp9_ = self->priv->remote_paths;
	g_hash_table_remove_all (_tmp9_);
	_tmp10_ = self->priv->to_build;
	g_hash_table_remove_all (_tmp10_);
	_tmp11_ = self->priv->checked_deps;
	g_hash_table_remove_all (_tmp11_);
	_tmp12_ = self->priv->ignorepkgs;
	g_hash_table_remove_all (_tmp12_);
	_tmp13_ = self->priv->overwrite_files;
	g_hash_table_remove_all (_tmp13_);
	_tmp14_ = self->priv->to_install_as_dep;
	g_hash_table_remove_all (_tmp14_);
	self->priv->no_confirm_commit = FALSE;
}

static void
pamac_alpm_utils_intern_compute_pkgs_to_remove (PamacAlpmUtils* self,
                                                alpm_handle_t* alpm_handle)
{
	gint tmp_trans_flags = 0;
	gboolean success = FALSE;
	g_return_if_fail (self != NULL);
	tmp_trans_flags = (gint) ALPM_TRANS_FLAG_NOLOCK;
	if ((self->priv->trans_flags & ALPM_TRANS_FLAG_UNNEEDED) != 0) {
		tmp_trans_flags |= (gint) ALPM_TRANS_FLAG_UNNEEDED;
	} else {
		if ((self->priv->trans_flags & ALPM_TRANS_FLAG_CASCADE) != 0) {
			self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_CASCADE);
			tmp_trans_flags |= (gint) ALPM_TRANS_FLAG_CASCADE;
		}
	}
	success = pamac_alpm_utils_trans_init (self, alpm_handle, tmp_trans_flags, FALSE);
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp0_;
			GHashTableIter _tmp1_ = {0};
			const gchar* name = NULL;
			_tmp0_ = self->priv->to_remove;
			g_hash_table_iter_init (&_tmp1_, _tmp0_);
			_name_it = _tmp1_;
			while (TRUE) {
				gconstpointer _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp2_;
				_tmp3_ = name;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp4_, FALSE);
				if (!success) {
					break;
				}
			}
		}
		if (success) {
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, FALSE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		alpm_list_t* pkgs_to_remove = NULL;
		alpm_list_t* _tmp5_;
		_tmp5_ = alpm_trans_get_remove (alpm_handle);
		pkgs_to_remove = _tmp5_;
		while (TRUE) {
			alpm_list_t* _tmp6_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp7_;
			gconstpointer _tmp8_;
			const gchar* name = NULL;
			alpm_pkg_t* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GHashTable* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = pkgs_to_remove;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = pkgs_to_remove;
			_tmp8_ = _tmp7_->data;
			trans_pkg = (alpm_pkg_t*) _tmp8_;
			_tmp9_ = trans_pkg;
			_tmp10_ = alpm_pkg_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			name = _tmp11_;
			_tmp12_ = self->priv->to_remove;
			_tmp13_ = name;
			if (!g_hash_table_contains (_tmp12_, _tmp13_)) {
				GHashTable* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = self->priv->required_to_remove;
				_tmp15_ = name;
				_tmp16_ = g_strdup (_tmp15_);
				g_hash_table_add (_tmp14_, _tmp16_);
			}
			pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		}
		pamac_alpm_utils_trans_release (self, alpm_handle);
	}
}

static void
pamac_alpm_utils_remove_install_deps_in_to_remove (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle,
                                                   alpm_list_t* deps_to_check)
{
	alpm_list_t* deps_to_check_next = NULL;
	alpm_list_t* _tmp72_;
	g_return_if_fail (self != NULL);
	deps_to_check_next = NULL;
	while (TRUE) {
		alpm_pkg_t* alpm_pkg = NULL;
		gconstpointer _tmp0_;
		GHashTable* _tmp1_;
		alpm_pkg_t* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		alpm_list_t* depends = NULL;
		alpm_pkg_t* _tmp6_;
		alpm_list_t* _tmp7_;
		alpm_list_t* _tmp8_;
		alpm_pkg_t* _tmp39_;
		alpm_list_t* _tmp40_;
		alpm_list_t* _tmp41_;
		if (!(deps_to_check != NULL)) {
			break;
		}
		_tmp0_ = deps_to_check->data;
		alpm_pkg = (alpm_pkg_t*) _tmp0_;
		_tmp1_ = self->priv->checked_deps;
		_tmp2_ = alpm_pkg;
		_tmp3_ = alpm_pkg_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		g_hash_table_add (_tmp1_, _tmp5_);
		_tmp6_ = alpm_pkg;
		_tmp7_ = alpm_pkg_get_depends (_tmp6_);
		_tmp8_ = _tmp7_;
		depends = _tmp8_;
		while (TRUE) {
			alpm_list_t* _tmp9_;
			alpm_pkg_t* satisfier = NULL;
			alpm_db_t* _tmp10_;
			alpm_db_t* _tmp11_;
			alpm_list_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp14_;
			gconstpointer _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			alpm_pkg_t* _tmp18_;
			alpm_pkg_t* _tmp19_;
			alpm_pkg_t* _tmp20_;
			_tmp9_ = depends;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = alpm_get_localdb (alpm_handle);
			_tmp11_ = _tmp10_;
			_tmp12_ = alpm_db_get_pkgcache (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = depends;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = alpm_find_satisfier (_tmp13_, _tmp17_);
			_tmp19_ = _tmp18_;
			_g_free0 (_tmp17_);
			satisfier = _tmp19_;
			_tmp20_ = satisfier;
			if (_tmp20_ != NULL) {
				GHashTable* _tmp21_;
				alpm_pkg_t* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp21_ = self->priv->checked_deps;
				_tmp22_ = satisfier;
				_tmp23_ = alpm_pkg_get_name (_tmp22_);
				_tmp24_ = _tmp23_;
				if (!g_hash_table_contains (_tmp21_, _tmp24_)) {
					GHashTable* _tmp25_;
					alpm_pkg_t* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					alpm_pkg_t* _tmp38_;
					_tmp25_ = self->priv->to_remove;
					_tmp26_ = satisfier;
					_tmp27_ = alpm_pkg_get_name (_tmp26_);
					_tmp28_ = _tmp27_;
					if (g_hash_table_remove (_tmp25_, _tmp28_)) {
						gchar* _tmp29_;
						gchar* _tmp30_;
						alpm_pkg_t* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp29_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
						_tmp30_ = _tmp29_;
						_tmp31_ = satisfier;
						_tmp32_ = alpm_pkg_get_name (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strconcat (_tmp30_, _tmp35_, NULL);
						_tmp37_ = _tmp36_;
						pamac_alpm_utils_do_emit_script_output (self, _tmp37_);
						_g_free0 (_tmp37_);
						_g_free0 (_tmp35_);
						_g_free0 (_tmp30_);
					}
					_tmp38_ = satisfier;
					deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp38_);
				}
			}
			depends = alpm_list_next (depends);
		}
		_tmp39_ = alpm_pkg;
		_tmp40_ = alpm_pkg_get_optdepends (_tmp39_);
		_tmp41_ = _tmp40_;
		depends = _tmp41_;
		while (TRUE) {
			alpm_list_t* _tmp42_;
			alpm_pkg_t* satisfier = NULL;
			alpm_db_t* _tmp43_;
			alpm_db_t* _tmp44_;
			alpm_list_t* _tmp45_;
			alpm_list_t* _tmp46_;
			alpm_list_t* _tmp47_;
			gconstpointer _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			alpm_pkg_t* _tmp51_;
			alpm_pkg_t* _tmp52_;
			alpm_pkg_t* _tmp53_;
			_tmp42_ = depends;
			if (!(_tmp42_ != NULL)) {
				break;
			}
			_tmp43_ = alpm_get_localdb (alpm_handle);
			_tmp44_ = _tmp43_;
			_tmp45_ = alpm_db_get_pkgcache (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = depends;
			_tmp48_ = _tmp47_->data;
			_tmp49_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = alpm_find_satisfier (_tmp46_, _tmp50_);
			_tmp52_ = _tmp51_;
			_g_free0 (_tmp50_);
			satisfier = _tmp52_;
			_tmp53_ = satisfier;
			if (_tmp53_ != NULL) {
				GHashTable* _tmp54_;
				alpm_pkg_t* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				_tmp54_ = self->priv->checked_deps;
				_tmp55_ = satisfier;
				_tmp56_ = alpm_pkg_get_name (_tmp55_);
				_tmp57_ = _tmp56_;
				if (!g_hash_table_contains (_tmp54_, _tmp57_)) {
					GHashTable* _tmp58_;
					alpm_pkg_t* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					alpm_pkg_t* _tmp71_;
					_tmp58_ = self->priv->to_remove;
					_tmp59_ = satisfier;
					_tmp60_ = alpm_pkg_get_name (_tmp59_);
					_tmp61_ = _tmp60_;
					if (g_hash_table_remove (_tmp58_, _tmp61_)) {
						gchar* _tmp62_;
						gchar* _tmp63_;
						alpm_pkg_t* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						_tmp62_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
						_tmp63_ = _tmp62_;
						_tmp64_ = satisfier;
						_tmp65_ = alpm_pkg_get_name (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
						_tmp70_ = _tmp69_;
						pamac_alpm_utils_do_emit_script_output (self, _tmp70_);
						_g_free0 (_tmp70_);
						_g_free0 (_tmp68_);
						_g_free0 (_tmp63_);
					}
					_tmp71_ = satisfier;
					deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp71_);
				}
			}
			depends = alpm_list_next (depends);
		}
		deps_to_check = alpm_list_next (deps_to_check);
	}
	_tmp72_ = deps_to_check_next;
	if (_tmp72_ != NULL) {
		alpm_list_t* _tmp73_;
		_tmp73_ = deps_to_check_next;
		pamac_alpm_utils_remove_install_deps_in_to_remove (self, alpm_handle, _tmp73_);
	}
	_alpm_list_free0 (deps_to_check_next);
}

static void
pamac_alpm_utils_intern_compute_pkgs_to_install (PamacAlpmUtils* self,
                                                 alpm_handle_t* alpm_handle,
                                                 alpm_db_t* aur_db)
{
	gint tmp_trans_flags = 0;
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	tmp_trans_flags = (gint) ALPM_TRANS_FLAG_NOLOCK;
	success = pamac_alpm_utils_trans_init (self, alpm_handle, tmp_trans_flags, FALSE);
	if (success) {
		_tmp0_ = self->priv->sysupgrade;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		success = pamac_alpm_utils_trans_sysupgrade (self, alpm_handle, FALSE);
		if (!success) {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp1_;
			GHashTableIter _tmp2_ = {0};
			const gchar* name = NULL;
			_tmp1_ = self->priv->to_install;
			g_hash_table_iter_init (&_tmp2_, _tmp1_);
			_name_it = _tmp2_;
			while (TRUE) {
				gconstpointer _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp3_;
				_tmp4_ = name;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp5_, FALSE);
				if (!success) {
					break;
				}
			}
		}
		if (success) {
			alpm_list_t* dbs = NULL;
			dbs = NULL;
			dbs = alpm_list_add (dbs, aur_db);
			{
				GHashTableIter _name_it = {0};
				GHashTable* _tmp6_;
				GHashTableIter _tmp7_ = {0};
				const gchar* name = NULL;
				_tmp6_ = self->priv->to_build;
				g_hash_table_iter_init (&_tmp7_, _tmp6_);
				_name_it = _tmp7_;
				while (TRUE) {
					gconstpointer _tmp8_;
					const gchar* _tmp9_;
					alpm_pkg_t* pkg = NULL;
					alpm_list_t* _tmp10_;
					const gchar* _tmp11_;
					alpm_pkg_t* _tmp12_;
					alpm_pkg_t* _tmp13_;
					_tmp8_ = _vala_hash_set_next_value (&_name_it);
					name = (const gchar*) _tmp8_;
					_tmp9_ = name;
					if (!(_tmp9_ != NULL)) {
						break;
					}
					_tmp10_ = dbs;
					_tmp11_ = name;
					_tmp12_ = alpm_find_dbs_satisfier (alpm_handle, _tmp10_, _tmp11_);
					pkg = _tmp12_;
					_tmp13_ = pkg;
					if (_tmp13_ == NULL) {
						success = FALSE;
						break;
					} else {
						alpm_pkg_t* _tmp14_;
						_tmp14_ = pkg;
						success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp14_, FALSE);
						if (!success) {
							break;
						}
					}
				}
			}
			_alpm_list_free0 (dbs);
		}
		if (success) {
			{
				GHashTableIter _path_it = {0};
				GHashTable* _tmp15_;
				GHashTableIter _tmp16_ = {0};
				const gchar* path = NULL;
				_tmp15_ = self->priv->local_paths;
				g_hash_table_iter_init (&_tmp16_, _tmp15_);
				_path_it = _tmp16_;
				while (TRUE) {
					gconstpointer _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp17_ = _vala_hash_set_next_value (&_path_it);
					path = (const gchar*) _tmp17_;
					_tmp18_ = path;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = path;
					_tmp20_ = alpm_option_get_local_file_siglevel (alpm_handle);
					_tmp21_ = _tmp20_;
					success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp19_, _tmp21_, FALSE);
					if (!success) {
						break;
					}
				}
			}
		}
		if (success) {
			{
				GHashTableIter _path_it = {0};
				GHashTable* _tmp22_;
				GHashTableIter _tmp23_ = {0};
				const gchar* path = NULL;
				_tmp22_ = self->priv->remote_paths;
				g_hash_table_iter_init (&_tmp23_, _tmp22_);
				_path_it = _tmp23_;
				while (TRUE) {
					gconstpointer _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp24_ = _vala_hash_set_next_value (&_path_it);
					path = (const gchar*) _tmp24_;
					_tmp25_ = path;
					if (!(_tmp25_ != NULL)) {
						break;
					}
					_tmp26_ = path;
					_tmp27_ = alpm_option_get_remote_file_siglevel (alpm_handle);
					_tmp28_ = _tmp27_;
					success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp26_, _tmp28_, FALSE);
					if (!success) {
						break;
					}
				}
			}
		}
		if (success) {
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, FALSE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		GHashTable* to_install_copy = NULL;
		GHashTable* _tmp29_;
		GHashFunc _tmp30_;
		GEqualFunc _tmp31_;
		GHashTable* _tmp32_;
		GHashFunc _tmp33_;
		GEqualFunc _tmp34_;
		GHashTable* _tmp35_;
		alpm_list_t* deps_to_check = NULL;
		alpm_list_t* pkgs_to_add = NULL;
		alpm_list_t* _tmp36_;
		alpm_list_t* pkgs_to_remove = NULL;
		alpm_list_t* _tmp149_;
		alpm_list_t* _tmp158_;
		_tmp29_ = self->priv->to_install;
		self->priv->to_install = NULL;
		to_install_copy = _tmp29_;
		_tmp30_ = g_str_hash;
		_tmp31_ = g_str_equal;
		_tmp32_ = g_hash_table_new_full (_tmp30_, _tmp31_, NULL, _g_free0_);
		_g_hash_table_unref0 (self->priv->to_install);
		self->priv->to_install = _tmp32_;
		_tmp33_ = g_str_hash;
		_tmp34_ = g_str_equal;
		_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, NULL, _g_free0_);
		_g_hash_table_unref0 (self->priv->to_build);
		self->priv->to_build = _tmp35_;
		deps_to_check = NULL;
		_tmp36_ = alpm_trans_get_add (alpm_handle);
		pkgs_to_add = _tmp36_;
		while (TRUE) {
			alpm_list_t* _tmp37_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp38_;
			gconstpointer _tmp39_;
			alpm_pkg_t* _tmp40_;
			alpm_db_t* _tmp41_;
			alpm_db_t* _tmp42_;
			GHashTable* _tmp62_;
			guint _tmp63_;
			guint _tmp64_;
			_tmp37_ = pkgs_to_add;
			if (!(_tmp37_ != NULL)) {
				break;
			}
			_tmp38_ = pkgs_to_add;
			_tmp39_ = _tmp38_->data;
			trans_pkg = (alpm_pkg_t*) _tmp39_;
			_tmp40_ = trans_pkg;
			_tmp41_ = alpm_pkg_get_db (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != NULL) {
				const gchar* name = NULL;
				alpm_pkg_t* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				alpm_pkg_t* _tmp46_;
				alpm_db_t* _tmp47_;
				alpm_db_t* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp43_ = trans_pkg;
				_tmp44_ = alpm_pkg_get_name (_tmp43_);
				_tmp45_ = _tmp44_;
				name = _tmp45_;
				_tmp46_ = trans_pkg;
				_tmp47_ = alpm_pkg_get_db (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = alpm_db_get_name (_tmp48_);
				_tmp50_ = _tmp49_;
				if (g_strcmp0 (_tmp50_, "pamac_aur") == 0) {
					GHashTable* _tmp51_;
					const gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp51_ = self->priv->to_build;
					_tmp52_ = name;
					_tmp53_ = g_strdup (_tmp52_);
					g_hash_table_add (_tmp51_, _tmp53_);
				} else {
					GHashTable* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = to_install_copy;
					_tmp55_ = name;
					if (g_hash_table_contains (_tmp54_, _tmp55_)) {
						GHashTable* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp56_ = self->priv->to_install;
						_tmp57_ = name;
						_tmp58_ = g_strdup (_tmp57_);
						g_hash_table_add (_tmp56_, _tmp58_);
					} else {
						GHashTable* _tmp59_;
						const gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp59_ = self->priv->deps_to_install;
						_tmp60_ = name;
						_tmp61_ = g_strdup (_tmp60_);
						g_hash_table_add (_tmp59_, _tmp61_);
					}
				}
			}
			_tmp62_ = self->priv->to_remove;
			_tmp63_ = g_hash_table_size (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ > ((guint) 0)) {
				GHashTable* _tmp65_;
				alpm_pkg_t* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				GHashTable* _tmp78_;
				alpm_pkg_t* _tmp79_;
				const gchar* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				alpm_list_t* depends = NULL;
				alpm_pkg_t* _tmp83_;
				alpm_list_t* _tmp84_;
				alpm_list_t* _tmp85_;
				alpm_pkg_t* _tmp116_;
				alpm_list_t* _tmp117_;
				alpm_list_t* _tmp118_;
				_tmp65_ = self->priv->to_remove;
				_tmp66_ = trans_pkg;
				_tmp67_ = alpm_pkg_get_name (_tmp66_);
				_tmp68_ = _tmp67_;
				if (g_hash_table_remove (_tmp65_, _tmp68_)) {
					gchar* _tmp69_;
					gchar* _tmp70_;
					alpm_pkg_t* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp69_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp70_ = _tmp69_;
					_tmp71_ = trans_pkg;
					_tmp72_ = alpm_pkg_get_name (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
					_tmp77_ = _tmp76_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp77_);
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp70_);
				}
				_tmp78_ = self->priv->checked_deps;
				_tmp79_ = trans_pkg;
				_tmp80_ = alpm_pkg_get_name (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = g_strdup (_tmp81_);
				g_hash_table_add (_tmp78_, _tmp82_);
				_tmp83_ = trans_pkg;
				_tmp84_ = alpm_pkg_get_depends (_tmp83_);
				_tmp85_ = _tmp84_;
				depends = _tmp85_;
				while (TRUE) {
					alpm_list_t* _tmp86_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp87_;
					alpm_db_t* _tmp88_;
					alpm_list_t* _tmp89_;
					alpm_list_t* _tmp90_;
					alpm_list_t* _tmp91_;
					gconstpointer _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					alpm_pkg_t* _tmp95_;
					alpm_pkg_t* _tmp96_;
					alpm_pkg_t* _tmp97_;
					_tmp86_ = depends;
					if (!(_tmp86_ != NULL)) {
						break;
					}
					_tmp87_ = alpm_get_localdb (alpm_handle);
					_tmp88_ = _tmp87_;
					_tmp89_ = alpm_db_get_pkgcache (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = depends;
					_tmp92_ = _tmp91_->data;
					_tmp93_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = alpm_find_satisfier (_tmp90_, _tmp94_);
					_tmp96_ = _tmp95_;
					_g_free0 (_tmp94_);
					satisfier = _tmp96_;
					_tmp97_ = satisfier;
					if (_tmp97_ != NULL) {
						GHashTable* _tmp98_;
						alpm_pkg_t* _tmp99_;
						const gchar* _tmp100_;
						const gchar* _tmp101_;
						_tmp98_ = self->priv->checked_deps;
						_tmp99_ = satisfier;
						_tmp100_ = alpm_pkg_get_name (_tmp99_);
						_tmp101_ = _tmp100_;
						if (!g_hash_table_contains (_tmp98_, _tmp101_)) {
							GHashTable* _tmp102_;
							alpm_pkg_t* _tmp103_;
							const gchar* _tmp104_;
							const gchar* _tmp105_;
							alpm_pkg_t* _tmp115_;
							_tmp102_ = self->priv->to_remove;
							_tmp103_ = satisfier;
							_tmp104_ = alpm_pkg_get_name (_tmp103_);
							_tmp105_ = _tmp104_;
							if (g_hash_table_remove (_tmp102_, _tmp105_)) {
								gchar* _tmp106_;
								gchar* _tmp107_;
								alpm_pkg_t* _tmp108_;
								const gchar* _tmp109_;
								const gchar* _tmp110_;
								gchar* _tmp111_;
								gchar* _tmp112_;
								gchar* _tmp113_;
								gchar* _tmp114_;
								_tmp106_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
								_tmp107_ = _tmp106_;
								_tmp108_ = satisfier;
								_tmp109_ = alpm_pkg_get_name (_tmp108_);
								_tmp110_ = _tmp109_;
								_tmp111_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = g_strconcat (_tmp107_, _tmp112_, NULL);
								_tmp114_ = _tmp113_;
								pamac_alpm_utils_do_emit_script_output (self, _tmp114_);
								_g_free0 (_tmp114_);
								_g_free0 (_tmp112_);
								_g_free0 (_tmp107_);
							}
							_tmp115_ = satisfier;
							deps_to_check = alpm_list_add (deps_to_check, _tmp115_);
						}
					}
					depends = alpm_list_next (depends);
				}
				_tmp116_ = trans_pkg;
				_tmp117_ = alpm_pkg_get_optdepends (_tmp116_);
				_tmp118_ = _tmp117_;
				depends = _tmp118_;
				while (TRUE) {
					alpm_list_t* _tmp119_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp120_;
					alpm_db_t* _tmp121_;
					alpm_list_t* _tmp122_;
					alpm_list_t* _tmp123_;
					alpm_list_t* _tmp124_;
					gconstpointer _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					alpm_pkg_t* _tmp128_;
					alpm_pkg_t* _tmp129_;
					alpm_pkg_t* _tmp130_;
					_tmp119_ = depends;
					if (!(_tmp119_ != NULL)) {
						break;
					}
					_tmp120_ = alpm_get_localdb (alpm_handle);
					_tmp121_ = _tmp120_;
					_tmp122_ = alpm_db_get_pkgcache (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = depends;
					_tmp125_ = _tmp124_->data;
					_tmp126_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = alpm_find_satisfier (_tmp123_, _tmp127_);
					_tmp129_ = _tmp128_;
					_g_free0 (_tmp127_);
					satisfier = _tmp129_;
					_tmp130_ = satisfier;
					if (_tmp130_ != NULL) {
						GHashTable* _tmp131_;
						alpm_pkg_t* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp131_ = self->priv->checked_deps;
						_tmp132_ = satisfier;
						_tmp133_ = alpm_pkg_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						if (!g_hash_table_contains (_tmp131_, _tmp134_)) {
							GHashTable* _tmp135_;
							alpm_pkg_t* _tmp136_;
							const gchar* _tmp137_;
							const gchar* _tmp138_;
							alpm_pkg_t* _tmp148_;
							_tmp135_ = self->priv->to_remove;
							_tmp136_ = satisfier;
							_tmp137_ = alpm_pkg_get_name (_tmp136_);
							_tmp138_ = _tmp137_;
							if (g_hash_table_remove (_tmp135_, _tmp138_)) {
								gchar* _tmp139_;
								gchar* _tmp140_;
								alpm_pkg_t* _tmp141_;
								const gchar* _tmp142_;
								const gchar* _tmp143_;
								gchar* _tmp144_;
								gchar* _tmp145_;
								gchar* _tmp146_;
								gchar* _tmp147_;
								_tmp139_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
								_tmp140_ = _tmp139_;
								_tmp141_ = satisfier;
								_tmp142_ = alpm_pkg_get_name (_tmp141_);
								_tmp143_ = _tmp142_;
								_tmp144_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp143_);
								_tmp145_ = _tmp144_;
								_tmp146_ = g_strconcat (_tmp140_, _tmp145_, NULL);
								_tmp147_ = _tmp146_;
								pamac_alpm_utils_do_emit_script_output (self, _tmp147_);
								_g_free0 (_tmp147_);
								_g_free0 (_tmp145_);
								_g_free0 (_tmp140_);
							}
							_tmp148_ = satisfier;
							deps_to_check = alpm_list_add (deps_to_check, _tmp148_);
						}
					}
					depends = alpm_list_next (depends);
				}
			}
			pkgs_to_add = alpm_list_next (pkgs_to_add);
		}
		_tmp149_ = alpm_trans_get_remove (alpm_handle);
		pkgs_to_remove = _tmp149_;
		while (TRUE) {
			alpm_list_t* _tmp150_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp151_;
			gconstpointer _tmp152_;
			GHashTable* _tmp153_;
			alpm_pkg_t* _tmp154_;
			const gchar* _tmp155_;
			const gchar* _tmp156_;
			gchar* _tmp157_;
			_tmp150_ = pkgs_to_remove;
			if (!(_tmp150_ != NULL)) {
				break;
			}
			_tmp151_ = pkgs_to_remove;
			_tmp152_ = _tmp151_->data;
			trans_pkg = (alpm_pkg_t*) _tmp152_;
			_tmp153_ = self->priv->conflicts_to_remove;
			_tmp154_ = trans_pkg;
			_tmp155_ = alpm_pkg_get_name (_tmp154_);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strdup (_tmp156_);
			g_hash_table_add (_tmp153_, _tmp157_);
			pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		}
		pamac_alpm_utils_trans_release (self, alpm_handle);
		_tmp158_ = deps_to_check;
		if (_tmp158_ != NULL) {
			alpm_list_t* _tmp159_;
			_tmp159_ = deps_to_check;
			pamac_alpm_utils_remove_install_deps_in_to_remove (self, alpm_handle, _tmp159_);
		}
		_alpm_list_free0 (deps_to_check);
		_g_hash_table_unref0 (to_install_copy);
	}
}

static void
_g_free_alpm_list_fn_free (gconstpointer a)
{
	g_free (a);
}

static void
pamac_alpm_utils_check_orphans_to_remove (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          alpm_list_t* deps_to_check)
{
	alpm_list_t* deps_to_check_next = NULL;
	alpm_list_t* _tmp102_;
	g_return_if_fail (self != NULL);
	deps_to_check_next = NULL;
	while (TRUE) {
		alpm_pkg_t* alpm_pkg = NULL;
		gconstpointer _tmp0_;
		GHashTable* _tmp1_;
		alpm_pkg_t* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		if (!(deps_to_check != NULL)) {
			break;
		}
		_tmp0_ = deps_to_check->data;
		alpm_pkg = (alpm_pkg_t*) _tmp0_;
		_tmp1_ = self->priv->checked_deps;
		_tmp2_ = alpm_pkg;
		_tmp3_ = alpm_pkg_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!g_hash_table_contains (_tmp1_, _tmp4_)) {
			alpm_pkg_t* _tmp5_;
			alpm_pkgreason_t _tmp6_;
			alpm_pkgreason_t _tmp7_;
			_tmp5_ = alpm_pkg;
			_tmp6_ = alpm_pkg_get_reason (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ == ALPM_PKG_REASON_DEPEND) {
				alpm_list_t* requiredby = NULL;
				alpm_pkg_t* _tmp8_;
				alpm_list_t* _tmp9_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp10_;
				gboolean extern_dep = FALSE;
				alpm_list_t* _tmp34_;
				_tmp8_ = alpm_pkg;
				_tmp9_ = alpm_pkg_compute_requiredby (_tmp8_);
				requiredby = _tmp9_;
				_tmp10_ = requiredby;
				list = _tmp10_;
				extern_dep = FALSE;
				while (TRUE) {
					alpm_list_t* _tmp11_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp12_;
					alpm_db_t* _tmp13_;
					alpm_list_t* _tmp14_;
					alpm_list_t* _tmp15_;
					alpm_list_t* _tmp16_;
					gconstpointer _tmp17_;
					alpm_pkg_t* _tmp18_;
					alpm_pkg_t* _tmp19_;
					_tmp11_ = list;
					if (!(_tmp11_ != NULL)) {
						break;
					}
					_tmp12_ = alpm_get_localdb (alpm_handle);
					_tmp13_ = _tmp12_;
					_tmp14_ = alpm_db_get_pkgcache (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = list;
					_tmp17_ = _tmp16_->data;
					_tmp18_ = alpm_find_satisfier (_tmp15_, (const gchar*) _tmp17_);
					satisfier = _tmp18_;
					_tmp19_ = satisfier;
					if (_tmp19_ != NULL) {
						gboolean _tmp20_ = FALSE;
						gboolean _tmp21_ = FALSE;
						GHashTable* _tmp22_;
						alpm_pkg_t* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp22_ = self->priv->to_remove;
						_tmp23_ = satisfier;
						_tmp24_ = alpm_pkg_get_name (_tmp23_);
						_tmp25_ = _tmp24_;
						if (!g_hash_table_contains (_tmp22_, _tmp25_)) {
							GHashTable* _tmp26_;
							alpm_pkg_t* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp26_ = self->priv->required_to_remove;
							_tmp27_ = satisfier;
							_tmp28_ = alpm_pkg_get_name (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp21_ = !g_hash_table_contains (_tmp26_, _tmp29_);
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							GHashTable* _tmp30_;
							alpm_pkg_t* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							_tmp30_ = self->priv->orphans_to_remove;
							_tmp31_ = satisfier;
							_tmp32_ = alpm_pkg_get_name (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp20_ = !g_hash_table_contains (_tmp30_, _tmp33_);
						} else {
							_tmp20_ = FALSE;
						}
						if (_tmp20_) {
							extern_dep = TRUE;
							break;
						}
					}
					list = alpm_list_next (list);
				}
				_tmp34_ = requiredby;
				alpm_list_free_inner (_tmp34_, _g_free_alpm_list_fn_free);
				if (!extern_dep) {
					alpm_list_t* optionalfor = NULL;
					alpm_pkg_t* _tmp35_;
					alpm_list_t* _tmp36_;
					alpm_list_t* _tmp37_;
					alpm_list_t* _tmp61_;
					_tmp35_ = alpm_pkg;
					_tmp36_ = alpm_pkg_compute_optionalfor (_tmp35_);
					optionalfor = _tmp36_;
					_tmp37_ = optionalfor;
					list = _tmp37_;
					while (TRUE) {
						alpm_list_t* _tmp38_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp39_;
						alpm_db_t* _tmp40_;
						alpm_list_t* _tmp41_;
						alpm_list_t* _tmp42_;
						alpm_list_t* _tmp43_;
						gconstpointer _tmp44_;
						alpm_pkg_t* _tmp45_;
						alpm_pkg_t* _tmp46_;
						_tmp38_ = list;
						if (!(_tmp38_ != NULL)) {
							break;
						}
						_tmp39_ = alpm_get_localdb (alpm_handle);
						_tmp40_ = _tmp39_;
						_tmp41_ = alpm_db_get_pkgcache (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = list;
						_tmp44_ = _tmp43_->data;
						_tmp45_ = alpm_find_satisfier (_tmp42_, (const gchar*) _tmp44_);
						satisfier = _tmp45_;
						_tmp46_ = satisfier;
						if (_tmp46_ != NULL) {
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							GHashTable* _tmp49_;
							alpm_pkg_t* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							_tmp49_ = self->priv->to_remove;
							_tmp50_ = satisfier;
							_tmp51_ = alpm_pkg_get_name (_tmp50_);
							_tmp52_ = _tmp51_;
							if (!g_hash_table_contains (_tmp49_, _tmp52_)) {
								GHashTable* _tmp53_;
								alpm_pkg_t* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
								_tmp53_ = self->priv->required_to_remove;
								_tmp54_ = satisfier;
								_tmp55_ = alpm_pkg_get_name (_tmp54_);
								_tmp56_ = _tmp55_;
								_tmp48_ = !g_hash_table_contains (_tmp53_, _tmp56_);
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								GHashTable* _tmp57_;
								alpm_pkg_t* _tmp58_;
								const gchar* _tmp59_;
								const gchar* _tmp60_;
								_tmp57_ = self->priv->orphans_to_remove;
								_tmp58_ = satisfier;
								_tmp59_ = alpm_pkg_get_name (_tmp58_);
								_tmp60_ = _tmp59_;
								_tmp47_ = !g_hash_table_contains (_tmp57_, _tmp60_);
							} else {
								_tmp47_ = FALSE;
							}
							if (_tmp47_) {
								extern_dep = TRUE;
								break;
							}
						}
						list = alpm_list_next (list);
					}
					_tmp61_ = optionalfor;
					alpm_list_free_inner (_tmp61_, _g_free_alpm_list_fn_free);
					if (!extern_dep) {
						GHashTable* _tmp62_;
						alpm_pkg_t* _tmp63_;
						const gchar* _tmp64_;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						GHashTable* _tmp67_;
						alpm_pkg_t* _tmp68_;
						const gchar* _tmp69_;
						const gchar* _tmp70_;
						gchar* _tmp71_;
						alpm_list_t* depends = NULL;
						alpm_pkg_t* _tmp72_;
						alpm_list_t* _tmp73_;
						alpm_list_t* _tmp74_;
						_tmp62_ = self->priv->orphans_to_remove;
						_tmp63_ = alpm_pkg;
						_tmp64_ = alpm_pkg_get_name (_tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup (_tmp65_);
						g_hash_table_add (_tmp62_, _tmp66_);
						_tmp67_ = self->priv->checked_deps;
						_tmp68_ = alpm_pkg;
						_tmp69_ = alpm_pkg_get_name (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup (_tmp70_);
						g_hash_table_add (_tmp67_, _tmp71_);
						_tmp72_ = alpm_pkg;
						_tmp73_ = alpm_pkg_get_depends (_tmp72_);
						_tmp74_ = _tmp73_;
						depends = _tmp74_;
						while (TRUE) {
							alpm_list_t* _tmp75_;
							alpm_pkg_t* satisfier = NULL;
							alpm_db_t* _tmp76_;
							alpm_db_t* _tmp77_;
							alpm_list_t* _tmp78_;
							alpm_list_t* _tmp79_;
							alpm_list_t* _tmp80_;
							gconstpointer _tmp81_;
							gchar* _tmp82_;
							gchar* _tmp83_;
							alpm_pkg_t* _tmp84_;
							alpm_pkg_t* _tmp85_;
							alpm_pkg_t* _tmp86_;
							_tmp75_ = depends;
							if (!(_tmp75_ != NULL)) {
								break;
							}
							_tmp76_ = alpm_get_localdb (alpm_handle);
							_tmp77_ = _tmp76_;
							_tmp78_ = alpm_db_get_pkgcache (_tmp77_);
							_tmp79_ = _tmp78_;
							_tmp80_ = depends;
							_tmp81_ = _tmp80_->data;
							_tmp82_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp81_);
							_tmp83_ = _tmp82_;
							_tmp84_ = alpm_find_satisfier (_tmp79_, _tmp83_);
							_tmp85_ = _tmp84_;
							_g_free0 (_tmp83_);
							satisfier = _tmp85_;
							_tmp86_ = satisfier;
							if (_tmp86_ != NULL) {
								gboolean _tmp87_ = FALSE;
								gboolean _tmp88_ = FALSE;
								GHashTable* _tmp89_;
								alpm_pkg_t* _tmp90_;
								const gchar* _tmp91_;
								const gchar* _tmp92_;
								_tmp89_ = self->priv->to_remove;
								_tmp90_ = satisfier;
								_tmp91_ = alpm_pkg_get_name (_tmp90_);
								_tmp92_ = _tmp91_;
								if (!g_hash_table_contains (_tmp89_, _tmp92_)) {
									GHashTable* _tmp93_;
									alpm_pkg_t* _tmp94_;
									const gchar* _tmp95_;
									const gchar* _tmp96_;
									_tmp93_ = self->priv->required_to_remove;
									_tmp94_ = satisfier;
									_tmp95_ = alpm_pkg_get_name (_tmp94_);
									_tmp96_ = _tmp95_;
									_tmp88_ = !g_hash_table_contains (_tmp93_, _tmp96_);
								} else {
									_tmp88_ = FALSE;
								}
								if (_tmp88_) {
									GHashTable* _tmp97_;
									alpm_pkg_t* _tmp98_;
									const gchar* _tmp99_;
									const gchar* _tmp100_;
									_tmp97_ = self->priv->orphans_to_remove;
									_tmp98_ = satisfier;
									_tmp99_ = alpm_pkg_get_name (_tmp98_);
									_tmp100_ = _tmp99_;
									_tmp87_ = !g_hash_table_contains (_tmp97_, _tmp100_);
								} else {
									_tmp87_ = FALSE;
								}
								if (_tmp87_) {
									alpm_pkg_t* _tmp101_;
									_tmp101_ = satisfier;
									deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp101_);
								}
							}
							depends = alpm_list_next (depends);
						}
					}
					_alpm_list_free0 (optionalfor);
				}
				_alpm_list_free0 (requiredby);
			}
		}
		deps_to_check = alpm_list_next (deps_to_check);
	}
	_tmp102_ = deps_to_check_next;
	if (_tmp102_ != NULL) {
		alpm_list_t* _tmp103_;
		_tmp103_ = deps_to_check_next;
		pamac_alpm_utils_check_orphans_to_remove (self, alpm_handle, _tmp103_);
	}
	_alpm_list_free0 (deps_to_check_next);
}

static void
pamac_alpm_utils_intern_compute_orphans_to_remove (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle)
{
	GHashTable* _tmp0_;
	alpm_list_t* deps_to_check = NULL;
	alpm_list_t* _tmp87_;
	g_return_if_fail (self != NULL);
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_RECURSE);
	_tmp0_ = self->priv->checked_deps;
	g_hash_table_remove_all (_tmp0_);
	deps_to_check = NULL;
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp1_;
		GHashTableIter _tmp2_ = {0};
		const gchar* name = NULL;
		_tmp1_ = self->priv->to_remove;
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_name_it = _tmp2_;
		while (TRUE) {
			gconstpointer _tmp3_;
			const gchar* _tmp4_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_db_t* _tmp5_;
			alpm_db_t* _tmp6_;
			const gchar* _tmp7_;
			alpm_pkg_t* _tmp8_;
			alpm_pkg_t* _tmp9_;
			_tmp3_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp3_;
			_tmp4_ = name;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = alpm_get_localdb (alpm_handle);
			_tmp6_ = _tmp5_;
			_tmp7_ = name;
			_tmp8_ = alpm_db_get_pkg (_tmp6_, _tmp7_);
			trans_pkg = _tmp8_;
			_tmp9_ = trans_pkg;
			if (_tmp9_ != NULL) {
				GHashTable* _tmp10_;
				alpm_pkg_t* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = self->priv->checked_deps;
				_tmp11_ = trans_pkg;
				_tmp12_ = alpm_pkg_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!g_hash_table_contains (_tmp10_, _tmp13_)) {
					GHashTable* _tmp14_;
					alpm_pkg_t* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					alpm_list_t* depends = NULL;
					alpm_pkg_t* _tmp19_;
					alpm_list_t* _tmp20_;
					alpm_list_t* _tmp21_;
					_tmp14_ = self->priv->checked_deps;
					_tmp15_ = trans_pkg;
					_tmp16_ = alpm_pkg_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup (_tmp17_);
					g_hash_table_add (_tmp14_, _tmp18_);
					_tmp19_ = trans_pkg;
					_tmp20_ = alpm_pkg_get_depends (_tmp19_);
					_tmp21_ = _tmp20_;
					depends = _tmp21_;
					while (TRUE) {
						alpm_list_t* _tmp22_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp23_;
						alpm_db_t* _tmp24_;
						alpm_list_t* _tmp25_;
						alpm_list_t* _tmp26_;
						alpm_list_t* _tmp27_;
						gconstpointer _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						alpm_pkg_t* _tmp31_;
						alpm_pkg_t* _tmp32_;
						alpm_pkg_t* _tmp33_;
						_tmp22_ = depends;
						if (!(_tmp22_ != NULL)) {
							break;
						}
						_tmp23_ = alpm_get_localdb (alpm_handle);
						_tmp24_ = _tmp23_;
						_tmp25_ = alpm_db_get_pkgcache (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = depends;
						_tmp28_ = _tmp27_->data;
						_tmp29_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = alpm_find_satisfier (_tmp26_, _tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp30_);
						satisfier = _tmp32_;
						_tmp33_ = satisfier;
						if (_tmp33_ != NULL) {
							gboolean _tmp34_ = FALSE;
							GHashTable* _tmp35_;
							alpm_pkg_t* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							_tmp35_ = self->priv->to_remove;
							_tmp36_ = satisfier;
							_tmp37_ = alpm_pkg_get_name (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!g_hash_table_contains (_tmp35_, _tmp38_)) {
								GHashTable* _tmp39_;
								alpm_pkg_t* _tmp40_;
								const gchar* _tmp41_;
								const gchar* _tmp42_;
								_tmp39_ = self->priv->required_to_remove;
								_tmp40_ = satisfier;
								_tmp41_ = alpm_pkg_get_name (_tmp40_);
								_tmp42_ = _tmp41_;
								_tmp34_ = !g_hash_table_contains (_tmp39_, _tmp42_);
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								alpm_pkg_t* _tmp43_;
								_tmp43_ = satisfier;
								deps_to_check = alpm_list_add (deps_to_check, _tmp43_);
							}
						}
						depends = alpm_list_next (depends);
					}
				}
			}
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp44_;
		GHashTableIter _tmp45_ = {0};
		const gchar* name = NULL;
		_tmp44_ = self->priv->required_to_remove;
		g_hash_table_iter_init (&_tmp45_, _tmp44_);
		_name_it = _tmp45_;
		while (TRUE) {
			gconstpointer _tmp46_;
			const gchar* _tmp47_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_db_t* _tmp48_;
			alpm_db_t* _tmp49_;
			const gchar* _tmp50_;
			alpm_pkg_t* _tmp51_;
			alpm_pkg_t* _tmp52_;
			_tmp46_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp46_;
			_tmp47_ = name;
			if (!(_tmp47_ != NULL)) {
				break;
			}
			_tmp48_ = alpm_get_localdb (alpm_handle);
			_tmp49_ = _tmp48_;
			_tmp50_ = name;
			_tmp51_ = alpm_db_get_pkg (_tmp49_, _tmp50_);
			trans_pkg = _tmp51_;
			_tmp52_ = trans_pkg;
			if (_tmp52_ != NULL) {
				GHashTable* _tmp53_;
				alpm_pkg_t* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				_tmp53_ = self->priv->checked_deps;
				_tmp54_ = trans_pkg;
				_tmp55_ = alpm_pkg_get_name (_tmp54_);
				_tmp56_ = _tmp55_;
				if (!g_hash_table_contains (_tmp53_, _tmp56_)) {
					GHashTable* _tmp57_;
					alpm_pkg_t* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					alpm_list_t* depends = NULL;
					alpm_pkg_t* _tmp62_;
					alpm_list_t* _tmp63_;
					alpm_list_t* _tmp64_;
					_tmp57_ = self->priv->checked_deps;
					_tmp58_ = trans_pkg;
					_tmp59_ = alpm_pkg_get_name (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strdup (_tmp60_);
					g_hash_table_add (_tmp57_, _tmp61_);
					_tmp62_ = trans_pkg;
					_tmp63_ = alpm_pkg_get_depends (_tmp62_);
					_tmp64_ = _tmp63_;
					depends = _tmp64_;
					while (TRUE) {
						alpm_list_t* _tmp65_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp66_;
						alpm_db_t* _tmp67_;
						alpm_list_t* _tmp68_;
						alpm_list_t* _tmp69_;
						alpm_list_t* _tmp70_;
						gconstpointer _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						alpm_pkg_t* _tmp74_;
						alpm_pkg_t* _tmp75_;
						alpm_pkg_t* _tmp76_;
						_tmp65_ = depends;
						if (!(_tmp65_ != NULL)) {
							break;
						}
						_tmp66_ = alpm_get_localdb (alpm_handle);
						_tmp67_ = _tmp66_;
						_tmp68_ = alpm_db_get_pkgcache (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = depends;
						_tmp71_ = _tmp70_->data;
						_tmp72_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = alpm_find_satisfier (_tmp69_, _tmp73_);
						_tmp75_ = _tmp74_;
						_g_free0 (_tmp73_);
						satisfier = _tmp75_;
						_tmp76_ = satisfier;
						if (_tmp76_ != NULL) {
							gboolean _tmp77_ = FALSE;
							GHashTable* _tmp78_;
							alpm_pkg_t* _tmp79_;
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							_tmp78_ = self->priv->to_remove;
							_tmp79_ = satisfier;
							_tmp80_ = alpm_pkg_get_name (_tmp79_);
							_tmp81_ = _tmp80_;
							if (!g_hash_table_contains (_tmp78_, _tmp81_)) {
								GHashTable* _tmp82_;
								alpm_pkg_t* _tmp83_;
								const gchar* _tmp84_;
								const gchar* _tmp85_;
								_tmp82_ = self->priv->required_to_remove;
								_tmp83_ = satisfier;
								_tmp84_ = alpm_pkg_get_name (_tmp83_);
								_tmp85_ = _tmp84_;
								_tmp77_ = !g_hash_table_contains (_tmp82_, _tmp85_);
							} else {
								_tmp77_ = FALSE;
							}
							if (_tmp77_) {
								alpm_pkg_t* _tmp86_;
								_tmp86_ = satisfier;
								deps_to_check = alpm_list_add (deps_to_check, _tmp86_);
							}
						}
						depends = alpm_list_next (depends);
					}
				}
			}
		}
	}
	_tmp87_ = deps_to_check;
	if (_tmp87_ != NULL) {
		alpm_list_t* _tmp88_;
		_tmp88_ = deps_to_check;
		pamac_alpm_utils_check_orphans_to_remove (self, alpm_handle, _tmp88_);
	}
	_alpm_list_free0 (deps_to_check);
}

static gboolean
pamac_alpm_utils_trans_prepare (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle,
                                alpm_db_t* aur_db)
{
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = pamac_alpm_utils_trans_init (self, alpm_handle, self->priv->trans_flags, TRUE);
	if (success) {
		_tmp0_ = self->priv->sysupgrade;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		success = pamac_alpm_utils_trans_sysupgrade (self, alpm_handle, TRUE);
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp1_;
			GHashTableIter _tmp2_ = {0};
			const gchar* name = NULL;
			_tmp1_ = self->priv->to_install;
			g_hash_table_iter_init (&_tmp2_, _tmp1_);
			_name_it = _tmp2_;
			while (TRUE) {
				gconstpointer _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp3_;
				_tmp4_ = name;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp5_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp6_;
			GHashTableIter _tmp7_ = {0};
			const gchar* name = NULL;
			_tmp6_ = self->priv->deps_to_install;
			g_hash_table_iter_init (&_tmp7_, _tmp6_);
			_name_it = _tmp7_;
			while (TRUE) {
				gconstpointer _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp8_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp8_;
				_tmp9_ = name;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp10_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	_tmp11_ = self->priv->to_build;
	_tmp12_ = g_hash_table_size (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > ((guint) 0)) {
		alpm_list_t* dbs = NULL;
		dbs = NULL;
		dbs = alpm_list_add (dbs, aur_db);
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp14_;
			GHashTableIter _tmp15_ = {0};
			const gchar* name = NULL;
			_tmp14_ = self->priv->to_build;
			g_hash_table_iter_init (&_tmp15_, _tmp14_);
			_name_it = _tmp15_;
			while (TRUE) {
				gconstpointer _tmp16_;
				const gchar* _tmp17_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp18_;
				const gchar* _tmp19_;
				alpm_pkg_t* _tmp20_;
				alpm_pkg_t* _tmp21_;
				_tmp16_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp16_;
				_tmp17_ = name;
				if (!(_tmp17_ != NULL)) {
					break;
				}
				_tmp18_ = dbs;
				_tmp19_ = name;
				_tmp20_ = alpm_find_dbs_satisfier (alpm_handle, _tmp18_, _tmp19_);
				pkg = _tmp20_;
				_tmp21_ = pkg;
				if (_tmp21_ == NULL) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp22_;
					GPtrArray* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					GPtrArray* _tmp26_;
					_tmp22_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
					details = _tmp22_;
					_tmp23_ = details;
					_tmp24_ = name;
					_tmp25_ = g_strdup_printf (_ ("target not found: %s"), _tmp24_);
					g_ptr_array_add (_tmp23_, _tmp25_);
					_tmp26_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp26_);
					success = FALSE;
					_g_ptr_array_unref0 (details);
					break;
				} else {
					alpm_pkg_t* _tmp27_;
					_tmp27_ = pkg;
					success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp27_, TRUE);
					if (!success) {
						break;
					}
				}
			}
		}
		_alpm_list_free0 (dbs);
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp28_;
			GHashTableIter _tmp29_ = {0};
			const gchar* name = NULL;
			_tmp28_ = self->priv->to_remove;
			g_hash_table_iter_init (&_tmp29_, _tmp28_);
			_name_it = _tmp29_;
			while (TRUE) {
				gconstpointer _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp30_;
				_tmp31_ = name;
				if (!(_tmp31_ != NULL)) {
					break;
				}
				_tmp32_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp32_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp33_;
			GHashTableIter _tmp34_ = {0};
			const gchar* name = NULL;
			_tmp33_ = self->priv->required_to_remove;
			g_hash_table_iter_init (&_tmp34_, _tmp33_);
			_name_it = _tmp34_;
			while (TRUE) {
				gconstpointer _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp35_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp35_;
				_tmp36_ = name;
				if (!(_tmp36_ != NULL)) {
					break;
				}
				_tmp37_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp37_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp38_;
			GHashTableIter _tmp39_ = {0};
			const gchar* name = NULL;
			_tmp38_ = self->priv->orphans_to_remove;
			g_hash_table_iter_init (&_tmp39_, _tmp38_);
			_name_it = _tmp39_;
			while (TRUE) {
				gconstpointer _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp40_;
				_tmp41_ = name;
				if (!(_tmp41_ != NULL)) {
					break;
				}
				_tmp42_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp42_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp43_;
			GHashTableIter _tmp44_ = {0};
			const gchar* path = NULL;
			_tmp43_ = self->priv->local_paths;
			g_hash_table_iter_init (&_tmp44_, _tmp43_);
			_path_it = _tmp44_;
			while (TRUE) {
				gconstpointer _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				_tmp45_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp45_;
				_tmp46_ = path;
				if (!(_tmp46_ != NULL)) {
					break;
				}
				_tmp47_ = path;
				_tmp48_ = alpm_option_get_local_file_siglevel (alpm_handle);
				_tmp49_ = _tmp48_;
				success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp47_, _tmp49_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp50_;
			GHashTableIter _tmp51_ = {0};
			const gchar* path = NULL;
			_tmp50_ = self->priv->remote_paths;
			g_hash_table_iter_init (&_tmp51_, _tmp50_);
			_path_it = _tmp51_;
			while (TRUE) {
				gconstpointer _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				_tmp52_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp52_;
				_tmp53_ = path;
				if (!(_tmp53_ != NULL)) {
					break;
				}
				_tmp54_ = path;
				_tmp55_ = alpm_option_get_remote_file_siglevel (alpm_handle);
				_tmp56_ = _tmp55_;
				success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp54_, _tmp56_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, TRUE);
	} else {
		pamac_alpm_utils_trans_release (self, alpm_handle);
	}
	result = success;
	return result;
}

static void
pamac_alpm_utils_get_transaction_summary (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          PamacTransactionSummary** summary)
{
	GHashTable* checked = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	alpm_list_t* pkgs_to_add = NULL;
	alpm_list_t* _tmp3_;
	alpm_list_t* pkgs_to_remove = NULL;
	alpm_list_t* _tmp175_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*summary != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	checked = _tmp2_;
	_tmp3_ = alpm_trans_get_add (alpm_handle);
	pkgs_to_add = _tmp3_;
	while (TRUE) {
		alpm_list_t* _tmp4_;
		alpm_pkg_t* trans_pkg = NULL;
		alpm_list_t* _tmp5_;
		gconstpointer _tmp6_;
		alpm_db_t* db = NULL;
		alpm_pkg_t* _tmp7_;
		alpm_db_t* _tmp8_;
		alpm_db_t* _tmp9_;
		const gchar* trans_pkg_name = NULL;
		alpm_pkg_t* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		alpm_db_t* _tmp14_;
		_tmp4_ = pkgs_to_add;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = pkgs_to_add;
		_tmp6_ = _tmp5_->data;
		trans_pkg = (alpm_pkg_t*) _tmp6_;
		_tmp7_ = trans_pkg;
		_tmp8_ = alpm_pkg_get_db (_tmp7_);
		_tmp9_ = _tmp8_;
		db = _tmp9_;
		_tmp10_ = trans_pkg;
		_tmp11_ = alpm_pkg_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		trans_pkg_name = _tmp12_;
		_tmp14_ = db;
		if (_tmp14_ != NULL) {
			alpm_db_t* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = db;
			_tmp16_ = alpm_db_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp13_ = g_strcmp0 (_tmp17_, "pamac_aur") == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			PamacAlpmPackage* pkg = NULL;
			alpm_pkg_t* _tmp18_;
			PamacAlpmPackage* _tmp19_;
			GPtrArray* _tmp20_;
			GPtrArray* _tmp21_;
			alpm_pkg_t* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GEqualFunc _tmp25_;
			PamacAlpmPackage* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			GPtrArray* _tmp75_;
			GPtrArray* _tmp76_;
			PamacAlpmPackage* _tmp77_;
			PamacPackage* _tmp78_;
			_tmp18_ = trans_pkg;
			_tmp19_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp18_);
			pkg = _tmp19_;
			_tmp20_ = pamac_transaction_summary_get_aur_pkgbases_to_build (*summary);
			_tmp21_ = _tmp20_;
			_tmp22_ = trans_pkg;
			_tmp23_ = alpm_pkg_get_base (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_str_equal;
			if (!g_ptr_array_find_with_equal_func (_tmp21_, _tmp24_, _tmp25_, NULL)) {
				GPtrArray* _tmp26_;
				GPtrArray* _tmp27_;
				alpm_pkg_t* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp26_ = pamac_transaction_summary_get_aur_pkgbases_to_build (*summary);
				_tmp27_ = _tmp26_;
				_tmp28_ = trans_pkg;
				_tmp29_ = alpm_pkg_get_base (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup (_tmp30_);
				g_ptr_array_add (_tmp27_, _tmp31_);
			}
			_tmp32_ = pkg;
			_tmp33_ = pamac_package_get_installed_version ((PamacPackage*) _tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_ == NULL) {
				GHashTable* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = self->priv->to_build;
				_tmp36_ = trans_pkg_name;
				if (!g_hash_table_contains (_tmp35_, _tmp36_)) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp37_;
					dep_found = FALSE;
					_tmp37_ = trans_pkg;
					check_pkg = _tmp37_;
					while (TRUE) {
						alpm_list_t* pkg_requiredby = NULL;
						alpm_pkg_t* _tmp38_;
						alpm_list_t* _tmp39_;
						alpm_list_t* requiredby_list = NULL;
						alpm_list_t* _tmp40_;
						alpm_list_t* _tmp74_;
						if (!(!dep_found)) {
							break;
						}
						_tmp38_ = check_pkg;
						_tmp39_ = alpm_pkg_compute_requiredby (_tmp38_);
						pkg_requiredby = _tmp39_;
						_tmp40_ = pkg_requiredby;
						requiredby_list = _tmp40_;
						while (TRUE) {
							alpm_list_t* _tmp41_;
							const gchar* requiredby_name = NULL;
							alpm_list_t* _tmp42_;
							gconstpointer _tmp43_;
							gboolean check_pkg_found = FALSE;
							alpm_list_t* pkgs_to_add2 = NULL;
							alpm_list_t* _tmp44_;
							gboolean _tmp73_ = FALSE;
							_tmp41_ = requiredby_list;
							if (!(_tmp41_ != NULL)) {
								break;
							}
							_tmp42_ = requiredby_list;
							_tmp43_ = _tmp42_->data;
							requiredby_name = _tmp43_;
							check_pkg_found = FALSE;
							_tmp44_ = alpm_trans_get_add (alpm_handle);
							pkgs_to_add2 = _tmp44_;
							while (TRUE) {
								alpm_list_t* _tmp45_;
								alpm_pkg_t* pkg_to_add = NULL;
								alpm_list_t* _tmp46_;
								gconstpointer _tmp47_;
								const gchar* pkg_to_add_name = NULL;
								alpm_pkg_t* _tmp48_;
								const gchar* _tmp49_;
								const gchar* _tmp50_;
								const gchar* _tmp51_;
								const gchar* _tmp52_;
								_tmp45_ = pkgs_to_add2;
								if (!(_tmp45_ != NULL)) {
									break;
								}
								_tmp46_ = pkgs_to_add2;
								_tmp47_ = _tmp46_->data;
								pkg_to_add = (alpm_pkg_t*) _tmp47_;
								_tmp48_ = pkg_to_add;
								_tmp49_ = alpm_pkg_get_name (_tmp48_);
								_tmp50_ = _tmp49_;
								pkg_to_add_name = _tmp50_;
								_tmp51_ = pkg_to_add_name;
								_tmp52_ = requiredby_name;
								if (g_strcmp0 (_tmp51_, _tmp52_) == 0) {
									GHashTable* _tmp53_;
									const gchar* _tmp54_;
									_tmp53_ = self->priv->to_build;
									_tmp54_ = pkg_to_add_name;
									if (g_hash_table_contains (_tmp53_, _tmp54_)) {
										PamacAlpmPackage* _tmp55_;
										GPtrArray* _tmp56_;
										GPtrArray* _tmp57_;
										const gchar* _tmp58_;
										_tmp55_ = pkg;
										_tmp56_ = pamac_alpm_package_get_requiredby (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp58_ = requiredby_name;
										requiredby_name = NULL;
										g_ptr_array_add (_tmp57_, (gchar*) _tmp58_);
										dep_found = TRUE;
									} else {
										GHashTable* _tmp59_;
										const gchar* _tmp60_;
										_tmp59_ = checked;
										_tmp60_ = pkg_to_add_name;
										if (g_hash_table_contains (_tmp59_, _tmp60_)) {
											gint i = 0;
											GHashTable* _tmp61_;
											const gchar* _tmp62_;
											gconstpointer _tmp63_;
											_tmp61_ = checked;
											_tmp62_ = pkg_to_add_name;
											_tmp63_ = g_hash_table_lookup (_tmp61_, _tmp62_);
											i = (gint) ((gintptr) _tmp63_);
											if (i < 100) {
												alpm_pkg_t* _tmp64_;
												GHashTable* _tmp65_;
												const gchar* _tmp66_;
												gchar* _tmp67_;
												_tmp64_ = pkg_to_add;
												check_pkg = _tmp64_;
												check_pkg_found = TRUE;
												_tmp65_ = checked;
												_tmp66_ = pkg_to_add_name;
												_tmp67_ = g_strdup (_tmp66_);
												g_hash_table_insert (_tmp65_, _tmp67_, (gpointer) ((gintptr) (i + 1)));
											}
										} else {
											alpm_pkg_t* _tmp68_;
											GHashTable* _tmp69_;
											const gchar* _tmp70_;
											gchar* _tmp71_;
											_tmp68_ = pkg_to_add;
											check_pkg = _tmp68_;
											check_pkg_found = TRUE;
											_tmp69_ = checked;
											_tmp70_ = pkg_to_add_name;
											_tmp71_ = g_strdup (_tmp70_);
											g_hash_table_insert (_tmp69_, _tmp71_, (gpointer) ((gintptr) 0));
										}
									}
									break;
								}
								pkgs_to_add2 = alpm_list_next (pkgs_to_add2);
							}
							if (!dep_found) {
								const gchar* _tmp72_;
								_tmp72_ = requiredby_name;
								_g_free0 (_tmp72_);
							}
							if (dep_found) {
								_tmp73_ = TRUE;
							} else {
								_tmp73_ = check_pkg_found;
							}
							if (_tmp73_) {
								break;
							}
							requiredby_list = alpm_list_next (requiredby_list);
						}
						_tmp74_ = requiredby_list;
						if (_tmp74_ == NULL) {
							_alpm_list_free0 (pkg_requiredby);
							break;
						}
						_alpm_list_free0 (pkg_requiredby);
					}
				}
			}
			_tmp75_ = pamac_transaction_summary_get_to_build (*summary);
			_tmp76_ = _tmp75_;
			_tmp77_ = pkg;
			_tmp78_ = _g_object_ref0 ((PamacPackage*) _tmp77_);
			g_ptr_array_add (_tmp76_, _tmp78_);
			_g_object_unref0 (pkg);
		} else {
			PamacAlpmPackage* pkg = NULL;
			alpm_pkg_t* _tmp79_;
			PamacAlpmPackage* _tmp80_;
			PamacAlpmPackage* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			alpm_db_t* _tmp170_;
			_tmp79_ = trans_pkg;
			_tmp80_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp79_);
			pkg = _tmp80_;
			_tmp81_ = pkg;
			_tmp82_ = pamac_package_get_installed_version ((PamacPackage*) _tmp81_);
			_tmp83_ = _tmp82_;
			if (_tmp83_ == NULL) {
				gboolean _tmp84_ = FALSE;
				alpm_db_t* _tmp85_;
				GPtrArray* _tmp148_;
				GPtrArray* _tmp149_;
				PamacAlpmPackage* _tmp150_;
				PamacPackage* _tmp151_;
				_tmp85_ = db;
				if (_tmp85_ != NULL) {
					GHashTable* _tmp86_;
					const gchar* _tmp87_;
					_tmp86_ = self->priv->to_install;
					_tmp87_ = trans_pkg_name;
					_tmp84_ = !g_hash_table_contains (_tmp86_, _tmp87_);
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp88_;
					dep_found = FALSE;
					_tmp88_ = trans_pkg;
					check_pkg = _tmp88_;
					while (TRUE) {
						alpm_list_t* pkg_requiredby = NULL;
						alpm_pkg_t* _tmp89_;
						alpm_list_t* _tmp90_;
						alpm_list_t* requiredby_list = NULL;
						alpm_list_t* _tmp91_;
						alpm_list_t* _tmp128_;
						if (!(!dep_found)) {
							break;
						}
						_tmp89_ = check_pkg;
						_tmp90_ = alpm_pkg_compute_requiredby (_tmp89_);
						pkg_requiredby = _tmp90_;
						_tmp91_ = pkg_requiredby;
						requiredby_list = _tmp91_;
						while (TRUE) {
							alpm_list_t* _tmp92_;
							const gchar* requiredby_name = NULL;
							alpm_list_t* _tmp93_;
							gconstpointer _tmp94_;
							gboolean check_pkg_found = FALSE;
							alpm_list_t* pkgs_to_add2 = NULL;
							alpm_list_t* _tmp95_;
							gboolean _tmp127_ = FALSE;
							_tmp92_ = requiredby_list;
							if (!(_tmp92_ != NULL)) {
								break;
							}
							_tmp93_ = requiredby_list;
							_tmp94_ = _tmp93_->data;
							requiredby_name = _tmp94_;
							check_pkg_found = FALSE;
							_tmp95_ = alpm_trans_get_add (alpm_handle);
							pkgs_to_add2 = _tmp95_;
							while (TRUE) {
								alpm_list_t* _tmp96_;
								alpm_pkg_t* pkg_to_add = NULL;
								alpm_list_t* _tmp97_;
								gconstpointer _tmp98_;
								const gchar* pkg_to_add_name = NULL;
								alpm_pkg_t* _tmp99_;
								const gchar* _tmp100_;
								const gchar* _tmp101_;
								const gchar* _tmp102_;
								const gchar* _tmp103_;
								_tmp96_ = pkgs_to_add2;
								if (!(_tmp96_ != NULL)) {
									break;
								}
								_tmp97_ = pkgs_to_add2;
								_tmp98_ = _tmp97_->data;
								pkg_to_add = (alpm_pkg_t*) _tmp98_;
								_tmp99_ = pkg_to_add;
								_tmp100_ = alpm_pkg_get_name (_tmp99_);
								_tmp101_ = _tmp100_;
								pkg_to_add_name = _tmp101_;
								_tmp102_ = pkg_to_add_name;
								_tmp103_ = requiredby_name;
								if (g_strcmp0 (_tmp102_, _tmp103_) == 0) {
									gboolean _tmp104_ = FALSE;
									GHashTable* _tmp105_;
									const gchar* _tmp106_;
									_tmp105_ = self->priv->to_install;
									_tmp106_ = pkg_to_add_name;
									if (g_hash_table_contains (_tmp105_, _tmp106_)) {
										_tmp104_ = TRUE;
									} else {
										GHashTable* _tmp107_;
										const gchar* _tmp108_;
										_tmp107_ = self->priv->to_build;
										_tmp108_ = pkg_to_add_name;
										_tmp104_ = g_hash_table_contains (_tmp107_, _tmp108_);
									}
									if (_tmp104_) {
										PamacAlpmPackage* _tmp109_;
										GPtrArray* _tmp110_;
										GPtrArray* _tmp111_;
										const gchar* _tmp112_;
										_tmp109_ = pkg;
										_tmp110_ = pamac_alpm_package_get_requiredby (_tmp109_);
										_tmp111_ = _tmp110_;
										_tmp112_ = requiredby_name;
										requiredby_name = NULL;
										g_ptr_array_add (_tmp111_, (gchar*) _tmp112_);
										dep_found = TRUE;
									} else {
										GHashTable* _tmp113_;
										const gchar* _tmp114_;
										_tmp113_ = checked;
										_tmp114_ = pkg_to_add_name;
										if (g_hash_table_contains (_tmp113_, _tmp114_)) {
											gint i = 0;
											GHashTable* _tmp115_;
											const gchar* _tmp116_;
											gconstpointer _tmp117_;
											_tmp115_ = checked;
											_tmp116_ = pkg_to_add_name;
											_tmp117_ = g_hash_table_lookup (_tmp115_, _tmp116_);
											i = (gint) ((gintptr) _tmp117_);
											if (i < 100) {
												alpm_pkg_t* _tmp118_;
												GHashTable* _tmp119_;
												const gchar* _tmp120_;
												gchar* _tmp121_;
												_tmp118_ = pkg_to_add;
												check_pkg = _tmp118_;
												check_pkg_found = TRUE;
												_tmp119_ = checked;
												_tmp120_ = pkg_to_add_name;
												_tmp121_ = g_strdup (_tmp120_);
												g_hash_table_insert (_tmp119_, _tmp121_, (gpointer) ((gintptr) (i + 1)));
											}
										} else {
											alpm_pkg_t* _tmp122_;
											GHashTable* _tmp123_;
											const gchar* _tmp124_;
											gchar* _tmp125_;
											_tmp122_ = pkg_to_add;
											check_pkg = _tmp122_;
											check_pkg_found = TRUE;
											_tmp123_ = checked;
											_tmp124_ = pkg_to_add_name;
											_tmp125_ = g_strdup (_tmp124_);
											g_hash_table_insert (_tmp123_, _tmp125_, (gpointer) ((gintptr) 0));
										}
									}
									break;
								}
								pkgs_to_add2 = alpm_list_next (pkgs_to_add2);
							}
							if (!dep_found) {
								const gchar* _tmp126_;
								_tmp126_ = requiredby_name;
								_g_free0 (_tmp126_);
							}
							if (dep_found) {
								_tmp127_ = TRUE;
							} else {
								_tmp127_ = check_pkg_found;
							}
							if (_tmp127_) {
								break;
							}
							requiredby_list = alpm_list_next (requiredby_list);
						}
						_tmp128_ = requiredby_list;
						if (_tmp128_ == NULL) {
							_alpm_list_free0 (pkg_requiredby);
							break;
						}
						_alpm_list_free0 (pkg_requiredby);
					}
					if (!dep_found) {
						alpm_list_t* depends_list = NULL;
						alpm_pkg_t* _tmp129_;
						alpm_list_t* _tmp130_;
						alpm_list_t* _tmp131_;
						_tmp129_ = trans_pkg;
						_tmp130_ = alpm_pkg_get_replaces (_tmp129_);
						_tmp131_ = _tmp130_;
						depends_list = _tmp131_;
						while (TRUE) {
							alpm_list_t* _tmp132_;
							gchar* depstring = NULL;
							alpm_list_t* _tmp133_;
							gconstpointer _tmp134_;
							gchar* _tmp135_;
							alpm_db_t* _tmp136_;
							alpm_db_t* _tmp137_;
							alpm_list_t* _tmp138_;
							alpm_list_t* _tmp139_;
							const gchar* _tmp140_;
							alpm_pkg_t* _tmp141_;
							_tmp132_ = depends_list;
							if (!(_tmp132_ != NULL)) {
								break;
							}
							_tmp133_ = depends_list;
							_tmp134_ = _tmp133_->data;
							_tmp135_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp134_);
							depstring = _tmp135_;
							_tmp136_ = alpm_get_localdb (alpm_handle);
							_tmp137_ = _tmp136_;
							_tmp138_ = alpm_db_get_pkgcache (_tmp137_);
							_tmp139_ = _tmp138_;
							_tmp140_ = depstring;
							_tmp141_ = alpm_find_satisfier (_tmp139_, _tmp140_);
							if (_tmp141_ != NULL) {
								PamacAlpmPackage* _tmp142_;
								GPtrArray* _tmp143_;
								GPtrArray* _tmp144_;
								alpm_list_t* _tmp145_;
								gconstpointer _tmp146_;
								gchar* _tmp147_;
								_tmp142_ = pkg;
								_tmp143_ = pamac_alpm_package_get_replaces (_tmp142_);
								_tmp144_ = _tmp143_;
								_tmp145_ = depends_list;
								_tmp146_ = _tmp145_->data;
								_tmp147_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp146_);
								g_ptr_array_add (_tmp144_, _tmp147_);
								_g_free0 (depstring);
								break;
							}
							depends_list = alpm_list_next (depends_list);
							_g_free0 (depstring);
						}
					}
				}
				_tmp148_ = pamac_transaction_summary_get_to_install (*summary);
				_tmp149_ = _tmp148_;
				_tmp150_ = pkg;
				_tmp151_ = _g_object_ref0 ((PamacPackage*) _tmp150_);
				g_ptr_array_add (_tmp149_, _tmp151_);
			} else {
				gint cmp = 0;
				PamacAlpmPackage* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				PamacAlpmPackage* _tmp155_;
				const gchar* _tmp156_;
				const gchar* _tmp157_;
				_tmp152_ = pkg;
				_tmp153_ = pamac_package_get_version ((PamacPackage*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = pkg;
				_tmp156_ = pamac_package_get_installed_version ((PamacPackage*) _tmp155_);
				_tmp157_ = _tmp156_;
				cmp = alpm_pkg_vercmp (_tmp154_, _tmp157_);
				if (cmp == 1) {
					GPtrArray* _tmp158_;
					GPtrArray* _tmp159_;
					PamacAlpmPackage* _tmp160_;
					PamacPackage* _tmp161_;
					_tmp158_ = pamac_transaction_summary_get_to_upgrade (*summary);
					_tmp159_ = _tmp158_;
					_tmp160_ = pkg;
					_tmp161_ = _g_object_ref0 ((PamacPackage*) _tmp160_);
					g_ptr_array_add (_tmp159_, _tmp161_);
				} else {
					if (cmp == 0) {
						GPtrArray* _tmp162_;
						GPtrArray* _tmp163_;
						PamacAlpmPackage* _tmp164_;
						PamacPackage* _tmp165_;
						_tmp162_ = pamac_transaction_summary_get_to_reinstall (*summary);
						_tmp163_ = _tmp162_;
						_tmp164_ = pkg;
						_tmp165_ = _g_object_ref0 ((PamacPackage*) _tmp164_);
						g_ptr_array_add (_tmp163_, _tmp165_);
					} else {
						GPtrArray* _tmp166_;
						GPtrArray* _tmp167_;
						PamacAlpmPackage* _tmp168_;
						PamacPackage* _tmp169_;
						_tmp166_ = pamac_transaction_summary_get_to_downgrade (*summary);
						_tmp167_ = _tmp166_;
						_tmp168_ = pkg;
						_tmp169_ = _g_object_ref0 ((PamacPackage*) _tmp168_);
						g_ptr_array_add (_tmp167_, _tmp169_);
					}
				}
			}
			_tmp170_ = db;
			if (_tmp170_ == NULL) {
				GPtrArray* _tmp171_;
				GPtrArray* _tmp172_;
				const gchar* _tmp173_;
				gchar* _tmp174_;
				_tmp171_ = pamac_transaction_summary_get_to_load (*summary);
				_tmp172_ = _tmp171_;
				_tmp173_ = trans_pkg_name;
				_tmp174_ = g_strdup (_tmp173_);
				g_ptr_array_add (_tmp172_, _tmp174_);
			}
			_g_object_unref0 (pkg);
		}
		pkgs_to_add = alpm_list_next (pkgs_to_add);
	}
	_tmp175_ = alpm_trans_get_remove (alpm_handle);
	pkgs_to_remove = _tmp175_;
	while (TRUE) {
		alpm_list_t* _tmp176_;
		alpm_pkg_t* trans_pkg = NULL;
		alpm_list_t* _tmp177_;
		gconstpointer _tmp178_;
		const gchar* trans_pkg_name = NULL;
		alpm_pkg_t* _tmp179_;
		const gchar* _tmp180_;
		const gchar* _tmp181_;
		PamacAlpmPackage* pkg = NULL;
		alpm_pkg_t* _tmp182_;
		PamacAlpmPackage* _tmp183_;
		GHashTable* _tmp184_;
		const gchar* _tmp185_;
		_tmp176_ = pkgs_to_remove;
		if (!(_tmp176_ != NULL)) {
			break;
		}
		_tmp177_ = pkgs_to_remove;
		_tmp178_ = _tmp177_->data;
		trans_pkg = (alpm_pkg_t*) _tmp178_;
		_tmp179_ = trans_pkg;
		_tmp180_ = alpm_pkg_get_name (_tmp179_);
		_tmp181_ = _tmp180_;
		trans_pkg_name = _tmp181_;
		_tmp182_ = trans_pkg;
		_tmp183_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp182_);
		pkg = _tmp183_;
		_tmp184_ = self->priv->to_remove;
		_tmp185_ = trans_pkg_name;
		if (g_hash_table_contains (_tmp184_, _tmp185_)) {
			GPtrArray* _tmp186_;
			GPtrArray* _tmp187_;
			PamacAlpmPackage* _tmp188_;
			PamacPackage* _tmp189_;
			_tmp186_ = pamac_transaction_summary_get_to_remove (*summary);
			_tmp187_ = _tmp186_;
			_tmp188_ = pkg;
			_tmp189_ = _g_object_ref0 ((PamacPackage*) _tmp188_);
			g_ptr_array_add (_tmp187_, _tmp189_);
		} else {
			GHashTable* _tmp190_;
			const gchar* _tmp191_;
			_tmp190_ = self->priv->required_to_remove;
			_tmp191_ = trans_pkg_name;
			if (g_hash_table_contains (_tmp190_, _tmp191_)) {
				gboolean dep_found = FALSE;
				alpm_pkg_t* check_pkg = NULL;
				alpm_pkg_t* _tmp192_;
				GPtrArray* _tmp222_;
				GPtrArray* _tmp223_;
				PamacAlpmPackage* _tmp224_;
				PamacPackage* _tmp225_;
				dep_found = FALSE;
				_tmp192_ = trans_pkg;
				check_pkg = _tmp192_;
				while (TRUE) {
					alpm_list_t* depends_list = NULL;
					alpm_pkg_t* _tmp193_;
					alpm_list_t* _tmp194_;
					alpm_list_t* _tmp195_;
					alpm_list_t* _tmp221_;
					if (!(!dep_found)) {
						break;
					}
					_tmp193_ = check_pkg;
					_tmp194_ = alpm_pkg_get_depends (_tmp193_);
					_tmp195_ = _tmp194_;
					depends_list = _tmp195_;
					while (TRUE) {
						alpm_list_t* _tmp196_;
						gchar* depstring = NULL;
						alpm_list_t* _tmp197_;
						gconstpointer _tmp198_;
						gchar* _tmp199_;
						alpm_pkg_t* dep = NULL;
						alpm_list_t* _tmp200_;
						const gchar* _tmp201_;
						alpm_pkg_t* _tmp202_;
						alpm_pkg_t* _tmp203_;
						_tmp196_ = depends_list;
						if (!(_tmp196_ != NULL)) {
							break;
						}
						_tmp197_ = depends_list;
						_tmp198_ = _tmp197_->data;
						_tmp199_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp198_);
						depstring = _tmp199_;
						_tmp200_ = alpm_trans_get_remove (alpm_handle);
						_tmp201_ = depstring;
						_tmp202_ = alpm_find_satisfier (_tmp200_, _tmp201_);
						dep = _tmp202_;
						_tmp203_ = dep;
						if (_tmp203_ != NULL) {
							gboolean _tmp204_ = FALSE;
							GHashTable* _tmp205_;
							alpm_pkg_t* _tmp206_;
							const gchar* _tmp207_;
							const gchar* _tmp208_;
							_tmp205_ = self->priv->to_remove;
							_tmp206_ = dep;
							_tmp207_ = alpm_pkg_get_name (_tmp206_);
							_tmp208_ = _tmp207_;
							if (g_hash_table_contains (_tmp205_, _tmp208_)) {
								_tmp204_ = TRUE;
							} else {
								GHashTable* _tmp209_;
								alpm_pkg_t* _tmp210_;
								const gchar* _tmp211_;
								const gchar* _tmp212_;
								_tmp209_ = self->priv->conflicts_to_remove;
								_tmp210_ = dep;
								_tmp211_ = alpm_pkg_get_name (_tmp210_);
								_tmp212_ = _tmp211_;
								_tmp204_ = g_hash_table_contains (_tmp209_, _tmp212_);
							}
							if (_tmp204_) {
								PamacAlpmPackage* _tmp213_;
								GPtrArray* _tmp214_;
								GPtrArray* _tmp215_;
								alpm_pkg_t* _tmp216_;
								const gchar* _tmp217_;
								const gchar* _tmp218_;
								gchar* _tmp219_;
								_tmp213_ = pkg;
								_tmp214_ = pamac_alpm_package_get_depends (_tmp213_);
								_tmp215_ = _tmp214_;
								_tmp216_ = dep;
								_tmp217_ = alpm_pkg_get_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = g_strdup (_tmp218_);
								g_ptr_array_add (_tmp215_, _tmp219_);
								dep_found = TRUE;
							} else {
								alpm_pkg_t* _tmp220_;
								_tmp220_ = dep;
								check_pkg = _tmp220_;
							}
							_g_free0 (depstring);
							break;
						}
						depends_list = alpm_list_next (depends_list);
						_g_free0 (depstring);
					}
					_tmp221_ = depends_list;
					if (_tmp221_ == NULL) {
						break;
					}
				}
				_tmp222_ = pamac_transaction_summary_get_to_remove (*summary);
				_tmp223_ = _tmp222_;
				_tmp224_ = pkg;
				_tmp225_ = _g_object_ref0 ((PamacPackage*) _tmp224_);
				g_ptr_array_add (_tmp223_, _tmp225_);
			} else {
				GHashTable* _tmp226_;
				const gchar* _tmp227_;
				_tmp226_ = self->priv->orphans_to_remove;
				_tmp227_ = trans_pkg_name;
				if (g_hash_table_contains (_tmp226_, _tmp227_)) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp228_;
					GPtrArray* _tmp246_;
					GPtrArray* _tmp247_;
					PamacAlpmPackage* _tmp248_;
					PamacPackage* _tmp249_;
					dep_found = FALSE;
					_tmp228_ = trans_pkg;
					check_pkg = _tmp228_;
					while (TRUE) {
						alpm_list_t* requiredby = NULL;
						alpm_pkg_t* _tmp229_;
						alpm_list_t* _tmp230_;
						alpm_list_t* _tmp231_;
						if (!(!dep_found)) {
							break;
						}
						_tmp229_ = check_pkg;
						_tmp230_ = alpm_pkg_compute_requiredby (_tmp229_);
						requiredby = _tmp230_;
						_tmp231_ = requiredby;
						if (_tmp231_ != NULL) {
							const gchar* name = NULL;
							alpm_list_t* _tmp232_;
							gconstpointer _tmp233_;
							GHashTable* _tmp234_;
							const gchar* _tmp235_;
							_tmp232_ = requiredby;
							_tmp233_ = _tmp232_->data;
							name = _tmp233_;
							_tmp234_ = self->priv->to_remove;
							_tmp235_ = name;
							if (g_hash_table_contains (_tmp234_, _tmp235_)) {
								PamacAlpmPackage* _tmp236_;
								GPtrArray* _tmp237_;
								GPtrArray* _tmp238_;
								const gchar* _tmp239_;
								_tmp236_ = pkg;
								_tmp237_ = pamac_alpm_package_get_requiredby (_tmp236_);
								_tmp238_ = _tmp237_;
								_tmp239_ = name;
								name = NULL;
								g_ptr_array_add (_tmp238_, (gchar*) _tmp239_);
								dep_found = TRUE;
							} else {
								alpm_db_t* _tmp240_;
								alpm_db_t* _tmp241_;
								const gchar* _tmp242_;
								alpm_pkg_t* _tmp243_;
								const gchar* _tmp244_;
								alpm_pkg_t* _tmp245_;
								_tmp240_ = alpm_get_localdb (alpm_handle);
								_tmp241_ = _tmp240_;
								_tmp242_ = name;
								_tmp243_ = alpm_db_get_pkg (_tmp241_, _tmp242_);
								check_pkg = _tmp243_;
								_tmp244_ = name;
								_g_free0 (_tmp244_);
								_tmp245_ = check_pkg;
								if (_tmp245_ == NULL) {
									_alpm_list_free0 (requiredby);
									break;
								}
							}
						} else {
							_alpm_list_free0 (requiredby);
							break;
						}
						_alpm_list_free0 (requiredby);
					}
					_tmp246_ = pamac_transaction_summary_get_to_remove (*summary);
					_tmp247_ = _tmp246_;
					_tmp248_ = pkg;
					_tmp249_ = _g_object_ref0 ((PamacPackage*) _tmp248_);
					g_ptr_array_add (_tmp247_, _tmp249_);
				} else {
					gboolean conflict_found = FALSE;
					alpm_list_t* depends_list = NULL;
					alpm_pkg_t* _tmp250_;
					alpm_list_t* _tmp251_;
					alpm_list_t* _tmp252_;
					GPtrArray* _tmp286_;
					GPtrArray* _tmp287_;
					PamacAlpmPackage* _tmp288_;
					PamacPackage* _tmp289_;
					conflict_found = FALSE;
					_tmp250_ = trans_pkg;
					_tmp251_ = alpm_pkg_get_conflicts (_tmp250_);
					_tmp252_ = _tmp251_;
					depends_list = _tmp252_;
					while (TRUE) {
						alpm_list_t* _tmp253_;
						gchar* depstring = NULL;
						alpm_list_t* _tmp254_;
						gconstpointer _tmp255_;
						gchar* _tmp256_;
						alpm_list_t* _tmp257_;
						const gchar* _tmp258_;
						alpm_pkg_t* _tmp259_;
						_tmp253_ = depends_list;
						if (!(_tmp253_ != NULL)) {
							break;
						}
						_tmp254_ = depends_list;
						_tmp255_ = _tmp254_->data;
						_tmp256_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp255_);
						depstring = _tmp256_;
						_tmp257_ = alpm_trans_get_add (alpm_handle);
						_tmp258_ = depstring;
						_tmp259_ = alpm_find_satisfier (_tmp257_, _tmp258_);
						if (_tmp259_ != NULL) {
							PamacAlpmPackage* _tmp260_;
							GPtrArray* _tmp261_;
							GPtrArray* _tmp262_;
							gchar* _tmp263_;
							_tmp260_ = pkg;
							_tmp261_ = pamac_alpm_package_get_conflicts (_tmp260_);
							_tmp262_ = _tmp261_;
							_tmp263_ = depstring;
							depstring = NULL;
							g_ptr_array_add (_tmp262_, _tmp263_);
							conflict_found = TRUE;
							_g_free0 (depstring);
							break;
						}
						depends_list = alpm_list_next (depends_list);
						_g_free0 (depstring);
					}
					if (!conflict_found) {
						alpm_list_t* _tmp264_;
						_tmp264_ = alpm_trans_get_add (alpm_handle);
						pkgs_to_add = _tmp264_;
						while (TRUE) {
							alpm_list_t* _tmp265_;
							alpm_pkg_t* add_pkg = NULL;
							alpm_list_t* _tmp266_;
							gconstpointer _tmp267_;
							alpm_pkg_t* _tmp268_;
							alpm_list_t* _tmp269_;
							alpm_list_t* _tmp270_;
							_tmp265_ = pkgs_to_add;
							if (!(_tmp265_ != NULL)) {
								break;
							}
							_tmp266_ = pkgs_to_add;
							_tmp267_ = _tmp266_->data;
							add_pkg = (alpm_pkg_t*) _tmp267_;
							_tmp268_ = add_pkg;
							_tmp269_ = alpm_pkg_get_conflicts (_tmp268_);
							_tmp270_ = _tmp269_;
							depends_list = _tmp270_;
							while (TRUE) {
								alpm_list_t* _tmp271_;
								gchar* depstring = NULL;
								alpm_list_t* _tmp272_;
								gconstpointer _tmp273_;
								gchar* _tmp274_;
								alpm_list_t* list = NULL;
								alpm_pkg_t* _tmp275_;
								alpm_list_t* _tmp276_;
								const gchar* _tmp277_;
								alpm_pkg_t* _tmp278_;
								_tmp271_ = depends_list;
								if (!(_tmp271_ != NULL)) {
									break;
								}
								_tmp272_ = depends_list;
								_tmp273_ = _tmp272_->data;
								_tmp274_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp273_);
								depstring = _tmp274_;
								list = NULL;
								_tmp275_ = trans_pkg;
								list = alpm_list_add (list, _tmp275_);
								_tmp276_ = list;
								_tmp277_ = depstring;
								_tmp278_ = alpm_find_satisfier (_tmp276_, _tmp277_);
								if (_tmp278_ != NULL) {
									PamacAlpmPackage* _tmp279_;
									GPtrArray* _tmp280_;
									GPtrArray* _tmp281_;
									alpm_pkg_t* _tmp282_;
									const gchar* _tmp283_;
									const gchar* _tmp284_;
									gchar* _tmp285_;
									_tmp279_ = pkg;
									_tmp280_ = pamac_alpm_package_get_conflicts (_tmp279_);
									_tmp281_ = _tmp280_;
									_tmp282_ = add_pkg;
									_tmp283_ = alpm_pkg_get_name (_tmp282_);
									_tmp284_ = _tmp283_;
									_tmp285_ = g_strdup (_tmp284_);
									g_ptr_array_add (_tmp281_, _tmp285_);
									conflict_found = TRUE;
									_alpm_list_free0 (list);
									_g_free0 (depstring);
									break;
								}
								depends_list = alpm_list_next (depends_list);
								_alpm_list_free0 (list);
								_g_free0 (depstring);
							}
							pkgs_to_add = alpm_list_next (pkgs_to_add);
						}
					}
					_tmp286_ = pamac_transaction_summary_get_conflicts_to_remove (*summary);
					_tmp287_ = _tmp286_;
					_tmp288_ = pkg;
					_tmp289_ = _g_object_ref0 ((PamacPackage*) _tmp288_);
					g_ptr_array_add (_tmp287_, _tmp289_);
				}
			}
		}
		pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		_g_object_unref0 (pkg);
	}
	_g_hash_table_unref0 (checked);
}

static void
___lambda5_ (PamacAlpmUtils* self,
             Download* download)
{
	g_return_if_fail (download != NULL);
	download_run (download);
	_g_object_unref0 (download);
}

static void
____lambda5__gfunc (gpointer data,
                    gpointer self)
{
	___lambda5_ ((PamacAlpmUtils*) self, (Download*) data);
}

static void
vala__g_thread_pool_free_wrapper (GThreadPool* pool,
                                  gboolean immediate,
                                  gboolean wait)
{
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		_tmp2_ = ptr;
		g_thread_pool_free ((GThreadPool*) _tmp2_, immediate, wait);
	}
	_g_thread_pool_free0 (pool);
}

static void
pamac_alpm_utils_download_files (PamacAlpmUtils* self,
                                 alpm_handle_t* handle,
                                 guint64 max_parallel_downloads,
                                 gboolean emit_signals)
{
	GPtrArray* to_download = NULL;
	GPtrArray* _tmp0_;
	alpm_list_t* pkgs_to_add = NULL;
	alpm_list_t* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	self->total_download = (guint64) 0;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	to_download = _tmp0_;
	_tmp1_ = alpm_trans_get_add (handle);
	pkgs_to_add = _tmp1_;
	while (TRUE) {
		alpm_list_t* _tmp2_;
		alpm_pkg_t* trans_pkg = NULL;
		alpm_list_t* _tmp3_;
		gconstpointer _tmp4_;
		guint64 download_size = 0ULL;
		alpm_pkg_t* _tmp5_;
		guint64 _tmp6_;
		guint64 _tmp7_;
		_tmp2_ = pkgs_to_add;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = pkgs_to_add;
		_tmp4_ = _tmp3_->data;
		trans_pkg = (alpm_pkg_t*) _tmp4_;
		_tmp5_ = trans_pkg;
		_tmp6_ = alpm_pkg_download_size (_tmp5_);
		_tmp7_ = _tmp6_;
		download_size = _tmp7_;
		if (download_size > ((guint64) 0)) {
			alpm_pkg_t* _tmp8_;
			guint64 _tmp9_;
			guint64 _tmp10_;
			GPtrArray* _tmp11_;
			alpm_pkg_t* _tmp12_;
			_tmp8_ = trans_pkg;
			_tmp9_ = alpm_pkg_download_size (_tmp8_);
			_tmp10_ = _tmp9_;
			self->total_download = self->total_download + _tmp10_;
			_tmp11_ = to_download;
			_tmp12_ = trans_pkg;
			g_ptr_array_add (_tmp11_, _tmp12_);
		}
		pkgs_to_add = alpm_list_next (pkgs_to_add);
	}
	if (self->total_download == ((guint64) 0)) {
		_g_ptr_array_unref0 (to_download);
		return;
	}
	if (emit_signals) {
		GPtrArray* _tmp13_;
		GPtrArray* _tmp14_;
		gchar* _tmp15_;
		pamac_alpm_utils_emit_totaldownload (self, self->total_download);
		_tmp13_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_tmp14_ = _tmp13_;
		pamac_alpm_utils_emit_event (self, (guint) ALPM_EVENT_PKG_RETRIEVE_START, (guint) 0, _tmp14_);
		_g_ptr_array_unref0 (_tmp14_);
		_tmp15_ = g_strdup ("");
		_g_free0 (self->current_filename);
		self->current_filename = _tmp15_;
	}
	{
		GThreadPool* dload_thread_pool = NULL;
		GThreadPool* _tmp16_;
		const gchar* cachedir = NULL;
		alpm_list_t* _tmp17_;
		alpm_list_t* _tmp18_;
		alpm_list_t* _tmp19_;
		gconstpointer _tmp20_;
		GPtrArray* _tmp21_;
		GThreadPool* _tmp26_;
		_tmp16_ = g_thread_pool_new (____lambda5__gfunc, self, (gint) max_parallel_downloads, TRUE, &_inner_error0_);
		dload_thread_pool = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			_g_ptr_array_unref0 (to_download);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp17_ = alpm_option_get_cachedirs (handle);
		_tmp18_ = _tmp17_;
		_tmp19_ = alpm_list_nth (_tmp18_, (gsize) 0);
		_tmp20_ = _tmp19_->data;
		cachedir = (const gchar*) _tmp20_;
		_tmp21_ = to_download;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp21_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				alpm_pkg_t* pkg = NULL;
				pkg = (alpm_pkg_t*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					GThreadPool* _tmp22_;
					const gchar* _tmp23_;
					alpm_pkg_t* _tmp24_;
					Download* _tmp25_;
					_tmp22_ = dload_thread_pool;
					_tmp23_ = cachedir;
					_tmp24_ = pkg;
					_tmp25_ = download_new (self, _tmp23_, _tmp24_, emit_signals);
					g_thread_pool_push (_tmp22_, _tmp25_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_thread_pool_free0 (dload_thread_pool);
						if (_inner_error0_->domain == G_THREAD_ERROR) {
							goto __catch0_g_thread_error;
						}
						_g_ptr_array_unref0 (to_download);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
		_tmp26_ = dload_thread_pool;
		dload_thread_pool = NULL;
		vala__g_thread_pool_free_wrapper (_tmp26_, FALSE, TRUE);
		_g_thread_pool_free0 (dload_thread_pool);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_warning ("alpm_utils.vala:1788: %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (to_download);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (emit_signals) {
		GPtrArray* _tmp29_;
		GPtrArray* _tmp30_;
		_tmp29_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_tmp30_ = _tmp29_;
		pamac_alpm_utils_emit_event (self, (guint) ALPM_EVENT_PKG_RETRIEVE_DONE, (guint) 0, _tmp30_);
		_g_ptr_array_unref0 (_tmp30_);
	}
	_g_ptr_array_unref0 (to_download);
}

static gboolean
pamac_alpm_utils_need_reboot (PamacAlpmUtils* self,
                              alpm_handle_t* alpm_handle)
{
	gboolean reboot_needed = FALSE;
	gchar** prefix = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint prefix_length1;
	gint _prefix_size_;
	gchar** contains = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint contains_length1;
	gint _contains_size_;
	gchar** full = NULL;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint full_length1;
	gint _full_size_;
	gchar** suffix = NULL;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint suffix_length1;
	gint _suffix_size_;
	alpm_list_t* to_add = NULL;
	alpm_list_t* _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	reboot_needed = FALSE;
	_tmp0_ = g_strdup ("linux-");
	_tmp1_ = g_strdup ("linux4");
	_tmp2_ = g_strdup ("linux5");
	_tmp3_ = g_strdup ("linux6");
	_tmp4_ = g_strdup ("nvidia-");
	_tmp5_ = g_strdup ("lib32-nvidia-");
	_tmp6_ = g_strdup ("systemd");
	_tmp7_ = g_strdup ("xf86-");
	_tmp8_ = g_strdup ("xorg-");
	_tmp9_ = g_new0 (gchar*, 9 + 1);
	_tmp9_[0] = _tmp0_;
	_tmp9_[1] = _tmp1_;
	_tmp9_[2] = _tmp2_;
	_tmp9_[3] = _tmp3_;
	_tmp9_[4] = _tmp4_;
	_tmp9_[5] = _tmp5_;
	_tmp9_[6] = _tmp6_;
	_tmp9_[7] = _tmp7_;
	_tmp9_[8] = _tmp8_;
	prefix = _tmp9_;
	prefix_length1 = 9;
	_prefix_size_ = prefix_length1;
	_tmp10_ = g_strdup ("mesa");
	_tmp11_ = g_strdup ("wayland");
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	contains = _tmp12_;
	contains_length1 = 2;
	_contains_size_ = contains_length1;
	_tmp13_ = g_strdup ("cryptsetup");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	full = _tmp14_;
	full_length1 = 1;
	_full_size_ = full_length1;
	_tmp15_ = g_strdup ("-ucode");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	suffix = _tmp16_;
	suffix_length1 = 1;
	_suffix_size_ = suffix_length1;
	_tmp17_ = alpm_trans_get_add (alpm_handle);
	to_add = _tmp17_;
	while (TRUE) {
		alpm_list_t* _tmp18_;
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp19_;
		gconstpointer _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp31_;
		gint _tmp31__length1;
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp18_ = to_add;
		if (!(_tmp18_ != NULL)) {
			break;
		}
		_tmp19_ = to_add;
		_tmp20_ = _tmp19_->data;
		pkg = (alpm_pkg_t*) _tmp20_;
		_tmp21_ = prefix;
		_tmp21__length1 = prefix_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp21_;
			str_collection_length1 = _tmp21__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp22_ = pkg;
					_tmp23_ = alpm_pkg_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = str;
					if (g_str_has_prefix (_tmp24_, _tmp25_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp26_ = contains;
		_tmp26__length1 = contains_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp26_;
			str_collection_length1 = _tmp26__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp27_ = pkg;
					_tmp28_ = alpm_pkg_get_name (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = str;
					if (string_contains (_tmp29_, _tmp30_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp31_ = full;
		_tmp31__length1 = full_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp31_;
			str_collection_length1 = _tmp31__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					const gchar* _tmp32_;
					alpm_pkg_t* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					_tmp32_ = str;
					_tmp33_ = pkg;
					_tmp34_ = alpm_pkg_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					if (g_strcmp0 (_tmp32_, _tmp35_) == 0) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp36_ = suffix;
		_tmp36__length1 = suffix_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp36_;
			str_collection_length1 = _tmp36__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp37_ = pkg;
					_tmp38_ = alpm_pkg_get_name (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = str;
					if (g_str_has_suffix (_tmp39_, _tmp40_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		to_add = alpm_list_next (to_add);
	}
	result = reboot_needed;
	suffix = (_vala_array_free (suffix, suffix_length1, (GDestroyNotify) g_free), NULL);
	full = (_vala_array_free (full, full_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
	prefix = (_vala_array_free (prefix, prefix_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		PamacAlpmUtils* self;
		self = _data58_->self;
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gboolean
___lambda6_ (Block58Data* _data58_,
             const gchar* pkgname,
             const gchar* val)
{
	PamacAlpmUtils* self;
	alpm_pkg_t* pkg = NULL;
	alpm_db_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	self = _data58_->self;
	g_return_val_if_fail (pkgname != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = alpm_get_localdb (_data58_->alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_db_get_pkg (_tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ != NULL) {
		alpm_pkg_t* _tmp4_;
		_tmp4_ = pkg;
		alpm_pkg_set_reason (_tmp4_, ALPM_PKG_REASON_DEPEND);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda6__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self, (const gchar*) key, (const gchar*) value);
	return result;
}

static gboolean
pamac_alpm_utils_trans_commit (PamacAlpmUtils* self,
                               alpm_handle_t* alpm_handle)
{
	Block58Data* _data58_;
	gboolean need_retry = FALSE;
	gboolean success = FALSE;
	gboolean reboot_needed = FALSE;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp45_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_data58_->alpm_handle = alpm_handle;
	pamac_alpm_utils_add_overwrite_files (self, _data58_->alpm_handle);
	need_retry = FALSE;
	success = FALSE;
	reboot_needed = FALSE;
	_tmp0_ = self->priv->to_syncfirst;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 0)) {
		pamac_alpm_utils_trans_release (self, _data58_->alpm_handle);
		success = pamac_alpm_utils_trans_init (self, _data58_->alpm_handle, self->priv->trans_flags, TRUE);
		if (success) {
			{
				GHashTableIter _name_it = {0};
				GHashTable* _tmp3_;
				GHashTableIter _tmp4_ = {0};
				const gchar* name = NULL;
				_tmp3_ = self->priv->to_syncfirst;
				g_hash_table_iter_init (&_tmp4_, _tmp3_);
				_name_it = _tmp4_;
				while (TRUE) {
					gconstpointer _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = _vala_hash_set_next_value (&_name_it);
					name = (const gchar*) _tmp5_;
					_tmp6_ = name;
					if (!(_tmp6_ != NULL)) {
						break;
					}
					_tmp7_ = name;
					success = pamac_alpm_utils_trans_add_pkg (self, _data58_->alpm_handle, _tmp7_, TRUE);
					if (!success) {
						break;
					}
				}
			}
			if (success) {
				success = pamac_alpm_utils_trans_prepare_real (self, _data58_->alpm_handle, TRUE);
			}
			if (success) {
				gboolean _tmp8_;
				reboot_needed = pamac_alpm_utils_need_reboot (self, _data58_->alpm_handle);
				_tmp8_ = pamac_alpm_utils_trans_commit_real (self, _data58_->alpm_handle, &need_retry);
				success = _tmp8_;
			}
			pamac_alpm_utils_trans_release (self, _data58_->alpm_handle);
			if (success) {
				gboolean _tmp15_ = FALSE;
				{
					GHashTableIter _name_it = {0};
					GHashTable* _tmp9_;
					GHashTableIter _tmp10_ = {0};
					const gchar* name = NULL;
					_tmp9_ = self->priv->to_syncfirst;
					g_hash_table_iter_init (&_tmp10_, _tmp9_);
					_name_it = _tmp10_;
					while (TRUE) {
						gconstpointer _tmp11_;
						const gchar* _tmp12_;
						GHashTable* _tmp13_;
						const gchar* _tmp14_;
						_tmp11_ = _vala_hash_set_next_value (&_name_it);
						name = (const gchar*) _tmp11_;
						_tmp12_ = name;
						if (!(_tmp12_ != NULL)) {
							break;
						}
						_tmp13_ = self->priv->to_install;
						_tmp14_ = name;
						g_hash_table_remove (_tmp13_, _tmp14_);
					}
				}
				success = pamac_alpm_utils_trans_init (self, _data58_->alpm_handle, self->priv->trans_flags, TRUE);
				if (success) {
					_tmp15_ = self->priv->sysupgrade;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					success = pamac_alpm_utils_trans_sysupgrade (self, _data58_->alpm_handle, TRUE);
				}
				if (success) {
					{
						GHashTableIter _name_it = {0};
						GHashTable* _tmp16_;
						GHashTableIter _tmp17_ = {0};
						const gchar* name = NULL;
						_tmp16_ = self->priv->to_install;
						g_hash_table_iter_init (&_tmp17_, _tmp16_);
						_name_it = _tmp17_;
						while (TRUE) {
							gconstpointer _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							_tmp18_ = _vala_hash_set_next_value (&_name_it);
							name = (const gchar*) _tmp18_;
							_tmp19_ = name;
							if (!(_tmp19_ != NULL)) {
								break;
							}
							_tmp20_ = name;
							success = pamac_alpm_utils_trans_add_pkg (self, _data58_->alpm_handle, _tmp20_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _name_it = {0};
						GHashTable* _tmp21_;
						GHashTableIter _tmp22_ = {0};
						const gchar* name = NULL;
						_tmp21_ = self->priv->to_remove;
						g_hash_table_iter_init (&_tmp22_, _tmp21_);
						_name_it = _tmp22_;
						while (TRUE) {
							gconstpointer _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							_tmp23_ = _vala_hash_set_next_value (&_name_it);
							name = (const gchar*) _tmp23_;
							_tmp24_ = name;
							if (!(_tmp24_ != NULL)) {
								break;
							}
							_tmp25_ = name;
							success = pamac_alpm_utils_trans_remove_pkg (self, _data58_->alpm_handle, _tmp25_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _path_it = {0};
						GHashTable* _tmp26_;
						GHashTableIter _tmp27_ = {0};
						const gchar* path = NULL;
						_tmp26_ = self->priv->local_paths;
						g_hash_table_iter_init (&_tmp27_, _tmp26_);
						_path_it = _tmp27_;
						while (TRUE) {
							gconstpointer _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							_tmp28_ = _vala_hash_set_next_value (&_path_it);
							path = (const gchar*) _tmp28_;
							_tmp29_ = path;
							if (!(_tmp29_ != NULL)) {
								break;
							}
							_tmp30_ = path;
							_tmp31_ = alpm_option_get_local_file_siglevel (_data58_->alpm_handle);
							_tmp32_ = _tmp31_;
							success = pamac_alpm_utils_trans_load_pkg (self, _data58_->alpm_handle, _tmp30_, _tmp32_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _path_it = {0};
						GHashTable* _tmp33_;
						GHashTableIter _tmp34_ = {0};
						const gchar* path = NULL;
						_tmp33_ = self->priv->remote_paths;
						g_hash_table_iter_init (&_tmp34_, _tmp33_);
						_path_it = _tmp34_;
						while (TRUE) {
							gconstpointer _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gint _tmp38_;
							gint _tmp39_;
							_tmp35_ = _vala_hash_set_next_value (&_path_it);
							path = (const gchar*) _tmp35_;
							_tmp36_ = path;
							if (!(_tmp36_ != NULL)) {
								break;
							}
							_tmp37_ = path;
							_tmp38_ = alpm_option_get_remote_file_siglevel (_data58_->alpm_handle);
							_tmp39_ = _tmp38_;
							success = pamac_alpm_utils_trans_load_pkg (self, _data58_->alpm_handle, _tmp37_, _tmp39_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					gboolean _tmp40_ = FALSE;
					gboolean _tmp41_ = FALSE;
					success = pamac_alpm_utils_trans_prepare_real (self, _data58_->alpm_handle, TRUE);
					if (success) {
						alpm_list_t* _tmp42_;
						_tmp42_ = alpm_trans_get_add (_data58_->alpm_handle);
						_tmp41_ = _tmp42_ == NULL;
					} else {
						_tmp41_ = FALSE;
					}
					if (_tmp41_) {
						alpm_list_t* _tmp43_;
						_tmp43_ = alpm_trans_get_remove (_data58_->alpm_handle);
						_tmp40_ = _tmp43_ == NULL;
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						pamac_alpm_utils_trans_release (self, _data58_->alpm_handle);
						pamac_alpm_utils_trans_reset (self);
						result = TRUE;
						block58_data_unref (_data58_);
						_data58_ = NULL;
						return result;
					}
				}
				if (!success) {
					pamac_alpm_utils_trans_release (self, _data58_->alpm_handle);
				}
			} else {
				if (need_retry) {
					if (((gint) self->priv->commit_retries) < 1) {
						guint8 _tmp44_;
						_tmp44_ = self->priv->commit_retries;
						self->priv->commit_retries = _tmp44_ + 1;
						success = pamac_alpm_utils_trans_run_real (self, _data58_->alpm_handle);
					}
				}
			}
		}
		if (!success) {
			pamac_alpm_utils_trans_reset (self);
			result = FALSE;
			block58_data_unref (_data58_);
			_data58_ = NULL;
			return result;
		}
	}
	if (!reboot_needed) {
		reboot_needed = pamac_alpm_utils_need_reboot (self, _data58_->alpm_handle);
	}
	_tmp45_ = pamac_alpm_utils_trans_commit_real (self, _data58_->alpm_handle, &need_retry);
	success = _tmp45_;
	if (success) {
		GHashTable* _tmp77_;
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp46_;
			GHashTableIter _tmp47_ = {0};
			const gchar* path = NULL;
			_tmp46_ = self->priv->local_paths;
			g_hash_table_iter_init (&_tmp47_, _tmp46_);
			_path_it = _tmp47_;
			while (TRUE) {
				gconstpointer _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_ = FALSE;
				const gchar* _tmp52_;
				_tmp48_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp48_;
				_tmp49_ = path;
				if (!(_tmp49_ != NULL)) {
					break;
				}
				_tmp52_ = path;
				if (g_str_has_prefix (_tmp52_, "/var/tmp/pamac-build")) {
					_tmp51_ = TRUE;
				} else {
					const gchar* _tmp53_;
					_tmp53_ = path;
					_tmp51_ = g_str_has_prefix (_tmp53_, "/tmp/pamac-build");
				}
				if (_tmp51_) {
					_tmp50_ = TRUE;
				} else {
					const gchar* _tmp54_;
					PamacConfig* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp54_ = path;
					_tmp55_ = self->priv->config;
					_tmp56_ = pamac_config_get_aur_build_dir (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp50_ = g_str_has_prefix (_tmp54_, _tmp57_);
				}
				if (_tmp50_) {
					if (self->priv->keep_built_pkgs) {
						alpm_list_t* cachedirs = NULL;
						alpm_list_t* _tmp58_;
						alpm_list_t* _tmp59_;
						const gchar* cachedir = NULL;
						alpm_list_t* _tmp60_;
						gconstpointer _tmp61_;
						_tmp58_ = alpm_option_get_cachedirs (_data58_->alpm_handle);
						_tmp59_ = _tmp58_;
						cachedirs = _tmp59_;
						_tmp60_ = cachedirs;
						_tmp61_ = _tmp60_->data;
						cachedir = (const gchar*) _tmp61_;
						{
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							_tmp62_ = path;
							_tmp63_ = cachedir;
							_tmp64_ = g_strdup_printf ("mv -f %s %s", _tmp62_, _tmp63_);
							_tmp65_ = _tmp64_;
							g_spawn_command_line_sync (_tmp65_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp65_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp66_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch0_g_spawn_error;
								}
								block58_data_unref (_data58_);
								_data58_ = NULL;
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp66_;
							}
						}
						goto __finally0;
						__catch0_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp67_;
							const gchar* _tmp68_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp67_ = e;
							_tmp68_ = _tmp67_->message;
							g_warning ("alpm_utils.vala:1956: %s", _tmp68_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp69_ = FALSE;
							block58_data_unref (_data58_);
							_data58_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp69_;
						}
					} else {
						{
							const gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							_tmp70_ = path;
							_tmp71_ = g_strdup_printf ("rm -f %s", _tmp70_);
							_tmp72_ = _tmp71_;
							g_spawn_command_line_sync (_tmp72_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp72_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp73_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch1_g_spawn_error;
								}
								block58_data_unref (_data58_);
								_data58_ = NULL;
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp73_;
							}
						}
						goto __finally1;
						__catch1_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp74_;
							const gchar* _tmp75_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp74_ = e;
							_tmp75_ = _tmp74_->message;
							g_warning ("alpm_utils.vala:1963: %s", _tmp75_);
							_g_error_free0 (e);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp76_ = FALSE;
							block58_data_unref (_data58_);
							_data58_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp76_;
						}
					}
				}
			}
		}
		_tmp77_ = self->priv->to_install_as_dep;
		g_hash_table_foreach_remove (_tmp77_, ____lambda6__ghr_func, _data58_);
		if (reboot_needed) {
			gchar* _tmp78_;
			gchar* _tmp79_;
			_tmp78_ = g_strconcat (g_dgettext (NULL, "A restart is required for the changes to take effect"), ".", NULL);
			_tmp79_ = _tmp78_;
			pamac_alpm_utils_do_emit_warning (self, _tmp79_);
			_g_free0 (_tmp79_);
		}
		if (self->priv->sysupgrade) {
			{
				g_spawn_command_line_sync ("rm -f /system-update", NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp80_ = FALSE;
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch2_g_spawn_error;
					}
					block58_data_unref (_data58_);
					_data58_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp80_;
				}
			}
			goto __finally2;
			__catch2_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp81_;
				const gchar* _tmp82_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp81_ = e;
				_tmp82_ = _tmp81_->message;
				g_warning ("alpm_utils.vala:1984: %s", _tmp82_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp83_ = FALSE;
				block58_data_unref (_data58_);
				_data58_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp83_;
			}
		}
	} else {
		if (need_retry) {
			if (((gint) self->priv->commit_retries) < 1) {
				guint8 _tmp84_;
				_tmp84_ = self->priv->commit_retries;
				self->priv->commit_retries = _tmp84_ + 1;
				success = pamac_alpm_utils_trans_run_real (self, _data58_->alpm_handle);
			}
		}
	}
	pamac_alpm_utils_trans_reset (self);
	result = success;
	block58_data_unref (_data58_);
	_data58_ = NULL;
	return result;
}

static gchar*
pamac_alpm_utils_backup_conflict_file (PamacAlpmUtils* self,
                                       const gchar* file_path)
{
	GString* backup_file_path = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GFile* backup_file = NULL;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_string_new (file_path);
	backup_file_path = _tmp0_;
	_tmp1_ = backup_file_path;
	g_string_append (_tmp1_, ".old");
	_tmp2_ = backup_file_path;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	backup_file = _tmp4_;
	_tmp5_ = backup_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint _tmp8_;
				GString* new_backup_file_path = NULL;
				GString* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp11_;
				GString* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GString* _tmp15_;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				if (!_tmp6_) {
					GFile* _tmp7_;
					_tmp7_ = backup_file;
					if (!g_file_query_exists (_tmp7_, NULL)) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = backup_file_path;
				_tmp10_ = _tmp9_->str;
				_tmp11_ = g_string_new (_tmp10_);
				new_backup_file_path = _tmp11_;
				_tmp12_ = new_backup_file_path;
				_tmp13_ = g_strdup_printf ("%u", i);
				_tmp14_ = _tmp13_;
				g_string_append (_tmp12_, _tmp14_);
				_g_free0 (_tmp14_);
				_tmp15_ = new_backup_file_path;
				_tmp16_ = _tmp15_->str;
				_tmp17_ = g_file_new_for_path (_tmp16_);
				_g_object_unref0 (backup_file);
				backup_file = _tmp17_;
				_g_string_free0 (new_backup_file_path);
			}
		}
	}
	{
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GFile* _tmp23_;
		gchar* _tmp24_;
		_tmp18_ = backup_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("mv -f %s %s", file_path, _tmp20_);
		_tmp22_ = _tmp21_;
		g_spawn_command_line_sync (_tmp22_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_object_unref0 (backup_file);
			_g_string_free0 (backup_file_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp23_ = backup_file;
		_tmp24_ = g_file_get_path (_tmp23_);
		result = _tmp24_;
		_g_object_unref0 (backup_file);
		_g_string_free0 (backup_file_path);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("alpm_utils.vala:2016: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (backup_file);
		_g_string_free0 (backup_file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (backup_file);
	_g_string_free0 (backup_file_path);
	return result;
}

static gboolean
pamac_alpm_utils_trans_commit_real (PamacAlpmUtils* self,
                                    alpm_handle_t* alpm_handle,
                                    gboolean* need_retry)
{
	gboolean success = FALSE;
	PamacConfig* _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	alpm_list_t* err_data = NULL;
	alpm_list_t* _tmp9_ = NULL;
	gint _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	_tmp0_ = self->priv->config;
	_tmp1_ = pamac_config_get_max_parallel_downloads (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ >= ((guint64) 2)) {
		PamacConfig* _tmp3_;
		guint64 _tmp4_;
		guint64 _tmp5_;
		GCancellable* _tmp6_;
		_tmp3_ = self->priv->config;
		_tmp4_ = pamac_config_get_max_parallel_downloads (_tmp3_);
		_tmp5_ = _tmp4_;
		pamac_alpm_utils_download_files (self, alpm_handle, _tmp5_, TRUE);
		_tmp6_ = self->cancellable;
		if (g_cancellable_is_cancelled (_tmp6_)) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			pamac_alpm_utils_trans_release (self, alpm_handle);
			pamac_alpm_utils_do_emit_script_output (self, "");
			_tmp7_ = g_strconcat (g_dgettext (NULL, "Transaction cancelled"), ".", NULL);
			_tmp8_ = _tmp7_;
			pamac_alpm_utils_do_emit_action (self, _tmp8_);
			_g_free0 (_tmp8_);
			result = FALSE;
			return result;
		}
	}
	_tmp10_ = alpm_trans_commit (alpm_handle, &_tmp9_);
	_alpm_list_free0 (err_data);
	err_data = _tmp9_;
	if (_tmp10_ == -1) {
		alpm_errno_t err_no = 0;
		gboolean _tmp11_ = FALSE;
		GPtrArray* details = NULL;
		GPtrArray* _tmp15_;
		err_no = alpm_errno (alpm_handle);
		if (err_no == ALPM_ERR_EXTERNAL_DOWNLOAD) {
			GCancellable* _tmp12_;
			_tmp12_ = self->cancellable;
			_tmp11_ = g_cancellable_is_cancelled (_tmp12_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			pamac_alpm_utils_trans_release (self, alpm_handle);
			pamac_alpm_utils_do_emit_script_output (self, "");
			_tmp13_ = g_strconcat (g_dgettext (NULL, "Transaction cancelled"), ".", NULL);
			_tmp14_ = _tmp13_;
			pamac_alpm_utils_do_emit_action (self, _tmp14_);
			_g_free0 (_tmp14_);
			result = FALSE;
			_alpm_list_free0 (err_data);
			return result;
		}
		*need_retry = FALSE;
		_tmp15_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp15_;
		switch (err_no) {
			case 0:
			{
				break;
			}
			case ALPM_ERR_FILE_CONFLICTS:
			{
				GPtrArray* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp19_;
				_tmp16_ = details;
				_tmp17_ = alpm_strerror (err_no);
				_tmp18_ = g_strconcat (_tmp17_, ":", NULL);
				g_ptr_array_add (_tmp16_, _tmp18_);
				_tmp19_ = err_data;
				list = _tmp19_;
				while (TRUE) {
					alpm_list_t* _tmp20_;
					alpm_fileconflict_t* conflict = NULL;
					alpm_list_t* _tmp21_;
					gconstpointer _tmp22_;
					alpm_fileconflict_t* _tmp23_;
					alpm_fileconflict_t* _tmp89_;
					_tmp20_ = list;
					if (!(_tmp20_ != NULL)) {
						break;
					}
					_tmp21_ = list;
					_tmp22_ = _tmp21_->data;
					conflict = _tmp22_;
					_tmp23_ = conflict;
					switch (_tmp23_->type) {
						case ALPM_FILECONFLICT_TARGET:
						{
							GPtrArray* _tmp24_;
							alpm_fileconflict_t* _tmp25_;
							const gchar* _tmp26_;
							alpm_fileconflict_t* _tmp27_;
							const gchar* _tmp28_;
							alpm_fileconflict_t* _tmp29_;
							const gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp24_ = details;
							_tmp25_ = conflict;
							_tmp26_ = _tmp25_->file;
							_tmp27_ = conflict;
							_tmp28_ = _tmp27_->target;
							_tmp29_ = conflict;
							_tmp30_ = _tmp29_->ctarget;
							_tmp31_ = g_strdup_printf (_ ("%1$s exists in both %2$s and %3$s"), _tmp26_, _tmp28_, _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_strconcat ("- ", _tmp32_, NULL);
							g_ptr_array_add (_tmp24_, _tmp33_);
							_g_free0 (_tmp32_);
							break;
						}
						case ALPM_FILECONFLICT_FILESYSTEM:
						{
							alpm_fileconflict_t* _tmp34_;
							const gchar* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							_tmp34_ = conflict;
							_tmp35_ = _tmp34_->ctarget;
							_tmp36_ = strlen (_tmp35_);
							_tmp37_ = _tmp36_;
							if (_tmp37_ > 0) {
								GPtrArray* _tmp38_;
								alpm_fileconflict_t* _tmp39_;
								const gchar* _tmp40_;
								alpm_fileconflict_t* _tmp41_;
								const gchar* _tmp42_;
								alpm_fileconflict_t* _tmp43_;
								const gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								_tmp38_ = details;
								_tmp39_ = conflict;
								_tmp40_ = _tmp39_->target;
								_tmp41_ = conflict;
								_tmp42_ = _tmp41_->file;
								_tmp43_ = conflict;
								_tmp44_ = _tmp43_->ctarget;
								_tmp45_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem (owned by %3$s)"), _tmp40_, _tmp42_, _tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat ("- ", _tmp46_, NULL);
								g_ptr_array_add (_tmp38_, _tmp47_);
								_g_free0 (_tmp46_);
							} else {
								if (((gint) self->priv->commit_retries) < 1) {
									gchar* backup_path = NULL;
									alpm_fileconflict_t* _tmp48_;
									const gchar* _tmp49_;
									gchar* _tmp50_;
									const gchar* _tmp51_;
									_tmp48_ = conflict;
									_tmp49_ = _tmp48_->file;
									_tmp50_ = pamac_alpm_utils_backup_conflict_file (self, _tmp49_);
									backup_path = _tmp50_;
									_tmp51_ = backup_path;
									if (_tmp51_ == NULL) {
										GPtrArray* _tmp52_;
										alpm_fileconflict_t* _tmp53_;
										const gchar* _tmp54_;
										alpm_fileconflict_t* _tmp55_;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										gchar* _tmp59_;
										gchar* _tmp60_;
										gchar* _tmp61_;
										GPtrArray* _tmp62_;
										gchar* _tmp63_;
										_tmp52_ = details;
										_tmp53_ = conflict;
										_tmp54_ = _tmp53_->target;
										_tmp55_ = conflict;
										_tmp56_ = _tmp55_->file;
										_tmp57_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp54_, _tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_strconcat ("- ", _tmp58_, NULL);
										_tmp60_ = _tmp59_;
										_tmp61_ = g_strconcat (_tmp60_, ",", NULL);
										g_ptr_array_add (_tmp52_, _tmp61_);
										_g_free0 (_tmp60_);
										_g_free0 (_tmp58_);
										_tmp62_ = details;
										_tmp63_ = g_strconcat ("  ", _ ("if this file is not needed, remove it and retry"), NULL);
										g_ptr_array_add (_tmp62_, _tmp63_);
									} else {
										gchar* _tmp64_;
										gchar* _tmp65_;
										alpm_fileconflict_t* _tmp66_;
										const gchar* _tmp67_;
										alpm_fileconflict_t* _tmp68_;
										const gchar* _tmp69_;
										gchar* _tmp70_;
										gchar* _tmp71_;
										gchar* _tmp72_;
										gchar* _tmp73_;
										const gchar* _tmp74_;
										gchar* _tmp75_;
										gchar* _tmp76_;
										_tmp64_ = g_strconcat (_ ("Warning"), ": ", NULL);
										_tmp65_ = _tmp64_;
										_tmp66_ = conflict;
										_tmp67_ = _tmp66_->target;
										_tmp68_ = conflict;
										_tmp69_ = _tmp68_->file;
										_tmp70_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp67_, _tmp69_);
										_tmp71_ = _tmp70_;
										_tmp72_ = g_strconcat (_tmp65_, _tmp71_, NULL);
										_tmp73_ = _tmp72_;
										pamac_alpm_utils_do_emit_warning (self, _tmp73_);
										_g_free0 (_tmp73_);
										_g_free0 (_tmp71_);
										_g_free0 (_tmp65_);
										_tmp74_ = backup_path;
										_tmp75_ = g_strdup_printf (_ ("It has been backed up to %s"), _tmp74_);
										_tmp76_ = _tmp75_;
										pamac_alpm_utils_do_emit_warning (self, _tmp76_);
										_g_free0 (_tmp76_);
										*need_retry = TRUE;
									}
									_g_free0 (backup_path);
								} else {
									GPtrArray* _tmp77_;
									alpm_fileconflict_t* _tmp78_;
									const gchar* _tmp79_;
									alpm_fileconflict_t* _tmp80_;
									const gchar* _tmp81_;
									gchar* _tmp82_;
									gchar* _tmp83_;
									gchar* _tmp84_;
									gchar* _tmp85_;
									gchar* _tmp86_;
									GPtrArray* _tmp87_;
									gchar* _tmp88_;
									_tmp77_ = details;
									_tmp78_ = conflict;
									_tmp79_ = _tmp78_->target;
									_tmp80_ = conflict;
									_tmp81_ = _tmp80_->file;
									_tmp82_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp79_, _tmp81_);
									_tmp83_ = _tmp82_;
									_tmp84_ = g_strconcat ("- ", _tmp83_, NULL);
									_tmp85_ = _tmp84_;
									_tmp86_ = g_strconcat (_tmp85_, ",", NULL);
									g_ptr_array_add (_tmp77_, _tmp86_);
									_g_free0 (_tmp85_);
									_g_free0 (_tmp83_);
									_tmp87_ = details;
									_tmp88_ = g_strconcat ("  ", _ ("if this file is not needed, remove it and retry"), NULL);
									g_ptr_array_add (_tmp87_, _tmp88_);
								}
							}
							break;
						}
						default:
						break;
					}
					_tmp89_ = conflict;
					_alpm_fileconflict_free0 (_tmp89_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_PKG_INVALID_CHECKSUM:
			{
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp90_;
				_tmp90_ = err_data;
				list = _tmp90_;
				if (((gint) self->priv->commit_retries) < 1) {
					gchar* _tmp91_;
					gchar* _tmp92_;
					_tmp91_ = g_strconcat (_ ("Removing invalid files and retrying"), "...", NULL);
					_tmp92_ = _tmp91_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp92_);
					_g_free0 (_tmp92_);
					*need_retry = TRUE;
				} else {
					GPtrArray* _tmp93_;
					const gchar* _tmp94_;
					gchar* _tmp95_;
					_tmp93_ = details;
					_tmp94_ = alpm_strerror (err_no);
					_tmp95_ = g_strconcat (_tmp94_, ":", NULL);
					g_ptr_array_add (_tmp93_, _tmp95_);
				}
				while (TRUE) {
					alpm_list_t* _tmp96_;
					const gchar* filename = NULL;
					alpm_list_t* _tmp97_;
					gconstpointer _tmp98_;
					const gchar* _tmp108_;
					_tmp96_ = list;
					if (!(_tmp96_ != NULL)) {
						break;
					}
					_tmp97_ = list;
					_tmp98_ = _tmp97_->data;
					filename = _tmp98_;
					if (!(*need_retry)) {
						GPtrArray* _tmp99_;
						const gchar* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						GPtrArray* _tmp106_;
						gchar* _tmp107_;
						_tmp99_ = details;
						_tmp100_ = filename;
						_tmp101_ = g_strdup_printf (_ ("%s is invalid or corrupted"), _tmp100_);
						_tmp102_ = _tmp101_;
						_tmp103_ = g_strconcat ("- ", _tmp102_, NULL);
						_tmp104_ = _tmp103_;
						_tmp105_ = g_strconcat (_tmp104_, ",", NULL);
						g_ptr_array_add (_tmp99_, _tmp105_);
						_g_free0 (_tmp104_);
						_g_free0 (_tmp102_);
						_tmp106_ = details;
						_tmp107_ = g_strconcat ("- ", _ ("you can remove this file and retry"), NULL);
						g_ptr_array_add (_tmp106_, _tmp107_);
					}
					_tmp108_ = filename;
					_g_free0 (_tmp108_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_PKG_INVALID:
			case ALPM_ERR_PKG_INVALID_SIG:
			{
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp114_;
				if (((gint) self->priv->commit_retries) < 1) {
					gchar* _tmp109_;
					gchar* _tmp110_;
					_tmp109_ = g_strconcat (_ ("Removing invalid files and retrying"), "...", NULL);
					_tmp110_ = _tmp109_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp110_);
					_g_free0 (_tmp110_);
					*need_retry = TRUE;
				} else {
					GPtrArray* _tmp111_;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					_tmp111_ = details;
					_tmp112_ = alpm_strerror (err_no);
					_tmp113_ = g_strconcat (_tmp112_, ":", NULL);
					g_ptr_array_add (_tmp111_, _tmp113_);
				}
				_tmp114_ = err_data;
				list = _tmp114_;
				while (TRUE) {
					alpm_list_t* _tmp115_;
					const gchar* filename = NULL;
					alpm_list_t* _tmp116_;
					gconstpointer _tmp117_;
					const gchar* _tmp134_;
					_tmp115_ = list;
					if (!(_tmp115_ != NULL)) {
						break;
					}
					_tmp116_ = list;
					_tmp117_ = _tmp116_->data;
					filename = _tmp117_;
					if (!(*need_retry)) {
						GPtrArray* _tmp118_;
						const gchar* _tmp119_;
						gchar* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						GPtrArray* _tmp125_;
						gchar* _tmp126_;
						_tmp118_ = details;
						_tmp119_ = filename;
						_tmp120_ = g_strdup_printf (_ ("%s is invalid or corrupted"), _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = g_strconcat ("- ", _tmp121_, NULL);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_strconcat (_tmp123_, ",", NULL);
						g_ptr_array_add (_tmp118_, _tmp124_);
						_g_free0 (_tmp123_);
						_g_free0 (_tmp121_);
						_tmp125_ = details;
						_tmp126_ = g_strconcat ("  ", _ ("you can remove this file and retry"), NULL);
						g_ptr_array_add (_tmp125_, _tmp126_);
					} else {
						{
							const gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							_tmp127_ = filename;
							_tmp128_ = g_strdup_printf ("rm -f %s", _tmp127_);
							_tmp129_ = _tmp128_;
							g_spawn_command_line_sync (_tmp129_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp129_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp130_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch0_g_spawn_error;
								}
								_g_ptr_array_unref0 (details);
								_alpm_list_free0 (err_data);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp130_;
							}
						}
						goto __finally0;
						__catch0_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp131_;
							const gchar* _tmp132_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp131_ = e;
							_tmp132_ = _tmp131_->message;
							g_warning ("alpm_utils.vala:2121: %s", _tmp132_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp133_ = FALSE;
							_g_ptr_array_unref0 (details);
							_alpm_list_free0 (err_data);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp133_;
						}
					}
					_tmp134_ = filename;
					_g_free0 (_tmp134_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_EXTERNAL_DOWNLOAD:
			{
				GPtrArray* _tmp135_;
				gchar* _tmp136_;
				_tmp135_ = details;
				_tmp136_ = g_strdup (_ ("failed to retrieve some files"));
				g_ptr_array_add (_tmp135_, _tmp136_);
				break;
			}
			default:
			{
				GPtrArray* _tmp137_;
				const gchar* _tmp138_;
				gchar* _tmp139_;
				_tmp137_ = details;
				_tmp138_ = alpm_strerror (err_no);
				_tmp139_ = g_strdup (_tmp138_);
				g_ptr_array_add (_tmp137_, _tmp139_);
				break;
			}
		}
		success = FALSE;
		if (!(*need_retry)) {
			GPtrArray* _tmp140_;
			_tmp140_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to commit transaction"), _tmp140_);
		}
		_g_ptr_array_unref0 (details);
	}
	pamac_alpm_utils_trans_release (self, alpm_handle);
	result = success;
	_alpm_list_free0 (err_data);
	return result;
}

static void
pamac_alpm_utils_trans_release (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	alpm_trans_release (alpm_handle);
	pamac_alpm_utils_remove_ignorepkgs (self, alpm_handle);
	pamac_alpm_utils_remove_overwrite_files (self, alpm_handle);
}

void
pamac_alpm_utils_trans_cancel (PamacAlpmUtils* self,
                               const gchar* sender)
{
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = self->priv->sender;
	if (g_strcmp0 (sender, _tmp0_) != 0) {
		return;
	}
	_tmp1_ = self->cancellable;
	g_cancellable_cancel (_tmp1_);
	pamac_alpm_utils_trans_reset (self);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static gchar*
pamac_alpm_utils_remove_bash_colors (PamacAlpmUtils* self,
                                     const gchar* msg)
{
	GRegex* regex = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\x1B\\[[0-9;]*[JKmsu]", 0));
	regex = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_regex_replace (regex, msg, (gssize) -1, 0, "", 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = g_strdup (msg);
		result = _tmp4_;
		_g_regex_unref0 (regex);
		return result;
	}
	__finally0:
	_g_regex_unref0 (regex);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
pamac_alpm_utils_emit_event (PamacAlpmUtils* self,
                             guint primary_event,
                             guint secondary_event,
                             GPtrArray* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	switch (primary_event) {
		case 1:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_strconcat (g_dgettext (NULL, "Checking dependencies"), "...", NULL);
			_tmp1_ = _tmp0_;
			pamac_alpm_utils_do_emit_action (self, _tmp1_);
			_g_free0 (_tmp1_);
			break;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strconcat (g_dgettext (NULL, "Checking file conflicts"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp2_;
			break;
		}
		case 5:
		{
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_strconcat (g_dgettext (NULL, "Resolving dependencies"), "...", NULL);
			_tmp4_ = _tmp3_;
			pamac_alpm_utils_do_emit_action (self, _tmp4_);
			_g_free0 (_tmp4_);
			break;
		}
		case 7:
		{
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = g_strconcat (g_dgettext (NULL, "Checking inter-conflicts"), "...", NULL);
			_tmp6_ = _tmp5_;
			pamac_alpm_utils_do_emit_action (self, _tmp6_);
			_g_free0 (_tmp6_);
			break;
		}
		case 11:
		{
			switch (secondary_event) {
				case 1:
				{
					gconstpointer _tmp7_;
					gchar* _tmp8_;
					gconstpointer _tmp9_;
					gconstpointer _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp7_ = g_ptr_array_index (details, (guint) 0);
					_tmp8_ = g_strdup ((const gchar*) _tmp7_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp8_;
					_tmp9_ = g_ptr_array_index (details, (guint) 0);
					_tmp10_ = g_ptr_array_index (details, (guint) 1);
					_tmp11_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp9_, (const gchar*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp14_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp15_;
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					break;
				}
				case 2:
				{
					gconstpointer _tmp16_;
					gchar* _tmp17_;
					gconstpointer _tmp18_;
					gconstpointer _tmp19_;
					gconstpointer _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp16_ = g_ptr_array_index (details, (guint) 0);
					_tmp17_ = g_strdup ((const gchar*) _tmp16_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp17_;
					_tmp18_ = g_ptr_array_index (details, (guint) 0);
					_tmp19_ = g_ptr_array_index (details, (guint) 1);
					_tmp20_ = g_ptr_array_index (details, (guint) 2);
					_tmp21_ = g_strdup_printf ("%s (%s -> %s)", (const gchar*) _tmp18_, (const gchar*) _tmp19_, (const gchar*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf (g_dgettext (NULL, "Upgrading %s"), _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp25_;
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					break;
				}
				case 3:
				{
					gconstpointer _tmp26_;
					gchar* _tmp27_;
					gconstpointer _tmp28_;
					gconstpointer _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp26_ = g_ptr_array_index (details, (guint) 0);
					_tmp27_ = g_strdup ((const gchar*) _tmp26_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp27_;
					_tmp28_ = g_ptr_array_index (details, (guint) 0);
					_tmp29_ = g_ptr_array_index (details, (guint) 1);
					_tmp30_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp28_, (const gchar*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strdup_printf (g_dgettext (NULL, "Reinstalling %s"), _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strconcat (_tmp33_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					break;
				}
				case 4:
				{
					gconstpointer _tmp35_;
					gchar* _tmp36_;
					gconstpointer _tmp37_;
					gconstpointer _tmp38_;
					gconstpointer _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp35_ = g_ptr_array_index (details, (guint) 0);
					_tmp36_ = g_strdup ((const gchar*) _tmp35_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp36_;
					_tmp37_ = g_ptr_array_index (details, (guint) 0);
					_tmp38_ = g_ptr_array_index (details, (guint) 1);
					_tmp39_ = g_ptr_array_index (details, (guint) 2);
					_tmp40_ = g_strdup_printf ("%s (%s -> %s)", (const gchar*) _tmp37_, (const gchar*) _tmp38_, (const gchar*) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_strdup_printf (g_dgettext (NULL, "Downgrading %s"), _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strconcat (_tmp43_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp44_;
					_g_free0 (_tmp43_);
					_g_free0 (_tmp41_);
					break;
				}
				case 5:
				{
					gconstpointer _tmp45_;
					gchar* _tmp46_;
					gconstpointer _tmp47_;
					gconstpointer _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp45_ = g_ptr_array_index (details, (guint) 0);
					_tmp46_ = g_strdup ((const gchar*) _tmp45_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp46_;
					_tmp47_ = g_ptr_array_index (details, (guint) 0);
					_tmp48_ = g_ptr_array_index (details, (guint) 1);
					_tmp49_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp47_, (const gchar*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup_printf (g_dgettext (NULL, "Removing %s"), _tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strconcat (_tmp52_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp53_;
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					break;
				}
				default:
				break;
			}
			break;
		}
		case 13:
		{
			gchar* _tmp54_;
			_tmp54_ = g_strconcat (g_dgettext (NULL, "Checking integrity"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp54_;
			break;
		}
		case 15:
		{
			gchar* _tmp55_;
			_tmp55_ = g_strconcat (g_dgettext (NULL, "Loading packages files"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp55_;
			break;
		}
		case 17:
		{
			gchar* msg = NULL;
			gconstpointer _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			_tmp56_ = g_ptr_array_index (details, (guint) 0);
			_tmp57_ = pamac_alpm_utils_remove_bash_colors (self, (const gchar*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = string_replace (_tmp58_, "\n", "");
			_tmp60_ = _tmp59_;
			_g_free0 (_tmp58_);
			msg = _tmp60_;
			_tmp61_ = msg;
			pamac_alpm_utils_do_emit_script_output (self, _tmp61_);
			_tmp62_ = self->current_filename;
			if (g_strcmp0 (_tmp62_, "") != 0) {
				gchar* action = NULL;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gboolean _tmp74_;
				_tmp63_ = self->current_filename;
				_tmp64_ = g_strdup_printf (g_dgettext (NULL, "Configuring %s"), _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp65_, "...", NULL);
				_tmp67_ = _tmp66_;
				_g_free0 (_tmp65_);
				action = _tmp67_;
				_tmp68_ = action;
				_tmp69_ = self->current_action;
				if (g_strcmp0 (_tmp68_, _tmp69_) != 0) {
					gchar* _tmp70_;
					_tmp70_ = action;
					action = NULL;
					_g_free0 (self->current_action);
					self->current_action = _tmp70_;
				}
				_tmp71_ = msg;
				_tmp72_ = g_utf8_strdown (_tmp71_, (gssize) -1);
				_tmp73_ = _tmp72_;
				_tmp74_ = string_contains (_tmp73_, "error");
				_g_free0 (_tmp73_);
				if (_tmp74_) {
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp75_ = self->current_filename;
					_tmp76_ = g_strdup_printf (g_dgettext (NULL, "Error while configuring %s"), _tmp75_);
					_tmp77_ = _tmp76_;
					pamac_alpm_utils_do_emit_warning (self, _tmp77_);
					_g_free0 (_tmp77_);
					pamac_alpm_utils_do_important_details_outpout (self, TRUE);
				} else {
					pamac_alpm_utils_do_important_details_outpout (self, FALSE);
				}
				_g_free0 (action);
			}
			_g_free0 (msg);
			break;
		}
		case 18:
		{
			pamac_alpm_utils_do_start_downloading (self);
			break;
		}
		case 19:
		case 20:
		{
			pamac_alpm_utils_do_stop_downloading (self);
			break;
		}
		case 21:
		{
			pamac_alpm_utils_do_start_downloading (self);
			break;
		}
		case 22:
		case 23:
		{
			gchar* _tmp78_;
			GHashTable* _tmp79_;
			GQueue* _tmp80_;
			gchar* _tmp81_;
			pamac_alpm_utils_do_stop_downloading (self);
			_tmp78_ = g_strdup ("");
			_g_free0 (self->current_filename);
			self->current_filename = _tmp78_;
			g_mutex_lock (&self->multi_progress_mutex);
			_tmp79_ = self->multi_progress;
			g_hash_table_remove_all (_tmp79_);
			g_mutex_unlock (&self->multi_progress_mutex);
			_tmp80_ = self->priv->download_rates;
			g_queue_clear (_tmp80_);
			self->priv->download_rate = (gdouble) 0;
			self->current_progress = (gdouble) 0;
			self->already_downloaded = (guint64) 0;
			_tmp81_ = g_strdup ("");
			_g_free0 (self->priv->current_status);
			self->priv->current_status = _tmp81_;
			self->total_download = (guint64) 0;
			break;
		}
		case 24:
		{
			gchar* _tmp82_;
			_tmp82_ = g_strconcat (g_dgettext (NULL, "Checking available disk space"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp82_;
			break;
		}
		case 26:
		{
			gconstpointer _tmp83_;
			gconstpointer _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp83_ = g_ptr_array_index (details, (guint) 0);
			_tmp84_ = g_ptr_array_index (details, (guint) 1);
			_tmp85_ = g_strdup_printf (g_dgettext (NULL, "%1$s optionally requires %2$s"), (const gchar*) _tmp83_, (const gchar*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strdup_printf ("%s: %s", g_dgettext (NULL, "Warning"), _tmp86_);
			_tmp88_ = _tmp87_;
			pamac_alpm_utils_do_emit_warning (self, _tmp88_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
			break;
		}
		case 27:
		{
			break;
		}
		case 28:
		{
			gchar* _tmp89_;
			_tmp89_ = g_strconcat (g_dgettext (NULL, "Checking keyring"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp89_;
			break;
		}
		case 30:
		{
			gchar* _tmp90_;
			gchar* _tmp91_;
			_tmp90_ = g_strconcat (g_dgettext (NULL, "Downloading required keys"), "...", NULL);
			_tmp91_ = _tmp90_;
			pamac_alpm_utils_do_emit_action (self, _tmp91_);
			_g_free0 (_tmp91_);
			break;
		}
		case 32:
		{
			gconstpointer _tmp92_;
			gconstpointer _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp92_ = g_ptr_array_index (details, (guint) 0);
			_tmp93_ = g_ptr_array_index (details, (guint) 0);
			_tmp94_ = g_strdup_printf (g_dgettext (NULL, "%1$s installed as %2$s.pacnew"), (const gchar*) _tmp92_, (const gchar*) _tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat (_tmp95_, ".", NULL);
			_tmp97_ = _tmp96_;
			pamac_alpm_utils_do_emit_script_output (self, _tmp97_);
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
			break;
		}
		case 33:
		{
			gconstpointer _tmp98_;
			gconstpointer _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			_tmp98_ = g_ptr_array_index (details, (guint) 0);
			_tmp99_ = g_ptr_array_index (details, (guint) 0);
			_tmp100_ = g_strdup_printf (g_dgettext (NULL, "%1$s installed as %2$s.pacsave"), (const gchar*) _tmp98_, (const gchar*) _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = g_strconcat (_tmp101_, ".", NULL);
			_tmp103_ = _tmp102_;
			pamac_alpm_utils_do_emit_script_output (self, _tmp103_);
			_g_free0 (_tmp103_);
			_g_free0 (_tmp101_);
			break;
		}
		case 34:
		{
			switch (secondary_event) {
				case 1:
				{
					gchar* _tmp104_;
					_tmp104_ = g_strconcat (g_dgettext (NULL, "Running pre-transaction hooks"), "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp104_;
					break;
				}
				case 2:
				{
					gchar* _tmp105_;
					gchar* _tmp106_;
					_tmp105_ = g_strdup ("");
					_g_free0 (self->current_filename);
					self->current_filename = _tmp105_;
					_tmp106_ = g_strconcat (g_dgettext (NULL, "Running post-transaction hooks"), "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp106_;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case 36:
		{
			gdouble progress = 0.0;
			gconstpointer _tmp107_;
			gconstpointer _tmp108_;
			gchar* status = NULL;
			gconstpointer _tmp109_;
			gconstpointer _tmp110_;
			gchar* _tmp111_;
			gboolean changed = FALSE;
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			_tmp107_ = g_ptr_array_index (details, (guint) 2);
			_tmp108_ = g_ptr_array_index (details, (guint) 3);
			progress = ((gdouble) atoi ((const gchar*) _tmp107_)) / atoi ((const gchar*) _tmp108_);
			_tmp109_ = g_ptr_array_index (details, (guint) 2);
			_tmp110_ = g_ptr_array_index (details, (guint) 3);
			_tmp111_ = g_strdup_printf ("%s/%s", (const gchar*) _tmp109_, (const gchar*) _tmp110_);
			status = _tmp111_;
			changed = FALSE;
			if (progress != self->current_progress) {
				self->current_progress = progress;
				changed = TRUE;
			}
			_tmp112_ = status;
			_tmp113_ = self->priv->current_status;
			if (g_strcmp0 (_tmp112_, _tmp113_) != 0) {
				gchar* _tmp114_;
				_tmp114_ = status;
				status = NULL;
				_g_free0 (self->priv->current_status);
				self->priv->current_status = _tmp114_;
				changed = TRUE;
			}
			if (changed) {
				gconstpointer _tmp115_;
				_tmp115_ = g_ptr_array_index (details, (guint) 1);
				if (g_strcmp0 ((const gchar*) _tmp115_, "") != 0) {
					const gchar* _tmp116_;
					gconstpointer _tmp117_;
					const gchar* _tmp118_;
					gconstpointer _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gboolean _tmp122_;
					_tmp116_ = self->current_action;
					_tmp117_ = g_ptr_array_index (details, (guint) 1);
					_tmp118_ = self->priv->current_status;
					pamac_alpm_utils_do_emit_hook_progress (self, _tmp116_, (const gchar*) _tmp117_, _tmp118_, self->current_progress);
					_tmp119_ = g_ptr_array_index (details, (guint) 1);
					_tmp120_ = g_utf8_strdown ((const gchar*) _tmp119_, (gssize) -1);
					_tmp121_ = _tmp120_;
					_tmp122_ = string_contains (_tmp121_, "error");
					_g_free0 (_tmp121_);
					if (_tmp122_) {
						pamac_alpm_utils_do_emit_warning (self, g_dgettext (NULL, "Error while running hooks"));
						pamac_alpm_utils_do_important_details_outpout (self, TRUE);
					}
				} else {
					const gchar* _tmp123_;
					gconstpointer _tmp124_;
					const gchar* _tmp125_;
					gconstpointer _tmp126_;
					gchar* _tmp127_;
					gchar* _tmp128_;
					gboolean _tmp129_;
					_tmp123_ = self->current_action;
					_tmp124_ = g_ptr_array_index (details, (guint) 0);
					_tmp125_ = self->priv->current_status;
					pamac_alpm_utils_do_emit_hook_progress (self, _tmp123_, (const gchar*) _tmp124_, _tmp125_, self->current_progress);
					_tmp126_ = g_ptr_array_index (details, (guint) 0);
					_tmp127_ = g_utf8_strdown ((const gchar*) _tmp126_, (gssize) -1);
					_tmp128_ = _tmp127_;
					_tmp129_ = string_contains (_tmp128_, "error");
					_g_free0 (_tmp128_);
					if (_tmp129_) {
						pamac_alpm_utils_do_emit_warning (self, g_dgettext (NULL, "Error while running hooks"));
						pamac_alpm_utils_do_important_details_outpout (self, TRUE);
					}
				}
			}
			_g_free0 (status);
			break;
		}
		default:
		{
			break;
		}
	}
}

void
pamac_alpm_utils_emit_progress (PamacAlpmUtils* self,
                                guint progress,
                                const gchar* pkgname,
                                guint percent,
                                guint n_targets,
                                guint current_target)
{
	gdouble fraction = 0.0;
	gchar* status = NULL;
	gchar* _tmp0_;
	gboolean changed = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	switch (progress) {
		case 0:
		case 1:
		case 2:
		case 3:
		case 4:
		{
			fraction = (((gdouble) (current_target - 1)) / n_targets) + (((gdouble) percent) / (100 * n_targets));
			break;
		}
		default:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
		{
			fraction = ((gdouble) percent) / 100;
			break;
		}
	}
	_tmp0_ = g_strdup_printf ("%lu/%lu", (gulong) current_target, (gulong) n_targets);
	status = _tmp0_;
	changed = FALSE;
	if (fraction != self->current_progress) {
		self->current_progress = fraction;
		changed = TRUE;
	}
	_tmp1_ = status;
	_tmp2_ = self->priv->current_status;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		gchar* _tmp3_;
		_tmp3_ = status;
		status = NULL;
		_g_free0 (self->priv->current_status);
		self->priv->current_status = _tmp3_;
		changed = TRUE;
	}
	if (changed) {
		const gchar* _tmp4_;
		_tmp4_ = self->current_action;
		if (g_strcmp0 (_tmp4_, "") != 0) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->current_action;
			_tmp6_ = self->priv->current_status;
			pamac_alpm_utils_do_emit_action_progress (self, _tmp5_, _tmp6_, self->current_progress);
		}
	}
	_g_free0 (status);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

void
pamac_alpm_utils_emit_download (PamacAlpmUtils* self,
                                guint64 xfered,
                                guint64 total)
{
	GString* text = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GString* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	g_return_if_fail (self != NULL);
	if (xfered == ((guint64) 0)) {
		GTimer* _tmp0_;
		_tmp0_ = self->rate_timer;
		g_timer_start (_tmp0_);
		if (self->total_download == ((guint64) 0)) {
			GQueue* _tmp1_;
			_tmp1_ = self->priv->download_rates;
			g_queue_clear (_tmp1_);
			self->priv->download_rate = (gdouble) 0;
		}
	}
	_tmp2_ = g_format_size_full (xfered, G_FORMAT_SIZE_DEFAULT);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_string_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	text = _tmp7_;
	if (self->current_progress < ((gdouble) 1)) {
		gdouble fraction = 0.0;
		fraction = ((gdouble) xfered) / total;
		if (fraction <= ((gdouble) 1)) {
			GString* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gdouble elapsed = 0.0;
			GTimer* _tmp13_;
			_tmp8_ = text;
			_tmp9_ = g_format_size_full (total, G_FORMAT_SIZE_DEFAULT);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf ("/%s", _tmp10_);
			_tmp12_ = _tmp11_;
			g_string_append (_tmp8_, _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			_tmp13_ = self->rate_timer;
			elapsed = g_timer_elapsed (_tmp13_, NULL);
			if (elapsed > ((gdouble) 1)) {
				gdouble current_rate = 0.0;
				GQueue* _tmp14_;
				GQueue* _tmp18_;
				gdouble* _tmp19_;
				GQueue* _tmp22_;
				current_rate = (xfered - self->already_downloaded) / elapsed;
				self->already_downloaded = xfered;
				_tmp14_ = self->priv->download_rates;
				if (_tmp14_->length > ((guint) 10)) {
					GQueue* _tmp15_;
					gpointer _tmp16_;
					gdouble* _tmp17_;
					_tmp15_ = self->priv->download_rates;
					_tmp16_ = g_queue_pop_head (_tmp15_);
					_tmp17_ = (gdouble*) _tmp16_;
					_g_free0 (_tmp17_);
				}
				_tmp18_ = self->priv->download_rates;
				_tmp19_ = __double_dup0 (&current_rate);
				g_queue_push_tail (_tmp18_, _tmp19_);
				if (xfered == total) {
					GTimer* _tmp20_;
					_tmp20_ = self->rate_timer;
					g_timer_stop (_tmp20_);
				} else {
					GTimer* _tmp21_;
					_tmp21_ = self->rate_timer;
					g_timer_start (_tmp21_);
				}
				_tmp22_ = self->priv->download_rates;
				if (_tmp22_->length == ((guint) 10)) {
					gdouble total_rates = 0.0;
					GQueue* _tmp23_;
					GList* _tmp24_;
					total_rates = (gdouble) 0;
					_tmp23_ = self->priv->download_rates;
					_tmp24_ = _tmp23_->head;
					{
						GList* previous_rate_collection = NULL;
						GList* previous_rate_it = NULL;
						previous_rate_collection = _tmp24_;
						for (previous_rate_it = previous_rate_collection; previous_rate_it != NULL; previous_rate_it = previous_rate_it->next) {
							gdouble previous_rate = 0.0;
							previous_rate = *((gdouble*) previous_rate_it->data);
							{
								total_rates += previous_rate;
							}
						}
					}
					self->priv->download_rate = total_rates / 10;
				}
			}
			if (self->priv->download_rate > ((gdouble) 0)) {
				guint remaining_seconds = 0U;
				GString* _tmp25_;
				remaining_seconds = (guint) round ((total - xfered) / self->priv->download_rate);
				_tmp25_ = text;
				g_string_append (_tmp25_, " ");
				if (remaining_seconds > ((guint) 0)) {
					if (remaining_seconds < ((guint) 60)) {
						GString* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp26_ = text;
						_tmp27_ = g_strdup_printf (g_dngettext (NULL, "About %lu second remaining", "About %lu seconds remaining", (gulong) remaining_seconds), (gulong) remaining_seconds);
						_tmp28_ = _tmp27_;
						g_string_append (_tmp26_, _tmp28_);
						_g_free0 (_tmp28_);
					} else {
						guint remaining_minutes = 0U;
						GString* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						remaining_minutes = (guint) round ((gdouble) (remaining_seconds / 60));
						_tmp29_ = text;
						_tmp30_ = g_strdup_printf (g_dngettext (NULL, "About %lu minute remaining", "About %lu minutes remaining", (gulong) remaining_minutes), (gulong) remaining_minutes);
						_tmp31_ = _tmp30_;
						g_string_append (_tmp29_, _tmp31_);
						_g_free0 (_tmp31_);
					}
				}
			}
		} else {
			GTimer* _tmp32_;
			fraction = (gdouble) 1;
			_tmp32_ = self->rate_timer;
			g_timer_stop (_tmp32_);
		}
		if (fraction != self->current_progress) {
			self->current_progress = fraction;
		}
	}
	_tmp33_ = text;
	_tmp34_ = _tmp33_->str;
	_tmp35_ = self->priv->current_status;
	if (g_strcmp0 (_tmp34_, _tmp35_) != 0) {
		GString* _tmp36_;
		gchar* _tmp37_;
		_tmp36_ = text;
		_tmp37_ = _tmp36_->str;
		_tmp36_->str = NULL;
		_g_free0 (self->priv->current_status);
		self->priv->current_status = _tmp37_;
	}
	_tmp38_ = self->current_action;
	_tmp39_ = self->priv->current_status;
	pamac_alpm_utils_do_emit_download_progress (self, _tmp38_, _tmp39_, self->current_progress);
	_g_string_free0 (text);
}

void
pamac_alpm_utils_emit_totaldownload (PamacAlpmUtils* self,
                                     guint64 total)
{
	GQueue* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->download_rates;
	g_queue_clear (_tmp0_);
	self->priv->download_rate = (gdouble) 0;
	self->current_progress = (gdouble) 0;
	self->already_downloaded = (guint64) 0;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->current_status);
	self->priv->current_status = _tmp1_;
	self->total_download = total;
}

void
pamac_alpm_utils_emit_log (PamacAlpmUtils* self,
                           guint level,
                           const gchar* msg)
{
	gchar* line = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	line = NULL;
	if (level == ((guint) 1)) {
		const gchar* _tmp0_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp0_ = self->current_filename;
		if (g_strcmp0 (_tmp0_, "") != 0) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = g_strconcat (g_dgettext (NULL, "Error"), ": ", NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = self->current_filename;
			_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, ": ", NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, msg, NULL);
			_g_free0 (line);
			line = _tmp8_;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = g_strconcat (g_dgettext (NULL, "Error"), ": ", NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp10_, msg, NULL);
			_g_free0 (line);
			line = _tmp11_;
			_g_free0 (_tmp10_);
		}
		pamac_alpm_utils_do_important_details_outpout (self, FALSE);
		_tmp12_ = line;
		_tmp13_ = string_replace (_tmp12_, "\n", "");
		_tmp14_ = _tmp13_;
		pamac_alpm_utils_do_emit_script_output (self, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		if (level == ((guint) (1 << 1))) {
			const gchar* _tmp15_;
			if (self->priv->no_confirm_commit) {
				_g_free0 (line);
				return;
			}
			_tmp15_ = self->current_filename;
			if (g_strcmp0 (_tmp15_, "manjaro-system") != 0) {
				const gchar* _tmp16_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp16_ = self->current_filename;
				if (g_strcmp0 (_tmp16_, "") != 0) {
					gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp17_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = self->current_filename;
					_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp21_, ": ", NULL);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat (_tmp23_, msg, NULL);
					_g_free0 (line);
					line = _tmp24_;
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
					_g_free0 (_tmp18_);
				} else {
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp25_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp26_, msg, NULL);
					_g_free0 (line);
					line = _tmp27_;
					_g_free0 (_tmp26_);
				}
				_tmp28_ = line;
				_tmp29_ = string_replace (_tmp28_, "\n", "");
				_tmp30_ = _tmp29_;
				pamac_alpm_utils_do_emit_script_output (self, _tmp30_);
				_g_free0 (_tmp30_);
			}
		}
	}
	_g_free0 (line);
}

static void
g_cclosure_user_marshal_INT__STRING_BOXED (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef gint (*GMarshalFunc_INT__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_INT__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
	g_value_set_int (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gdouble arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_double (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                  GValue * return_value,
                                                                  guint n_param_values,
                                                                  const GValue * param_values,
                                                                  gpointer invocation_hint,
                                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gdouble arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_double (param_values + 5), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_BOXED (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOXED) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
pamac_alpm_utils_class_init (PamacAlpmUtilsClass * klass,
                             gpointer klass_data)
{
	pamac_alpm_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacAlpmUtils_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_alpm_utils_finalize;
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL] = g_signal_new ("choose-provider", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__STRING_BOXED, G_TYPE_INT, 2, G_TYPE_STRING, G_TYPE_PTR_ARRAY);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL] = g_signal_new ("start-downloading", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL] = g_signal_new ("stop-downloading", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL] = g_signal_new ("emit-action", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL] = g_signal_new ("emit-action-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL] = g_signal_new ("emit-download-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL] = g_signal_new ("emit-hook-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL] = g_signal_new ("emit-script-output", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL] = g_signal_new ("emit-warning", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL] = g_signal_new ("emit-error", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_PTR_ARRAY);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL] = g_signal_new ("important-details-outpout", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
}

static void
pamac_alpm_utils_instance_init (PamacAlpmUtils * self,
                                gpointer klass)
{
	self->priv = pamac_alpm_utils_get_instance_private (self);
}

static void
pamac_alpm_utils_finalize (GObject * obj)
{
	PamacAlpmUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	_g_free0 (self->priv->sender);
	_g_object_unref0 (self->priv->config);
	_alpm_config_unref0 (self->alpm_config);
	_g_free0 (self->priv->tmp_path);
	_g_object_unref0 (self->lockfile);
	_g_free0 (self->priv->current_status);
	_g_hash_table_unref0 (self->priv->to_install);
	_g_hash_table_unref0 (self->priv->deps_to_install);
	_g_hash_table_unref0 (self->priv->to_remove);
	_g_hash_table_unref0 (self->priv->required_to_remove);
	_g_hash_table_unref0 (self->priv->orphans_to_remove);
	_g_hash_table_unref0 (self->priv->conflicts_to_remove);
	_g_hash_table_unref0 (self->priv->local_paths);
	_g_hash_table_unref0 (self->priv->remote_paths);
	_g_hash_table_unref0 (self->priv->to_build);
	_g_hash_table_unref0 (self->priv->checked_deps);
	_g_hash_table_unref0 (self->priv->to_install_as_dep);
	_g_hash_table_unref0 (self->priv->ignorepkgs);
	_g_hash_table_unref0 (self->priv->overwrite_files);
	_g_hash_table_unref0 (self->priv->to_syncfirst);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->current_filename);
	_g_free0 (self->current_action);
	_g_ptr_array_unref0 (self->unresolvables);
	_vala_clear_GMutex (&self->multi_progress_mutex);
	_g_hash_table_unref0 (self->multi_progress);
	_g_object_unref0 (self->soup_session);
	_g_timer_destroy0 (self->rate_timer);
	(self->priv->download_rates == NULL) ? NULL : (self->priv->download_rates = (_g_queue_free__g_free0_ (self->priv->download_rates), NULL));
	G_OBJECT_CLASS (pamac_alpm_utils_parent_class)->finalize (obj);
}

static GType
pamac_alpm_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacAlpmUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_alpm_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacAlpmUtils), 0, (GInstanceInitFunc) pamac_alpm_utils_instance_init, NULL };
	GType pamac_alpm_utils_type_id;
	pamac_alpm_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacAlpmUtils", &g_define_type_info, 0);
	PamacAlpmUtils_private_offset = g_type_add_instance_private (pamac_alpm_utils_type_id, sizeof (PamacAlpmUtilsPrivate));
	return pamac_alpm_utils_type_id;
}

GType
pamac_alpm_utils_get_type (void)
{
	static volatile gsize pamac_alpm_utils_type_id__once = 0;
	if (g_once_init_enter (&pamac_alpm_utils_type_id__once)) {
		GType pamac_alpm_utils_type_id;
		pamac_alpm_utils_type_id = pamac_alpm_utils_get_type_once ();
		g_once_init_leave (&pamac_alpm_utils_type_id__once, pamac_alpm_utils_type_id);
	}
	return pamac_alpm_utils_type_id__once;
}

void
write_log_file (const gchar* event)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* log = NULL;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* file = NULL;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (event != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	_tmp2_ = g_date_time_format (_tmp1_, "[%Y-%m-%dT%H:%M:%S%z]");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s [PAMAC] %s\n", _tmp3_, event);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	log = _tmp5_;
	_tmp6_ = g_file_new_for_path ("/var/log/pacman.log");
	file = _tmp6_;
	{
		GFileOutputStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileOutputStream* _tmp9_;
		GDataOutputStream* dos = NULL;
		GDataOutputStream* _tmp10_;
		GDataOutputStream* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = file;
		_tmp9_ = g_file_append_to (_tmp8_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = g_data_output_stream_new ((GOutputStream*) _tmp7_);
		dos = _tmp10_;
		_tmp11_ = dos;
		_tmp12_ = log;
		g_data_output_stream_put_string (_tmp11_, _tmp12_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dos);
			_g_object_unref0 (_tmp7_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dos);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("alpm_utils.vala:2475: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (log);
		_g_date_time_unref0 (now);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (log);
	_g_date_time_unref0 (now);
}

void
cb_event (void* ctx,
          alpm_event_t* data)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	GPtrArray* details = NULL;
	GPtrArray* _tmp1_;
	guint secondary_type = 0U;
	PamacAlpmUtils* _tmp96_;
	GPtrArray* _tmp97_;
	g_return_if_fail (data != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils));
	alpm_utils = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	details = _tmp1_;
	secondary_type = (guint) 0;
	switch (data->type) {
		case ALPM_EVENT_HOOK_START:
		{
			switch (data->hook.when) {
				case ALPM_HOOK_PRE_TRANSACTION:
				{
					secondary_type = (guint) ALPM_HOOK_PRE_TRANSACTION;
					break;
				}
				case ALPM_HOOK_POST_TRANSACTION:
				{
					secondary_type = (guint) ALPM_HOOK_POST_TRANSACTION;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case ALPM_EVENT_HOOK_RUN_START:
		{
			GPtrArray* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_;
			GPtrArray* _tmp7_;
			gchar* _tmp8_;
			GPtrArray* _tmp9_;
			gchar* _tmp10_;
			GPtrArray* _tmp11_;
			gchar* _tmp12_;
			_tmp2_ = details;
			_tmp3_ = data->hook_run.name;
			_tmp4_ = g_strdup (_tmp3_);
			g_ptr_array_add (_tmp2_, _tmp4_);
			_tmp6_ = data->hook_run.desc;
			_tmp5_ = _tmp6_;
			if (_tmp5_ == NULL) {
				_tmp5_ = "";
			}
			_tmp7_ = details;
			_tmp8_ = g_strdup (_tmp5_);
			g_ptr_array_add (_tmp7_, _tmp8_);
			_tmp9_ = details;
			_tmp10_ = g_strdup_printf ("%" G_GSIZE_FORMAT, data->hook_run.position);
			g_ptr_array_add (_tmp9_, _tmp10_);
			_tmp11_ = details;
			_tmp12_ = g_strdup_printf ("%" G_GSIZE_FORMAT, data->hook_run.total);
			g_ptr_array_add (_tmp11_, _tmp12_);
			break;
		}
		case ALPM_EVENT_PACKAGE_OPERATION_START:
		{
			switch (data->package_operation.operation) {
				case ALPM_PACKAGE_REMOVE:
				{
					GPtrArray* _tmp13_;
					alpm_pkg_t* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					GPtrArray* _tmp18_;
					alpm_pkg_t* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp13_ = details;
					_tmp14_ = data->package_operation.oldpkg;
					_tmp15_ = alpm_pkg_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					g_ptr_array_add (_tmp13_, _tmp17_);
					_tmp18_ = details;
					_tmp19_ = data->package_operation.oldpkg;
					_tmp20_ = alpm_pkg_get_version (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup (_tmp21_);
					g_ptr_array_add (_tmp18_, _tmp22_);
					secondary_type = (guint) ALPM_PACKAGE_REMOVE;
					break;
				}
				case ALPM_PACKAGE_INSTALL:
				{
					GPtrArray* _tmp23_;
					alpm_pkg_t* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					GPtrArray* _tmp28_;
					alpm_pkg_t* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp23_ = details;
					_tmp24_ = data->package_operation.newpkg;
					_tmp25_ = alpm_pkg_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup (_tmp26_);
					g_ptr_array_add (_tmp23_, _tmp27_);
					_tmp28_ = details;
					_tmp29_ = data->package_operation.newpkg;
					_tmp30_ = alpm_pkg_get_version (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strdup (_tmp31_);
					g_ptr_array_add (_tmp28_, _tmp32_);
					secondary_type = (guint) ALPM_PACKAGE_INSTALL;
					break;
				}
				case ALPM_PACKAGE_REINSTALL:
				{
					GPtrArray* _tmp33_;
					alpm_pkg_t* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					GPtrArray* _tmp38_;
					alpm_pkg_t* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp33_ = details;
					_tmp34_ = data->package_operation.newpkg;
					_tmp35_ = alpm_pkg_get_name (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strdup (_tmp36_);
					g_ptr_array_add (_tmp33_, _tmp37_);
					_tmp38_ = details;
					_tmp39_ = data->package_operation.newpkg;
					_tmp40_ = alpm_pkg_get_version (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_strdup (_tmp41_);
					g_ptr_array_add (_tmp38_, _tmp42_);
					secondary_type = (guint) ALPM_PACKAGE_REINSTALL;
					break;
				}
				case ALPM_PACKAGE_UPGRADE:
				{
					GPtrArray* _tmp43_;
					alpm_pkg_t* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					GPtrArray* _tmp48_;
					alpm_pkg_t* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					GPtrArray* _tmp53_;
					alpm_pkg_t* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp43_ = details;
					_tmp44_ = data->package_operation.oldpkg;
					_tmp45_ = alpm_pkg_get_name (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup (_tmp46_);
					g_ptr_array_add (_tmp43_, _tmp47_);
					_tmp48_ = details;
					_tmp49_ = data->package_operation.oldpkg;
					_tmp50_ = alpm_pkg_get_version (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strdup (_tmp51_);
					g_ptr_array_add (_tmp48_, _tmp52_);
					_tmp53_ = details;
					_tmp54_ = data->package_operation.newpkg;
					_tmp55_ = alpm_pkg_get_version (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strdup (_tmp56_);
					g_ptr_array_add (_tmp53_, _tmp57_);
					secondary_type = (guint) ALPM_PACKAGE_UPGRADE;
					break;
				}
				case ALPM_PACKAGE_DOWNGRADE:
				{
					GPtrArray* _tmp58_;
					alpm_pkg_t* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					GPtrArray* _tmp63_;
					alpm_pkg_t* _tmp64_;
					const gchar* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					GPtrArray* _tmp68_;
					alpm_pkg_t* _tmp69_;
					const gchar* _tmp70_;
					const gchar* _tmp71_;
					gchar* _tmp72_;
					_tmp58_ = details;
					_tmp59_ = data->package_operation.oldpkg;
					_tmp60_ = alpm_pkg_get_name (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = g_strdup (_tmp61_);
					g_ptr_array_add (_tmp58_, _tmp62_);
					_tmp63_ = details;
					_tmp64_ = data->package_operation.oldpkg;
					_tmp65_ = alpm_pkg_get_version (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = g_strdup (_tmp66_);
					g_ptr_array_add (_tmp63_, _tmp67_);
					_tmp68_ = details;
					_tmp69_ = data->package_operation.newpkg;
					_tmp70_ = alpm_pkg_get_version (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = g_strdup (_tmp71_);
					g_ptr_array_add (_tmp68_, _tmp72_);
					secondary_type = (guint) ALPM_PACKAGE_DOWNGRADE;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case ALPM_EVENT_SCRIPTLET_INFO:
		{
			GPtrArray* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			_tmp73_ = details;
			_tmp74_ = data->scriptlet_info.line;
			_tmp75_ = g_strdup (_tmp74_);
			g_ptr_array_add (_tmp73_, _tmp75_);
			break;
		}
		case ALPM_EVENT_PKG_RETRIEVE_START:
		{
			PamacAlpmUtils* _tmp76_;
			GCancellable* _tmp77_;
			PamacAlpmUtils* _tmp78_;
			_tmp76_ = alpm_utils;
			_tmp77_ = _tmp76_->cancellable;
			if (g_cancellable_is_cancelled (_tmp77_)) {
				_g_ptr_array_unref0 (details);
				_g_object_unref0 (alpm_utils);
				return;
			}
			_tmp78_ = alpm_utils;
			pamac_alpm_utils_emit_totaldownload (_tmp78_, data->pkg_retrieve.total_size);
			break;
		}
		case ALPM_EVENT_OPTDEP_REMOVAL:
		{
			GPtrArray* _tmp79_;
			alpm_pkg_t* _tmp80_;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			gchar* _tmp83_;
			GPtrArray* _tmp84_;
			alpm_depend_t* _tmp85_;
			gchar* _tmp86_;
			_tmp79_ = details;
			_tmp80_ = data->optdep_removal.pkg;
			_tmp81_ = alpm_pkg_get_name (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = g_strdup (_tmp82_);
			g_ptr_array_add (_tmp79_, _tmp83_);
			_tmp84_ = details;
			_tmp85_ = data->optdep_removal.optdep;
			_tmp86_ = alpm_dep_compute_string (_tmp85_);
			g_ptr_array_add (_tmp84_, _tmp86_);
			break;
		}
		case ALPM_EVENT_DATABASE_MISSING:
		{
			GPtrArray* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			_tmp87_ = details;
			_tmp88_ = data->database_missing.dbname;
			_tmp89_ = g_strdup (_tmp88_);
			g_ptr_array_add (_tmp87_, _tmp89_);
			break;
		}
		case ALPM_EVENT_PACNEW_CREATED:
		{
			GPtrArray* _tmp90_;
			const gchar* _tmp91_;
			gchar* _tmp92_;
			_tmp90_ = details;
			_tmp91_ = data->pacnew_created.file;
			_tmp92_ = g_strdup (_tmp91_);
			g_ptr_array_add (_tmp90_, _tmp92_);
			break;
		}
		case ALPM_EVENT_PACSAVE_CREATED:
		{
			GPtrArray* _tmp93_;
			const gchar* _tmp94_;
			gchar* _tmp95_;
			_tmp93_ = details;
			_tmp94_ = data->pacsave_created.file;
			_tmp95_ = g_strdup (_tmp94_);
			g_ptr_array_add (_tmp93_, _tmp95_);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp96_ = alpm_utils;
	_tmp97_ = details;
	pamac_alpm_utils_emit_event (_tmp96_, (guint) data->type, secondary_type, _tmp97_);
	_g_ptr_array_unref0 (details);
	_g_object_unref0 (alpm_utils);
}

void
cb_question (void* ctx,
             alpm_question_t* data)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	g_return_if_fail (data != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils));
	alpm_utils = _tmp0_;
	switch (data->type) {
		case ALPM_QUESTION_INSTALL_IGNOREPKG:
		{
			data->install_ignorepkg.install = 0;
			break;
		}
		case ALPM_QUESTION_REPLACE_PKG:
		{
			data->replace.replace = 1;
			break;
		}
		case ALPM_QUESTION_CONFLICT_PKG:
		{
			data->conflict.remove = 1;
			break;
		}
		case ALPM_QUESTION_REMOVE_PKGS:
		{
			PamacAlpmUtils* _tmp1_;
			GPtrArray* _tmp2_;
			alpm_list_t* list = NULL;
			alpm_list_t* _tmp3_;
			_tmp1_ = alpm_utils;
			_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			_g_ptr_array_unref0 (_tmp1_->unresolvables);
			_tmp1_->unresolvables = _tmp2_;
			_tmp3_ = data->remove_pkgs.packages;
			list = _tmp3_;
			while (TRUE) {
				alpm_list_t* _tmp4_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp5_;
				gconstpointer _tmp6_;
				PamacAlpmUtils* _tmp7_;
				GPtrArray* _tmp8_;
				alpm_pkg_t* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp4_ = list;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = list;
				_tmp6_ = _tmp5_->data;
				pkg = (alpm_pkg_t*) _tmp6_;
				_tmp7_ = alpm_utils;
				_tmp8_ = _tmp7_->unresolvables;
				_tmp9_ = pkg;
				_tmp10_ = alpm_pkg_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup (_tmp11_);
				g_ptr_array_add (_tmp8_, _tmp12_);
				list = alpm_list_next (list);
			}
			data->remove_pkgs.skip = 0;
			break;
		}
		case ALPM_QUESTION_SELECT_PROVIDER:
		{
			gchar* depend_str = NULL;
			alpm_depend_t* _tmp13_;
			gchar* _tmp14_;
			GPtrArray* providers_str = NULL;
			GPtrArray* _tmp15_;
			alpm_list_t* list = NULL;
			alpm_list_t* _tmp16_;
			PamacAlpmUtils* _tmp25_;
			const gchar* _tmp26_;
			GPtrArray* _tmp27_;
			_tmp13_ = data->select_provider.depend;
			_tmp14_ = alpm_dep_compute_string (_tmp13_);
			depend_str = _tmp14_;
			_tmp15_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			providers_str = _tmp15_;
			_tmp16_ = data->select_provider.providers;
			list = _tmp16_;
			while (TRUE) {
				alpm_list_t* _tmp17_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp18_;
				gconstpointer _tmp19_;
				GPtrArray* _tmp20_;
				alpm_pkg_t* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp17_ = list;
				if (!(_tmp17_ != NULL)) {
					break;
				}
				_tmp18_ = list;
				_tmp19_ = _tmp18_->data;
				pkg = (alpm_pkg_t*) _tmp19_;
				_tmp20_ = providers_str;
				_tmp21_ = pkg;
				_tmp22_ = alpm_pkg_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strdup (_tmp23_);
				g_ptr_array_add (_tmp20_, _tmp24_);
				list = alpm_list_next (list);
			}
			_tmp25_ = alpm_utils;
			_tmp26_ = depend_str;
			_tmp27_ = providers_str;
			data->select_provider.use_index = pamac_alpm_utils_do_choose_provider (_tmp25_, _tmp26_, _tmp27_);
			_g_ptr_array_unref0 (providers_str);
			_g_free0 (depend_str);
			break;
		}
		case ALPM_QUESTION_CORRUPTED_PKG:
		{
			data->corrupted.remove = 1;
			break;
		}
		case ALPM_QUESTION_IMPORT_KEY:
		{
			data->import_key.import = 1;
			break;
		}
		default:
		{
			data->any.answer = 0;
			break;
		}
	}
	_g_object_unref0 (alpm_utils);
}

void
cb_progress (void* ctx,
             alpm_progress_t progress,
             const gchar* pkgname,
             gint percent,
             guint n_targets,
             guint current_target)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	g_return_if_fail (pkgname != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils));
	alpm_utils = _tmp0_;
	pamac_alpm_utils_emit_progress (alpm_utils, (guint) progress, pkgname, (guint) percent, n_targets, current_target);
	_g_object_unref0 (alpm_utils);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

void
compute_multi_download_progress (PamacAlpmUtils* alpm_utils)
{
	guint64 total_progress = 0ULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	guint64* progress = NULL;
	g_return_if_fail (alpm_utils != NULL);
	total_progress = (guint64) 0;
	_tmp0_ = alpm_utils->multi_progress;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		guint64* _tmp3_;
		guint64* _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_free0 (progress);
		_tmp3_ = __uint64_dup0 ((guint64*) _tmp1_);
		progress = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = progress;
		total_progress += *_tmp4_;
	}
	pamac_alpm_utils_emit_download (alpm_utils, total_progress, alpm_utils->total_download);
	_g_free0 (progress);
}

void
cb_download (PamacAlpmUtils* alpm_utils,
             const gchar* filename,
             guint64 xfered,
             guint64 total)
{
	g_return_if_fail (alpm_utils != NULL);
	g_return_if_fail (filename != NULL);
	if (alpm_utils->total_download == ((guint64) 0)) {
		pamac_alpm_utils_emit_download (alpm_utils, xfered, total);
	} else {
		GHashTable* _tmp0_;
		gchar* _tmp1_;
		guint64* _tmp2_;
		g_mutex_lock (&alpm_utils->multi_progress_mutex);
		_tmp0_ = alpm_utils->multi_progress;
		_tmp1_ = g_strdup (filename);
		_tmp2_ = __uint64_dup0 (&xfered);
		g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
		compute_multi_download_progress (alpm_utils);
		g_mutex_unlock (&alpm_utils->multi_progress_mutex);
	}
}

gint
cb_fetch (void* ctx,
          const gchar* fileurl,
          const gchar* localpath,
          gint force)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	gchar* mirror = NULL;
	gchar* _tmp1_;
	PamacAlpmUtils* _tmp2_;
	gchar* _tmp3_;
	gint ret = 0;
	PamacAlpmUtils* _tmp4_;
	const gchar* _tmp5_;
	PamacAlpmUtils* _tmp6_;
	const gchar* _tmp7_;
	PamacAlpmUtils* _tmp14_;
	PamacAlpmUtils* _tmp15_;
	PamacAlpmUtils* _tmp16_;
	gint result;
	g_return_val_if_fail (fileurl != NULL, 0);
	g_return_val_if_fail (localpath != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils));
	alpm_utils = _tmp0_;
	_tmp1_ = g_path_get_dirname (fileurl);
	mirror = _tmp1_;
	_tmp2_ = alpm_utils;
	_tmp3_ = g_path_get_basename (fileurl);
	_g_free0 (_tmp2_->current_filename);
	_tmp2_->current_filename = _tmp3_;
	_tmp4_ = alpm_utils;
	_tmp5_ = mirror;
	_tmp6_ = alpm_utils;
	_tmp7_ = _tmp6_->current_filename;
	ret = dload (_tmp4_, _tmp5_, _tmp7_, localpath, force, FALSE, TRUE);
	if (ret == 0) {
		PamacAlpmUtils* _tmp8_;
		const gchar* _tmp9_;
		PamacAlpmUtils* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = alpm_utils;
		_tmp9_ = mirror;
		_tmp10_ = alpm_utils;
		_tmp11_ = _tmp10_->current_filename;
		_tmp12_ = g_strconcat (_tmp11_, ".sig", NULL);
		_tmp13_ = _tmp12_;
		dload (_tmp8_, _tmp9_, _tmp13_, localpath, force, FALSE, FALSE);
		_g_free0 (_tmp13_);
	}
	_tmp14_ = alpm_utils;
	_tmp14_->already_downloaded = (guint64) 0;
	_tmp15_ = alpm_utils;
	_tmp15_->current_progress = (gdouble) 0;
	_tmp16_ = alpm_utils;
	if (_tmp16_->total_download == ((guint64) 0)) {
		PamacAlpmUtils* _tmp17_;
		PamacAlpmUtils* _tmp18_;
		GHashTable* _tmp19_;
		PamacAlpmUtils* _tmp20_;
		_tmp17_ = alpm_utils;
		g_mutex_lock (&_tmp17_->multi_progress_mutex);
		_tmp18_ = alpm_utils;
		_tmp19_ = _tmp18_->multi_progress;
		g_hash_table_remove_all (_tmp19_);
		_tmp20_ = alpm_utils;
		g_mutex_unlock (&_tmp20_->multi_progress_mutex);
	}
	result = ret;
	_g_free0 (mirror);
	_g_object_unref0 (alpm_utils);
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gint
dload (PamacAlpmUtils* alpm_utils,
       const gchar* mirror,
       const gchar* filename,
       const gchar* localpath,
       gint force,
       gboolean parallel,
       gboolean emit_signals)
{
	GCancellable* _tmp0_;
	gchar* url = NULL;
	gchar* _tmp1_;
	GFile* destfile = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* tempfile = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gchar* name = NULL;
	gchar* _tmp13_;
	gchar* version_release = NULL;
	gchar* _tmp14_;
	gboolean remove_partial_download = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gint64 size = 0LL;
	gchar* last_modified = NULL;
	gboolean continue_download = FALSE;
	GTimer* emit_timer = NULL;
	GTimer* _tmp18_;
	gint _tmp185_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (alpm_utils != NULL, 0);
	g_return_val_if_fail (mirror != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	g_return_val_if_fail (localpath != NULL, 0);
	_tmp0_ = alpm_utils->cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		result = -1;
		return result;
	}
	_tmp1_ = g_build_filename (mirror, filename, NULL);
	url = _tmp1_;
	_tmp2_ = g_build_filename (localpath, filename, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	destfile = _tmp5_;
	_tmp6_ = destfile;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".part", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	tempfile = _tmp12_;
	_tmp13_ = g_strdup ("");
	name = _tmp13_;
	_tmp14_ = g_strdup ("");
	version_release = _tmp14_;
	remove_partial_download = TRUE;
	_tmp16_ = url;
	if (string_contains (_tmp16_, ".pkg.tar.")) {
		const gchar* _tmp17_;
		_tmp17_ = url;
		_tmp15_ = !g_str_has_suffix (_tmp17_, ".sig");
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		remove_partial_download = FALSE;
	}
	size = (gint64) 0;
	last_modified = NULL;
	continue_download = FALSE;
	_tmp18_ = g_timer_new ();
	emit_timer = _tmp18_;
	{
		GInputStream* input = NULL;
		const gchar* _tmp19_;
		GFileOutputStream* output = NULL;
		guint64 progress = 0ULL;
		guint8* buf = NULL;
		guint8* _tmp100_;
		gint buf_length1;
		gint _buf_size_;
		_tmp19_ = url;
		if (g_str_has_prefix (_tmp19_, "http")) {
			SoupMessage* message = NULL;
			const gchar* _tmp20_;
			SoupMessage* _tmp21_;
			GInputStream* _tmp39_ = NULL;
			SoupSession* _tmp40_;
			SoupMessage* _tmp41_;
			GInputStream* _tmp42_;
			GInputStream* _tmp43_;
			SoupMessage* _tmp44_;
			guint _tmp45_;
			guint _tmp46_;
			SoupMessage* _tmp47_;
			guint _tmp48_;
			guint _tmp49_;
			SoupMessage* _tmp59_;
			SoupMessageHeaders* _tmp60_;
			SoupMessageHeaders* _tmp61_;
			SoupMessage* _tmp62_;
			SoupMessageHeaders* _tmp63_;
			SoupMessageHeaders* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp20_ = url;
			_tmp21_ = soup_message_new ("GET", _tmp20_);
			message = _tmp21_;
			if (force == 0) {
				GFile* _tmp22_;
				_tmp22_ = destfile;
				if (g_file_query_exists (_tmp22_, NULL)) {
					GFileInfo* info = NULL;
					GFile* _tmp23_;
					GFileInfo* _tmp24_;
					GDateTime* time = NULL;
					GFileInfo* _tmp25_;
					GDateTime* _tmp26_;
					SoupMessage* _tmp27_;
					SoupMessageHeaders* _tmp28_;
					SoupMessageHeaders* _tmp29_;
					GDateTime* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					GFile* _tmp33_;
					_tmp23_ = destfile;
					_tmp24_ = g_file_query_info (_tmp23_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
					info = _tmp24_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (message);
						_g_object_unref0 (input);
						goto __catch0_g_error;
					}
					_tmp25_ = info;
					_tmp26_ = g_file_info_get_modification_date_time (_tmp25_);
					time = _tmp26_;
					_tmp27_ = message;
					_tmp28_ = soup_message_get_request_headers (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = time;
					_tmp31_ = soup_date_time_to_string (_tmp30_, SOUP_DATE_HTTP);
					_tmp32_ = _tmp31_;
					soup_message_headers_append (_tmp29_, "If-Modified-Since", _tmp32_);
					_g_free0 (_tmp32_);
					_tmp33_ = tempfile;
					if (g_file_query_exists (_tmp33_, NULL)) {
						GFile* _tmp34_;
						_tmp34_ = tempfile;
						g_file_delete (_tmp34_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_date_time_unref0 (time);
							_g_object_unref0 (info);
							_g_object_unref0 (message);
							_g_object_unref0 (input);
							goto __catch0_g_error;
						}
					}
					_g_date_time_unref0 (time);
					_g_object_unref0 (info);
				} else {
					GFile* _tmp35_;
					_tmp35_ = tempfile;
					if (g_file_query_exists (_tmp35_, NULL)) {
						GFile* _tmp36_;
						_tmp36_ = tempfile;
						g_file_delete (_tmp36_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (message);
							_g_object_unref0 (input);
							goto __catch0_g_error;
						}
					}
				}
			} else {
				GFile* _tmp37_;
				_tmp37_ = tempfile;
				if (g_file_query_exists (_tmp37_, NULL)) {
					GFile* _tmp38_;
					_tmp38_ = tempfile;
					g_file_delete (_tmp38_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (message);
						_g_object_unref0 (input);
						goto __catch0_g_error;
					}
				}
			}
			_tmp40_ = alpm_utils->soup_session;
			_tmp41_ = message;
			_tmp42_ = soup_session_send (_tmp40_, _tmp41_, NULL, &_inner_error0_);
			_tmp39_ = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (message);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp43_ = _tmp39_;
			_tmp39_ = NULL;
			_g_object_unref0 (input);
			input = _tmp43_;
			_tmp44_ = message;
			g_object_get (_tmp44_, "status-code", &_tmp45_, NULL);
			_tmp46_ = _tmp45_;
			if (_tmp46_ == ((guint) 304)) {
				result = 1;
				_g_object_unref0 (_tmp39_);
				_g_object_unref0 (message);
				_g_object_unref0 (input);
				_g_timer_destroy0 (emit_timer);
				_g_free0 (last_modified);
				_g_free0 (version_release);
				_g_free0 (name);
				_g_object_unref0 (tempfile);
				_g_object_unref0 (destfile);
				_g_free0 (url);
				return result;
			}
			_tmp47_ = message;
			g_object_get (_tmp47_, "status-code", &_tmp48_, NULL);
			_tmp49_ = _tmp48_;
			if (_tmp49_ >= ((guint) 400)) {
				const gchar* _tmp50_;
				_tmp50_ = url;
				if (!g_str_has_suffix (_tmp50_, ".sig")) {
					const gchar* _tmp51_;
					SoupMessage* _tmp52_;
					guint _tmp53_;
					guint _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp51_ = url;
					_tmp52_ = message;
					g_object_get (_tmp52_, "status-code", &_tmp53_, NULL);
					_tmp54_ = _tmp53_;
					_tmp55_ = g_strdup_printf ("%u", _tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strdup_printf ("%s: %s %s", _tmp51_, _ ("Error"), _tmp56_);
					_tmp58_ = _tmp57_;
					pamac_alpm_utils_do_emit_script_output (alpm_utils, _tmp58_);
					_g_free0 (_tmp58_);
					_g_free0 (_tmp56_);
				}
				result = -1;
				_g_object_unref0 (_tmp39_);
				_g_object_unref0 (message);
				_g_object_unref0 (input);
				_g_timer_destroy0 (emit_timer);
				_g_free0 (last_modified);
				_g_free0 (version_release);
				_g_free0 (name);
				_g_object_unref0 (tempfile);
				_g_object_unref0 (destfile);
				_g_free0 (url);
				return result;
			}
			_tmp59_ = message;
			_tmp60_ = soup_message_get_response_headers (_tmp59_);
			_tmp61_ = _tmp60_;
			size = soup_message_headers_get_content_length (_tmp61_);
			_tmp62_ = message;
			_tmp63_ = soup_message_get_response_headers (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = soup_message_headers_get_one (_tmp64_, "Last-Modified");
			_tmp66_ = g_strdup (_tmp65_);
			_g_free0 (last_modified);
			last_modified = _tmp66_;
			_g_object_unref0 (_tmp39_);
			_g_object_unref0 (message);
		} else {
			GFile* file = NULL;
			const gchar* _tmp67_;
			GFile* _tmp68_;
			GFileInfo* new_info = NULL;
			GFile* _tmp69_;
			GFileInfo* _tmp70_;
			GDateTime* new_time = NULL;
			GFileInfo* _tmp71_;
			GDateTime* _tmp72_;
			GDateTime* _tmp73_;
			gchar* _tmp74_;
			GFileInputStream* _tmp88_ = NULL;
			GFile* _tmp89_;
			GFileInputStream* _tmp90_;
			GFileInputStream* _tmp91_;
			_tmp67_ = url;
			_tmp68_ = g_file_new_for_uri (_tmp67_);
			file = _tmp68_;
			_tmp69_ = file;
			_tmp70_ = g_file_query_info (_tmp69_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			new_info = _tmp70_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp71_ = new_info;
			_tmp72_ = g_file_info_get_modification_date_time (_tmp71_);
			new_time = _tmp72_;
			_tmp73_ = new_time;
			_tmp74_ = g_date_time_format_iso8601 (_tmp73_);
			_g_free0 (last_modified);
			last_modified = _tmp74_;
			if (force == 0) {
				GFile* _tmp75_;
				_tmp75_ = destfile;
				if (g_file_query_exists (_tmp75_, NULL)) {
					GFileInfo* old_info = NULL;
					GFile* _tmp76_;
					GFileInfo* _tmp77_;
					GDateTime* old_time = NULL;
					GFileInfo* _tmp78_;
					GDateTime* _tmp79_;
					GTimeSpan elapsed_time = 0LL;
					GDateTime* _tmp80_;
					GDateTime* _tmp81_;
					GFile* _tmp82_;
					_tmp76_ = destfile;
					_tmp77_ = g_file_query_info (_tmp76_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
					old_info = _tmp77_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_date_time_unref0 (new_time);
						_g_object_unref0 (new_info);
						_g_object_unref0 (file);
						_g_object_unref0 (input);
						goto __catch0_g_error;
					}
					_tmp78_ = old_info;
					_tmp79_ = g_file_info_get_modification_date_time (_tmp78_);
					old_time = _tmp79_;
					_tmp80_ = new_time;
					_tmp81_ = old_time;
					elapsed_time = g_date_time_difference (_tmp80_, _tmp81_);
					if (elapsed_time <= ((GTimeSpan) 0)) {
						result = 1;
						_g_date_time_unref0 (old_time);
						_g_object_unref0 (old_info);
						_g_date_time_unref0 (new_time);
						_g_object_unref0 (new_info);
						_g_object_unref0 (file);
						_g_object_unref0 (input);
						_g_timer_destroy0 (emit_timer);
						_g_free0 (last_modified);
						_g_free0 (version_release);
						_g_free0 (name);
						_g_object_unref0 (tempfile);
						_g_object_unref0 (destfile);
						_g_free0 (url);
						return result;
					}
					_tmp82_ = tempfile;
					if (g_file_query_exists (_tmp82_, NULL)) {
						GFile* _tmp83_;
						_tmp83_ = tempfile;
						g_file_delete (_tmp83_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_date_time_unref0 (old_time);
							_g_object_unref0 (old_info);
							_g_date_time_unref0 (new_time);
							_g_object_unref0 (new_info);
							_g_object_unref0 (file);
							_g_object_unref0 (input);
							goto __catch0_g_error;
						}
					}
					_g_date_time_unref0 (old_time);
					_g_object_unref0 (old_info);
				} else {
					GFile* _tmp84_;
					_tmp84_ = tempfile;
					if (g_file_query_exists (_tmp84_, NULL)) {
						GFile* _tmp85_;
						_tmp85_ = tempfile;
						g_file_delete (_tmp85_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_date_time_unref0 (new_time);
							_g_object_unref0 (new_info);
							_g_object_unref0 (file);
							_g_object_unref0 (input);
							goto __catch0_g_error;
						}
					}
				}
			} else {
				GFile* _tmp86_;
				_tmp86_ = tempfile;
				if (g_file_query_exists (_tmp86_, NULL)) {
					GFile* _tmp87_;
					_tmp87_ = tempfile;
					g_file_delete (_tmp87_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_date_time_unref0 (new_time);
						_g_object_unref0 (new_info);
						_g_object_unref0 (file);
						_g_object_unref0 (input);
						goto __catch0_g_error;
					}
				}
			}
			_tmp89_ = file;
			_tmp90_ = g_file_read (_tmp89_, NULL, &_inner_error0_);
			_tmp88_ = _tmp90_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_date_time_unref0 (new_time);
				_g_object_unref0 (new_info);
				_g_object_unref0 (file);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp91_ = _tmp88_;
			_tmp88_ = NULL;
			_g_object_unref0 (input);
			input = (GInputStream*) _tmp91_;
			_g_object_unref0 (_tmp88_);
			_g_date_time_unref0 (new_time);
			_g_object_unref0 (new_info);
			_g_object_unref0 (file);
		}
		if (continue_download) {
			GFileOutputStream* _tmp92_ = NULL;
			GFile* _tmp93_;
			GFileOutputStream* _tmp94_;
			GFileOutputStream* _tmp95_;
			_tmp93_ = tempfile;
			_tmp94_ = g_file_append_to (_tmp93_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp92_ = _tmp94_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (output);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp95_ = _tmp92_;
			_tmp92_ = NULL;
			_g_object_unref0 (output);
			output = _tmp95_;
			_g_object_unref0 (_tmp92_);
		} else {
			GFileOutputStream* _tmp96_ = NULL;
			GFile* _tmp97_;
			GFileOutputStream* _tmp98_;
			GFileOutputStream* _tmp99_;
			_tmp97_ = tempfile;
			_tmp98_ = g_file_create (_tmp97_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp96_ = _tmp98_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (output);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp99_ = _tmp96_;
			_tmp96_ = NULL;
			_g_object_unref0 (output);
			output = _tmp99_;
			_g_object_unref0 (_tmp96_);
		}
		progress = (guint64) 0;
		_tmp100_ = g_new0 (guint8, 8192);
		buf = _tmp100_;
		buf_length1 = 8192;
		_buf_size_ = buf_length1;
		if (emit_signals) {
			gboolean _tmp101_ = FALSE;
			if (g_str_has_suffix (filename, ".db")) {
				_tmp101_ = TRUE;
			} else {
				_tmp101_ = g_str_has_suffix (filename, ".files");
			}
			if (_tmp101_) {
				gchar* filename_copy = NULL;
				gchar* _tmp102_;
				const gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				_tmp102_ = g_strdup (filename);
				filename_copy = _tmp102_;
				g_mutex_lock (&alpm_utils->multi_progress_mutex);
				_tmp103_ = filename_copy;
				_tmp104_ = g_strdup_printf (_ ("Refreshing %s"), _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_strconcat (_tmp105_, "...", NULL);
				_g_free0 (alpm_utils->current_action);
				alpm_utils->current_action = _tmp106_;
				_g_free0 (_tmp105_);
				g_mutex_unlock (&alpm_utils->multi_progress_mutex);
				_g_free0 (filename_copy);
			} else {
				gchar* name_version_release = NULL;
				gchar* _tmp107_;
				const gchar* _tmp108_;
				_tmp107_ = string_slice (filename, (glong) 0, (glong) string_last_index_of_char (filename, (gunichar) '-', 0));
				name_version_release = _tmp107_;
				_tmp108_ = name_version_release;
				if (_tmp108_ != NULL) {
					gchar* name_version = NULL;
					const gchar* _tmp109_;
					const gchar* _tmp110_;
					gchar* _tmp111_;
					const gchar* _tmp112_;
					_tmp109_ = name_version_release;
					_tmp110_ = name_version_release;
					_tmp111_ = string_slice (_tmp109_, (glong) 0, (glong) string_last_index_of_char (_tmp110_, (gunichar) '-', 0));
					name_version = _tmp111_;
					_tmp112_ = name_version;
					if (_tmp112_ != NULL) {
						gint version_index = 0;
						const gchar* _tmp113_;
						gchar* tmp_name = NULL;
						const gchar* _tmp114_;
						gchar* _tmp115_;
						const gchar* _tmp116_;
						_tmp113_ = name_version;
						version_index = string_last_index_of_char (_tmp113_, (gunichar) '-', 0);
						_tmp114_ = name_version;
						_tmp115_ = string_slice (_tmp114_, (glong) 0, (glong) version_index);
						tmp_name = _tmp115_;
						_tmp116_ = tmp_name;
						if (_tmp116_ != NULL) {
							const gchar* _tmp117_;
							gchar* _tmp118_;
							gchar* tmp_version_release = NULL;
							const gchar* _tmp119_;
							const gchar* _tmp120_;
							gint _tmp121_;
							gint _tmp122_;
							gchar* _tmp123_;
							const gchar* _tmp124_;
							_tmp117_ = tmp_name;
							_tmp118_ = g_strdup (_tmp117_);
							_g_free0 (name);
							name = _tmp118_;
							_tmp119_ = name_version_release;
							_tmp120_ = name_version_release;
							_tmp121_ = strlen (_tmp120_);
							_tmp122_ = _tmp121_;
							_tmp123_ = string_slice (_tmp119_, (glong) (version_index + 1), (glong) _tmp122_);
							tmp_version_release = _tmp123_;
							_tmp124_ = tmp_version_release;
							if (_tmp124_ != NULL) {
								const gchar* _tmp125_;
								gchar* _tmp126_;
								_tmp125_ = tmp_version_release;
								_tmp126_ = g_strdup (_tmp125_);
								_g_free0 (version_release);
								version_release = _tmp126_;
								g_mutex_lock (&alpm_utils->multi_progress_mutex);
								if (parallel) {
									const gchar* _tmp127_;
									const gchar* _tmp128_;
									gchar* _tmp129_;
									gchar* _tmp130_;
									gchar* _tmp131_;
									_tmp127_ = name;
									_tmp128_ = version_release;
									_tmp129_ = g_strdup_printf ("%s (%s)", _tmp127_, _tmp128_);
									_tmp130_ = _tmp129_;
									_tmp131_ = g_strdup_printf (_ ("Download of %s started"), _tmp130_);
									_g_free0 (alpm_utils->current_action);
									alpm_utils->current_action = _tmp131_;
									_g_free0 (_tmp130_);
								} else {
									const gchar* _tmp132_;
									const gchar* _tmp133_;
									gchar* _tmp134_;
									gchar* _tmp135_;
									gchar* _tmp136_;
									gchar* _tmp137_;
									gchar* _tmp138_;
									_tmp132_ = name;
									_tmp133_ = version_release;
									_tmp134_ = g_strdup_printf ("%s (%s)", _tmp132_, _tmp133_);
									_tmp135_ = _tmp134_;
									_tmp136_ = g_strdup_printf (_ ("Downloading %s"), _tmp135_);
									_tmp137_ = _tmp136_;
									_tmp138_ = g_strconcat (_tmp137_, "...", NULL);
									_g_free0 (alpm_utils->current_action);
									alpm_utils->current_action = _tmp138_;
									_g_free0 (_tmp137_);
									_g_free0 (_tmp135_);
								}
								g_mutex_unlock (&alpm_utils->multi_progress_mutex);
							}
							_g_free0 (tmp_version_release);
						}
						_g_free0 (tmp_name);
					}
					_g_free0 (name_version);
				}
				_g_free0 (name_version_release);
			}
			cb_download (alpm_utils, filename, (guint64) 0, (guint64) size);
		}
		if (emit_signals) {
			GTimer* _tmp139_;
			_tmp139_ = emit_timer;
			g_timer_start (_tmp139_);
		}
		while (TRUE) {
			gssize read = 0L;
			GInputStream* _tmp140_;
			guint8* _tmp141_;
			gint _tmp141__length1;
			GCancellable* _tmp142_;
			GFileOutputStream* _tmp143_;
			guint8* _tmp144_;
			gint _tmp144__length1;
			GCancellable* _tmp145_;
			gboolean _tmp146_ = FALSE;
			_tmp140_ = input;
			_tmp141_ = buf;
			_tmp141__length1 = buf_length1;
			_tmp142_ = alpm_utils->cancellable;
			read = g_input_stream_read (_tmp140_, _tmp141_, (gsize) _tmp141__length1, _tmp142_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (output);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			if (read == ((gssize) 0)) {
				break;
			}
			_tmp143_ = output;
			_tmp144_ = buf;
			_tmp144__length1 = buf_length1;
			g_output_stream_write ((GOutputStream*) _tmp143_, _tmp144_ + 0, (gsize) (((gint) read) - 0), NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (output);
				_g_object_unref0 (input);
				goto __catch0_g_error;
			}
			_tmp145_ = alpm_utils->cancellable;
			if (g_cancellable_is_cancelled (_tmp145_)) {
				break;
			}
			progress += (guint64) read;
			if (emit_signals) {
				GTimer* _tmp147_;
				_tmp147_ = emit_timer;
				_tmp146_ = g_timer_elapsed (_tmp147_, NULL) > 0.1;
			} else {
				_tmp146_ = FALSE;
			}
			if (_tmp146_) {
				GTimer* _tmp148_;
				cb_download (alpm_utils, filename, progress, (guint64) size);
				_tmp148_ = emit_timer;
				g_timer_start (_tmp148_);
			}
		}
		buf = (g_free (buf), NULL);
		_g_object_unref0 (output);
		_g_object_unref0 (input);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp149_;
		GTimer* _tmp155_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp149_ = e;
		if (_tmp149_->code != G_IO_ERROR_CANCELLED) {
			const gchar* _tmp150_;
			GError* _tmp151_;
			const gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			_tmp150_ = url;
			_tmp151_ = e;
			_tmp152_ = _tmp151_->message;
			_tmp153_ = g_strdup_printf ("%s: %s", _tmp150_, _tmp152_);
			_tmp154_ = _tmp153_;
			pamac_alpm_utils_do_emit_script_output (alpm_utils, _tmp154_);
			_g_free0 (_tmp154_);
		}
		_tmp155_ = emit_timer;
		g_timer_stop (_tmp155_);
		if (remove_partial_download) {
			{
				GFile* _tmp156_;
				_tmp156_ = tempfile;
				if (g_file_query_exists (_tmp156_, NULL)) {
					GFile* _tmp157_;
					_tmp157_ = tempfile;
					g_file_delete (_tmp157_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp158_;
				const gchar* _tmp159_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp158_ = e;
				_tmp159_ = _tmp158_->message;
				g_warning ("alpm_utils.vala:2831: %s", _tmp159_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp160_ = -1;
				_g_error_free0 (e);
				_g_timer_destroy0 (emit_timer);
				_g_free0 (last_modified);
				_g_free0 (version_release);
				_g_free0 (name);
				_g_object_unref0 (tempfile);
				_g_object_unref0 (destfile);
				_g_free0 (url);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp160_;
			}
		}
		result = -1;
		_g_error_free0 (e);
		_g_timer_destroy0 (emit_timer);
		_g_free0 (last_modified);
		_g_free0 (version_release);
		_g_free0 (name);
		_g_object_unref0 (tempfile);
		_g_object_unref0 (destfile);
		_g_free0 (url);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp161_ = -1;
		_g_timer_destroy0 (emit_timer);
		_g_free0 (last_modified);
		_g_free0 (version_release);
		_g_free0 (name);
		_g_object_unref0 (tempfile);
		_g_object_unref0 (destfile);
		_g_free0 (url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp161_;
	}
	if (emit_signals) {
		GTimer* _tmp162_;
		gboolean _tmp163_ = FALSE;
		gboolean _tmp164_ = FALSE;
		_tmp162_ = emit_timer;
		g_timer_stop (_tmp162_);
		if (parallel) {
			const gchar* _tmp165_;
			_tmp165_ = name;
			_tmp164_ = g_strcmp0 (_tmp165_, "") != 0;
		} else {
			_tmp164_ = FALSE;
		}
		if (_tmp164_) {
			const gchar* _tmp166_;
			_tmp166_ = version_release;
			_tmp163_ = g_strcmp0 (_tmp166_, "") != 0;
		} else {
			_tmp163_ = FALSE;
		}
		if (_tmp163_) {
			const gchar* _tmp167_;
			const gchar* _tmp168_;
			gchar* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			g_mutex_lock (&alpm_utils->multi_progress_mutex);
			_tmp167_ = name;
			_tmp168_ = version_release;
			_tmp169_ = g_strdup_printf ("%s (%s)", _tmp167_, _tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = g_strdup_printf (_ ("Download of %s finished"), _tmp170_);
			_g_free0 (alpm_utils->current_action);
			alpm_utils->current_action = _tmp171_;
			_g_free0 (_tmp170_);
			g_mutex_unlock (&alpm_utils->multi_progress_mutex);
		}
		cb_download (alpm_utils, filename, (guint64) size, (guint64) size);
	}
	{
		GFile* _tmp172_;
		GFile* _tmp173_;
		const gchar* _tmp174_;
		_tmp172_ = tempfile;
		_tmp173_ = destfile;
		g_file_move (_tmp172_, _tmp173_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp174_ = last_modified;
		if (_tmp174_ != NULL) {
			GDateTime* datetime = NULL;
			const gchar* _tmp175_;
			GDateTime* _tmp176_;
			GFileInfo* info = NULL;
			GFile* _tmp177_;
			GFileInfo* _tmp178_;
			GFileInfo* _tmp179_;
			GDateTime* _tmp180_;
			GFile* _tmp181_;
			GFileInfo* _tmp182_;
			_tmp175_ = last_modified;
			_tmp176_ = soup_date_time_new_from_http_string (_tmp175_);
			datetime = _tmp176_;
			_tmp177_ = destfile;
			_tmp178_ = g_file_query_info (_tmp177_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp178_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_date_time_unref0 (datetime);
				goto __catch2_g_error;
			}
			_tmp179_ = info;
			_tmp180_ = datetime;
			g_file_info_set_modification_date_time (_tmp179_, _tmp180_);
			_tmp181_ = destfile;
			_tmp182_ = info;
			g_file_set_attributes_from_info (_tmp181_, _tmp182_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_date_time_unref0 (datetime);
				goto __catch2_g_error;
			}
			_g_object_unref0 (info);
			_g_date_time_unref0 (datetime);
		}
		result = 0;
		_g_timer_destroy0 (emit_timer);
		_g_free0 (last_modified);
		_g_free0 (version_release);
		_g_free0 (name);
		_g_object_unref0 (tempfile);
		_g_object_unref0 (destfile);
		_g_free0 (url);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp183_;
		const gchar* _tmp184_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp183_ = e;
		_tmp184_ = _tmp183_->message;
		g_warning ("alpm_utils.vala:2858: %s", _tmp184_);
		result = -1;
		_g_error_free0 (e);
		_g_timer_destroy0 (emit_timer);
		_g_free0 (last_modified);
		_g_free0 (version_release);
		_g_free0 (name);
		_g_object_unref0 (tempfile);
		_g_object_unref0 (destfile);
		_g_free0 (url);
		return result;
	}
	__finally2:
	_g_timer_destroy0 (emit_timer);
	_g_free0 (last_modified);
	_g_free0 (version_release);
	_g_free0 (name);
	_g_object_unref0 (tempfile);
	_g_object_unref0 (destfile);
	_g_free0 (url);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp185_;
}

void
cb_log (void* ctx,
        alpm_loglevel_t level,
        const gchar* fmt,
        va_list args)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	PamacAlpmUtils* _tmp1_;
	GCancellable* _tmp2_;
	alpm_loglevel_t logmask = 0;
	gchar* log = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (fmt != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils));
	alpm_utils = _tmp0_;
	_tmp1_ = alpm_utils;
	_tmp2_ = _tmp1_->cancellable;
	if (g_cancellable_is_cancelled (_tmp2_)) {
		_g_object_unref0 (alpm_utils);
		return;
	}
	logmask = ALPM_LOG_ERROR | ALPM_LOG_WARNING;
	if ((level & logmask) == 0) {
		_g_object_unref0 (alpm_utils);
		return;
	}
	log = NULL;
	_tmp3_ = g_strdup_vprintf (fmt, args);
	_g_free0 (log);
	log = _tmp3_;
	_tmp4_ = log;
	if (_tmp4_ != NULL) {
		PamacAlpmUtils* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = alpm_utils;
		_tmp6_ = log;
		pamac_alpm_utils_emit_log (_tmp5_, (guint) level, _tmp6_);
	}
	_g_free0 (log);
	_g_object_unref0 (alpm_utils);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

