/* pamac_config.c generated by valac 0.56.16, the Vala compiler
 * generated from pamac_config.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pamac.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_DAEMON (pamac_daemon_get_type ())
#define PAMAC_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_DAEMON, PamacDaemon))
#define PAMAC_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_DAEMON))
#define PAMAC_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_DAEMON, PamacDaemonIface))

typedef struct _PamacDaemon PamacDaemon;
typedef struct _PamacDaemonIface PamacDaemonIface;

#define PAMAC_TYPE_DAEMON_PROXY (pamac_daemon_proxy_get_type ())

#define PAMAC_TYPE_PLUGIN_LOADER (pamac_plugin_loader_get_type ())
#define PAMAC_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoader))
#define PAMAC_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoaderClass))
#define PAMAC_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PLUGIN_LOADER))
#define PAMAC_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PLUGIN_LOADER))
#define PAMAC_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoaderClass))

typedef struct _PamacPluginLoader PamacPluginLoader;
typedef struct _PamacPluginLoaderClass PamacPluginLoaderClass;

#define PAMAC_TYPE_AUR_PLUGIN (pamac_aur_plugin_get_type ())
#define PAMAC_AUR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_AUR_PLUGIN, PamacAURPlugin))
#define PAMAC_IS_AUR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_AUR_PLUGIN))
#define PAMAC_AUR_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_AUR_PLUGIN, PamacAURPluginIface))

typedef struct _PamacAURPlugin PamacAURPlugin;
typedef struct _PamacAURPluginIface PamacAURPluginIface;

#define PAMAC_TYPE_AUR_INFOS (pamac_aur_infos_get_type ())
#define PAMAC_AUR_INFOS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_AUR_INFOS, PamacAURInfos))
#define PAMAC_AUR_INFOS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_AUR_INFOS, PamacAURInfosClass))
#define PAMAC_IS_AUR_INFOS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_AUR_INFOS))
#define PAMAC_IS_AUR_INFOS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_AUR_INFOS))
#define PAMAC_AUR_INFOS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_AUR_INFOS, PamacAURInfosClass))

typedef struct _PamacAURInfos PamacAURInfos;
typedef struct _PamacAURInfosClass PamacAURInfosClass;

#define PAMAC_TYPE_APPSTREAM_PLUGIN (pamac_appstream_plugin_get_type ())
#define PAMAC_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPlugin))
#define PAMAC_IS_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN))
#define PAMAC_APPSTREAM_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPluginIface))

typedef struct _PamacAppstreamPlugin PamacAppstreamPlugin;
typedef struct _PamacAppstreamPluginIface PamacAppstreamPluginIface;

#define PAMAC_TYPE_APP (pamac_app_get_type ())
#define PAMAC_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APP, PamacApp))
#define PAMAC_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_APP, PamacAppClass))
#define PAMAC_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APP))
#define PAMAC_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_APP))
#define PAMAC_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_APP, PamacAppClass))

typedef struct _PamacApp PamacApp;
typedef struct _PamacAppClass PamacAppClass;

#define PAMAC_TYPE_SNAP_PLUGIN (pamac_snap_plugin_get_type ())
#define PAMAC_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPlugin))
#define PAMAC_IS_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PLUGIN))
#define PAMAC_SNAP_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPluginIface))

typedef struct _PamacSnapPlugin PamacSnapPlugin;
typedef struct _PamacSnapPluginIface PamacSnapPluginIface;

#define PAMAC_TYPE_FLATPAK_PLUGIN (pamac_flatpak_plugin_get_type ())
#define PAMAC_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPlugin))
#define PAMAC_IS_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN))
#define PAMAC_FLATPAK_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPluginIface))

typedef struct _PamacFlatpakPlugin PamacFlatpakPlugin;
typedef struct _PamacFlatpakPluginIface PamacFlatpakPluginIface;

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
enum  {
	PAMAC_CONFIG_0_PROPERTY,
	PAMAC_CONFIG_CONF_PATH_PROPERTY,
	PAMAC_CONFIG_RECURSE_PROPERTY,
	PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY,
	PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY,
	PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY,
	PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY,
	PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY,
	PAMAC_CONFIG_SUPPORT_AUR_PROPERTY,
	PAMAC_CONFIG_ENABLE_AUR_PROPERTY,
	PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY,
	PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY,
	PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY,
	PAMAC_CONFIG_ENABLE_SNAP_PROPERTY,
	PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY,
	PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY,
	PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY,
	PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY,
	PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY,
	PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY,
	PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY,
	PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY,
	PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY,
	PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY,
	PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY,
	PAMAC_CONFIG_ENVIRONMENT_VARIABLES_PROPERTY,
	PAMAC_CONFIG_DB_PATH_PROPERTY,
	PAMAC_CONFIG_CHECKSPACE_PROPERTY,
	PAMAC_CONFIG_IGNOREPKGS_PROPERTY,
	PAMAC_CONFIG_ALPM_CONFIG_PROPERTY,
	PAMAC_CONFIG_NUM_PROPERTIES
};
static GParamSpec* pamac_config_properties[PAMAC_CONFIG_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alpm_config_unref0(var) ((var == NULL) ? NULL : (var = (alpm_config_unref (var), NULL)))
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PamacDaemonIface {
	GTypeInterface parent_iface;
	gchar* (*get_sender) (PamacDaemon* self, GError** error);
	gchar* (*get_lockfile) (PamacDaemon* self, GError** error);
	void (*set_environment_variables) (PamacDaemon* self, GHashTable* variables, GError** error);
	void (*start_get_authorization) (PamacDaemon* self, GError** error);
	void (*remove_authorization) (PamacDaemon* self, GError** error);
	void (*start_write_alpm_config) (PamacDaemon* self, GHashTable* new_alpm_conf, GError** error);
	void (*start_write_pamac_config) (PamacDaemon* self, GHashTable* new_pamac_conf, GError** error);
	void (*start_generate_mirrors_list) (PamacDaemon* self, const gchar* country, GError** error);
	void (*start_clean_cache) (PamacDaemon* self, gchar** filenames, gint filenames_length1, GError** error);
	void (*start_clean_build_files) (PamacDaemon* self, const gchar* aur_build_dir, GError** error);
	void (*start_set_pkgreason) (PamacDaemon* self, const gchar* pkgname, guint reason, GError** error);
	void (*start_download_updates) (PamacDaemon* self, GError** error);
	void (*start_download_pkgs) (PamacDaemon* self, gchar** urls, gint urls_length1, GError** error);
	void (*start_trans_refresh) (PamacDaemon* self, gboolean force, GError** error);
	void (*start_trans_run) (PamacDaemon* self, gboolean sysupgrade, gboolean enable_downgrade, gboolean simple_install, gboolean keep_built_pkgs, gint trans_flags, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_load_local, gint to_load_local_length1, gchar** to_load_remote, gint to_load_remote_length1, gchar** to_install_as_dep, gint to_install_as_dep_length1, gchar** ignorepkgs, gint ignorepkgs_length1, gchar** overwrite_files, gint overwrite_files_length1, GError** error);
	void (*trans_cancel) (PamacDaemon* self, GError** error);
	void (*quit) (PamacDaemon* self, GError** error);
	void (*start_snap_trans_run) (PamacDaemon* self, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, GError** error);
	void (*start_snap_switch_channel) (PamacDaemon* self, const gchar* snap_name, const gchar* channel, GError** error);
	void (*start_flatpak_trans_run) (PamacDaemon* self, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1, GError** error);
};

struct _PamacAURPluginIface {
	GTypeInterface parent_iface;
	void (*set_real_build_dir) (PamacAURPlugin* self, const gchar* config_aur_build_dir);
	const gchar* (*get_real_build_dir) (PamacAURPlugin* self);
	gboolean (*update_db) (PamacAURPlugin* self, gboolean force_refresh, gboolean emit_signal);
	PamacAURInfos* (*get_infos) (PamacAURPlugin* self, const gchar* pkgname);
	GPtrArray* (*get_multi_infos) (PamacAURPlugin* self, GPtrArray* pkgnames);
	GPtrArray* (*get_providers) (PamacAURPlugin* self, const gchar* depend);
	GPtrArray* (*search) (PamacAURPlugin* self, const gchar* search_string);
};

struct _PamacAppstreamPluginIface {
	GTypeInterface parent_iface;
	void (*load) (PamacAppstreamPlugin* self, GPtrArray* repos_names);
	GPtrArray* (*get_apps) (PamacAppstreamPlugin* self);
	GPtrArray* (*search) (PamacAppstreamPlugin* self, gchar** search_tokens, gint search_tokens_length1);
	GPtrArray* (*get_pkgname_apps) (PamacAppstreamPlugin* self, const gchar* pkgname);
	GHashTable* (*get_category_apps) (PamacAppstreamPlugin* self, const gchar* category);
};

struct _PamacSnapPluginIface {
	GTypeInterface parent_iface;
	void (*search_snaps) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_snaps_sync) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	gboolean (*is_installed_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap_by_app_id) (PamacSnapPlugin* self, const gchar* app_id);
	void (*get_installed_snaps) (PamacSnapPlugin* self, GPtrArray** pkgs);
	gchar* (*get_installed_snap_icon) (PamacSnapPlugin* self, const gchar* name, GError** error);
	void (*get_category_snaps) (PamacSnapPlugin* self, const gchar* category, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacSnapPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1);
	gboolean (*switch_channel) (PamacSnapPlugin* self, const gchar* sender, const gchar* name, const gchar* channel);
	void (*trans_cancel) (PamacSnapPlugin* self, const gchar* sender);
	void (*refresh) (PamacSnapPlugin* self);
};

struct _PamacFlatpakPluginIface {
	GTypeInterface parent_iface;
	gboolean (*refresh_appstream_data) (PamacFlatpakPlugin* self);
	void (*load_appstream_data) (PamacFlatpakPlugin* self);
	void (*get_remotes_names) (PamacFlatpakPlugin* self, GPtrArray** remotes_names);
	void (*search_flatpaks) (PamacFlatpakPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_flatpaks_sync) (PamacFlatpakPlugin* self, gchar** search_terms, gint search_terms_length1, GPtrArray** pkgs);
	gboolean (*is_installed_flatpak) (PamacFlatpakPlugin* self, const gchar* name);
	PamacFlatpakPackage* (*get_flatpak_by_app_id) (PamacFlatpakPlugin* self, const gchar* app_id);
	PamacFlatpakPackage* (*get_flatpak) (PamacFlatpakPlugin* self, const gchar* id);
	void (*get_installed_flatpaks) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	void (*get_category_flatpaks) (PamacFlatpakPlugin* self, const gchar* category, GPtrArray** pkgs);
	void (*get_flatpak_updates) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacFlatpakPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1);
	void (*trans_cancel) (PamacFlatpakPlugin* self, const gchar* sender);
	void (*refresh) (PamacFlatpakPlugin* self);
	guint64 (*get_refresh_period) (PamacFlatpakPlugin* self);
	void (*set_refresh_period) (PamacFlatpakPlugin* self, guint64 value);
};

struct _PamacConfigPrivate {
	GHashTable* environment_variables_priv;
	PamacDaemon* system_daemon;
	gboolean _support_aur;
	gboolean _support_appstream;
	gboolean _support_snap;
	gboolean _support_flatpak;
	gboolean _enable_aur;
	gboolean _enable_appstream;
	gboolean _enable_snap;
	gboolean _enable_flatpak;
	gboolean _check_aur_updates;
	gboolean _download_updates;
	gchar* _conf_path;
	gboolean _recurse;
	gboolean _keep_built_pkgs;
	gboolean _enable_downgrade;
	gboolean _simple_install;
	guint64 _refresh_period;
	gboolean _no_update_hide_icon;
	PamacPluginLoader* aur_plugin_loader;
	PamacPluginLoader* appstream_plugin_loader;
	PamacPluginLoader* snap_plugin_loader;
	gboolean _check_flatpak_updates;
	PamacPluginLoader* flatpak_plugin_loader;
	gchar* _aur_build_dir;
	gboolean _check_aur_vcs_updates;
	gboolean _offline_upgrade;
	guint64 _max_parallel_downloads;
	guint64 _clean_keep_num_pkgs;
	gboolean _clean_rm_only_uninstalled;
	AlpmConfig* _alpm_config;
};

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gchar* dbpath;
	gboolean checkspace;
	GHashTable* ignorepkgs;
	GHashTable* holdpkgs;
	GHashTable* syncfirsts;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

static gint PamacConfig_private_offset;
static gpointer pamac_config_parent_class = NULL;

VALA_EXTERN GType pamac_daemon_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pamac_daemon_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType pamac_daemon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_plugin_loader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_aur_infos_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_aur_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_app_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_appstream_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_snap_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_flatpak_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AlpmConfig* pamac_config_get_alpm_config (PamacConfig* self);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
static void pamac_config_parse_file (PamacConfig* self,
                              const gchar* path);
VALA_EXTERN PamacAURPlugin* pamac_config_get_aur_plugin (PamacConfig* self);
VALA_EXTERN gpointer pamac_plugin_loader_get_plugin (PamacPluginLoader* self);
VALA_EXTERN PamacAppstreamPlugin* pamac_config_get_appstream_plugin (PamacConfig* self);
VALA_EXTERN PamacSnapPlugin* pamac_config_get_snap_plugin (PamacConfig* self);
VALA_EXTERN PamacFlatpakPlugin* pamac_config_get_flatpak_plugin (PamacConfig* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN void pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                            GHashTable* new_pamac_conf,
                                            GError** error);
VALA_EXTERN void pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                           GHashTable* new_alpm_conf,
                                           GError** error);
static void pamac_config_set_support_aur (PamacConfig* self,
                                   gboolean value);
static void pamac_config_set_support_appstream (PamacConfig* self,
                                         gboolean value);
static void pamac_config_set_support_snap (PamacConfig* self,
                                    gboolean value);
static void pamac_config_set_alpm_config (PamacConfig* self,
                                   AlpmConfig* value);
static GObject * pamac_config_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN AlpmConfig* alpm_config_construct (GType object_type,
                                   const gchar* path);
VALA_EXTERN PamacPluginLoader* pamac_plugin_loader_new (GType t_type,
                                            GBoxedCopyFunc t_dup_func,
                                            GDestroyNotify t_destroy_func,
                                            const gchar* name);
VALA_EXTERN PamacPluginLoader* pamac_plugin_loader_construct (GType object_type,
                                                  GType t_type,
                                                  GBoxedCopyFunc t_dup_func,
                                                  GDestroyNotify t_destroy_func,
                                                  const gchar* name);
VALA_EXTERN gboolean pamac_plugin_loader_load (PamacPluginLoader* self);
static void pamac_config_finalize (GObject * obj);
static GType pamac_config_get_type_once (void);
static void _vala_pamac_config_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_pamac_config_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_config_get_instance_private (PamacConfig* self)
{
	return G_STRUCT_MEMBER_P (self, PamacConfig_private_offset);
}

PamacConfig*
pamac_config_construct (GType object_type,
                        const gchar* conf_path)
{
	PamacConfig * self = NULL;
	g_return_val_if_fail (conf_path != NULL, NULL);
	self = (PamacConfig*) g_object_new (object_type, "conf-path", conf_path, NULL);
	return self;
}

PamacConfig*
pamac_config_new (const gchar* conf_path)
{
	return pamac_config_construct (PAMAC_TYPE_CONFIG, conf_path);
}

void
pamac_config_add_ignorepkg (PamacConfig* self,
                            const gchar* name)
{
	AlpmConfig* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp1_ = _tmp0_->ignorepkgs;
	_tmp2_ = g_strdup (name);
	g_hash_table_add (_tmp1_, _tmp2_);
}

void
pamac_config_remove_ignorepkg (PamacConfig* self,
                               const gchar* name)
{
	AlpmConfig* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp1_ = _tmp0_->ignorepkgs;
	g_hash_table_remove (_tmp1_, name);
}

void
pamac_config_reload (PamacConfig* self)
{
	AlpmConfig* _tmp0_;
	const gchar* _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alpm_config;
	alpm_config_reload (_tmp0_);
	pamac_config_set_recurse (self, FALSE);
	pamac_config_set_keep_built_pkgs (self, FALSE);
	pamac_config_set_enable_downgrade (self, FALSE);
	pamac_config_set_simple_install (self, FALSE);
	pamac_config_set_refresh_period (self, (guint64) 6);
	pamac_config_set_no_update_hide_icon (self, FALSE);
	pamac_config_set_enable_aur (self, FALSE);
	pamac_config_set_enable_appstream (self, TRUE);
	pamac_config_set_enable_snap (self, FALSE);
	pamac_config_set_enable_flatpak (self, FALSE);
	pamac_config_set_aur_build_dir (self, "/var/tmp");
	pamac_config_set_download_updates (self, FALSE);
	pamac_config_set_max_parallel_downloads (self, (guint64) 1);
	pamac_config_set_clean_keep_num_pkgs (self, (guint64) 3);
	pamac_config_set_clean_rm_only_uninstalled (self, FALSE);
	_tmp1_ = self->priv->_conf_path;
	pamac_config_parse_file (self, _tmp1_);
	_tmp2_ = self->priv->_max_parallel_downloads;
	if (_tmp2_ > ((guint64) 10)) {
		pamac_config_set_max_parallel_downloads (self, (guint64) 10);
	}
	_tmp3_ = self->priv->_refresh_period;
	if (_tmp3_ > ((guint64) 168)) {
		pamac_config_set_refresh_period (self, (guint64) 168);
	}
}

PamacAURPlugin*
pamac_config_get_aur_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	PamacAURPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pamac_config_get_support_aur (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PamacPluginLoader* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->aur_plugin_loader;
		_tmp3_ = pamac_plugin_loader_get_plugin (_tmp2_);
		result = (PamacAURPlugin*) _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

PamacAppstreamPlugin*
pamac_config_get_appstream_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	PamacAppstreamPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pamac_config_get_support_appstream (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PamacPluginLoader* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->appstream_plugin_loader;
		_tmp3_ = pamac_plugin_loader_get_plugin (_tmp2_);
		result = (PamacAppstreamPlugin*) _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

PamacSnapPlugin*
pamac_config_get_snap_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	PamacSnapPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pamac_config_get_support_snap (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PamacPluginLoader* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->snap_plugin_loader;
		_tmp3_ = pamac_plugin_loader_get_plugin (_tmp2_);
		result = (PamacSnapPlugin*) _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

PamacFlatpakPlugin*
pamac_config_get_flatpak_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	PamacFlatpakPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pamac_config_get_support_flatpak (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PamacPluginLoader* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->flatpak_plugin_loader;
		_tmp3_ = pamac_plugin_loader_get_plugin (_tmp2_);
		result = (PamacFlatpakPlugin*) _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static void
pamac_config_parse_file (PamacConfig* self,
                         const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	_tmp1_ = file;
	if (g_file_query_exists (_tmp1_, NULL)) {
		{
			GFileInputStream* _tmp2_ = NULL;
			GFile* _tmp3_;
			GFileInputStream* _tmp4_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp5_;
			gchar* line = NULL;
			_tmp3_ = file;
			_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
			dis = _tmp5_;
			while (TRUE) {
				gchar* _tmp6_ = NULL;
				GDataInputStream* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar** splitted = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				const gchar* key = NULL;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp7_ = dis;
				_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp2_);
					goto __catch0_g_error;
				}
				_tmp9_ = _tmp6_;
				_tmp6_ = NULL;
				_g_free0 (line);
				line = _tmp9_;
				_tmp10_ = line;
				if (!(_tmp10_ != NULL)) {
					_g_free0 (_tmp6_);
					break;
				}
				_tmp11_ = line;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == 0) {
					_g_free0 (_tmp6_);
					continue;
				}
				_tmp14_ = line;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "#", 2);
				splitted = _tmp16_;
				splitted_length1 = _vala_array_length (_tmp15_);
				_splitted_size_ = splitted_length1;
				_tmp17_ = splitted;
				_tmp17__length1 = splitted_length1;
				_tmp18_ = _tmp17_[0];
				_tmp19_ = string_strip (_tmp18_);
				_g_free0 (line);
				line = _tmp19_;
				_tmp20_ = line;
				_tmp21_ = strlen (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == 0) {
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp6_);
					continue;
				}
				_tmp23_ = line;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "=", 2);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				splitted = _tmp25_;
				splitted_length1 = _vala_array_length (_tmp24_);
				_splitted_size_ = splitted_length1;
				_tmp26_ = splitted;
				_tmp26__length1 = splitted_length1;
				_tmp27_ = _tmp26_[0];
				_tmp28_ = g_strstrip (_tmp27_);
				key = _tmp28_;
				_tmp29_ = key;
				if (g_strcmp0 (_tmp29_, "RemoveUnrequiredDeps") == 0) {
					pamac_config_set_recurse (self, TRUE);
				} else {
					const gchar* _tmp30_;
					_tmp30_ = key;
					if (g_strcmp0 (_tmp30_, "EnableDowngrade") == 0) {
						pamac_config_set_enable_downgrade (self, TRUE);
					} else {
						const gchar* _tmp31_;
						_tmp31_ = key;
						if (g_strcmp0 (_tmp31_, "SimpleInstall") == 0) {
							pamac_config_set_simple_install (self, TRUE);
						} else {
							const gchar* _tmp32_;
							_tmp32_ = key;
							if (g_strcmp0 (_tmp32_, "RefreshPeriod") == 0) {
								gchar** _tmp33_;
								gint _tmp33__length1;
								_tmp33_ = splitted;
								_tmp33__length1 = splitted_length1;
								if (_tmp33__length1 == 2) {
									const gchar* val = NULL;
									gchar** _tmp34_;
									gint _tmp34__length1;
									const gchar* _tmp35_;
									const gchar* _tmp36_;
									const gchar* _tmp37_;
									_tmp34_ = splitted;
									_tmp34__length1 = splitted_length1;
									_tmp35_ = _tmp34_[1];
									_tmp36_ = g_strstrip (_tmp35_);
									val = _tmp36_;
									_tmp37_ = val;
									pamac_config_set_refresh_period (self, uint64_parse (_tmp37_, (guint) 0));
								}
							} else {
								const gchar* _tmp38_;
								_tmp38_ = key;
								if (g_strcmp0 (_tmp38_, "KeepNumPackages") == 0) {
									gchar** _tmp39_;
									gint _tmp39__length1;
									_tmp39_ = splitted;
									_tmp39__length1 = splitted_length1;
									if (_tmp39__length1 == 2) {
										const gchar* val = NULL;
										gchar** _tmp40_;
										gint _tmp40__length1;
										const gchar* _tmp41_;
										const gchar* _tmp42_;
										const gchar* _tmp43_;
										_tmp40_ = splitted;
										_tmp40__length1 = splitted_length1;
										_tmp41_ = _tmp40_[1];
										_tmp42_ = g_strstrip (_tmp41_);
										val = _tmp42_;
										_tmp43_ = val;
										pamac_config_set_clean_keep_num_pkgs (self, uint64_parse (_tmp43_, (guint) 0));
									}
								} else {
									const gchar* _tmp44_;
									_tmp44_ = key;
									if (g_strcmp0 (_tmp44_, "OnlyRmUninstalled") == 0) {
										pamac_config_set_clean_rm_only_uninstalled (self, TRUE);
									} else {
										const gchar* _tmp45_;
										_tmp45_ = key;
										if (g_strcmp0 (_tmp45_, "NoUpdateHideIcon") == 0) {
											pamac_config_set_no_update_hide_icon (self, TRUE);
										} else {
											const gchar* _tmp46_;
											_tmp46_ = key;
											if (g_strcmp0 (_tmp46_, "EnableAUR") == 0) {
												pamac_config_set_enable_aur (self, TRUE);
											} else {
												const gchar* _tmp47_;
												_tmp47_ = key;
												if (g_strcmp0 (_tmp47_, "KeepBuiltPkgs") == 0) {
													pamac_config_set_keep_built_pkgs (self, TRUE);
												} else {
													const gchar* _tmp48_;
													_tmp48_ = key;
													if (g_strcmp0 (_tmp48_, "EnableSnap") == 0) {
														pamac_config_set_enable_snap (self, TRUE);
													} else {
														const gchar* _tmp49_;
														_tmp49_ = key;
														if (g_strcmp0 (_tmp49_, "EnableFlatpak") == 0) {
															pamac_config_set_enable_flatpak (self, TRUE);
														} else {
															const gchar* _tmp50_;
															_tmp50_ = key;
															if (g_strcmp0 (_tmp50_, "CheckFlatpakUpdates") == 0) {
																pamac_config_set_check_flatpak_updates (self, TRUE);
															} else {
																const gchar* _tmp51_;
																_tmp51_ = key;
																if (g_strcmp0 (_tmp51_, "BuildDirectory") == 0) {
																	gchar** _tmp52_;
																	gint _tmp52__length1;
																	_tmp52_ = splitted;
																	_tmp52__length1 = splitted_length1;
																	if (_tmp52__length1 == 2) {
																		gchar** _tmp53_;
																		gint _tmp53__length1;
																		const gchar* _tmp54_;
																		const gchar* _tmp55_;
																		_tmp53_ = splitted;
																		_tmp53__length1 = splitted_length1;
																		_tmp54_ = _tmp53_[1];
																		_tmp55_ = g_strstrip (_tmp54_);
																		pamac_config_set_aur_build_dir (self, _tmp55_);
																	}
																} else {
																	const gchar* _tmp56_;
																	_tmp56_ = key;
																	if (g_strcmp0 (_tmp56_, "CheckAURUpdates") == 0) {
																		pamac_config_set_check_aur_updates (self, TRUE);
																	} else {
																		const gchar* _tmp57_;
																		_tmp57_ = key;
																		if (g_strcmp0 (_tmp57_, "CheckAURVCSUpdates") == 0) {
																			pamac_config_set_check_aur_vcs_updates (self, TRUE);
																		} else {
																			const gchar* _tmp58_;
																			_tmp58_ = key;
																			if (g_strcmp0 (_tmp58_, "DownloadUpdates") == 0) {
																				pamac_config_set_download_updates (self, TRUE);
																			} else {
																				const gchar* _tmp59_;
																				_tmp59_ = key;
																				if (g_strcmp0 (_tmp59_, "OfflineUpgrade") == 0) {
																					pamac_config_set_offline_upgrade (self, TRUE);
																				} else {
																					const gchar* _tmp60_;
																					_tmp60_ = key;
																					if (g_strcmp0 (_tmp60_, "MaxParallelDownloads") == 0) {
																						gchar** _tmp61_;
																						gint _tmp61__length1;
																						_tmp61_ = splitted;
																						_tmp61__length1 = splitted_length1;
																						if (_tmp61__length1 == 2) {
																							const gchar* val = NULL;
																							gchar** _tmp62_;
																							gint _tmp62__length1;
																							const gchar* _tmp63_;
																							const gchar* _tmp64_;
																							const gchar* _tmp65_;
																							_tmp62_ = splitted;
																							_tmp62__length1 = splitted_length1;
																							_tmp63_ = _tmp62_[1];
																							_tmp64_ = g_strstrip (_tmp63_);
																							val = _tmp64_;
																							_tmp65_ = val;
																							pamac_config_set_max_parallel_downloads (self, uint64_parse (_tmp65_, (guint) 0));
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp6_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp66_;
			const gchar* _tmp67_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp66_ = e;
			_tmp67_ = _tmp66_->message;
			g_warning ("pamac_config.vala:360: %s", _tmp67_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_warning ("pamac_config.vala:363: File '%s' doesn't exist.", path);
	}
	_g_object_unref0 (file);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

void
pamac_config_save (PamacConfig* self)
{
	PamacDaemon* _tmp0_;
	GHashTable* new_pamac_conf = NULL;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	guint64 _tmp15_;
	GVariant* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	GVariant* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GVariant* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_;
	GVariant* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	GVariant* _tmp33_;
	GHashTable* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_;
	GVariant* _tmp37_;
	GHashTable* _tmp38_;
	gchar* _tmp39_;
	guint64 _tmp40_;
	GVariant* _tmp41_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	guint64 _tmp44_;
	GVariant* _tmp45_;
	GHashTable* _tmp46_;
	gchar* _tmp47_;
	gboolean _tmp48_;
	GVariant* _tmp49_;
	GHashTable* _tmp50_;
	gchar* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	GVariant* _tmp54_;
	GHashTable* _tmp55_;
	gchar* _tmp56_;
	gboolean _tmp57_;
	GVariant* _tmp58_;
	GHashTable* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	GVariant* _tmp63_;
	GHashTable* _tmp64_;
	gchar* _tmp65_;
	gboolean _tmp66_;
	GVariant* _tmp67_;
	GHashTable* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	GVariant* _tmp71_;
	GHashTable* _tmp72_;
	gchar* _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	GVariant* _tmp76_;
	GHashTable* _tmp77_;
	gchar* _tmp78_;
	gboolean _tmp79_;
	gboolean _tmp80_;
	GVariant* _tmp81_;
	GHashTable* _tmp82_;
	gchar* _tmp83_;
	gboolean _tmp84_;
	GVariant* _tmp85_;
	GHashTable* new_alpm_conf = NULL;
	GHashFunc _tmp90_;
	GEqualFunc _tmp91_;
	GHashTable* _tmp92_;
	GHashTable* _tmp93_;
	gchar* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	GVariant* _tmp97_;
	GString* ignorepkgs_str = NULL;
	GString* _tmp98_;
	GHashTable* _tmp108_;
	gchar* _tmp109_;
	GString* _tmp110_;
	const gchar* _tmp111_;
	GVariant* _tmp112_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->system_daemon;
	if (_tmp0_ == NULL) {
		{
			PamacDaemon* _tmp1_ = NULL;
			PamacDaemon* _tmp2_;
			PamacDaemon* _tmp3_;
			_tmp2_ = (PamacDaemon*) g_initable_new (PAMAC_TYPE_DAEMON_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.manjaro.pamac.daemon", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/manjaro/pamac/daemon", "g-interface-name", "org.manjaro.pamac.daemon", NULL);
			_tmp1_ = (PamacDaemon*) _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->system_daemon);
			self->priv->system_daemon = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("pamac_config.vala:372: save pamac config error: %s", _tmp5_);
			_g_error_free0 (e);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_variant_unref0_);
	new_pamac_conf = _tmp8_;
	_tmp9_ = new_pamac_conf;
	_tmp10_ = g_strdup ("RemoveUnrequiredDeps");
	_tmp11_ = self->priv->_recurse;
	_tmp12_ = g_variant_new_boolean (_tmp11_);
	g_variant_ref_sink (_tmp12_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	_tmp13_ = new_pamac_conf;
	_tmp14_ = g_strdup ("RefreshPeriod");
	_tmp15_ = self->priv->_refresh_period;
	_tmp16_ = g_variant_new_uint64 (_tmp15_);
	g_variant_ref_sink (_tmp16_);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
	_tmp17_ = new_pamac_conf;
	_tmp18_ = g_strdup ("NoUpdateHideIcon");
	_tmp19_ = self->priv->_no_update_hide_icon;
	_tmp20_ = g_variant_new_boolean (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
	_tmp21_ = new_pamac_conf;
	_tmp22_ = g_strdup ("DownloadUpdates");
	_tmp23_ = pamac_config_get_download_updates (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_new_boolean (_tmp24_);
	g_variant_ref_sink (_tmp25_);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp25_);
	_tmp26_ = new_pamac_conf;
	_tmp27_ = g_strdup ("OfflineUpgrade");
	_tmp28_ = self->priv->_offline_upgrade;
	_tmp29_ = g_variant_new_boolean (_tmp28_);
	g_variant_ref_sink (_tmp29_);
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp29_);
	_tmp30_ = new_pamac_conf;
	_tmp31_ = g_strdup ("EnableDowngrade");
	_tmp32_ = self->priv->_enable_downgrade;
	_tmp33_ = g_variant_new_boolean (_tmp32_);
	g_variant_ref_sink (_tmp33_);
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp33_);
	_tmp34_ = new_pamac_conf;
	_tmp35_ = g_strdup ("SimpleInstall");
	_tmp36_ = self->priv->_simple_install;
	_tmp37_ = g_variant_new_boolean (_tmp36_);
	g_variant_ref_sink (_tmp37_);
	g_hash_table_insert (_tmp34_, _tmp35_, _tmp37_);
	_tmp38_ = new_pamac_conf;
	_tmp39_ = g_strdup ("MaxParallelDownloads");
	_tmp40_ = self->priv->_max_parallel_downloads;
	_tmp41_ = g_variant_new_uint64 (_tmp40_);
	g_variant_ref_sink (_tmp41_);
	g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
	_tmp42_ = new_pamac_conf;
	_tmp43_ = g_strdup ("KeepNumPackages");
	_tmp44_ = self->priv->_clean_keep_num_pkgs;
	_tmp45_ = g_variant_new_uint64 (_tmp44_);
	g_variant_ref_sink (_tmp45_);
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp45_);
	_tmp46_ = new_pamac_conf;
	_tmp47_ = g_strdup ("OnlyRmUninstalled");
	_tmp48_ = self->priv->_clean_rm_only_uninstalled;
	_tmp49_ = g_variant_new_boolean (_tmp48_);
	g_variant_ref_sink (_tmp49_);
	g_hash_table_insert (_tmp46_, _tmp47_, _tmp49_);
	_tmp50_ = new_pamac_conf;
	_tmp51_ = g_strdup ("EnableAUR");
	_tmp52_ = pamac_config_get_enable_aur (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_variant_new_boolean (_tmp53_);
	g_variant_ref_sink (_tmp54_);
	g_hash_table_insert (_tmp50_, _tmp51_, _tmp54_);
	_tmp55_ = new_pamac_conf;
	_tmp56_ = g_strdup ("KeepBuiltPkgs");
	_tmp57_ = self->priv->_keep_built_pkgs;
	_tmp58_ = g_variant_new_boolean (_tmp57_);
	g_variant_ref_sink (_tmp58_);
	g_hash_table_insert (_tmp55_, _tmp56_, _tmp58_);
	_tmp59_ = new_pamac_conf;
	_tmp60_ = g_strdup ("CheckAURUpdates");
	_tmp61_ = pamac_config_get_check_aur_updates (self);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_variant_new_boolean (_tmp62_);
	g_variant_ref_sink (_tmp63_);
	g_hash_table_insert (_tmp59_, _tmp60_, _tmp63_);
	_tmp64_ = new_pamac_conf;
	_tmp65_ = g_strdup ("CheckAURVCSUpdates");
	_tmp66_ = self->priv->_check_aur_vcs_updates;
	_tmp67_ = g_variant_new_boolean (_tmp66_);
	g_variant_ref_sink (_tmp67_);
	g_hash_table_insert (_tmp64_, _tmp65_, _tmp67_);
	_tmp68_ = new_pamac_conf;
	_tmp69_ = g_strdup ("BuildDirectory");
	_tmp70_ = self->priv->_aur_build_dir;
	_tmp71_ = g_variant_new_string (_tmp70_);
	g_variant_ref_sink (_tmp71_);
	g_hash_table_insert (_tmp68_, _tmp69_, _tmp71_);
	_tmp72_ = new_pamac_conf;
	_tmp73_ = g_strdup ("EnableSnap");
	_tmp74_ = pamac_config_get_enable_snap (self);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_variant_new_boolean (_tmp75_);
	g_variant_ref_sink (_tmp76_);
	g_hash_table_insert (_tmp72_, _tmp73_, _tmp76_);
	_tmp77_ = new_pamac_conf;
	_tmp78_ = g_strdup ("EnableFlatpak");
	_tmp79_ = pamac_config_get_enable_flatpak (self);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_variant_new_boolean (_tmp80_);
	g_variant_ref_sink (_tmp81_);
	g_hash_table_insert (_tmp77_, _tmp78_, _tmp81_);
	_tmp82_ = new_pamac_conf;
	_tmp83_ = g_strdup ("CheckFlatpakUpdates");
	_tmp84_ = self->priv->_check_flatpak_updates;
	_tmp85_ = g_variant_new_boolean (_tmp84_);
	g_variant_ref_sink (_tmp85_);
	g_hash_table_insert (_tmp82_, _tmp83_, _tmp85_);
	{
		PamacDaemon* _tmp86_;
		GHashTable* _tmp87_;
		_tmp86_ = self->priv->system_daemon;
		_tmp87_ = new_pamac_conf;
		pamac_daemon_start_write_pamac_config (_tmp86_, _tmp87_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp88_;
		const gchar* _tmp89_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp88_ = e;
		_tmp89_ = _tmp88_->message;
		g_warning ("pamac_config.vala:399: save pamac config error: %s", _tmp89_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (new_pamac_conf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp90_ = g_str_hash;
	_tmp91_ = g_str_equal;
	_tmp92_ = g_hash_table_new_full (_tmp90_, _tmp91_, _g_free0_, _g_variant_unref0_);
	new_alpm_conf = _tmp92_;
	_tmp93_ = new_alpm_conf;
	_tmp94_ = g_strdup ("CheckSpace");
	_tmp95_ = pamac_config_get_checkspace (self);
	_tmp96_ = _tmp95_;
	_tmp97_ = g_variant_new_boolean (_tmp96_);
	g_variant_ref_sink (_tmp97_);
	g_hash_table_insert (_tmp93_, _tmp94_, _tmp97_);
	_tmp98_ = g_string_new ("");
	ignorepkgs_str = _tmp98_;
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp99_;
		GHashTable* _tmp100_;
		GHashTableIter _tmp101_ = {0};
		const gchar* name = NULL;
		_tmp99_ = pamac_config_get_ignorepkgs (self);
		_tmp100_ = _tmp99_;
		g_hash_table_iter_init (&_tmp101_, _tmp100_);
		_name_it = _tmp101_;
		while (TRUE) {
			gconstpointer _tmp102_;
			const gchar* _tmp103_;
			GString* _tmp104_;
			GString* _tmp106_;
			const gchar* _tmp107_;
			_tmp102_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp102_;
			_tmp103_ = name;
			if (!(_tmp103_ != NULL)) {
				break;
			}
			_tmp104_ = ignorepkgs_str;
			if (_tmp104_->len > ((gssize) 0)) {
				GString* _tmp105_;
				_tmp105_ = ignorepkgs_str;
				g_string_append (_tmp105_, " ");
			}
			_tmp106_ = ignorepkgs_str;
			_tmp107_ = name;
			g_string_append (_tmp106_, _tmp107_);
		}
	}
	_tmp108_ = new_alpm_conf;
	_tmp109_ = g_strdup ("IgnorePkg");
	_tmp110_ = ignorepkgs_str;
	_tmp111_ = _tmp110_->str;
	_tmp112_ = g_variant_new_string (_tmp111_);
	g_variant_ref_sink (_tmp112_);
	g_hash_table_insert (_tmp108_, _tmp109_, _tmp112_);
	{
		PamacDaemon* _tmp113_;
		GHashTable* _tmp114_;
		_tmp113_ = self->priv->system_daemon;
		_tmp114_ = new_alpm_conf;
		pamac_daemon_start_write_alpm_config (_tmp113_, _tmp114_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp115_;
		const gchar* _tmp116_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp115_ = e;
		_tmp116_ = _tmp115_->message;
		g_warning ("pamac_config.vala:415: save pamac config error: %s", _tmp116_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (ignorepkgs_str);
		_g_hash_table_unref0 (new_alpm_conf);
		_g_hash_table_unref0 (new_pamac_conf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (ignorepkgs_str);
	_g_hash_table_unref0 (new_alpm_conf);
	_g_hash_table_unref0 (new_pamac_conf);
}

const gchar*
pamac_config_get_conf_path (PamacConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_conf_path;
	result = _tmp0_;
	return result;
}

static void
pamac_config_set_conf_path (PamacConfig* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_conf_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_conf_path);
		self->priv->_conf_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CONF_PATH_PROPERTY]);
	}
}

gboolean
pamac_config_get_recurse (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recurse;
	return result;
}

void
pamac_config_set_recurse (PamacConfig* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_recurse (self);
	if (old_value != value) {
		self->priv->_recurse = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_RECURSE_PROPERTY]);
	}
}

gboolean
pamac_config_get_keep_built_pkgs (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_keep_built_pkgs;
	return result;
}

void
pamac_config_set_keep_built_pkgs (PamacConfig* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_keep_built_pkgs (self);
	if (old_value != value) {
		self->priv->_keep_built_pkgs = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY]);
	}
}

gboolean
pamac_config_get_enable_downgrade (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_downgrade;
	return result;
}

void
pamac_config_set_enable_downgrade (PamacConfig* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_enable_downgrade (self);
	if (old_value != value) {
		self->priv->_enable_downgrade = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY]);
	}
}

gboolean
pamac_config_get_simple_install (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_simple_install;
	return result;
}

void
pamac_config_set_simple_install (PamacConfig* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_simple_install (self);
	if (old_value != value) {
		self->priv->_simple_install = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY]);
	}
}

guint64
pamac_config_get_refresh_period (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_refresh_period;
	return result;
}

void
pamac_config_set_refresh_period (PamacConfig* self,
                                 guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_refresh_period (self);
	if (old_value != value) {
		self->priv->_refresh_period = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY]);
	}
}

gboolean
pamac_config_get_no_update_hide_icon (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_update_hide_icon;
	return result;
}

void
pamac_config_set_no_update_hide_icon (PamacConfig* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_no_update_hide_icon (self);
	if (old_value != value) {
		self->priv->_no_update_hide_icon = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY]);
	}
}

gboolean
pamac_config_get_support_aur (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_aur;
	return result;
}

static void
pamac_config_set_support_aur (PamacConfig* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_support_aur = value;
	if (!self->priv->_support_aur) {
		pamac_config_set_enable_aur (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_AUR_PROPERTY]);
}

gboolean
pamac_config_get_enable_aur (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_aur;
	return result;
}

void
pamac_config_set_enable_aur (PamacConfig* self,
                             gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_support_aur) {
		_tmp0_ = value;
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->_enable_aur = _tmp0_;
	if (!self->priv->_enable_aur) {
		pamac_config_set_check_aur_updates (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_AUR_PROPERTY]);
}

gboolean
pamac_config_get_support_appstream (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_appstream;
	return result;
}

static void
pamac_config_set_support_appstream (PamacConfig* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_support_appstream = value;
	if (!self->priv->_support_appstream) {
		pamac_config_set_enable_appstream (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY]);
}

gboolean
pamac_config_get_enable_appstream (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_appstream;
	return result;
}

void
pamac_config_set_enable_appstream (PamacConfig* self,
                                   gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_support_appstream) {
		_tmp0_ = value;
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->_enable_appstream = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY]);
}

gboolean
pamac_config_get_support_snap (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_snap;
	return result;
}

static void
pamac_config_set_support_snap (PamacConfig* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_support_snap = value;
	if (!self->priv->_support_snap) {
		pamac_config_set_enable_snap (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY]);
}

gboolean
pamac_config_get_enable_snap (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_snap;
	return result;
}

void
pamac_config_set_enable_snap (PamacConfig* self,
                              gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_support_snap) {
		_tmp0_ = value;
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->_enable_snap = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_SNAP_PROPERTY]);
}

gboolean
pamac_config_get_support_flatpak (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_flatpak;
	return result;
}

void
pamac_config_set_support_flatpak (PamacConfig* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_support_flatpak = value;
	if (!self->priv->_support_flatpak) {
		pamac_config_set_enable_flatpak (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY]);
}

gboolean
pamac_config_get_enable_flatpak (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_flatpak;
	return result;
}

void
pamac_config_set_enable_flatpak (PamacConfig* self,
                                 gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_support_flatpak) {
		_tmp0_ = value;
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->_enable_flatpak = _tmp0_;
	if (!self->priv->_enable_flatpak) {
		pamac_config_set_check_flatpak_updates (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY]);
}

gboolean
pamac_config_get_check_flatpak_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_flatpak_updates;
	return result;
}

void
pamac_config_set_check_flatpak_updates (PamacConfig* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_check_flatpak_updates (self);
	if (old_value != value) {
		self->priv->_check_flatpak_updates = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY]);
	}
}

const gchar*
pamac_config_get_aur_build_dir (PamacConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aur_build_dir;
	result = _tmp0_;
	return result;
}

void
pamac_config_set_aur_build_dir (PamacConfig* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_aur_build_dir (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_aur_build_dir);
		self->priv->_aur_build_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY]);
	}
}

gboolean
pamac_config_get_check_aur_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_aur_updates;
	return result;
}

void
pamac_config_set_check_aur_updates (PamacConfig* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_check_aur_updates = value;
	if (!self->priv->_check_aur_updates) {
		pamac_config_set_check_aur_vcs_updates (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY]);
}

gboolean
pamac_config_get_check_aur_vcs_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_aur_vcs_updates;
	return result;
}

void
pamac_config_set_check_aur_vcs_updates (PamacConfig* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_check_aur_vcs_updates (self);
	if (old_value != value) {
		self->priv->_check_aur_vcs_updates = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY]);
	}
}

gboolean
pamac_config_get_download_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_download_updates;
	return result;
}

void
pamac_config_set_download_updates (PamacConfig* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_download_updates = value;
	if (!self->priv->_download_updates) {
		pamac_config_set_offline_upgrade (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY]);
}

gboolean
pamac_config_get_offline_upgrade (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_offline_upgrade;
	return result;
}

void
pamac_config_set_offline_upgrade (PamacConfig* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_offline_upgrade (self);
	if (old_value != value) {
		self->priv->_offline_upgrade = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY]);
	}
}

guint64
pamac_config_get_max_parallel_downloads (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_max_parallel_downloads;
	return result;
}

void
pamac_config_set_max_parallel_downloads (PamacConfig* self,
                                         guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_max_parallel_downloads (self);
	if (old_value != value) {
		self->priv->_max_parallel_downloads = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY]);
	}
}

guint64
pamac_config_get_clean_keep_num_pkgs (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_clean_keep_num_pkgs;
	return result;
}

void
pamac_config_set_clean_keep_num_pkgs (PamacConfig* self,
                                      guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_clean_keep_num_pkgs (self);
	if (old_value != value) {
		self->priv->_clean_keep_num_pkgs = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY]);
	}
}

gboolean
pamac_config_get_clean_rm_only_uninstalled (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_clean_rm_only_uninstalled;
	return result;
}

void
pamac_config_set_clean_rm_only_uninstalled (PamacConfig* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_clean_rm_only_uninstalled (self);
	if (old_value != value) {
		self->priv->_clean_rm_only_uninstalled = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY]);
	}
}

GHashTable*
pamac_config_get_environment_variables (PamacConfig* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->environment_variables_priv;
	result = _tmp0_;
	return result;
}

const gchar*
pamac_config_get_db_path (PamacConfig* self)
{
	const gchar* result;
	AlpmConfig* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp1_ = _tmp0_->dbpath;
	result = _tmp1_;
	return result;
}

gboolean
pamac_config_get_checkspace (PamacConfig* self)
{
	gboolean result;
	AlpmConfig* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_alpm_config;
	result = _tmp0_->checkspace;
	return result;
}

void
pamac_config_set_checkspace (PamacConfig* self,
                             gboolean value)
{
	AlpmConfig* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp0_->checkspace = value;
	g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECKSPACE_PROPERTY]);
}

GHashTable*
pamac_config_get_ignorepkgs (PamacConfig* self)
{
	GHashTable* result;
	AlpmConfig* _tmp0_;
	GHashTable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp1_ = _tmp0_->ignorepkgs;
	result = _tmp1_;
	return result;
}

AlpmConfig*
pamac_config_get_alpm_config (PamacConfig* self)
{
	AlpmConfig* result;
	AlpmConfig* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alpm_config;
	result = _tmp0_;
	return result;
}

static gpointer
_alpm_config_ref0 (gpointer self)
{
	return self ? alpm_config_ref (self) : NULL;
}

static void
pamac_config_set_alpm_config (PamacConfig* self,
                              AlpmConfig* value)
{
	AlpmConfig* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_alpm_config (self);
	if (old_value != value) {
		AlpmConfig* _tmp0_;
		_tmp0_ = _alpm_config_ref0 (value);
		_alpm_config_unref0 (self->priv->_alpm_config);
		self->priv->_alpm_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ALPM_CONFIG_PROPERTY]);
	}
}

static GObject *
pamac_config_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacConfig * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	AlpmConfig* _tmp3_;
	AlpmConfig* _tmp4_;
	const gchar* variable = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	PamacPluginLoader* _tmp35_;
	PamacPluginLoader* _tmp36_;
	PamacPluginLoader* _tmp37_;
	PamacPluginLoader* _tmp38_;
	PamacPluginLoader* _tmp39_;
	PamacPluginLoader* _tmp40_;
	PamacPluginLoader* _tmp41_;
	PamacPluginLoader* _tmp42_;
	parent_class = G_OBJECT_CLASS (pamac_config_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_CONFIG, PamacConfig);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->environment_variables_priv);
	self->priv->environment_variables_priv = _tmp2_;
	_tmp3_ = alpm_config_new ("/etc/pacman.conf");
	_tmp4_ = _tmp3_;
	pamac_config_set_alpm_config (self, _tmp4_);
	_alpm_config_unref0 (_tmp4_);
	_tmp5_ = g_getenv ("http_proxy");
	variable = _tmp5_;
	_tmp6_ = variable;
	if (_tmp6_ != NULL) {
		GHashTable* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = self->priv->environment_variables_priv;
		_tmp8_ = g_strdup ("http_proxy");
		_tmp9_ = variable;
		_tmp10_ = g_strdup (_tmp9_);
		g_hash_table_insert (_tmp7_, _tmp8_, _tmp10_);
	}
	_tmp11_ = g_getenv ("https_proxy");
	variable = _tmp11_;
	_tmp12_ = variable;
	if (_tmp12_ != NULL) {
		GHashTable* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = self->priv->environment_variables_priv;
		_tmp14_ = g_strdup ("https_proxy");
		_tmp15_ = variable;
		_tmp16_ = g_strdup (_tmp15_);
		g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
	}
	_tmp17_ = g_getenv ("ftp_proxy");
	variable = _tmp17_;
	_tmp18_ = variable;
	if (_tmp18_ != NULL) {
		GHashTable* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = self->priv->environment_variables_priv;
		_tmp20_ = g_strdup ("ftp_proxy");
		_tmp21_ = variable;
		_tmp22_ = g_strdup (_tmp21_);
		g_hash_table_insert (_tmp19_, _tmp20_, _tmp22_);
	}
	_tmp23_ = g_getenv ("socks_proxy");
	variable = _tmp23_;
	_tmp24_ = variable;
	if (_tmp24_ != NULL) {
		GHashTable* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp25_ = self->priv->environment_variables_priv;
		_tmp26_ = g_strdup ("socks_proxy");
		_tmp27_ = variable;
		_tmp28_ = g_strdup (_tmp27_);
		g_hash_table_insert (_tmp25_, _tmp26_, _tmp28_);
	}
	_tmp29_ = g_getenv ("no_proxy");
	variable = _tmp29_;
	_tmp30_ = variable;
	if (_tmp30_ != NULL) {
		GHashTable* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp31_ = self->priv->environment_variables_priv;
		_tmp32_ = g_strdup ("no_proxy");
		_tmp33_ = variable;
		_tmp34_ = g_strdup (_tmp33_);
		g_hash_table_insert (_tmp31_, _tmp32_, _tmp34_);
	}
	pamac_config_set_refresh_period (self, (guint64) 6);
	pamac_config_set_support_aur (self, FALSE);
	_tmp35_ = pamac_plugin_loader_new (PAMAC_TYPE_AUR_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-aur");
	_g_object_unref0 (self->priv->aur_plugin_loader);
	self->priv->aur_plugin_loader = _tmp35_;
	_tmp36_ = self->priv->aur_plugin_loader;
	if (pamac_plugin_loader_load (_tmp36_)) {
		pamac_config_set_support_aur (self, TRUE);
	}
	pamac_config_set_support_appstream (self, FALSE);
	_tmp37_ = pamac_plugin_loader_new (PAMAC_TYPE_APPSTREAM_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-appstream");
	_g_object_unref0 (self->priv->appstream_plugin_loader);
	self->priv->appstream_plugin_loader = _tmp37_;
	_tmp38_ = self->priv->appstream_plugin_loader;
	if (pamac_plugin_loader_load (_tmp38_)) {
		pamac_config_set_support_appstream (self, TRUE);
	}
	pamac_config_set_support_snap (self, FALSE);
	_tmp39_ = pamac_plugin_loader_new (PAMAC_TYPE_SNAP_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-snap");
	_g_object_unref0 (self->priv->snap_plugin_loader);
	self->priv->snap_plugin_loader = _tmp39_;
	_tmp40_ = self->priv->snap_plugin_loader;
	if (pamac_plugin_loader_load (_tmp40_)) {
		pamac_config_set_support_snap (self, TRUE);
	}
	pamac_config_set_support_flatpak (self, FALSE);
	_tmp41_ = pamac_plugin_loader_new (PAMAC_TYPE_FLATPAK_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-flatpak");
	_g_object_unref0 (self->priv->flatpak_plugin_loader);
	self->priv->flatpak_plugin_loader = _tmp41_;
	_tmp42_ = self->priv->flatpak_plugin_loader;
	if (pamac_plugin_loader_load (_tmp42_)) {
		pamac_config_set_support_flatpak (self, TRUE);
	}
	pamac_config_reload (self);
	return obj;
}

static void
pamac_config_class_init (PamacConfigClass * klass,
                         gpointer klass_data)
{
	pamac_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacConfig_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_config_set_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_config_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CONF_PATH_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CONF_PATH_PROPERTY] = g_param_spec_string ("conf-path", "conf-path", "conf-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_RECURSE_PROPERTY, pamac_config_properties[PAMAC_CONFIG_RECURSE_PROPERTY] = g_param_spec_boolean ("recurse", "recurse", "recurse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY] = g_param_spec_boolean ("keep-built-pkgs", "keep-built-pkgs", "keep-built-pkgs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY] = g_param_spec_boolean ("enable-downgrade", "enable-downgrade", "enable-downgrade", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY] = g_param_spec_boolean ("simple-install", "simple-install", "simple-install", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY, pamac_config_properties[PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY] = g_param_spec_uint64 ("refresh-period", "refresh-period", "refresh-period", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY, pamac_config_properties[PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY] = g_param_spec_boolean ("no-update-hide-icon", "no-update-hide-icon", "no-update-hide-icon", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_AUR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_AUR_PROPERTY] = g_param_spec_boolean ("support-aur", "support-aur", "support-aur", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_AUR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_AUR_PROPERTY] = g_param_spec_boolean ("enable-aur", "enable-aur", "enable-aur", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY] = g_param_spec_boolean ("support-appstream", "support-appstream", "support-appstream", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY] = g_param_spec_boolean ("enable-appstream", "enable-appstream", "enable-appstream", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY] = g_param_spec_boolean ("support-snap", "support-snap", "support-snap", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_SNAP_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_SNAP_PROPERTY] = g_param_spec_boolean ("enable-snap", "enable-snap", "enable-snap", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY] = g_param_spec_boolean ("support-flatpak", "support-flatpak", "support-flatpak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY] = g_param_spec_boolean ("enable-flatpak", "enable-flatpak", "enable-flatpak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY] = g_param_spec_boolean ("check-flatpak-updates", "check-flatpak-updates", "check-flatpak-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY] = g_param_spec_string ("aur-build-dir", "aur-build-dir", "aur-build-dir", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY] = g_param_spec_boolean ("check-aur-updates", "check-aur-updates", "check-aur-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY] = g_param_spec_boolean ("check-aur-vcs-updates", "check-aur-vcs-updates", "check-aur-vcs-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY] = g_param_spec_boolean ("download-updates", "download-updates", "download-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY, pamac_config_properties[PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY] = g_param_spec_boolean ("offline-upgrade", "offline-upgrade", "offline-upgrade", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY] = g_param_spec_uint64 ("max-parallel-downloads", "max-parallel-downloads", "max-parallel-downloads", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY] = g_param_spec_uint64 ("clean-keep-num-pkgs", "clean-keep-num-pkgs", "clean-keep-num-pkgs", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY] = g_param_spec_boolean ("clean-rm-only-uninstalled", "clean-rm-only-uninstalled", "clean-rm-only-uninstalled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENVIRONMENT_VARIABLES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENVIRONMENT_VARIABLES_PROPERTY] = g_param_spec_boxed ("environment-variables", "environment-variables", "environment-variables", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_DB_PATH_PROPERTY, pamac_config_properties[PAMAC_CONFIG_DB_PATH_PROPERTY] = g_param_spec_string ("db-path", "db-path", "db-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECKSPACE_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECKSPACE_PROPERTY] = g_param_spec_boolean ("checkspace", "checkspace", "checkspace", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_IGNOREPKGS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_IGNOREPKGS_PROPERTY] = g_param_spec_boxed ("ignorepkgs", "ignorepkgs", "ignorepkgs", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ALPM_CONFIG_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ALPM_CONFIG_PROPERTY] = param_spec_alpm_config ("alpm-config", "alpm-config", "alpm-config", TYPE_ALPM_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pamac_config_instance_init (PamacConfig * self,
                            gpointer klass)
{
	self->priv = pamac_config_get_instance_private (self);
}

static void
pamac_config_finalize (GObject * obj)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_CONFIG, PamacConfig);
	_g_hash_table_unref0 (self->priv->environment_variables_priv);
	_g_object_unref0 (self->priv->system_daemon);
	_g_free0 (self->priv->_conf_path);
	_g_object_unref0 (self->priv->aur_plugin_loader);
	_g_object_unref0 (self->priv->appstream_plugin_loader);
	_g_object_unref0 (self->priv->snap_plugin_loader);
	_g_object_unref0 (self->priv->flatpak_plugin_loader);
	_g_free0 (self->priv->_aur_build_dir);
	_alpm_config_unref0 (self->priv->_alpm_config);
	G_OBJECT_CLASS (pamac_config_parent_class)->finalize (obj);
}

static GType
pamac_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacConfig), 0, (GInstanceInitFunc) pamac_config_instance_init, NULL };
	GType pamac_config_type_id;
	pamac_config_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacConfig", &g_define_type_info, 0);
	PamacConfig_private_offset = g_type_add_instance_private (pamac_config_type_id, sizeof (PamacConfigPrivate));
	return pamac_config_type_id;
}

GType
pamac_config_get_type (void)
{
	static volatile gsize pamac_config_type_id__once = 0;
	if (g_once_init_enter (&pamac_config_type_id__once)) {
		GType pamac_config_type_id;
		pamac_config_type_id = pamac_config_get_type_once ();
		g_once_init_leave (&pamac_config_type_id__once, pamac_config_type_id);
	}
	return pamac_config_type_id__once;
}

static void
_vala_pamac_config_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_CONFIG, PamacConfig);
	switch (property_id) {
		case PAMAC_CONFIG_CONF_PATH_PROPERTY:
		g_value_set_string (value, pamac_config_get_conf_path (self));
		break;
		case PAMAC_CONFIG_RECURSE_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_recurse (self));
		break;
		case PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_keep_built_pkgs (self));
		break;
		case PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_downgrade (self));
		break;
		case PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_simple_install (self));
		break;
		case PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_refresh_period (self));
		break;
		case PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_no_update_hide_icon (self));
		break;
		case PAMAC_CONFIG_SUPPORT_AUR_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_aur (self));
		break;
		case PAMAC_CONFIG_ENABLE_AUR_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_aur (self));
		break;
		case PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_appstream (self));
		break;
		case PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_appstream (self));
		break;
		case PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_snap (self));
		break;
		case PAMAC_CONFIG_ENABLE_SNAP_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_snap (self));
		break;
		case PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_flatpak (self));
		break;
		case PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_flatpak (self));
		break;
		case PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_flatpak_updates (self));
		break;
		case PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY:
		g_value_set_string (value, pamac_config_get_aur_build_dir (self));
		break;
		case PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_aur_updates (self));
		break;
		case PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_aur_vcs_updates (self));
		break;
		case PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_download_updates (self));
		break;
		case PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_offline_upgrade (self));
		break;
		case PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_max_parallel_downloads (self));
		break;
		case PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_clean_keep_num_pkgs (self));
		break;
		case PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_clean_rm_only_uninstalled (self));
		break;
		case PAMAC_CONFIG_ENVIRONMENT_VARIABLES_PROPERTY:
		g_value_set_boxed (value, pamac_config_get_environment_variables (self));
		break;
		case PAMAC_CONFIG_DB_PATH_PROPERTY:
		g_value_set_string (value, pamac_config_get_db_path (self));
		break;
		case PAMAC_CONFIG_CHECKSPACE_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_checkspace (self));
		break;
		case PAMAC_CONFIG_IGNOREPKGS_PROPERTY:
		g_value_set_boxed (value, pamac_config_get_ignorepkgs (self));
		break;
		case PAMAC_CONFIG_ALPM_CONFIG_PROPERTY:
		value_set_alpm_config (value, pamac_config_get_alpm_config (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_config_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_CONFIG, PamacConfig);
	switch (property_id) {
		case PAMAC_CONFIG_CONF_PATH_PROPERTY:
		pamac_config_set_conf_path (self, g_value_get_string (value));
		break;
		case PAMAC_CONFIG_RECURSE_PROPERTY:
		pamac_config_set_recurse (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_KEEP_BUILT_PKGS_PROPERTY:
		pamac_config_set_keep_built_pkgs (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_DOWNGRADE_PROPERTY:
		pamac_config_set_enable_downgrade (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SIMPLE_INSTALL_PROPERTY:
		pamac_config_set_simple_install (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY:
		pamac_config_set_refresh_period (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_NO_UPDATE_HIDE_ICON_PROPERTY:
		pamac_config_set_no_update_hide_icon (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_AUR_PROPERTY:
		pamac_config_set_support_aur (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_AUR_PROPERTY:
		pamac_config_set_enable_aur (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY:
		pamac_config_set_support_appstream (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY:
		pamac_config_set_enable_appstream (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY:
		pamac_config_set_support_snap (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_SNAP_PROPERTY:
		pamac_config_set_enable_snap (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY:
		pamac_config_set_support_flatpak (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY:
		pamac_config_set_enable_flatpak (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY:
		pamac_config_set_check_flatpak_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY:
		pamac_config_set_aur_build_dir (self, g_value_get_string (value));
		break;
		case PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY:
		pamac_config_set_check_aur_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY:
		pamac_config_set_check_aur_vcs_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_DOWNLOAD_UPDATES_PROPERTY:
		pamac_config_set_download_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY:
		pamac_config_set_offline_upgrade (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY:
		pamac_config_set_max_parallel_downloads (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY:
		pamac_config_set_clean_keep_num_pkgs (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY:
		pamac_config_set_clean_rm_only_uninstalled (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_CHECKSPACE_PROPERTY:
		pamac_config_set_checkspace (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ALPM_CONFIG_PROPERTY:
		pamac_config_set_alpm_config (self, value_get_alpm_config (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

