/* Pamac.h generated by valac 0.56.12, the Vala compiler, do not modify */

#ifndef __SRC_PAMAC_H__
#define __SRC_PAMAC_H__

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <alpm.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define PAMAC_DATADIR "/usr/share"
#define PAMAC_PKGDATADIR "/usr/share/pamac"
#define PAMAC_GETTEXT_PACKAGE "pamac"
#define PAMAC_RELEASE_NAME "pamac"
#define PAMAC_VERSION "7.3.0"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;

#define PAMAC_TYPE_UPDATE_INFOS (pamac_update_infos_get_type ())
typedef struct _PamacUpdateInfos PamacUpdateInfos;

#define PAMAC_TYPE_TRANSACTION_SUMMARY (pamac_transaction_summary_get_type ())
typedef struct _PamacTransactionSummary PamacTransactionSummary;

#define PAMAC_TYPE_UPDATES (pamac_updates_get_type ())
typedef struct _PamacUpdates PamacUpdates;

#define PAMAC_TYPE_ALPM_PACKAGE (pamac_alpm_package_get_type ())
typedef struct _PamacAlpmPackage PamacAlpmPackage;

#define PAMAC_TYPE_AUR_PACKAGE (pamac_aur_package_get_type ())
typedef struct _PamacAURPackage PamacAURPackage;

#define PAMAC_TYPE_ERROR_INFOS (pamac_error_infos_get_type ())
typedef struct _PamacErrorInfos PamacErrorInfos;

#define PAMAC_TYPE_MIRRORS_CONFIG (pamac_mirrors_config_get_type ())
#define PAMAC_MIRRORS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_MIRRORS_CONFIG, PamacMirrorsConfig))
#define PAMAC_MIRRORS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_MIRRORS_CONFIG, PamacMirrorsConfigClass))
#define PAMAC_IS_MIRRORS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_MIRRORS_CONFIG))
#define PAMAC_IS_MIRRORS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_MIRRORS_CONFIG))
#define PAMAC_MIRRORS_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_MIRRORS_CONFIG, PamacMirrorsConfigClass))

typedef struct _PamacMirrorsConfig PamacMirrorsConfig;
typedef struct _PamacMirrorsConfigClass PamacMirrorsConfigClass;
typedef struct _PamacMirrorsConfigPrivate PamacMirrorsConfigPrivate;

#define PAMAC_TYPE_ALPM_PACKAGE_DETAILS (pamac_alpm_package_details_get_type ())
typedef struct _PamacAlpmPackageDetails PamacAlpmPackageDetails;

#define PAMAC_TYPE_AUR_PACKAGE_DETAILS (pamac_aur_package_details_get_type ())
typedef struct _PamacAURPackageDetails PamacAURPackageDetails;

#define PAMAC_TYPE_CONFIG (pamac_config_get_type ())
#define PAMAC_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_CONFIG, PamacConfig))
#define PAMAC_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_CONFIG, PamacConfigClass))
#define PAMAC_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_CONFIG))
#define PAMAC_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_CONFIG))
#define PAMAC_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_CONFIG, PamacConfigClass))

typedef struct _PamacConfig PamacConfig;
typedef struct _PamacConfigClass PamacConfigClass;
typedef struct _PamacConfigPrivate PamacConfigPrivate;

#define PAMAC_TYPE_PROGRESS_BOX (pamac_progress_box_get_type ())
#define PAMAC_PROGRESS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PROGRESS_BOX, PamacProgressBox))
#define PAMAC_PROGRESS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PROGRESS_BOX, PamacProgressBoxClass))
#define PAMAC_IS_PROGRESS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PROGRESS_BOX))
#define PAMAC_IS_PROGRESS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PROGRESS_BOX))
#define PAMAC_PROGRESS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PROGRESS_BOX, PamacProgressBoxClass))

typedef struct _PamacProgressBox PamacProgressBox;
typedef struct _PamacProgressBoxClass PamacProgressBoxClass;
typedef struct _PamacProgressBoxPrivate PamacProgressBoxPrivate;

#define PAMAC_TYPE_TRANSACTION (pamac_transaction_get_type ())
#define PAMAC_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_TRANSACTION, PamacTransaction))
#define PAMAC_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_TRANSACTION, PamacTransactionClass))
#define PAMAC_IS_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_TRANSACTION))
#define PAMAC_IS_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_TRANSACTION))
#define PAMAC_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_TRANSACTION, PamacTransactionClass))

typedef struct _PamacTransaction PamacTransaction;
typedef struct _PamacTransactionClass PamacTransactionClass;
typedef struct _PamacTransactionPrivate PamacTransactionPrivate;
typedef enum  {
	PAMAC_TRANSACTION_MODE_MANAGER,
	PAMAC_TRANSACTION_MODE_INSTALLER
} PamacTransactionMode;

#define PAMAC_TRANSACTION_TYPE_MODE (pamac_transaction_mode_get_type ())

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gint checkspace;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

struct _PamacUpdateInfos {
	gchar* name;
	gchar* old_version;
	gchar* new_version;
	gchar* repo;
	guint64 download_size;
};

struct _PamacTransactionSummary {
	PamacUpdateInfos* to_install;
	gint to_install_length1;
	PamacUpdateInfos* to_upgrade;
	gint to_upgrade_length1;
	PamacUpdateInfos* to_downgrade;
	gint to_downgrade_length1;
	PamacUpdateInfos* to_reinstall;
	gint to_reinstall_length1;
	PamacUpdateInfos* to_remove;
	gint to_remove_length1;
	PamacUpdateInfos* to_build;
	gint to_build_length1;
	PamacUpdateInfos* aur_conflicts_to_remove;
	gint aur_conflicts_to_remove_length1;
	gchar** aur_pkgbases_to_build;
	gint aur_pkgbases_to_build_length1;
};

struct _PamacAlpmPackage {
	gchar* name;
	gchar* version;
	gchar* installed_version;
	gchar* desc;
	gchar* repo;
	guint64 size;
	guint64 download_size;
	guint origin;
};

struct _PamacAURPackage {
	gchar* name;
	gchar* version;
	gchar* installed_version;
	gchar* desc;
	gdouble popularity;
};

struct _PamacUpdates {
	gboolean is_syncfirst;
	PamacAlpmPackage* repos_updates;
	gint repos_updates_length1;
	PamacAURPackage* aur_updates;
	gint aur_updates_length1;
};

struct _PamacErrorInfos {
	guint errnos;
	gchar* message;
	gchar** details;
	gint details_length1;
};

struct _PamacMirrorsConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PamacMirrorsConfigPrivate * priv;
};

struct _PamacMirrorsConfigClass {
	GTypeClass parent_class;
	void (*finalize) (PamacMirrorsConfig *self);
};

struct _PamacAlpmPackageDetails {
	gchar* name;
	gchar* version;
	gchar* desc;
	gchar* repo;
	guint origin;
	gchar* url;
	gchar* packager;
	gchar* builddate;
	gchar* installdate;
	gchar* reason;
	gchar* has_signature;
	gchar* downloadsize;
	gchar* installsize;
	gchar** licenses;
	gint licenses_length1;
	gchar** depends;
	gint depends_length1;
	gchar** optdepends;
	gint optdepends_length1;
	gchar** requiredby;
	gint requiredby_length1;
	gchar** optionalfor;
	gint optionalfor_length1;
	gchar** provides;
	gint provides_length1;
	gchar** replaces;
	gint replaces_length1;
	gchar** conflicts;
	gint conflicts_length1;
	gchar** groups;
	gint groups_length1;
	gchar** backups;
	gint backups_length1;
};

struct _PamacAURPackageDetails {
	gchar* name;
	gchar* version;
	gchar* desc;
	gdouble popularity;
	gchar* packagebase;
	gchar* url;
	gchar* maintainer;
	gint64 firstsubmitted;
	gint64 lastmodified;
	gint64 outofdate;
	gint64 numvotes;
	gchar** licenses;
	gint licenses_length1;
	gchar** depends;
	gint depends_length1;
	gchar** makedepends;
	gint makedepends_length1;
	gchar** checkdepends;
	gint checkdepends_length1;
	gchar** optdepends;
	gint optdepends_length1;
	gchar** provides;
	gint provides_length1;
	gchar** replaces;
	gint replaces_length1;
	gchar** conflicts;
	gint conflicts_length1;
};

struct _PamacConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PamacConfigPrivate * priv;
};

struct _PamacConfigClass {
	GTypeClass parent_class;
	void (*finalize) (PamacConfig *self);
};

struct _PamacProgressBox {
	GtkBox parent_instance;
	PamacProgressBoxPrivate * priv;
	GtkProgressBar* progressbar;
	GtkLabel* action_label;
};

struct _PamacProgressBoxClass {
	GtkBoxClass parent_class;
};

struct _PamacTransaction {
	GObject parent_instance;
	PamacTransactionPrivate * priv;
	PamacTransactionMode mode;
	GHashTable* to_install;
	GHashTable* to_remove;
	GHashTable* to_load;
	GHashTable* to_build;
	GHashTable* to_update;
	GHashTable* transaction_summary;
	GHashTable* temporary_ignorepkgs;
	PamacProgressBox* progress_box;
	GtkScrolledWindow* term_window;
};

struct _PamacTransactionClass {
	GObjectClass parent_class;
};

VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlpmConfig, alpm_config_unref)
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN AlpmConfig* alpm_config_construct (GType object_type,
                                   const gchar* path);
VALA_EXTERN GList* alpm_config_get_holdpkgs (AlpmConfig* self);
VALA_EXTERN GList* alpm_config_get_syncfirsts (AlpmConfig* self);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self,
                                       gboolean files_db,
                                       gboolean tmp_db);
VALA_EXTERN void alpm_config_write (AlpmConfig* self,
                        GHashTable* new_conf);
VALA_EXTERN void pamac_search (gchar** needles,
                   gint needles_length1,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_);
VALA_EXTERN JsonArray* pamac_search_finish (GAsyncResult* _res_);
VALA_EXTERN void pamac_multiinfo (gchar** pkgnames,
                      gint pkgnames_length1,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_);
VALA_EXTERN JsonArray* pamac_multiinfo_finish (GAsyncResult* _res_);
VALA_EXTERN GType pamac_update_infos_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacUpdateInfos* pamac_update_infos_dup (const PamacUpdateInfos* self);
VALA_EXTERN void pamac_update_infos_free (PamacUpdateInfos* self);
VALA_EXTERN void pamac_update_infos_copy (const PamacUpdateInfos* self,
                              PamacUpdateInfos* dest);
VALA_EXTERN void pamac_update_infos_destroy (PamacUpdateInfos* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacUpdateInfos, pamac_update_infos_destroy)
VALA_EXTERN GType pamac_transaction_summary_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacTransactionSummary* pamac_transaction_summary_dup (const PamacTransactionSummary* self);
VALA_EXTERN void pamac_transaction_summary_free (PamacTransactionSummary* self);
VALA_EXTERN void pamac_transaction_summary_copy (const PamacTransactionSummary* self,
                                     PamacTransactionSummary* dest);
VALA_EXTERN void pamac_transaction_summary_destroy (PamacTransactionSummary* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacTransactionSummary, pamac_transaction_summary_destroy)
VALA_EXTERN GType pamac_updates_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_alpm_package_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacAlpmPackage* pamac_alpm_package_dup (const PamacAlpmPackage* self);
VALA_EXTERN void pamac_alpm_package_free (PamacAlpmPackage* self);
VALA_EXTERN void pamac_alpm_package_copy (const PamacAlpmPackage* self,
                              PamacAlpmPackage* dest);
VALA_EXTERN void pamac_alpm_package_destroy (PamacAlpmPackage* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacAlpmPackage, pamac_alpm_package_destroy)
VALA_EXTERN GType pamac_aur_package_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacAURPackage* pamac_aur_package_dup (const PamacAURPackage* self);
VALA_EXTERN void pamac_aur_package_free (PamacAURPackage* self);
VALA_EXTERN void pamac_aur_package_copy (const PamacAURPackage* self,
                             PamacAURPackage* dest);
VALA_EXTERN void pamac_aur_package_destroy (PamacAURPackage* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacAURPackage, pamac_aur_package_destroy)
VALA_EXTERN PamacUpdates* pamac_updates_dup (const PamacUpdates* self);
VALA_EXTERN void pamac_updates_free (PamacUpdates* self);
VALA_EXTERN void pamac_updates_copy (const PamacUpdates* self,
                         PamacUpdates* dest);
VALA_EXTERN void pamac_updates_destroy (PamacUpdates* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacUpdates, pamac_updates_destroy)
VALA_EXTERN GType pamac_error_infos_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacErrorInfos* pamac_error_infos_dup (const PamacErrorInfos* self);
VALA_EXTERN void pamac_error_infos_free (PamacErrorInfos* self);
VALA_EXTERN void pamac_error_infos_copy (const PamacErrorInfos* self,
                             PamacErrorInfos* dest);
VALA_EXTERN void pamac_error_infos_destroy (PamacErrorInfos* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacErrorInfos, pamac_error_infos_destroy)
VALA_EXTERN void pamac_error_infos_init (PamacErrorInfos *self);
VALA_EXTERN gpointer pamac_mirrors_config_ref (gpointer instance);
VALA_EXTERN void pamac_mirrors_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* pamac_param_spec_mirrors_config (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void pamac_value_set_mirrors_config (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void pamac_value_take_mirrors_config (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer pamac_value_get_mirrors_config (const GValue* value);
VALA_EXTERN GType pamac_mirrors_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacMirrorsConfig, pamac_mirrors_config_unref)
VALA_EXTERN PamacMirrorsConfig* pamac_mirrors_config_new (const gchar* path);
VALA_EXTERN PamacMirrorsConfig* pamac_mirrors_config_construct (GType object_type,
                                                    const gchar* path);
VALA_EXTERN void pamac_mirrors_config_reload (PamacMirrorsConfig* self);
VALA_EXTERN void pamac_mirrors_config_write (PamacMirrorsConfig* self,
                                 GHashTable* new_conf);
VALA_EXTERN const gchar* pamac_mirrors_config_get_choosen_generation_method (PamacMirrorsConfig* self);
VALA_EXTERN const gchar* pamac_mirrors_config_get_choosen_country (PamacMirrorsConfig* self);
VALA_EXTERN GType pamac_alpm_package_details_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacAlpmPackageDetails* pamac_alpm_package_details_dup (const PamacAlpmPackageDetails* self);
VALA_EXTERN void pamac_alpm_package_details_free (PamacAlpmPackageDetails* self);
VALA_EXTERN void pamac_alpm_package_details_copy (const PamacAlpmPackageDetails* self,
                                      PamacAlpmPackageDetails* dest);
VALA_EXTERN void pamac_alpm_package_details_destroy (PamacAlpmPackageDetails* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacAlpmPackageDetails, pamac_alpm_package_details_destroy)
VALA_EXTERN GType pamac_aur_package_details_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacAURPackageDetails* pamac_aur_package_details_dup (const PamacAURPackageDetails* self);
VALA_EXTERN void pamac_aur_package_details_free (PamacAURPackageDetails* self);
VALA_EXTERN void pamac_aur_package_details_copy (const PamacAURPackageDetails* self,
                                     PamacAURPackageDetails* dest);
VALA_EXTERN void pamac_aur_package_details_destroy (PamacAURPackageDetails* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PamacAURPackageDetails, pamac_aur_package_details_destroy)
VALA_EXTERN gpointer pamac_config_ref (gpointer instance);
VALA_EXTERN void pamac_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* pamac_param_spec_config (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void pamac_value_set_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN void pamac_value_take_config (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer pamac_value_get_config (const GValue* value);
VALA_EXTERN GType pamac_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacConfig, pamac_config_unref)
VALA_EXTERN PamacConfig* pamac_config_new (void);
VALA_EXTERN PamacConfig* pamac_config_construct (GType object_type);
VALA_EXTERN void pamac_config_reload (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_recurse (PamacConfig* self);
VALA_EXTERN guint64 pamac_config_get_refresh_period (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_no_update_hide_icon (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_enable_aur (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_search_aur (PamacConfig* self);
VALA_EXTERN const gchar* pamac_config_get_aur_build_dir (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_check_aur_updates (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_aur_keep_pkgs (PamacConfig* self);
VALA_EXTERN const gchar* pamac_config_get_aur_move_dir (PamacConfig* self);
VALA_EXTERN guint64 pamac_config_get_keep_num_pkgs (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_rm_only_uninstalled (PamacConfig* self);
VALA_EXTERN const gchar* pamac_config_get_terminal_background (PamacConfig* self);
VALA_EXTERN const gchar* pamac_config_get_terminal_foreground (PamacConfig* self);
VALA_EXTERN const gchar* pamac_config_get_terminal_font (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_update_files_db (PamacConfig* self);
VALA_EXTERN GHashTable* pamac_config_get_environment_variables (PamacConfig* self);
VALA_EXTERN GType pamac_progress_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacProgressBox, g_object_unref)
VALA_EXTERN PamacProgressBox* pamac_progress_box_new (void);
VALA_EXTERN PamacProgressBox* pamac_progress_box_construct (GType object_type);
VALA_EXTERN GType pamac_transaction_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacTransaction, g_object_unref)
VALA_EXTERN GType pamac_transaction_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacTransaction* pamac_transaction_new (GtkApplicationWindow* application_window);
VALA_EXTERN PamacTransaction* pamac_transaction_construct (GType object_type,
                                               GtkApplicationWindow* application_window);
VALA_EXTERN void pamac_transaction_config_changed (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_update_terminal_background (PamacTransaction* self,
                                                   const gchar* background);
VALA_EXTERN void pamac_transaction_update_terminal_foreground (PamacTransaction* self,
                                                   const gchar* foreground);
VALA_EXTERN void pamac_transaction_update_terminal_font (PamacTransaction* self,
                                             const gchar* font);
VALA_EXTERN void pamac_transaction_run_preferences_dialog (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_get_current_error (PamacTransaction* self,
                                          PamacErrorInfos* result);
VALA_EXTERN gchar** pamac_transaction_get_mirrors_countries (PamacTransaction* self,
                                                 gint* result_length1);
VALA_EXTERN gboolean pamac_transaction_get_lock (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_unlock (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_start_save_pamac_config (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_start_write_alpm_config (PamacTransaction* self,
                                                GHashTable* new_alpm_conf);
VALA_EXTERN void pamac_transaction_start_write_mirrors_config (PamacTransaction* self,
                                                   GHashTable* new_mirrors_conf);
VALA_EXTERN void pamac_transaction_start_progressbar_pulse (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_stop_progressbar_pulse (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_start_generate_mirrors_list (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_clean_cache (PamacTransaction* self,
                                    guint64 keep_nb,
                                    gboolean only_uninstalled);
VALA_EXTERN void pamac_transaction_start_set_pkgreason (PamacTransaction* self,
                                            const gchar* pkgname,
                                            guint reason);
VALA_EXTERN void pamac_transaction_start_refresh (PamacTransaction* self,
                                      gboolean force);
VALA_EXTERN void pamac_transaction_refresh_handle (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_checkspace (PamacTransaction* self);
VALA_EXTERN gchar** pamac_transaction_get_ignorepkgs (PamacTransaction* self,
                                          gint* result_length1);
VALA_EXTERN void pamac_transaction_get_installed_pkg (PamacTransaction* self,
                                          const gchar* pkgname,
                                          PamacAlpmPackage* result);
VALA_EXTERN void pamac_transaction_find_installed_satisfier (PamacTransaction* self,
                                                 const gchar* depstring,
                                                 PamacAlpmPackage* result);
VALA_EXTERN gboolean pamac_transaction_should_hold (PamacTransaction* self,
                                        const gchar* pkgname);
VALA_EXTERN guint pamac_transaction_get_pkg_reason (PamacTransaction* self,
                                        const gchar* pkgname);
VALA_EXTERN guint pamac_transaction_get_pkg_origin (PamacTransaction* self,
                                        const gchar* pkgname);
VALA_EXTERN void pamac_transaction_get_installed_pkgs (PamacTransaction* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_installed_pkgs_finish (PamacTransaction* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1);
VALA_EXTERN void pamac_transaction_get_explicitly_installed_pkgs (PamacTransaction* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_explicitly_installed_pkgs_finish (PamacTransaction* self,
                                                                          GAsyncResult* _res_,
                                                                          gint* result_length1);
VALA_EXTERN void pamac_transaction_get_foreign_pkgs (PamacTransaction* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_foreign_pkgs_finish (PamacTransaction* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1);
VALA_EXTERN void pamac_transaction_get_orphans (PamacTransaction* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_orphans_finish (PamacTransaction* self,
                                                        GAsyncResult* _res_,
                                                        gint* result_length1);
VALA_EXTERN void pamac_transaction_get_sync_pkg (PamacTransaction* self,
                                     const gchar* pkgname,
                                     PamacAlpmPackage* result);
VALA_EXTERN void pamac_transaction_find_sync_satisfier (PamacTransaction* self,
                                            const gchar* depstring,
                                            PamacAlpmPackage* result);
VALA_EXTERN void pamac_transaction_search_pkgs (PamacTransaction* self,
                                    const gchar* search_string,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_search_pkgs_finish (PamacTransaction* self,
                                                        GAsyncResult* _res_,
                                                        gint* result_length1);
VALA_EXTERN void pamac_transaction_search_in_aur (PamacTransaction* self,
                                      const gchar* search_string,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN PamacAURPackage* pamac_transaction_search_in_aur_finish (PamacTransaction* self,
                                                         GAsyncResult* _res_,
                                                         gint* result_length1);
VALA_EXTERN gchar** pamac_transaction_get_repos_names (PamacTransaction* self,
                                           gint* result_length1);
VALA_EXTERN void pamac_transaction_get_repo_pkgs (PamacTransaction* self,
                                      const gchar* repo,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_repo_pkgs_finish (PamacTransaction* self,
                                                          GAsyncResult* _res_,
                                                          gint* result_length1);
VALA_EXTERN gchar** pamac_transaction_get_groups_names (PamacTransaction* self,
                                            gint* result_length1);
VALA_EXTERN void pamac_transaction_get_group_pkgs (PamacTransaction* self,
                                       const gchar* group_name,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN PamacAlpmPackage* pamac_transaction_get_group_pkgs_finish (PamacTransaction* self,
                                                           GAsyncResult* _res_,
                                                           gint* result_length1);
VALA_EXTERN gchar** pamac_transaction_get_pkg_uninstalled_optdeps (PamacTransaction* self,
                                                       const gchar* pkgname,
                                                       gint* result_length1);
VALA_EXTERN void pamac_transaction_get_pkg_details (PamacTransaction* self,
                                        const gchar* pkgname,
                                        PamacAlpmPackageDetails* result);
VALA_EXTERN gchar** pamac_transaction_get_pkg_files (PamacTransaction* self,
                                         const gchar* pkgname,
                                         gint* result_length1);
VALA_EXTERN void pamac_transaction_get_aur_details (PamacTransaction* self,
                                        const gchar* pkgname,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void pamac_transaction_get_aur_details_finish (PamacTransaction* self,
                                               GAsyncResult* _res_,
                                               PamacAURPackageDetails* result);
VALA_EXTERN void pamac_transaction_start_get_updates (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_sysupgrade (PamacTransaction* self,
                                   gboolean enable_downgrade);
VALA_EXTERN void pamac_transaction_clear_lists (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_run (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_cancel (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_release (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_stop_daemon (PamacTransaction* self);
VALA_EXTERN void pamac_transaction_display_error (PamacTransaction* self,
                                      const gchar* message,
                                      gchar** details,
                                      gint details_length1);
VALA_EXTERN gboolean pamac_transaction_get_check_aur_updates (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_enable_aur (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_search_aur (PamacTransaction* self);
VALA_EXTERN const gchar* pamac_transaction_get_aur_build_dir (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_aur_keep_pkgs (PamacTransaction* self);
VALA_EXTERN const gchar* pamac_transaction_get_aur_move_dir (PamacTransaction* self);
VALA_EXTERN guint64 pamac_transaction_get_keep_num_pkgs (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_rm_only_uninstalled (PamacTransaction* self);
VALA_EXTERN const gchar* pamac_transaction_get_terminal_background (PamacTransaction* self);
VALA_EXTERN const gchar* pamac_transaction_get_terminal_foreground (PamacTransaction* self);
VALA_EXTERN const gchar* pamac_transaction_get_terminal_font (PamacTransaction* self);
VALA_EXTERN GHashTable* pamac_transaction_get_environment_variables (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_no_update_hide_icon (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_recurse (PamacTransaction* self);
VALA_EXTERN gboolean pamac_transaction_get_update_files_db (PamacTransaction* self);
VALA_EXTERN guint64 pamac_transaction_get_refresh_period (PamacTransaction* self);
VALA_EXTERN GtkApplicationWindow* pamac_transaction_get_application_window (PamacTransaction* self);

G_END_DECLS

#endif
