"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _os = _interopRequireDefault(require("os"));
var _helpers = require("./helpers");
var _asyncQueue = _interopRequireDefault(require("./async-queue"));
var _gitShellOutStrategy = _interopRequireDefault(require("./git-shell-out-strategy"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _default = {
  create(workingDir, options = {}) {
    return this.withStrategies([_gitShellOutStrategy.default])(workingDir, options);
  },
  withStrategies(strategies) {
    return function createForStrategies(workingDir, options = {}) {
      const parallelism = options.parallelism || Math.max(3, _os.default.cpus().length);
      const commandQueue = new _asyncQueue.default({
        parallelism
      });
      const strategyOptions = _objectSpread({}, options, {
        queue: commandQueue
      });
      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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