"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class ContextMenuInterceptor extends _react.default.Component {
  static handle(event) {
    for (const [element, callback] of ContextMenuInterceptor.registration) {
      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }
  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
  }
  componentDidMount() {
    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
    ContextMenuInterceptor.registration.set(this.element, (...args) => this.props.onWillShowContextMenu(...args));
  }
  render() {
    return _react.default.createElement("div", {
      ref: e => {
        this.element = e;
      }
    }, this.props.children);
  }
  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }
}
exports.default = ContextMenuInterceptor;
_defineProperty(ContextMenuInterceptor, "propTypes", {
  onWillShowContextMenu: _propTypes.default.func.isRequired,
  children: _propTypes.default.element.isRequired
});
_defineProperty(ContextMenuInterceptor, "registration", new Map());
function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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