"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BIN_SCRIPTS = void 0;
var _os = _interopRequireDefault(require("os"));
var _path = _interopRequireDefault(require("path"));
var _fsExtra = _interopRequireDefault(require("fs-extra"));
var _helpers = require("./helpers");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const BIN_SCRIPTS = {
  getCredentialHelperJs: 'git-credential-atom.js',
  getCredentialHelperSh: 'git-credential-atom.sh',
  getAskPassJs: 'git-askpass-atom.js',
  getAskPassSh: 'git-askpass-atom.sh',
  getSshWrapperSh: 'linux-ssh-wrapper.sh',
  getGpgWrapperSh: 'gpg-wrapper.sh'
};
exports.BIN_SCRIPTS = BIN_SCRIPTS;
class GitTempDir {
  constructor() {
    this.created = false;
  }
  async ensure() {
    if (this.created) {
      return;
    }
    this.root = await (0, _helpers.getTempDir)({
      dir: process.platform === 'win32' ? _os.default.tmpdir() : '/tmp',
      prefix: 'github-',
      symlinkOk: true
    });
    await Promise.all(Object.values(BIN_SCRIPTS).map(async filename => {
      await _fsExtra.default.copy(_path.default.resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path.default.join(this.root, filename));
      if (_path.default.extname(filename) === '.sh') {
        await _fsExtra.default.chmod(_path.default.join(this.root, filename), 0o700);
      }
    }));
    this.created = true;
  }
  getRootPath() {
    return this.root;
  }
  getScriptPath(filename) {
    if (!this.created) {
      throw new Error(`Attempt to access filename ${filename} in uninitialized GitTempDir`);
    }
    return _path.default.join(this.root, filename);
  }
  getSocketOptions() {
    if (process.platform === 'win32') {
      return {
        port: 0,
        host: 'localhost'
      };
    } else {
      return {
        path: this.getScriptPath('helper.sock')
      };
    }
  }
  dispose() {
    return _fsExtra.default.remove(this.root);
  }
}
exports.default = GitTempDir;
function createGetter(key) {
  const filename = BIN_SCRIPTS[key];
  return function () {
    return this.getScriptPath(filename);
  };
}
for (const key in BIN_SCRIPTS) {
  GitTempDir.prototype[key] = createGetter(key);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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