"use strict";

var _githubPackage = _interopRequireDefault(require("./github-package"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
let pack;
const entry = {
  initialize() {
    pack = new _githubPackage.default({
      workspace: atom.workspace,
      project: atom.project,
      commands: atom.commands,
      notificationManager: atom.notifications,
      tooltips: atom.tooltips,
      styles: atom.styles,
      keymaps: atom.keymaps,
      grammars: atom.grammars,
      config: atom.config,
      deserializers: atom.deserializers,
      confirm: atom.confirm.bind(atom),
      getLoadSettings: atom.getLoadSettings.bind(atom),
      currentWindow: atom.getCurrentWindow(),
      configDirPath: atom.getConfigDirPath()
    });
  }
};
module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];
      if (typeof item === 'function') {
        item = item.bind(pack);
      }
      return item;
    } else {
      return target[name];
    }
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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