"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _helpers = require("./helpers");
const refreshMapPerUniqueId = new WeakMap();
class PeriodicRefresher {
  static getRefreshMap(uniqueId) {
    let refreshMap = refreshMapPerUniqueId.get(uniqueId);
    if (!refreshMap) {
      refreshMap = new Map();
      refreshMapPerUniqueId.set(uniqueId, refreshMap);
    }
    return refreshMap;
  }
  constructor(uniqueId, options) {
    (0, _helpers.autobind)(this, 'refreshNow');
    this.options = options;
    this._refreshesPerId = PeriodicRefresher.getRefreshMap(uniqueId);
  }
  start() {
    if (!this._timer) {
      this._scheduleNext();
    }
  }
  _clearTimer() {
    if (this._timer) {
      clearTimeout(this._timer);
      delete this._timer;
    }
  }
  _scheduleNext() {
    this._timer = setTimeout(this.refreshNow, this.options.interval());
  }
  refreshNow(force = false) {
    const currentId = this.options.getCurrentId();
    const lastRefreshForId = this._refreshesPerId.get(currentId) || 0;
    const delta = performance.now() - lastRefreshForId;
    if (force || delta > this.options.minimumIntervalPerId) {
      this._refreshesPerId.set(currentId, performance.now());
      this.options.refresh();
    }
    // Schedule another refresh if one is already scheduled
    if (this._timer) {
      this._clearTimer();
      this._scheduleNext();
    }
  }
  destroy() {
    this._clearTimer();
  }
}
exports.default = PeriodicRefresher;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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