"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTypePropType = exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.RefresherPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.EndpointPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = exports.TokenPropType = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const TokenPropType = _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.symbol, _propTypes.default.instanceOf(Error)]);
exports.TokenPropType = TokenPropType;
const DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};
exports.DOMNodePropType = DOMNodePropType;
const WorkdirContextPoolPropType = _propTypes.default.shape({
  getContext: _propTypes.default.func.isRequired
});
exports.WorkdirContextPoolPropType = WorkdirContextPoolPropType;
const GithubLoginModelPropType = _propTypes.default.shape({
  getToken: _propTypes.default.func.isRequired,
  setToken: _propTypes.default.func.isRequired,
  removeToken: _propTypes.default.func.isRequired,
  getScopes: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
});
exports.GithubLoginModelPropType = GithubLoginModelPropType;
const RemotePropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  getUrl: _propTypes.default.func.isRequired,
  isGithubRepo: _propTypes.default.func.isRequired,
  getOwner: _propTypes.default.func.isRequired,
  getRepo: _propTypes.default.func.isRequired,
  getEndpoint: _propTypes.default.func.isRequired
});
exports.RemotePropType = RemotePropType;
const EndpointPropType = _propTypes.default.shape({
  getGraphQLRoot: _propTypes.default.func.isRequired,
  getRestRoot: _propTypes.default.func.isRequired,
  getRestURI: _propTypes.default.func.isRequired
});
exports.EndpointPropType = EndpointPropType;
const BranchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  isDetached: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});
exports.BranchPropType = BranchPropType;
const SearchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  createQuery: _propTypes.default.func.isRequired
});
exports.SearchPropType = SearchPropType;
const RemoteSetPropType = _propTypes.default.shape({
  withName: _propTypes.default.func.isRequired,
  isEmpty: _propTypes.default.func.isRequired,
  size: _propTypes.default.func.isRequired,
  [Symbol.iterator]: _propTypes.default.func.isRequired
});
exports.RemoteSetPropType = RemoteSetPropType;
const BranchSetPropType = _propTypes.default.shape({
  getNames: _propTypes.default.func.isRequired,
  getPullTargets: _propTypes.default.func.isRequired,
  getPushSources: _propTypes.default.func.isRequired
});
exports.BranchSetPropType = BranchSetPropType;
const CommitPropType = _propTypes.default.shape({
  getSha: _propTypes.default.func.isRequired,
  getMessageSubject: _propTypes.default.func.isRequired,
  isUnbornRef: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});
exports.CommitPropType = CommitPropType;
const AuthorPropType = _propTypes.default.shape({
  getEmail: _propTypes.default.func.isRequired,
  getFullName: _propTypes.default.func.isRequired,
  getAvatarUrl: _propTypes.default.func.isRequired
});
exports.AuthorPropType = AuthorPropType;
const RelayConnectionPropType = nodePropType => _propTypes.default.shape({
  edges: _propTypes.default.arrayOf(_propTypes.default.shape({
    cursor: _propTypes.default.string,
    node: nodePropType
  })),
  pageInfo: _propTypes.default.shape({
    endCursor: _propTypes.default.string,
    hasNextPage: _propTypes.default.bool,
    hasPreviousPage: _propTypes.default.bool,
    startCursor: _propTypes.default.string
  }),
  totalCount: _propTypes.default.number
});
exports.RelayConnectionPropType = RelayConnectionPropType;
const RefHolderPropType = _propTypes.default.shape({
  isEmpty: _propTypes.default.func.isRequired,
  get: _propTypes.default.func.isRequired,
  setter: _propTypes.default.func.isRequired,
  observe: _propTypes.default.func.isRequired
});
exports.RefHolderPropType = RefHolderPropType;
const PointPropType = _propTypes.default.shape({
  row: _propTypes.default.number.isRequired,
  column: _propTypes.default.number.isRequired,
  isEqual: _propTypes.default.func.isRequired
});
exports.PointPropType = PointPropType;
const RangePropType = _propTypes.default.shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes.default.func.isRequired
});
exports.RangePropType = RangePropType;
const EnableableOperationPropType = _propTypes.default.shape({
  isEnabled: _propTypes.default.func.isRequired,
  run: _propTypes.default.func.isRequired,
  getMessage: _propTypes.default.func.isRequired,
  why: _propTypes.default.func.isRequired
});
exports.EnableableOperationPropType = EnableableOperationPropType;
const OperationStateObserverPropType = _propTypes.default.shape({
  onDidComplete: _propTypes.default.func.isRequired,
  dispose: _propTypes.default.func.isRequired
});
exports.OperationStateObserverPropType = OperationStateObserverPropType;
const RefresherPropType = _propTypes.default.shape({
  setRetryCallback: _propTypes.default.func.isRequired,
  trigger: _propTypes.default.func.isRequired,
  deregister: _propTypes.default.func.isRequired
});
exports.RefresherPropType = RefresherPropType;
const IssueishPropType = _propTypes.default.shape({
  getNumber: _propTypes.default.func.isRequired,
  getTitle: _propTypes.default.func.isRequired,
  getGitHubURL: _propTypes.default.func.isRequired,
  getAuthorLogin: _propTypes.default.func.isRequired,
  getAuthorAvatarURL: _propTypes.default.func.isRequired,
  getCreatedAt: _propTypes.default.func.isRequired,
  getHeadRefName: _propTypes.default.func.isRequired,
  getHeadRepositoryID: _propTypes.default.func.isRequired,
  getStatusCounts: _propTypes.default.func.isRequired
});
exports.IssueishPropType = IssueishPropType;
const FilePatchItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.string.isRequired
});
exports.FilePatchItemPropType = FilePatchItemPropType;
const MultiFilePatchPropType = _propTypes.default.shape({
  getFilePatches: _propTypes.default.func.isRequired
});
exports.MultiFilePatchPropType = MultiFilePatchPropType;
const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];
const MergeConflictItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.shape({
    file: _propTypes.default.oneOf(statusNames).isRequired,
    ours: _propTypes.default.oneOf(statusNames).isRequired,
    theirs: _propTypes.default.oneOf(statusNames).isRequired
  }).isRequired
});
exports.MergeConflictItemPropType = MergeConflictItemPropType;
const UserStorePropType = _propTypes.default.shape({
  getUsers: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
});

// Require item classes lazily to prevent circular imports
exports.UserStorePropType = UserStorePropType;
let lazyItemConstructors = null;
function createItemTypePropType(required) {
  return function (props, propName, componentName) {
    if (lazyItemConstructors === null) {
      lazyItemConstructors = new Set();
      for (const itemPath of ['./items/changed-file-item', './items/commit-preview-item', './items/commit-detail-item', './items/issueish-detail-item']) {
        lazyItemConstructors.add(require(itemPath).default);
      }
    }
    if (props[propName] === undefined || props[propName] === null) {
      /* istanbul ignore else */
      if (required) {
        return new Error(`Missing required prop ${propName} on component ${componentName}.`);
      } else {
        return undefined;
      }
    }

    /* istanbul ignore if */
    if (!lazyItemConstructors.has(props[propName])) {
      const choices = Array.from(lazyItemConstructors, each => each.name).join(', ');
      return new Error(`Invalid prop "${propName}" supplied to ${componentName}. Must be one of ${choices}.`);
    }
    return undefined;
  };
}
const ItemTypePropType = createItemTypePropType(false);
exports.ItemTypePropType = ItemTypePropType;
ItemTypePropType.isRequired = createItemTypePropType(true);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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