"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
class TabGroup {
  constructor() {
    this.nodesByElement = new Map();
    this.lastElement = null;
    this.autofocusTarget = null;
  }
  appendElement(element, autofocus) {
    const lastNode = this.nodesByElement.get(this.lastElement) || {
      next: element,
      previous: element
    };
    const next = lastNode.next;
    const previous = this.lastElement || element;
    this.nodesByElement.set(element, {
      next,
      previous
    });
    this.nodesByElement.get(lastNode.next).previous = element;
    lastNode.next = element;
    this.lastElement = element;
    if (autofocus && this.autofocusTarget === null) {
      this.autofocusTarget = element;
    }
  }
  removeElement(element) {
    const node = this.nodesByElement.get(element);
    if (node) {
      const beforeNode = this.nodesByElement.get(node.previous);
      const afterNode = this.nodesByElement.get(node.next);
      beforeNode.next = node.next;
      afterNode.previous = node.previous;
    }
    this.nodesByElement.delete(element);
  }
  after(element) {
    const node = this.nodesByElement.get(element) || {
      next: undefined
    };
    return node.next;
  }
  focusAfter(element) {
    const original = this.getCurrentFocus();
    let next = this.after(element);
    while (next && next !== element) {
      next.focus();
      if (this.getCurrentFocus() !== original) {
        return;
      }
      next = this.after(next);
    }
  }
  before(element) {
    const node = this.nodesByElement.get(element) || {
      previous: undefined
    };
    return node.previous;
  }
  focusBefore(element) {
    const original = this.getCurrentFocus();
    let previous = this.before(element);
    while (previous && previous !== element) {
      previous.focus();
      if (this.getCurrentFocus() !== original) {
        return;
      }
      previous = this.before(previous);
    }
  }
  autofocus() {
    this.autofocusTarget && this.autofocusTarget.focus();
  }

  /* istanbul ignore next */
  getCurrentFocus() {
    return document.activeElement;
  }
}
exports.default = TabGroup;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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