"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.watchWorkspaceItem = watchWorkspaceItem;
var _atom = require("atom");
var _uriPattern = _interopRequireDefault(require("./atom/uri-pattern"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class ItemWatcher {
  constructor(workspace, pattern, component, stateKey) {
    _defineProperty(this, "updateActiveState", () => {
      const wasActive = this.activeItem;
      this.activeItem = this.isActiveItem();
      // Update the component's state if it's changed as a result
      if (wasActive && !this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: false
        }, resolve));
      } else if (!wasActive && this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: true
        }, resolve));
      } else {
        return Promise.resolve();
      }
    });
    _defineProperty(this, "itemMatches", item => item && item.getURI && this.pattern.matches(item.getURI()).ok());
    this.workspace = workspace;
    this.pattern = pattern instanceof _uriPattern.default ? pattern : new _uriPattern.default(pattern);
    this.component = component;
    this.stateKey = stateKey;
    this.activeItem = this.isActiveItem();
    this.subs = new _atom.CompositeDisposable();
  }
  isActiveItem() {
    for (const pane of this.workspace.getPanes()) {
      if (this.itemMatches(pane.getActiveItem())) {
        return true;
      }
    }
    return false;
  }
  setInitialState() {
    if (!this.component.state) {
      this.component.state = {};
    }
    this.component.state[this.stateKey] = this.activeItem;
    return this;
  }
  subscribeToWorkspace() {
    this.subs.dispose();
    this.subs = new _atom.CompositeDisposable(this.workspace.getCenter().onDidChangeActivePaneItem(this.updateActiveState));
    return this;
  }
  setPattern(pattern) {
    this.pattern = pattern instanceof _uriPattern.default ? pattern : new _uriPattern.default(pattern);
    return this.updateActiveState();
  }
  dispose() {
    this.subs.dispose();
  }
}
function watchWorkspaceItem(workspace, pattern, component, stateKey) {
  return new ItemWatcher(workspace, pattern, component, stateKey).setInitialState().subscribeToWorkspace();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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