// Generated by CoffeeScript 1.12.7
(function() {
  var asarPath, child_process, fs, npm, path, semver;

  child_process = require('child_process');

  fs = require('./fs');

  path = require('path');

  npm = require('npm');

  semver = require('semver');

  asarPath = null;

  module.exports = {
    getHomeDirectory: function() {
      if (process.platform === 'win32') {
        return process.env.USERPROFILE;
      } else {
        return process.env.HOME;
      }
    },
    getAtomDirectory: function() {
      var ref;
      return (ref = process.env.ATOM_HOME) != null ? ref : path.join(this.getHomeDirectory(), '.pulsar');
    },
    getRustupHomeDirPath: function() {
      if (process.env.RUSTUP_HOME) {
        return process.env.RUSTUP_HOME;
      } else {
        return path.join(this.getHomeDirectory(), '.multirust');
      }
    },
    getCacheDirectory: function() {
      return path.join(this.getAtomDirectory(), '.apm');
    },
    getResourcePath: function(callback) {
      var apmFolder, appFolder;
      if (process.env.ATOM_RESOURCE_PATH) {
        return process.nextTick(function() {
          return callback(process.env.ATOM_RESOURCE_PATH);
        });
      }
      if (asarPath) {
        return process.nextTick(function() {
          return callback(asarPath);
        });
      }
      apmFolder = path.resolve(__dirname, '..');
      appFolder = path.dirname(apmFolder);
      if (path.basename(apmFolder) === 'ppm' && path.basename(appFolder) === 'app') {
        asarPath = appFolder + ".asar";
        if (fs.existsSync(asarPath)) {
          return process.nextTick(function() {
            return callback(asarPath);
          });
        }
      }
      apmFolder = path.resolve(__dirname, '..', '..', '..');
      appFolder = path.dirname(apmFolder);
      if (path.basename(apmFolder) === 'ppm' && path.basename(appFolder) === 'app') {
        asarPath = appFolder + ".asar";
        if (fs.existsSync(asarPath)) {
          return process.nextTick(function() {
            return callback(asarPath);
          });
        }
      }
      switch (process.platform) {
        case 'darwin':
          return child_process.exec('mdfind "kMDItemCFBundleIdentifier == \'dev.pulsar-edit.pulsar\'"', function(error, stdout, stderr) {
            var appLocation;
            if (stdout == null) {
              stdout = '';
            }
            if (!error) {
              appLocation = stdout.split('\n')[0];
            }
            if (!appLocation) {
              appLocation = '/Applications/Pulsar.app';
            }
            asarPath = appLocation + "/Contents/Resources/app.asar";
            return process.nextTick(function() {
              return callback(asarPath);
            });
          });
        case 'linux':
          asarPath = '/opt/Pulsar/resources/app.asar';
          return process.nextTick(function() {
            return callback(asarPath);
          });
        case 'win32':
          asarPath = "/Users/" + process.env.USERNAME + "/AppData/Local/Programs/Pulsar/resources/app.asar";
          if (!fs.existsSync(asarPath)) {
            asarPath = "/Program Files/Pulsar/resources/app.asar";
          }
          return process.nextTick(function() {
            return callback(asarPath);
          });
        default:
          return process.nextTick(function() {
            return callback('');
          });
      }
    },
    getReposDirectory: function() {
      var ref;
      return (ref = process.env.ATOM_REPOS_HOME) != null ? ref : path.join(this.getHomeDirectory(), 'github');
    },
    getElectronUrl: function() {
      var ref;
      return (ref = process.env.ATOM_ELECTRON_URL) != null ? ref : 'https://artifacts.electronjs.org/headers/dist';
    },
    getAtomPackagesUrl: function() {
      var ref;
      return (ref = process.env.ATOM_PACKAGES_URL) != null ? ref : (this.getAtomApiUrl()) + "/packages";
    },
    getAtomApiUrl: function() {
      var ref;
      return (ref = process.env.ATOM_API_URL) != null ? ref : 'https://api.pulsar-edit.dev/api';
    },
    getElectronArch: function() {
      var ref;
      switch (process.platform) {
        case 'darwin':
          return 'x64';
        default:
          return (ref = process.env.ATOM_ARCH) != null ? ref : process.arch;
      }
    },
    getUserConfigPath: function() {
      return path.resolve(this.getAtomDirectory(), '.apmrc');
    },
    getGlobalConfigPath: function() {
      return path.resolve(this.getAtomDirectory(), '.apm', '.apmrc');
    },
    isWin32: function() {
      return process.platform === 'win32';
    },
    x86ProgramFilesDirectory: function() {
      return process.env["ProgramFiles(x86)"] || process.env["ProgramFiles"];
    },
    getInstalledVisualStudioFlag: function() {
      if (!this.isWin32()) {
        return null;
      }
      if (process.env.GYP_MSVS_VERSION) {
        return process.env.GYP_MSVS_VERSION;
      }
      if (this.visualStudioIsInstalled("2019")) {
        return '2019';
      }
      if (this.visualStudioIsInstalled("2017")) {
        return '2017';
      }
      if (this.visualStudioIsInstalled("14.0")) {
        return '2015';
      }
    },
    visualStudioIsInstalled: function(version) {
      if (version < 2017) {
        return fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio " + version, "Common7", "IDE"));
      } else {
        return fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio", "" + version, "BuildTools", "Common7", "IDE")) || fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio", "" + version, "Community", "Common7", "IDE")) || fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio", "" + version, "Enterprise", "Common7", "IDE")) || fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio", "" + version, "Professional", "Common7", "IDE")) || fs.existsSync(path.join(this.x86ProgramFilesDirectory(), "Microsoft Visual Studio", "" + version, "WDExpress", "Common7", "IDE"));
      }
    },
    loadNpm: function(callback) {
      var npmOptions;
      npmOptions = {
        userconfig: this.getUserConfigPath(),
        globalconfig: this.getGlobalConfigPath()
      };
      return npm.load(npmOptions, function() {
        return callback(null, npm);
      });
    },
    getSetting: function(key, callback) {
      return this.loadNpm(function() {
        return callback(npm.config.get(key));
      });
    },
    setupApmRcFile: function() {
      try {
        return fs.writeFileSync(this.getGlobalConfigPath(), "; This file is auto-generated and should not be edited since any\n; modifications will be lost the next time any apm command is run.\n;\n; You should instead edit your .apmrc config located in ~/.pulsar/.apmrc\ncache = " + (this.getCacheDirectory()) + "\n; Hide progress-bar to prevent npm from altering apm console output.\nprogress = false");
      } catch (error1) {}
    }
  };

}).call(this);
